/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitLon;

import com.tridium.lonworks.device.NvDev;
import com.tridium.lonworks.local.BPseudoNV;
import com.tridium.lonworks.local.BPseudoNvContainer;
import java.util.HashMap;
import javax.baja.lonworks.enums.BLonNvDirection;
import javax.baja.lonworks.enums.BLonSnvtType;
import javax.baja.lonworks.londata.BLonBoolean;
import javax.baja.lonworks.londata.BLonByteArray;
import javax.baja.lonworks.londata.BLonData;
import javax.baja.lonworks.londata.BLonDouble;
import javax.baja.lonworks.londata.BLonEnum;
import javax.baja.lonworks.londata.BLonFloat;
import javax.baja.lonworks.londata.BLonInteger;
import javax.baja.lonworks.londata.BLonPrimitive;
import javax.baja.lonworks.londata.BLonString;
import javax.baja.lonworks.util.SnvtUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Knob;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BLonPoint
extends BPseudoNvContainer {
    public static final Property snvt = BLonPoint.newProperty((int)0, (BValue)BLonSnvtType.SnvtTemp, null);
    public static final Property nvo = BLonPoint.newProperty((int)0, (BValue)new BPseudoNV(39, BLonNvDirection.output), null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final String DELIMITER = "_";
    private HashMap valHash;
    static /* synthetic */ Class class$com$tridium$kitLon$BLonPoint;
    static /* synthetic */ Class class$com$tridium$kitLon$BLonPoint$InputPrimitive;

    public BLonSnvtType getSnvt() {
        return (BLonSnvtType)this.get(snvt);
    }

    public void setSnvt(BLonSnvtType bLonSnvtType) {
        this.set(snvt, (BValue)bLonSnvtType, null);
    }

    public BPseudoNV getNvo() {
        return (BPseudoNV)this.get(nvo);
    }

    public void setNvo(BPseudoNV bPseudoNV) {
        this.set(nvo, (BValue)bPseudoNV, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == snvt) {
            this.verifyLonData();
        } else if (property.getType().is(BStatusValue.TYPE)) {
            this.updateSnvt(property, context);
        }
    }

    public void started() throws Exception {
        super.started();
        this.verifyLonData();
        this.updateSnvt();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.valHash != null) {
            this.valHash.clear();
        }
        this.valHash = null;
    }

    public final void knobAdded(Knob knob, Context context) {
        super.knobAdded(knob, context);
        NvDev.knobAdded((BComponent)this, (Knob)knob, (Context)context);
    }

    public final void knobRemoved(Knob knob, Context context) {
        super.knobRemoved(knob, context);
        NvDev.knobRemoved((BComponent)this, (Knob)knob, (Context)context);
    }

    public void checkRename(Property property, String string, Context context) {
        throw new IllegalNameException("kitLon", "point.rename", null);
    }

    private final void updateSnvt(Property property, Context context) {
        this.setNvPrimitive(property, (BStatusValue)this.get(property));
    }

    private final void updateSnvt() {
        Property[] propertyArray = this.getPropertiesArray();
        int n = 0;
        while (n < propertyArray.length) {
            BValue bValue = this.get(propertyArray[n]);
            if (bValue instanceof BStatusValue) {
                this.setNvPrimitive(propertyArray[n], (BStatusValue)bValue);
            }
            ++n;
        }
    }

    private final void setNvPrimitive(Property property, BStatusValue bStatusValue) {
        int n;
        BStatusValue bStatusValue2 = (BStatusValue)this.getValHash().get(property);
        if (bStatusValue2 != null && bStatusValue2.equivalent((Object)bStatusValue)) {
            return;
        }
        this.getValHash().put(property, bStatusValue.newCopy());
        String string = property.getName();
        BPseudoNV bPseudoNV = this.getNvo();
        while ((n = string.indexOf(DELIMITER)) > 0) {
            bPseudoNV = (BComponent)bPseudoNV.get(string.substring(0, n));
            string = string.substring(n + 1);
        }
        BLonPrimitive bLonPrimitive = (BLonPrimitive)bPseudoNV.get(string);
        if (bStatusValue instanceof BStatusNumeric) {
            bPseudoNV.set(string, (BValue)bLonPrimitive.makeFromDouble(((BStatusNumeric)bStatusValue).getValue()));
        } else if (bStatusValue instanceof BStatusBoolean) {
            bPseudoNV.set(string, (BValue)bLonPrimitive.makeFromBoolean(((BStatusBoolean)bStatusValue).getValue()));
        } else if (bStatusValue instanceof BStatusEnum) {
            bPseudoNV.set(string, (BValue)bLonPrimitive.makeFromEnum((BEnum)((BStatusEnum)bStatusValue).getValue()));
        } else if (bStatusValue instanceof BStatusString) {
            bPseudoNV.set(string, (BValue)bLonPrimitive.makeFromString(((BStatusString)bStatusValue).getValue()));
        }
    }

    private final HashMap getValHash() {
        if (this.valHash == null) {
            this.valHash = new HashMap();
        }
        return this.valHash;
    }

    private final void verifyLonData() {
        int n = this.getSnvt().getOrdinal();
        BLonData bLonData = SnvtUtil.getLonData((int)n);
        if (bLonData == null) {
            return;
        }
        BPseudoNV bPseudoNV = this.getNvo();
        if (bPseudoNV.getNvProps().getSnvtType() == n && bPseudoNV.getData().hasEquivalentElements(bLonData)) {
            return;
        }
        bPseudoNV.getNvProps().setSnvtType(n);
        bPseudoNV.setData(bLonData);
        Class clazz = class$com$tridium$kitLon$BLonPoint$InputPrimitive;
        if (clazz == null) {
            clazz = class$com$tridium$kitLon$BLonPoint$InputPrimitive = BLonPoint.class("[Lcom.tridium.kitLon.BLonPoint$InputPrimitive;", false);
        }
        Array array = new Array(clazz);
        this.parsePrimitives(array, bLonData, "");
        InputPrimitive[] inputPrimitiveArray = (InputPrimitive[])array.trim();
        Context context = Transaction.start((BComponent)this, (Context)new BasicContext());
        Property[] propertyArray = this.getPropertiesArray();
        int n2 = 0;
        while (n2 < inputPrimitiveArray.length) {
            Property property = this.findAndRemoveProperty(inputPrimitiveArray[n2], propertyArray, context);
            if (property == null) {
                this.add(inputPrimitiveArray[n2].name, (BValue)inputPrimitiveArray[n2].val, 0, inputPrimitiveArray[n2].facets, context);
            }
            ++n2;
        }
        this.removeRemainingProps(propertyArray, context);
        this.validateNvLinks(context);
        try {
            Transaction.end((BComponent)this, (Context)context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void validateNvLinks(Context context) {
        Knob[] knobArray = this.getKnobs((Slot)nvo);
        int n = 0;
        while (n < knobArray.length) {
            LinkCheck linkCheck = NvDev.doNvCheckLink((BComponent)this, (Slot)nvo, (BComponent)knobArray[n].getSourceComponent(), (Slot)knobArray[n].getTargetSlot(), null);
            if (!linkCheck.isValid()) {
                BLink bLink = knobArray[n].getLink();
                knobArray[n].getTargetComponent().remove(bLink.getPropertyInParent(), context);
                bLink.deactivate();
            }
            ++n;
        }
    }

    private final void parsePrimitives(Array array, BLonData bLonData, String string) {
        SlotCursor slotCursor = bLonData.getProperties();
        while (slotCursor.nextObject()) {
            String string2;
            Property property = slotCursor.property();
            BObject bObject = slotCursor.get();
            String string3 = string2 = string.length() > 0 ? string + '_' + property.getName() : property.getName();
            if (bObject instanceof BLonData) {
                this.parsePrimitives(array, (BLonData)bObject, string2);
                continue;
            }
            if (!(bObject instanceof BLonPrimitive)) continue;
            BStatusNumeric bStatusNumeric = null;
            if (bObject instanceof BLonDouble) {
                bStatusNumeric = new BStatusNumeric();
            } else if (bObject instanceof BLonFloat) {
                bStatusNumeric = new BStatusNumeric();
            } else if (bObject instanceof BLonInteger) {
                bStatusNumeric = new BStatusNumeric();
            } else if (bObject instanceof BLonString) {
                bStatusNumeric = new BStatusString();
            } else if (bObject instanceof BLonBoolean) {
                bStatusNumeric = new BStatusBoolean();
            } else if (bObject instanceof BLonEnum) {
                bStatusNumeric = new BStatusNumeric();
            } else if (bObject instanceof BLonByteArray) {
                bStatusNumeric = new BStatusString();
            } else {
                throw new IllegalStateException("Unsupported LonPrimitive");
            }
            array.add((Object)new InputPrimitive((BStatusValue)bStatusNumeric, string2, property.getFacets()));
        }
    }

    private final Property findAndRemoveProperty(InputPrimitive inputPrimitive, Property[] propertyArray, Context context) {
        String string = inputPrimitive.name;
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property != null && property.getName().equals(string) && !property.isFrozen()) {
                if (property.getType() != inputPrimitive.val.getType()) {
                    this.remove(property, context);
                    property = null;
                }
                propertyArray[n] = null;
                return property;
            }
            ++n;
        }
        return null;
    }

    private final void removeRemainingProps(Property[] propertyArray, Context context) {
        int n = 0;
        while (n < propertyArray.length) {
            Property property = propertyArray[n];
            if (property != null && !property.isFrozen() && property.getType().is(BStatusValue.TYPE)) {
                this.remove(property, context);
            }
            ++n;
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$kitLon$BLonPoint;
        if (clazz == null) {
            clazz = class$com$tridium$kitLon$BLonPoint = BLonPoint.class("[Lcom.tridium.kitLon.BLonPoint;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.make((String)"module://lonworks/com/tridium/lonworks/ui/icons/nv.png");
    }

    static class InputPrimitive {
        BStatusValue val;
        String name;
        BFacets facets;

        InputPrimitive(BStatusValue bStatusValue, String string, BFacets bFacets) {
            this.val = bStatusValue;
            this.name = string;
            this.facets = bFacets;
        }
    }
}

