/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import java.io.Serializable;
import java.util.Hashtable;
import javax.baja.ldap.BLdapExt;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class BLdapV2
extends BLdapExt {
    public static final Property connectionUser = BLdapV2.newProperty((int)0, (String)"", null);
    public static final Property connectionPwd = BLdapV2.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BLdapV2 == null ? (class$javax$baja$ldap$BLdapV2 = BLdapV2.class$("javax.baja.ldap.BLdapV2")) : class$javax$baja$ldap$BLdapV2));
    private static final String ERR_CNX_URL = "ldap.error.urlConnectionFailed";
    static /* synthetic */ Class class$javax$baja$ldap$BLdapV2;

    public String getConnectionUser() {
        return this.getString(connectionUser);
    }

    public void setConnectionUser(String string) {
        this.setString(connectionUser, string, null);
    }

    public BPassword getConnectionPwd() {
        return (BPassword)this.get(connectionPwd);
    }

    public void setConnectionPwd(BPassword bPassword) {
        this.set(connectionPwd, (BValue)bPassword, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUser authenticate(String string, String string2, Context context) throws AuthenticationException {
        String string3;
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        BUser bUser = this.service.getUser(string);
        this.validateUser(bUser, context);
        DirContext dirContext = null;
        try {
            string3 = this.getConnectionUrl();
            if (string3.length() > 0) {
                dirContext = this.initialDirContext(string3);
            }
        }
        catch (CommunicationException communicationException) {
            return this.authCachedCredentials(string, string2, context);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            return this.authCachedCredentials(string, string2, context);
        }
        catch (ConfigurationException configurationException) {
            return this.authCachedCredentials(string, string2, context);
        }
        catch (Exception exception) {
            log.warning(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception);
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}));
        }
        if (dirContext == null) {
            return null;
        }
        try {
            Serializable serializable;
            string3 = this.getUserLoginAttr() + "=" + string;
            SearchResult searchResult = null;
            try {
                serializable = new SearchControls();
                serializable.setSearchScope(2);
                serializable.setCountLimit(1L);
                NamingEnumeration namingEnumeration = dirContext.search(this.getUserBase(), string3, (SearchControls)serializable);
                try {
                    if (namingEnumeration.hasMore()) {
                        searchResult = (SearchResult)namingEnumeration.next();
                    }
                }
                finally {
                    namingEnumeration.close();
                }
            }
            catch (Exception exception) {
                log.warning(lex.getText("ldap.error.ldapsearch", new Object[]{string3}), (Throwable)exception);
                throw new AuthenticationException(lex.getText("ldap.error.ldapsearch", new Object[]{string3}));
            }
            serializable = null;
            if (searchResult != null) {
                try {
                    string3 = this.getUserBase();
                    string3 = string3.length() > 0 ? searchResult.getName() + "," + string3 : searchResult.getName();
                    dirContext.addToEnvironment("java.naming.security.principal", string3);
                    dirContext.addToEnvironment("java.naming.security.credentials", string2);
                    serializable = dirContext.getAttributes(string3);
                }
                catch (Exception exception) {
                    if (bUser != null) {
                        bUser.authenticateFailed((BUserService)this.service);
                        this.service.auditLoginAttempt(false, bUser, context);
                    }
                    log.warning(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception);
                    throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}));
                }
            } else {
                log.message(lex.getText("ldap.error.userNotFound", new Object[]{string3}));
                if (bUser != null) {
                    bUser.authenticateFailed((BUserService)this.service);
                    this.service.auditLoginAttempt(false, bUser, context);
                }
                throw new AuthenticationException(lex.getText("ldap.error.userNotFound", new Object[]{string3}));
            }
            try {
                bUser = this.prepareUser(string, string2, bUser, (Attributes)serializable, dirContext);
            }
            catch (Exception exception) {
                log.error(lex.getText("ldap.error.attributes", new Object[]{string3}), (Throwable)exception);
                bUser.authenticateFailed((BUserService)this.service);
                this.service.auditLoginAttempt(false, bUser, context);
                throw new AuthenticationException(lex.getText("ldap.error.attributes", new Object[]{string3}));
            }
        }
        finally {
            try {
                dirContext.close();
            }
            catch (Exception exception) {
                log.trace("Closing connection.", (Throwable)exception);
            }
        }
        if (!this.service.canLogin(bUser)) {
            bUser.authenticateFailed((BUserService)this.service);
            this.service.auditLoginAttempt(false, bUser, context);
            throw new AuthenticationException();
        }
        bUser.authenticateOk((BUserService)this.service);
        this.service.auditLoginAttempt(true, bUser, context);
        return bUser;
    }

    public BUser authenticate(BICredentials bICredentials, Context context) {
        if (bICredentials instanceof BUsernameAndPassword) {
            BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
            String string = bUsernameAndPassword.getUsername();
            String string2 = bUsernameAndPassword.getPassword().getValue();
            return this.authenticate(string, string2, context);
        }
        throw new AuthenticationException("Unsupported credential type for LdapV2.");
    }

    protected DirContext initialDirContext(String string) throws NamingException {
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", this.getInitialContextFactory());
        hashtable.put("java.naming.provider.url", string);
        if (!this.getEnableConnectionPooling()) {
            hashtable.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if ((string2 = this.getConnectionUser()).length() > 0) {
            log.trace("Authentication: simple");
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("java.naming.security.principal", string2);
            hashtable.put("java.naming.security.credentials", this.getConnectionPwd().getString());
        } else {
            log.trace("Authentication: Anonymous");
        }
        if (this.getSSL()) {
            try {
                log.trace("SSL enabled");
                hashtable.put("java.naming.security.protocol", "ssl");
                if (CertManagerFactory.isCertManagerActive()) {
                    hashtable.put("java.naming.ldap.factory.socket", "javax.baja.security.crypto.se.BajaSSLSocketFactory");
                }
            }
            catch (Exception exception) {
                log.warning(lex.getText("ldap.error.SSLSocketFactory"));
            }
        }
        if ((string2 = this.getReferral()).length() > 0) {
            hashtable.put("java.naming.referral", string2);
            log.trace("Referral: " + string2);
        }
        return new InitialDirContext(hashtable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

