/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import com.tridium.ldap.BPrototypeFolder;
import javax.baja.ldap.BLdapExt;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.AuthenticateUtil;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;

public class BLdapUserService
extends BUserService {
    public static final Property userPrototypes = BLdapUserService.newProperty((int)0, (BValue)new BPrototypeFolder(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BLdapUserService == null ? (class$javax$baja$ldap$BLdapUserService = BLdapUserService.class$("javax.baja.ldap.BLdapUserService")) : class$javax$baja$ldap$BLdapUserService));
    protected static final Log log = Log.getLog((String)"ldap");
    static /* synthetic */ Class class$javax$baja$ldap$BLdapUserService;
    static /* synthetic */ Class class$javax$baja$ldap$BLdapExt;

    public BUserPrototypes getUserPrototypes() {
        return (BUserPrototypes)this.get(userPrototypes);
    }

    public void setUserPrototypes(BUserPrototypes bUserPrototypes) {
        this.set(userPrototypes, (BValue)bUserPrototypes, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BUser authenticateBasic(String string, String string2, Context context) throws AuthenticationException {
        if (string == null || string.length() == 0) {
            throw new AuthenticationException();
        }
        if (this.isLocalUser(string)) {
            return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this, (Context)context);
        }
        BLdapExt bLdapExt = this.ext();
        if (bLdapExt == null) {
            log.error(this.toPathString() + " missing child BLdapExt instance.");
            throw new AuthenticationException();
        }
        BUser bUser = bLdapExt.authenticate(string, string2, context);
        if (bUser == null) {
            log.message("Attempting to authenicate cached user: " + string);
            return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this, (Context)context);
        }
        return bUser;
    }

    public boolean isDistributable() {
        return false;
    }

    public void addLdapUser(String string, BUser bUser, String string2) {
        Property property = this.add(SlotPath.escape((String)string), (BValue)bUser, 0x10000000);
        BUser bUser2 = (BUser)this.get(property);
        bUser2.setPrototypeName(string2);
    }

    public void removeLdapUser(String string) {
        this.remove(SlotPath.escape((String)string));
    }

    public void removeLdapUser(BUser bUser) {
        this.remove((BComplex)bUser);
    }

    public BLdapExt ext() {
        SlotCursor slotCursor = this.getProperties();
        if (slotCursor.next(class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BLdapUserService.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt)) {
            return (BLdapExt)slotCursor.get();
        }
        return null;
    }

    public boolean canUsePasswordFeatures(BUser bUser) {
        return this.isLocalUser(bUser.getName());
    }

    public boolean isLocalUser(String string) {
        if (string == null) {
            return false;
        }
        BUser bUser = this.getUser(string);
        if (bUser == null) {
            return false;
        }
        return !Flags.isUserDefined1((BComplex)this, (Slot)bUser.getPropertyInParent());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

