/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import javax.baja.ldap.BLdapUserService;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.AuthenticateUtil;
import javax.baja.user.BUser;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class BLdapExt
extends BComponent {
    public static final Property enableConnectionPooling = BLdapExt.newProperty((int)0, (boolean)true, null);
    public static final Property connectionUrl = BLdapExt.newProperty((int)0, (String)"ldap://example.com", null);
    public static final Property SSL = BLdapExt.newProperty((int)0, (boolean)false, null);
    public static final Property userLoginAttr = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property userBase = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property attrEmail = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property attrFullName = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property attrLanguage = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property attrCellPhoneNumber = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property attrPrototype = BLdapExt.newProperty((int)0, (String)"", null);
    public static final Property cacheExpiration = BLdapExt.newProperty((int)0, (BValue)BRelTime.make((long)604800000L), null);
    public static final Property initialContextFactory = BLdapExt.newProperty((int)4, (String)"com.sun.jndi.ldap.LdapCtxFactory", null);
    public static final Property referral = BLdapExt.newProperty((int)4, (String)"follow", null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BLdapExt.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt));
    protected static final Lexicon lex = Lexicon.make((Class)(class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BLdapExt.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt));
    protected static final String DEFAULT_PROTOTYPE = "defaultPrototype";
    protected static final String MISSING_ATT_LANG = "ldap.error.userLangAtt";
    protected static final String MISSING_ATT_NAME = "ldap.error.userNameAtt";
    protected static final String MISSING_ATT_EMAIL = "ldap.error.userEMailAtt";
    protected static final String MISSING_ATT_CELL = "ldap.error.userCellAtt";
    protected static final String MISSING_ATT_PROTOTYPE = "ldap.error.missingPrototypeAtt";
    protected static final String MSG_PROTOTYPE_NOT_FOUND = "ldap.warning.prototypeNotFound";
    protected static final String ERR_LDAP_SEARCH = "ldap.error.ldapsearch";
    protected static final String ERR_LDAP_LOCKOUT = "ldap.error.lockout";
    protected static final String ERR_LDAP_AUTH_FAILED = "ldap.error.authFailed";
    protected static final String ERR_LDAP_USER_NOT_FOUND = "ldap.error.userNotFound";
    protected static final String ERR_LDAP_ATTR = "ldap.error.attributes";
    protected static final String ERR_LDAP_SSL_SOCKET_FACT = "ldap.error.SSLSocketFactory";
    protected static final String LDAP_LOGIN_AUTH_CACHED = "ldap.login.authCached";
    protected static Log log = Log.getLog((String)"ldap");
    protected BLdapUserService service;
    static /* synthetic */ Class class$javax$baja$ldap$BLdapExt;
    static /* synthetic */ Class class$javax$baja$user$BUser;

    public boolean getEnableConnectionPooling() {
        return this.getBoolean(enableConnectionPooling);
    }

    public void setEnableConnectionPooling(boolean bl) {
        this.setBoolean(enableConnectionPooling, bl, null);
    }

    public String getConnectionUrl() {
        return this.getString(connectionUrl);
    }

    public void setConnectionUrl(String string) {
        this.setString(connectionUrl, string, null);
    }

    public boolean getSSL() {
        return this.getBoolean(SSL);
    }

    public void setSSL(boolean bl) {
        this.setBoolean(SSL, bl, null);
    }

    public String getUserLoginAttr() {
        return this.getString(userLoginAttr);
    }

    public void setUserLoginAttr(String string) {
        this.setString(userLoginAttr, string, null);
    }

    public String getUserBase() {
        return this.getString(userBase);
    }

    public void setUserBase(String string) {
        this.setString(userBase, string, null);
    }

    public String getAttrEmail() {
        return this.getString(attrEmail);
    }

    public void setAttrEmail(String string) {
        this.setString(attrEmail, string, null);
    }

    public String getAttrFullName() {
        return this.getString(attrFullName);
    }

    public void setAttrFullName(String string) {
        this.setString(attrFullName, string, null);
    }

    public String getAttrLanguage() {
        return this.getString(attrLanguage);
    }

    public void setAttrLanguage(String string) {
        this.setString(attrLanguage, string, null);
    }

    public String getAttrCellPhoneNumber() {
        return this.getString(attrCellPhoneNumber);
    }

    public void setAttrCellPhoneNumber(String string) {
        this.setString(attrCellPhoneNumber, string, null);
    }

    public String getAttrPrototype() {
        return this.getString(attrPrototype);
    }

    public void setAttrPrototype(String string) {
        this.setString(attrPrototype, string, null);
    }

    public BRelTime getCacheExpiration() {
        return (BRelTime)this.get(cacheExpiration);
    }

    public void setCacheExpiration(BRelTime bRelTime) {
        this.set(cacheExpiration, (BValue)bRelTime, null);
    }

    public String getInitialContextFactory() {
        return this.getString(initialContextFactory);
    }

    public void setInitialContextFactory(String string) {
        this.setString(initialContextFactory, string, null);
    }

    public String getReferral() {
        return this.getString(referral);
    }

    public void setReferral(String string) {
        this.setString(referral, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BICredentials challenge(FoxSession foxSession) throws Exception {
        throw new AuthenticationException("Unimplemented method 'challenge'");
    }

    public BUser authenticate(String string, String string2, Context context) throws AuthenticationException {
        throw new AuthenticationException();
    }

    public BUser authenticate(BICredentials bICredentials, Context context) throws AuthenticationException {
        throw new AuthenticationException();
    }

    public FoxMessage getRejectedData() {
        return null;
    }

    public Log getLog() {
        return log;
    }

    public BLdapUserService getService() {
        return this.service;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof BLdapUserService;
    }

    public void started() throws Exception {
        this.service = (BLdapUserService)this.getParent();
        super.started();
    }

    protected BUser authCachedCredentials(String string, String string2, Context context) {
        log.message(lex.getText(LDAP_LOGIN_AUTH_CACHED));
        try {
            BUser bUser = this.getService().getUser(string);
            if (null != bUser) {
                return AuthenticateUtil.authenticateUsernameAndPassword((String)string, (String)string2, (BUserService)this.getService(), (Context)context);
            }
        }
        catch (AuthenticationException authenticationException) {
            log.warning(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}));
            throw new AuthenticationException(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}));
        }
        throw new AuthenticationException(lex.getText(ERR_LDAP_AUTH_FAILED, new Object[]{string}));
    }

    protected BUser prepareUser(String string, String string2, BUser bUser, Attributes attributes, DirContext dirContext) throws NamingException {
        BUser bUser2 = (BUser)this.service.getUserPrototypes().get(DEFAULT_PROTOTYPE);
        bUser2 = this.getPrototypeUserAccount(string, attributes, dirContext, bUser2);
        return this.prepareUser(string, string2, bUser, bUser2, attributes, dirContext);
    }

    protected BUser prepareUser(String string, String string2, BUser bUser, BUser bUser2, Attributes attributes, DirContext dirContext) throws NamingException {
        if (null == bUser2) {
            bUser2 = (BUser)this.service.getUserPrototypes().get(DEFAULT_PROTOTYPE);
            bUser2 = this.getPrototypeUserAccount(string, attributes, dirContext, bUser2);
        }
        if (bUser == null) {
            bUser = this.addUser(string, bUser2);
        }
        if (string2 != null) {
            bUser.setPassword(BPassword.make((String)string2));
        }
        bUser.setEnabled(bUser2.getEnabled());
        bUser.setPermissions(bUser2.getPermissions());
        BAbsTime bAbsTime = bUser2.getExpiration();
        BRelTime bRelTime = this.getCacheExpiration();
        if (bRelTime.getMillis() > 0L) {
            BAbsTime bAbsTime2 = Clock.time().add(bRelTime);
            if (bAbsTime.isNull() || bAbsTime2.isBefore(bAbsTime)) {
                bAbsTime = bAbsTime2;
            }
        }
        bUser.setExpiration(bAbsTime);
        this.setEmailFromLDAPAttribute(string, bUser, attributes);
        this.setFullNameFromLDAPAttribute(string, bUser, attributes);
        this.setLanguageFromLDAPAttribute(string, bUser, attributes);
        this.setCellPhoneNumberFromLDAPAttribute(string, bUser, attributes);
        return bUser;
    }

    protected void validateUser(BUser bUser, Context context) throws AuthenticationException {
        if (bUser != null && bUser.getLockOut()) {
            bUser.authenticateFailed((BUserService)this.service);
            this.service.auditLoginAttempt(false, bUser, context);
            throw new AuthenticationException(lex.getText(ERR_LDAP_LOCKOUT, new Object[]{bUser.getUsername()}));
        }
    }

    protected BUser getPrototypeUserAccount(String string, Attributes attributes, DirContext dirContext, BUser bUser) throws NamingException {
        BUser[] bUserArray;
        if (this.getAttrPrototype().length() > 0 && (bUserArray = this.getProtoUsers()) != null && bUserArray.length > 0) {
            Attribute attribute = attributes.get(this.getAttrPrototype());
            if (attribute != null) {
                int n = attribute.size();
                NameParser nameParser = dirContext.getNameParser("");
                int n2 = Integer.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    int n3;
                    String string2 = attribute.get(i).toString().trim();
                    if (string2.indexOf(61) >= 0) {
                        try {
                            string2 = this.prototypeName(nameParser.parse(string2));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (string2.length() <= 0 || (n3 = this.indexOf(string2, bUserArray)) < 0 || n3 >= n2) continue;
                    n2 = n3;
                }
                if (n2 < Integer.MAX_VALUE) {
                    bUser = bUserArray[n2];
                } else {
                    log.warning(lex.getText(MSG_PROTOTYPE_NOT_FOUND, new Object[]{string}));
                }
            } else {
                log.trace(lex.getText(MISSING_ATT_PROTOTYPE, new Object[]{string, this.getAttrPrototype()}));
            }
        }
        return bUser;
    }

    protected BUser addUser(String string, BUser bUser) {
        String string2 = bUser.getName();
        BUser bUser2 = (BUser)bUser.newCopy(true);
        this.service.addLdapUser(string, bUser2, string2);
        return bUser2;
    }

    protected void setLanguageFromLDAPAttribute(String string, BUser bUser, Attributes attributes) throws NamingException {
        if (this.getAttrLanguage().length() > 0) {
            Attribute attribute = attributes.get(this.getAttrLanguage());
            if (attribute != null) {
                bUser.setLanguage(attribute.get().toString());
            } else {
                log.warning(lex.getText(MISSING_ATT_LANG, new Object[]{string, this.getAttrLanguage()}));
            }
        }
    }

    protected void setFullNameFromLDAPAttribute(String string, BUser bUser, Attributes attributes) throws NamingException {
        if (this.getAttrFullName().length() > 0) {
            Attribute attribute = attributes.get(this.getAttrFullName());
            if (attribute != null) {
                bUser.setFullName(attribute.get().toString());
            } else {
                log.warning(lex.getText(MISSING_ATT_NAME, new Object[]{string, this.getAttrFullName()}));
            }
        }
    }

    protected void setEmailFromLDAPAttribute(String string, BUser bUser, Attributes attributes) throws NamingException {
        if (this.getAttrEmail().length() > 0) {
            Attribute attribute = attributes.get(this.getAttrEmail());
            if (attribute != null) {
                bUser.setEmail(attribute.get().toString());
            } else {
                log.warning(lex.getText(MISSING_ATT_EMAIL, new Object[]{string, this.getAttrEmail()}));
            }
        }
    }

    protected void setCellPhoneNumberFromLDAPAttribute(String string, BUser bUser, Attributes attributes) throws NamingException {
        if (this.getAttrCellPhoneNumber().length() > 0) {
            Attribute attribute = attributes.get(this.getAttrCellPhoneNumber());
            if (attribute != null) {
                bUser.setCellPhoneNumber(attribute.get().toString());
            } else {
                log.warning(lex.getText(MISSING_ATT_CELL, new Object[]{string, this.getAttrCellPhoneNumber()}));
            }
        }
    }

    protected BUser[] getProtoUsers() {
        BUserPrototypes bUserPrototypes = this.service.getUserPrototypes();
        return (BUser[])bUserPrototypes.getChildren(class$javax$baja$user$BUser == null ? (class$javax$baja$user$BUser = BLdapExt.class$("javax.baja.user.BUser")) : class$javax$baja$user$BUser);
    }

    protected int indexOf(String string, BUser[] bUserArray) {
        string = SlotPath.escape((String)string);
        int n = bUserArray.length;
        while (--n >= 0) {
            if (!bUserArray[n].getName().equals(string)) continue;
            return n;
        }
        return -1;
    }

    protected String prototypeName(Name name) {
        name = name.getSuffix(name.size() - 1);
        String string = name.toString();
        return string.substring(string.indexOf(61) + 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

