/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import com.tridium.httpd.CookieUtil;
import com.tridium.httpd.HttpRequest;
import com.tridium.ldap.v3.BLdapV3Ext;
import com.tridium.ldap.v3.auth.BKerberosAuthenticator;
import com.tridium.ldap.v3.auth.KerberosKeytabConfig;
import com.tridium.ldap.v3.web.AcquireHttpCredentialsAction;
import com.tridium.nre.auth.ScramSha256Server;
import com.tridium.web.BHttpAuthAgent;
import com.tridium.web.BHttpUsernamePasswordAuthAgent;
import com.tridium.web.WebUtil;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.io.Base64;
import javax.baja.ldap.BLdapExt;
import javax.baja.ldap.BLdapUserService;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebService;
import javax.baja.web.LoginState;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BHttpLdapAuthAgent
extends BHttpUsernamePasswordAuthAgent {
    public static final BHttpLdapAuthAgent INSTANCE = new BHttpLdapAuthAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BHttpLdapAuthAgent == null ? (class$javax$baja$ldap$BHttpLdapAuthAgent = BHttpLdapAuthAgent.class$("javax.baja.ldap.BHttpLdapAuthAgent")) : class$javax$baja$ldap$BHttpLdapAuthAgent));
    private static final String REQUIRED_JAVA_VERSION = "1.6";
    private static final String COOKIE_HIDE_KERB_LOGIN = "niagara_hide_kerb_login";
    private static final String COOKIE_USE_KERB_CREDS = "niagara_use_kerb_creds";
    private static final Lexicon lex = Lexicon.make((Class)(class$javax$baja$ldap$BHttpLdapAuthAgent == null ? (class$javax$baja$ldap$BHttpLdapAuthAgent = BHttpLdapAuthAgent.class$("javax.baja.ldap.BHttpLdapAuthAgent")) : class$javax$baja$ldap$BHttpLdapAuthAgent));
    private static final String LEX_WEB_LOGIN_FAILED = "ldap.kerberos.web.loginFailed";
    private static final String LEX_WEB_LOGIN_FAILED_LINK = "ldap.kerberos.web.loginFailed.linkText";
    private static final String LEX_WEB_LOGIN_FAILED_DETAILS = "ldap.kerberos.web.loginFailed.details";
    private static final String LEX_WEB_LOGIN_FAILED_UNSUPPORTED = "ldap.kerberos.web.loginFailed.unsupported";
    private static final String LEX_WEB_HIDE = "ldap.kerberos.web.hideLogin";
    private static final String LEX_WEB_SHOW = "ldap.kerberos.web.showLogin";
    private static final String LEX_WEB_DESCRIPTION = "ldap.kerberos.web.description";
    private static final String LEX_WEB_HELP = "ldap.kerberos.web.help";
    private static final String LEX_WEB_LOGIN = "ldap.kerberos.web.loginButton";
    private static final String LEX_WEB_REMEMBER = "ldap.kerberos.web.remember";
    private static final String LEX_AUTH_LDAP_SERVER = "ldap.http.augh.connectToServer";
    private static final String LEX_AUTH_CACHED = "ldap.http.auth.tryCache";
    private static final String SESSION_ATTR_KERB_CREDS = "kerberosCredentials";
    private static final String SESSION_ATTR_LAST_CONNECT_TO_LDAP = "lastConnectTimeToLdap";
    private static final long MAX_TIME_UNTIL_CONNENT_TO_LDAP = 300000L;
    static /* synthetic */ Class class$javax$baja$ldap$BHttpLdapAuthAgent;
    static /* synthetic */ Class class$com$tridium$ldap$v3$BLdapV3Ext;
    static /* synthetic */ Class class$com$tridium$ldap$v3$auth$BKerberosAuthenticator;

    public Type getType() {
        return TYPE;
    }

    private BHttpLdapAuthAgent() {
        BWebService bWebService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        if (bWebService != null) {
            bWebService.initFileResources((BIDirectory)BOrd.make((String)"module://ldap/com/tridium/ldap/v3/web/rc").resolve().get());
        }
    }

    public void doLoginGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = httpServletRequest.getRequestURI();
        if (string.toLowerCase().startsWith("/login-kerb")) {
            String string2 = httpServletRequest.getHeader("authorization");
            if (string2 != null) {
                String string3 = string2.substring("Negotiate ".length());
                BKerberosCredentials bKerberosCredentials = this.getCredentialsFromToken(string3);
                if (bKerberosCredentials == null) {
                    String string4 = CookieUtil.getCookieName((HttpServletRequest)httpServletRequest, (String)"niagara_login_state");
                    Cookie cookie = new Cookie(string4, String.valueOf(4));
                    cookie.setPath("/");
                    httpServletResponse.addCookie(cookie);
                    this.invalidateSession(httpServletRequest, httpServletResponse);
                    httpServletResponse.sendRedirect(WebUtil.getAbsolutePathBase((HttpServletRequest)httpServletRequest) + "login");
                    return;
                }
                httpServletRequest.getSession().setAttribute(SESSION_ATTR_KERB_CREDS, (Object)bKerberosCredentials);
                httpServletRequest.getSession().setAttribute("sessionInfoUser", (Object)bKerberosCredentials.getUsername());
                httpServletResponse.sendRedirect("/");
                return;
            }
        } else {
            Cookie cookie = this.getCookie(httpServletRequest, COOKIE_USE_KERB_CREDS);
            if (cookie != null && cookie.getValue().equals("true")) {
                httpServletResponse.sendRedirect("/login-kerb");
                return;
            }
        }
        super.doLoginGet(httpServletRequest, httpServletResponse);
    }

    public String getLoginMessageContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LoginState loginState) {
        if (loginState.getState() == 4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" <b>" + lex.getText(LEX_WEB_LOGIN_FAILED) + "</b><br>");
            String string = System.getProperty("java.version", "1.5");
            if (string.compareTo(REQUIRED_JAVA_VERSION) < 0) {
                stringBuffer.append(" " + lex.getText(LEX_WEB_LOGIN_FAILED_UNSUPPORTED) + "");
            } else {
                stringBuffer.append(" " + this.buildHelpLink(lex.getText(LEX_WEB_LOGIN_FAILED_LINK)) + "<br>");
                stringBuffer.append(" " + lex.getText(LEX_WEB_LOGIN_FAILED_DETAILS) + "");
            }
            return stringBuffer.toString();
        }
        return super.getLoginMessageContent(httpServletRequest, httpServletResponse, loginState);
    }

    protected void doWriteCustomLoginAddition(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        String string = System.getProperty("java.version", "1.5");
        if (string.compareTo(REQUIRED_JAVA_VERSION) < 0) {
            return;
        }
        String string2 = "Network";
        BKerberosAuthenticator bKerberosAuthenticator = this.getKerberosAuthenticator();
        if (bKerberosAuthenticator == null) {
            return;
        }
        string2 = bKerberosAuthenticator.getRealmDisplayName();
        if (string2.equals("")) {
            string2 = bKerberosAuthenticator.getRealm();
        }
        boolean bl = false;
        Cookie cookie = this.getCookie(httpServletRequest, COOKIE_HIDE_KERB_LOGIN);
        String string3 = "";
        if (cookie != null && cookie.getValue().equals("true")) {
            string3 = " style='display:none;'";
            bl = true;
        }
        Object[] objectArray = new Object[]{string2};
        String string4 = bl ? lex.getText(LEX_WEB_SHOW, objectArray) : lex.getText(LEX_WEB_HIDE, objectArray);
        String string5 = lex.getText(LEX_WEB_DESCRIPTION, objectArray);
        String string6 = lex.getText(LEX_WEB_HELP);
        String string7 = lex.getText(LEX_WEB_LOGIN, objectArray);
        String string8 = lex.getText(LEX_WEB_REMEMBER);
        printWriter.println(" <tr><td colspan='2' align='left'>");
        printWriter.println("  <label>OR</label> (<a href='javascript:void(0)' vlink='#FF' alink='#0000FF' onclick='toggleBox(this);'>" + string4 + "</a>)");
        printWriter.println("  <hr align='right' valign='top' width='100%' size='1'>");
        printWriter.println(" </td></tr>");
        printWriter.println(" <tr id='box'" + string3 + ">");
        printWriter.println("  <td colspan='2' align='right'>");
        printWriter.println("   <div><label>" + string5 + "</label></div>");
        printWriter.println("   <div style='margin:0px 2px 10px 0px;'>" + this.buildHelpLink(string6) + "</div>");
        printWriter.println("   <div><input id='kerberosButton' type='submit' class='button' value='" + string7 + "'/></div>");
        printWriter.println("   <div style='margin:5px 2px 0px 0px;'><input type='checkbox' name='kerberos' value='remember'>" + string8 + "</div>");
        printWriter.println("  </td>");
        printWriter.println(" </tr>");
        printWriter.println(" <tr><td colspan='2'></td></tr>");
        printWriter.println(" ");
        printWriter.println(" <script>");
        printWriter.println(this.buildJavascriptToggle(string2));
        printWriter.println(" </script>");
    }

    public void doLoginPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        byte[] byArray = new byte[httpServletRequest.getContentLength()];
        DataInputStream dataInputStream = new DataInputStream((InputStream)httpServletRequest.getInputStream());
        dataInputStream.readFully(byArray);
        String string = new String(byArray);
        String[] stringArray = TextUtil.split((String)string, (char)'&');
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 1);
            hashtable.put(BHttpLdapAuthAgent.decodeValue((String)"", (String)string2), BHttpLdapAuthAgent.decodeValue((String)string2, (String)string3));
        }
        if (httpServletRequest.getContentType().startsWith("application/x-niagara-login-support")) {
            if (hashtable.get("action").equals("sendClientFirstMessage")) {
                String string4 = ScramSha256Server.extractUsername((String)((String)hashtable.get("clientFirstMessage")));
                BLdapUserService bLdapUserService = (BLdapUserService)this.getUserService();
                if (!bLdapUserService.isLocalUser(string4)) {
                    BLdapUserService.log.error("Cookie-digest authentication is not supported by the LdapUserService, please change the authentication property of the WebService to basic or cookie.");
                    throw new AuthenticationException();
                }
            }
            super.handleLoginSupport(hashtable, httpServletRequest, httpServletResponse);
            return;
        }
        String string5 = (String)hashtable.get("token");
        if (string5 != null && !string5.equals("")) {
            super.handleFormLogin(hashtable, httpServletRequest, httpServletResponse);
            return;
        }
        if (hashtable.containsKey("kerberos")) {
            Cookie cookie = new Cookie(COOKIE_USE_KERB_CREDS, "true");
            cookie.setMaxAge(31536000);
            cookie.setPath("/");
            httpServletResponse.addCookie(cookie);
        }
        if (httpServletRequest instanceof HttpRequest) {
            ((HttpRequest)httpServletRequest).resetSession();
        }
        httpServletResponse.sendRedirect("/login-kerb");
    }

    private String buildHelpLink(String string) {
        String string2 = "<a href=\"/help-kerberos.html\" onclick=\"window.open('/help-kerberos.html','popup','width=500,height=500,scrollbars=yes,resizable=yes,toolbar=no,directories=no,location=no,menubar=no,status=no,left=0,top=0'); return false\">" + string + "</a>";
        return string2;
    }

    private String buildJavascriptToggle(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = lex.getText(LEX_WEB_HIDE, new Object[]{string});
        String string3 = lex.getText(LEX_WEB_SHOW, new Object[]{string});
        stringBuffer.append("function toggleBox(obj) {\n");
        stringBuffer.append("  var box = document.getElementById('box');\n");
        stringBuffer.append("  var expDate = new Date();\n");
        stringBuffer.append("  expDate.setDate(expDate.getDate()+365);\n");
        stringBuffer.append("  var c_value;\n");
        stringBuffer.append("  if (box.style.display == 'none') {\n");
        stringBuffer.append("    box.style.display = '';\n");
        stringBuffer.append("    obj.innerHTML = '" + string2 + "';\n");
        stringBuffer.append("    c_value = ''");
        stringBuffer.append("  } else {\n");
        stringBuffer.append("    box.style.display = 'none';\n");
        stringBuffer.append("    obj.innerHTML = '" + string3 + "';\n");
        stringBuffer.append("    c_value = 'true;expires=' + expDate.toUTCString();\n");
        stringBuffer.append("  }\n");
        stringBuffer.append("  document.cookie = 'niagara_hide_kerb_login=' + c_value;\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    private Cookie getCookie(HttpServletRequest httpServletRequest, String string) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(string)) continue;
            return cookieArray[i];
        }
        return null;
    }

    private BKerberosCredentials getCredentialsFromToken(String string) {
        BKerberosAuthenticator bKerberosAuthenticator = this.getKerberosAuthenticator();
        if (bKerberosAuthenticator == null) {
            return null;
        }
        String string2 = bKerberosAuthenticator.getRealm();
        String string3 = bKerberosAuthenticator.getKeyDistributionCenter();
        String string4 = bKerberosAuthenticator.getStationKerberosName();
        BOrd bOrd = bKerberosAuthenticator.getKeyTabLocation();
        if (bOrd == null || bOrd.isNull()) {
            throw new AuthenticationException("Check station settings. Keytab location must be specified for web login");
        }
        String string5 = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath()).getPath();
        System.setProperty("java.security.krb5.realm", string2);
        System.setProperty("java.security.krb5.kdc", string3);
        LoginContext loginContext = null;
        try {
            loginContext = new LoginContext("javax.baja.ldap.v3.web.BHttpLdapAuthAgent", null, null, new KerberosKeytabConfig(string4, string5));
            loginContext.login();
        }
        catch (LoginException loginException) {
            loginException.printStackTrace();
            return null;
        }
        AcquireHttpCredentialsAction acquireHttpCredentialsAction = new AcquireHttpCredentialsAction(string);
        BKerberosCredentials bKerberosCredentials = (BKerberosCredentials)Subject.doAs(loginContext.getSubject(), acquireHttpCredentialsAction);
        return bKerberosCredentials;
    }

    public BUser authenticate(BHttpAuthAgent.AuthContext authContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        BFacets bFacets = null;
        if (authContext.getAudit()) {
            bFacets = BFacets.make((String)"target", (BIDataValue)BString.make((String)this.getWebService().toPathString()), (String)"slotName", (BIDataValue)BString.make((String)(authContext.getRemoteHost() != null ? authContext.getRemoteHost() : "")));
        }
        BUser bUser = null;
        String string = authContext.getScheme();
        bUser = authContext.getScheme() != null && authContext.getScheme().equalsIgnoreCase("Kerberos") ? this.authenticateKerberos((BHttpUsernamePasswordAuthAgent.SessionAuthContext)authContext, (Context)bFacets) : (authContext.getScheme() != null && authContext.getScheme().equalsIgnoreCase("Basic") ? this.authenticateBasic(authContext, (Context)bFacets) : (this.isDigest() ? this.authenticateDigest((BHttpUsernamePasswordAuthAgent.SessionAuthContext)authContext, (Context)bFacets) : this.authenticateBasic(authContext, (Context)bFacets)));
        if (bUser != null) {
            this.updateCookie(authContext, httpServletRequest, httpServletResponse);
        }
        return bUser;
    }

    protected BUser authenticateBasic(BHttpAuthAgent.AuthContext authContext, Context context) throws AuthenticationException {
        if (authContext instanceof BHttpUsernamePasswordAuthAgent.SessionAuthContext) {
            return super.authenticateSession((BHttpUsernamePasswordAuthAgent.SessionAuthContext)authContext, context);
        }
        if (authContext instanceof BHttpUsernamePasswordAuthAgent.BasicAuthContext) {
            Object object;
            BHttpUsernamePasswordAuthAgent.BasicAuthContext basicAuthContext = (BHttpUsernamePasswordAuthAgent.BasicAuthContext)authContext;
            BLdapUserService bLdapUserService = (BLdapUserService)this.getUserService();
            String string = basicAuthContext.getUsername();
            String string2 = basicAuthContext.getPassword();
            HttpSession httpSession = authContext.getSession();
            if (string == null || string.length() == 0) {
                throw new AuthenticationException();
            }
            if (bLdapUserService.isLocalUser(string)) {
                return super.authenticateBasic((BHttpAuthAgent.AuthContext)basicAuthContext, context);
            }
            BLdapExt bLdapExt = bLdapUserService.ext();
            if (bLdapExt == null) {
                BLdapUserService.log.error(bLdapUserService.toPathString() + " missing child BLdapExt instance.");
                throw new AuthenticationException();
            }
            if (httpSession != null && !httpSession.isNew()) {
                object = (Long)httpSession.getAttribute(SESSION_ATTR_LAST_CONNECT_TO_LDAP);
                if (object == null) {
                    object = new Long(0L);
                }
                if (BAbsTime.now().getMillis() - (Long)object < 300000L) {
                    BLdapUserService.log.trace(lex.getText(LEX_AUTH_CACHED, new Object[]{string}));
                    BUser bUser = super.authenticateBasic((BHttpAuthAgent.AuthContext)basicAuthContext, context);
                    if (bUser != null) {
                        return bUser;
                    }
                } else {
                    BLdapUserService.log.trace(lex.getText(LEX_AUTH_LDAP_SERVER, new Object[]{string}));
                }
            }
            object = bLdapExt.authenticate(string, string2, context);
            if (httpSession != null) {
                httpSession.setAttribute(SESSION_ATTR_LAST_CONNECT_TO_LDAP, (Object)new Long(BAbsTime.now().getMillis()));
            }
            if (object == null) {
                BLdapUserService.log.message(lex.getText(LEX_AUTH_CACHED, new Object[]{string}));
                return super.authenticateBasic((BHttpAuthAgent.AuthContext)basicAuthContext, context);
            }
            return object;
        }
        throw new AuthenticationException("Invalid state");
    }

    protected BUser authenticateDigest(BHttpUsernamePasswordAuthAgent.SessionAuthContext sessionAuthContext, Context context) throws AuthenticationException {
        String string;
        BLdapUserService bLdapUserService = (BLdapUserService)this.getUserService();
        if (bLdapUserService.isLocalUser(string = sessionAuthContext.getUsername())) {
            return super.authenticateDigest(sessionAuthContext, context);
        }
        BLdapUserService.log.error("Cookie-digest authentication is not supported by the LdapUserService, please change the authentication property of the WebService to basic or cookie.");
        throw new AuthenticationException();
    }

    protected BUser authenticateKerberos(BHttpUsernamePasswordAuthAgent.SessionAuthContext sessionAuthContext, Context context) throws AuthenticationException {
        Object object;
        Object object2;
        BLdapUserService bLdapUserService = (BLdapUserService)this.getUserService();
        String string = sessionAuthContext.getUsername();
        HttpSession httpSession = sessionAuthContext.getSession();
        if (string == null || string.length() == 0) {
            throw new AuthenticationException();
        }
        if (bLdapUserService.isLocalUser(string)) {
            throw new AuthenticationException();
        }
        BLdapExt bLdapExt = bLdapUserService.ext();
        if (bLdapExt == null) {
            BLdapUserService.log.error(bLdapUserService.toPathString() + " missing child BLdapExt instance.");
            throw new AuthenticationException();
        }
        if (httpSession != null && !httpSession.isNew()) {
            boolean bl;
            object2 = (Long)httpSession.getAttribute(SESSION_ATTR_LAST_CONNECT_TO_LDAP);
            if (object2 == null) {
                object2 = new Long(0L);
            }
            boolean bl2 = bl = (object = (Boolean)httpSession.getAttribute("sessionInfoAuth")) != null && ((Boolean)object).booleanValue();
            if (bl && BAbsTime.now().getMillis() - (Long)object2 < 300000L) {
                BUser bUser = bLdapUserService.getUser(string);
                if (bUser != null) {
                    return bUser;
                }
            } else {
                BLdapUserService.log.trace(Lexicon.make((Class)(class$javax$baja$ldap$BHttpLdapAuthAgent == null ? (class$javax$baja$ldap$BHttpLdapAuthAgent = BHttpLdapAuthAgent.class$("javax.baja.ldap.BHttpLdapAuthAgent")) : class$javax$baja$ldap$BHttpLdapAuthAgent)).getText(LEX_AUTH_LDAP_SERVER, new Object[]{string}));
            }
        }
        if ((object2 = (BKerberosCredentials)httpSession.getAttribute(SESSION_ATTR_KERB_CREDS)) == null) {
            throw new AuthenticationException();
        }
        object = bLdapExt.authenticate((BICredentials)object2, context);
        if (httpSession != null) {
            httpSession.setAttribute(SESSION_ATTR_LAST_CONNECT_TO_LDAP, (Object)new Long(BAbsTime.now().getMillis()));
        }
        return object;
    }

    protected BHttpAuthAgent.AuthContext getFromCookie(Cookie cookie, boolean bl) throws Exception {
        BHttpUsernamePasswordAuthAgent.BasicAuthContext basicAuthContext = null;
        String string = cookie.getName();
        if (string.equals("niagara_auth") || string.equals("niagara_auth_auto")) {
            String string2 = cookie.getValue();
            string2 = Base64.decodeToString((String)string2);
            basicAuthContext = new BHttpUsernamePasswordAuthAgent.BasicAuthContext((BHttpUsernamePasswordAuthAgent)this, string2);
            basicAuthContext.setScheme("Cookie");
        } else if (string.equals("niagara_session")) {
            String string3 = cookie.getValue();
            BWebService bWebService = (BWebService)Sys.getService((Type)BWebService.TYPE);
            HttpSession httpSession = bWebService.getHttpSession(string3);
            if (httpSession != null) {
                String string4 = (String)httpSession.getAttribute("sessionInfoUser");
                basicAuthContext = new BHttpUsernamePasswordAuthAgent.SessionAuthContext((BHttpUsernamePasswordAuthAgent)this, string4);
                if (httpSession.getAttribute(SESSION_ATTR_KERB_CREDS) != null) {
                    basicAuthContext.setScheme("Kerberos");
                }
            }
        }
        return basicAuthContext;
    }

    private BKerberosAuthenticator getKerberosAuthenticator() {
        BLdapUserService bLdapUserService = null;
        try {
            bLdapUserService = (BLdapUserService)Sys.getService((Type)BUserService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
        BLdapV3Ext bLdapV3Ext = null;
        Object[] objectArray = bLdapUserService.getChildren(class$com$tridium$ldap$v3$BLdapV3Ext == null ? (class$com$tridium$ldap$v3$BLdapV3Ext = BHttpLdapAuthAgent.class$("com.tridium.ldap.v3.BLdapV3Ext")) : class$com$tridium$ldap$v3$BLdapV3Ext);
        if (objectArray.length > 0) {
            bLdapV3Ext = (BLdapV3Ext)((Object)objectArray[0]);
        }
        if (bLdapV3Ext == null) {
            return null;
        }
        BKerberosAuthenticator bKerberosAuthenticator = null;
        Object[] objectArray2 = bLdapV3Ext.getChildren(class$com$tridium$ldap$v3$auth$BKerberosAuthenticator == null ? (class$com$tridium$ldap$v3$auth$BKerberosAuthenticator = BHttpLdapAuthAgent.class$("com.tridium.ldap.v3.auth.BKerberosAuthenticator")) : class$com$tridium$ldap$v3$auth$BKerberosAuthenticator);
        if (objectArray2.length > 0) {
            bKerberosAuthenticator = (BKerberosAuthenticator)((Object)objectArray2[0]);
        }
        if (bKerberosAuthenticator == null) {
            return null;
        }
        return bKerberosAuthenticator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

