/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ldap;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.Acceptor;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxUsernamePasswordAuthAgent;
import javax.baja.ldap.BActiveDirectoryExt;
import javax.baja.ldap.BLdapExt;
import javax.baja.ldap.BLdapUserService;
import javax.baja.ldap.BLdapV2;
import javax.baja.log.Log;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

public class BFoxLdapAuthAgent
extends BFoxUsernamePasswordAuthAgent {
    public static final BFoxLdapAuthAgent INSTANCE = new BFoxLdapAuthAgent();
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ldap$BFoxLdapAuthAgent == null ? (class$javax$baja$ldap$BFoxLdapAuthAgent = BFoxLdapAuthAgent.class$("javax.baja.ldap.BFoxLdapAuthAgent")) : class$javax$baja$ldap$BFoxLdapAuthAgent));
    static /* synthetic */ Class class$javax$baja$ldap$BFoxLdapAuthAgent;
    static /* synthetic */ Class class$javax$baja$ldap$BLdapExt;

    public Type getType() {
        return TYPE;
    }

    protected boolean authenticateBasic(FoxSession foxSession) throws Exception {
        BLdapExt bLdapExt = this.getLdapExt();
        if (bLdapExt instanceof BLdapV2 || bLdapExt instanceof BActiveDirectoryExt) {
            return super.authenticateBasic(foxSession);
        }
        if (foxSession.getRemoteHello().getString("app.version", "3.8").compareTo("3.8") < 0) {
            BFoxService bFoxService = (BFoxService)Sys.getService((Type)BFoxService.TYPE);
            BAbsTime bAbsTime = bFoxService.getLegacyAuthentication();
            if (!bAbsTime.isNull() && bAbsTime.isAfter(BAbsTime.now())) {
                return super.authenticateBasic(foxSession);
            }
            Log log = Log.getLog((String)"ldap.auth");
            if (log.isTraceOn()) {
                log.error(Lexicon.make((String)"fox").getText("fox.legacy.cannotAuth"));
            }
            return false;
        }
        BICredentials bICredentials = null;
        bICredentials = bLdapExt.challenge(foxSession);
        String string = null;
        if (null != bICredentials) {
            if (!(bICredentials instanceof BIUserCredentials)) {
                throw new FoxAuthenticationException("Unsupported credential type: " + bICredentials.getType().getTypeName(), foxSession);
            }
        } else {
            return false;
        }
        BIUserCredentials bIUserCredentials = (BIUserCredentials)bICredentials;
        string = bIUserCredentials.getUsername();
        foxSession.setState("server.tune receivedLogin user=" + string);
        Acceptor.accept((FoxSession)foxSession);
        bIUserCredentials = this.authenticateAttempt(foxSession, string);
        Context context = this.getAuditContext(foxSession);
        BUser bUser = null;
        if (bICredentials instanceof BHttpFoxCredentials) {
            try {
                bUser = BUserService.httpHandler.processCredentials((BHttpFoxCredentials)bICredentials, foxSession.getRemoteHost());
                bUser.authenticateOk((BUserService)bIUserCredentials);
                bIUserCredentials.auditLoginAttempt(true, bUser, context);
            }
            catch (AuthenticationException authenticationException) {
                if (bUser != null) {
                    bUser.authenticateFailed((BUserService)bIUserCredentials);
                    bIUserCredentials.auditLoginAttempt(false, bUser, context);
                }
                return false;
            }
        }
        try {
            bUser = this.authenticateUser((BUserService)bIUserCredentials, bICredentials, context);
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        this.authenticateSuccess(foxSession, bUser);
        return true;
    }

    protected BUser authenticateUser(BUserService bUserService, BICredentials bICredentials, Context context) {
        if (!(bICredentials instanceof BIUserCredentials)) {
            throw new AuthenticationException("Unsupported credentials type. Must be BIUserCredential.");
        }
        BIUserCredentials bIUserCredentials = (BIUserCredentials)bICredentials;
        String string = bIUserCredentials.getUsername();
        String string2 = null;
        if (bIUserCredentials instanceof BUsernameAndPassword) {
            string2 = ((BUsernameAndPassword)bIUserCredentials).getPassword().getValue();
        }
        BLdapUserService bLdapUserService = (BLdapUserService)bUserService;
        if (string == null || string.length() == 0) {
            throw new AuthenticationException();
        }
        if (bLdapUserService.isLocalUser(string)) {
            return super.authenticateUser(bUserService, string, string2, context);
        }
        BLdapExt bLdapExt = bLdapUserService.ext();
        if (bLdapExt == null) {
            BLdapUserService.log.error(bLdapUserService.toPathString() + " missing child BLdapExt instance.");
            throw new AuthenticationException();
        }
        BUser bUser = bLdapExt.authenticate(bICredentials, context);
        return bUser;
    }

    protected BUser authenticateUser(BUserService bUserService, String string, String string2, Context context) {
        BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(string, string2);
        return this.authenticateUser(bUserService, (BICredentials)bUsernameAndPassword, context);
    }

    private BLdapExt getLdapExt() {
        BLdapUserService bLdapUserService = (BLdapUserService)Sys.getService((Type)BUserService.TYPE);
        BLdapExt bLdapExt = null;
        Object[] objectArray = bLdapUserService.getChildren(class$javax$baja$ldap$BLdapExt == null ? (class$javax$baja$ldap$BLdapExt = BFoxLdapAuthAgent.class$("javax.baja.ldap.BLdapExt")) : class$javax$baja$ldap$BLdapExt);
        if (objectArray.length > 0) {
            bLdapExt = (BLdapExt)((Object)objectArray[0]);
        }
        return bLdapExt;
    }

    protected FoxMessage generateRejectedMessage(Throwable throwable, Throwable throwable2, Context context) {
        FoxMessage foxMessage = super.generateRejectedMessage(throwable, throwable2, context);
        FoxMessage foxMessage2 = new FoxMessage();
        try {
            foxMessage2 = foxMessage.getMessage("data");
        }
        catch (Exception exception) {
            foxMessage.add("data", foxMessage2);
        }
        FoxMessage foxMessage3 = this.getLdapExt().getRejectedData();
        if (foxMessage3 != null) {
            foxMessage2.add("ldap", foxMessage3);
        }
        return foxMessage;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

