/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3.auth;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.ldap.v3.BAuthenticationMechanism;
import com.tridium.ldap.v3.BLdapV3Ext;
import com.tridium.ldap.v3.BindNameFormatter;
import com.tridium.ldap.v3.auth.BAuthenticator;
import com.tridium.util.ValueByteBuffer;
import java.util.Hashtable;
import javax.baja.ldap.BLdapUserService;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class BSimpleAuthenticator
extends BAuthenticator {
    public static final Property connectionUser = BSimpleAuthenticator.newProperty((int)0, (String)"", null);
    public static final Property connectionPassword = BSimpleAuthenticator.newProperty((int)0, (BValue)BPassword.make((String)""), null);
    public static final Property authenticationMechanism = BSimpleAuthenticator.newProperty((int)0, (BValue)BAuthenticationMechanism.simple, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$ldap$v3$auth$BSimpleAuthenticator == null ? (class$com$tridium$ldap$v3$auth$BSimpleAuthenticator = BSimpleAuthenticator.class$("com.tridium.ldap.v3.auth.BSimpleAuthenticator")) : class$com$tridium$ldap$v3$auth$BSimpleAuthenticator));
    private static final String LDAP_UNSUPPORTED_CREDS = "ldap.error.unsupportedCred";
    static /* synthetic */ Class class$com$tridium$ldap$v3$auth$BSimpleAuthenticator;
    static /* synthetic */ Class class$com$tridium$ldap$v3$BLdapV3Ext;

    public String getConnectionUser() {
        return this.getString(connectionUser);
    }

    public void setConnectionUser(String string) {
        this.setString(connectionUser, string, null);
    }

    public BPassword getConnectionPassword() {
        return (BPassword)this.get(connectionPassword);
    }

    public void setConnectionPassword(BPassword bPassword) {
        this.set(connectionPassword, (BValue)bPassword, null);
    }

    public BAuthenticationMechanism getAuthenticationMechanism() {
        return (BAuthenticationMechanism)this.get(authenticationMechanism);
    }

    public void setAuthenticationMechanism(BAuthenticationMechanism bAuthenticationMechanism) {
        this.set(authenticationMechanism, (BValue)bAuthenticationMechanism, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BICredentials challenge(FoxSession foxSession) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("method", "basic");
        foxSession.setState("server.tune sendChallenge basic");
        foxSession.sendTuning("challenge", foxMessage);
        foxSession.setState("server.tune receiveLogin");
        FoxMessage foxMessage2 = foxSession.receiveTuning("login");
        String string = foxMessage2.getString("username");
        String string2 = foxMessage2.getString("password", null);
        byte[] byArray = foxMessage2.getBlob("credentials", null);
        if (null != byArray) {
            foxSession.setState("server.tune receivedLogin data.len=" + byArray.length);
            BICredentials bICredentials = (BICredentials)ValueByteBuffer.unmarshal((byte[])byArray);
            return bICredentials;
        }
        BUsernameAndPassword bUsernameAndPassword = new BUsernameAndPassword(string, string2);
        return bUsernameAndPassword;
    }

    public DirContext authenticate(BICredentials bICredentials, Context context) throws Exception {
        String string;
        Object object;
        String string2;
        String string3;
        if (!(bICredentials instanceof BUsernameAndPassword)) {
            log.error(lex.getText(LDAP_UNSUPPORTED_CREDS));
            return null;
        }
        BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
        String string4 = bUsernameAndPassword.getUsername();
        String string5 = bUsernameAndPassword.getPassword().getValue();
        if (string4 == null || string4.length() == 0) {
            return null;
        }
        BLdapV3Ext bLdapV3Ext = (BLdapV3Ext)this.getParent();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("java.naming.factory.initial", bLdapV3Ext.getInitialContextFactory());
        String string6 = bLdapV3Ext.getConnectionUrl();
        if (string6.length() == 0) {
            return null;
        }
        hashtable.put("java.naming.provider.url", bLdapV3Ext.getConnectionUrl());
        if (!bLdapV3Ext.getEnableConnectionPooling()) {
            hashtable.put("com.sun.jndi.ldap.connect.pool", "false");
        }
        if (this.getConnectionUser().length() > 0) {
            string3 = this.getConnectionUser();
            string2 = this.getConnectionPassword().getValue();
        } else {
            object = new BindNameFormatter(bLdapV3Ext);
            ((BindNameFormatter)object).setUserName(string4);
            string3 = ((BindNameFormatter)object).getFormattedBindName();
            string2 = string5;
        }
        hashtable.put("java.naming.security.principal", string3);
        hashtable.put("java.naming.security.credentials", string2);
        log.trace("Binding as: " + string3);
        object = this.getAuthenticationMechanism().getDisplayTag(null);
        hashtable.put("java.naming.security.authentication", object);
        log.trace("Authentication: " + (String)object);
        if (bLdapV3Ext.getSSL()) {
            log.trace("SSL enabled");
            hashtable.put("java.naming.security.protocol", "ssl");
            if (CertManagerFactory.isCertManagerActive()) {
                hashtable.put("java.naming.ldap.factory.socket", "javax.baja.security.crypto.se.BajaSSLSocketFactory");
            }
        }
        if ((string = bLdapV3Ext.getReferral()).length() > 0) {
            hashtable.put("java.naming.referral", string);
            log.trace("Referral: " + string);
        }
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        return initialDirContext;
    }

    public void rebind(DirContext dirContext, BICredentials bICredentials, String string) throws NamingException {
        if (!(bICredentials instanceof BUsernameAndPassword)) {
            return;
        }
        BLdapV3Ext bLdapV3Ext = null;
        BLdapUserService bLdapUserService = (BLdapUserService)Sys.getService((Type)BUserService.TYPE);
        Object[] objectArray = bLdapUserService.getChildren(class$com$tridium$ldap$v3$BLdapV3Ext == null ? (class$com$tridium$ldap$v3$BLdapV3Ext = BSimpleAuthenticator.class$("com.tridium.ldap.v3.BLdapV3Ext")) : class$com$tridium$ldap$v3$BLdapV3Ext);
        if (objectArray.length > 0) {
            bLdapV3Ext = (BLdapV3Ext)((Object)objectArray[0]);
        }
        BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
        String string2 = bUsernameAndPassword.getUsername();
        String string3 = bUsernameAndPassword.getPassword().getValue();
        BindNameFormatter bindNameFormatter = new BindNameFormatter(bLdapV3Ext);
        bindNameFormatter.setUserName(string2);
        bindNameFormatter.setUserBase(string.substring(string.indexOf(",") + 1));
        String string4 = bindNameFormatter.getFormattedBindName();
        log.trace("Re-binding as: " + string4);
        dirContext.addToEnvironment("java.naming.security.principal", string4);
        dirContext.addToEnvironment("java.naming.security.credentials", string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

