/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3.auth;

import com.sun.security.jgss.GSSUtil;
import com.tridium.fox.kerberos.KerberosCallbackHandler;
import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.ldap.v3.BLdapV3Ext;
import com.tridium.ldap.v3.auth.AcquireCredentialsAction;
import com.tridium.ldap.v3.auth.BAuthenticator;
import com.tridium.ldap.v3.auth.KerberosKeytabConfig;
import com.tridium.ldap.v3.auth.LdapKerberosAuthAction;
import com.tridium.util.ValueByteBuffer;
import java.security.PrivilegedActionException;
import javax.baja.file.BFileSystem;
import javax.baja.ldap.BLdapUserService;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseException;
import javax.baja.naming.BOrd;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BHttpFoxCredentials;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserService;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import sun.security.krb5.KrbException;

public class BKerberosAuthenticator
extends BAuthenticator {
    public static final Property realm = BKerberosAuthenticator.newProperty((int)0, (String)"EXAMPLE.COM", null);
    public static final Property realmDisplayName = BKerberosAuthenticator.newProperty((int)0, (String)"", null);
    public static final Property keyDistributionCenter = BKerberosAuthenticator.newProperty((int)0, (String)"kdc.example.com", null);
    public static final Property stationKerberosName = BKerberosAuthenticator.newProperty((int)0, (String)"station name", null);
    public static final Property stationKerberosPassword = BKerberosAuthenticator.newProperty((int)0, (BValue)BPassword.DEFAULT, null);
    public static final Property keyTabLocation = BKerberosAuthenticator.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$ldap$v3$auth$BKerberosAuthenticator == null ? (class$com$tridium$ldap$v3$auth$BKerberosAuthenticator = BKerberosAuthenticator.class$("com.tridium.ldap.v3.auth.BKerberosAuthenticator")) : class$com$tridium$ldap$v3$auth$BKerberosAuthenticator));
    private static final String LDAP_KERB_NOT_LICENSED = "ldap.kerberos.notLicensed";
    private static final String LDAP_KERB_BIND = "ldap.kerberos.bind";
    private static final String LDAP_KERB_UNSUPPORTED_CREDS = "ldap.kerberos.unsupportedCreds";
    private static final String LDAP_KERB_PRIN_NOT_FOUND = "ldap.kerberos.station.principalNotFound";
    private static final String LDAP_KERB_STAT_INVALID_CREDS = "ldap.kerberos.station.invalidCreds";
    private static final String LDAP_KERB_STAT_LOGIN_FAIL = "ldap.kerberos.station.loginFailed";
    private static final int KRB_EXC_C_PRINCIPAL_UNKNOWN = 6;
    private static final int KRB_EXC_PREAUTH_FAILED = 24;
    static /* synthetic */ Class class$com$tridium$ldap$v3$auth$BKerberosAuthenticator;

    public String getRealm() {
        return this.getString(realm);
    }

    public void setRealm(String string) {
        this.setString(realm, string, null);
    }

    public String getRealmDisplayName() {
        return this.getString(realmDisplayName);
    }

    public void setRealmDisplayName(String string) {
        this.setString(realmDisplayName, string, null);
    }

    public String getKeyDistributionCenter() {
        return this.getString(keyDistributionCenter);
    }

    public void setKeyDistributionCenter(String string) {
        this.setString(keyDistributionCenter, string, null);
    }

    public String getStationKerberosName() {
        return this.getString(stationKerberosName);
    }

    public void setStationKerberosName(String string) {
        this.setString(stationKerberosName, string, null);
    }

    public BPassword getStationKerberosPassword() {
        return (BPassword)this.get(stationKerberosPassword);
    }

    public void setStationKerberosPassword(BPassword bPassword) {
        this.set(stationKerberosPassword, (BValue)bPassword, null);
    }

    public BOrd getKeyTabLocation() {
        return (BOrd)this.get(keyTabLocation);
    }

    public void setKeyTabLocation(BOrd bOrd) {
        this.set(keyTabLocation, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public FoxMessage getRejectedData() {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("kerberosRealm", this.getRealm());
        return foxMessage;
    }

    public BICredentials challenge(FoxSession foxSession) throws Exception {
        FoxMessage foxMessage = new FoxMessage();
        foxMessage.add("method", "kerberos");
        foxMessage.add("realm", this.getRealm());
        foxMessage.add("kdc", this.getKeyDistributionCenter());
        foxMessage.add("server", this.getStationKerberosName());
        foxSession.setState("server.tune sendChallenge kerberos");
        foxSession.sendTuning("challenge", foxMessage);
        foxSession.setState("server.tune receive firstMessage");
        FoxMessage foxMessage2 = foxSession.receiveTuning("authMessage1");
        String string = foxMessage2.getString("authInput");
        foxSession.setState("server.tune receivedChallengeResponse authInputType=" + string);
        if (string.equals("authInputLocal")) {
            foxSession.setState("server.tune receiveLogin");
            FoxMessage foxMessage3 = foxSession.receiveTuning("login");
            String string2 = foxMessage3.getString("username", null);
            String string3 = foxMessage3.getString("password", null);
            BLdapUserService bLdapUserService = (BLdapUserService)Sys.getService((Type)BUserService.TYPE);
            if (!bLdapUserService.isLocalUser(string2)) {
                return null;
            }
            return new BUsernameAndPassword(string2, string3);
        }
        if (string.equals("authInputHttp")) {
            byte[] byArray = foxMessage2.getBlob("credentials");
            BHttpFoxCredentials bHttpFoxCredentials = (BHttpFoxCredentials)ValueByteBuffer.unmarshal((byte[])byArray);
            return bHttpFoxCredentials;
        }
        return this.acquireKerberosCredentials(foxSession);
    }

    private BKerberosCredentials acquireKerberosCredentials(FoxSession foxSession) throws Exception {
        Object object;
        Object object2;
        try {
            this.requireKerberosFeature();
        }
        catch (LicenseException licenseException) {
            String string = lex.getText(LDAP_KERB_NOT_LICENSED);
            log.error(string);
            this.sendTokenTuningError(foxSession, string);
            throw new FoxAuthenticationException(string, string, null, foxSession);
        }
        System.setProperty("java.security.krb5.realm", this.getRealm());
        System.setProperty("java.security.krb5.kdc", this.getKeyDistributionCenter());
        String string = this.getStationKerberosName();
        BOrd bOrd = this.getKeyTabLocation();
        if (bOrd != null && !bOrd.isNull()) {
            object2 = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath()).getPath();
            object = new KerberosKeytabConfig(string, (String)object2);
        } else {
            object = new KerberosConfig(string);
            object.setIsInitiator(false);
        }
        object2 = null;
        try {
            object2 = new LoginContext("com.tridium.ldap.v3.auth.BKerberosAuthenticator", null, (CallbackHandler)new KerberosCallbackHandler(string, this.getStationKerberosPassword().getValue()), (Configuration)object);
            ((LoginContext)object2).login();
        }
        catch (LoginException loginException) {
            Throwable throwable = loginException.getCause();
            if (throwable instanceof KrbException) {
                this.handleKrbException(foxSession, (KrbException)throwable);
            }
            log.error(lex.getText(LDAP_KERB_STAT_LOGIN_FAIL));
            throw new FoxAuthenticationException(lex.getText(LDAP_KERB_STAT_LOGIN_FAIL), null, null, foxSession);
        }
        BKerberosCredentials bKerberosCredentials = (BKerberosCredentials)Subject.doAs(((LoginContext)object2).getSubject(), new AcquireCredentialsAction(foxSession));
        return bKerberosCredentials;
    }

    private void handleKrbException(FoxSession foxSession, KrbException krbException) {
        int n = krbException.returnCode();
        switch (n) {
            case 6: {
                log.error(lex.getText(LDAP_KERB_PRIN_NOT_FOUND));
                break;
            }
            default: {
                log.error(lex.getText(LDAP_KERB_STAT_INVALID_CREDS));
                this.sendTokenTuningError(foxSession, lex.getText(LDAP_KERB_STAT_INVALID_CREDS));
            }
        }
    }

    private void sendTokenTuningError(FoxSession foxSession, String string) {
        try {
            FoxMessage foxMessage = new FoxMessage();
            foxMessage.add("error", string);
            foxSession.setState("server.token " + string);
            foxSession.sendTuning("serverToken", foxMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DirContext authenticate(BICredentials bICredentials, Context context) throws Exception {
        Subject subject;
        Object object;
        this.requireKerberosFeature();
        if (bICredentials instanceof BUsernameAndPassword) {
            object = (BUsernameAndPassword)bICredentials;
            KerberosConfig kerberosConfig = new KerberosConfig(object.getUsername());
            System.setProperty("java.security.krb5.realm", this.getRealm());
            System.setProperty("java.security.krb5.kdc", this.getKeyDistributionCenter());
            LoginContext loginContext = null;
            try {
                loginContext = new LoginContext("com.tridium.ldap.v3.auth.BKerberosAuthenticator", null, (CallbackHandler)new KerberosCallbackHandler(object.getUsername(), object.getPassword().getValue()), (Configuration)kerberosConfig);
                loginContext.login();
            }
            catch (LoginException loginException) {
                log.error(lex.getText(LDAP_KERB_STAT_LOGIN_FAIL));
                throw new AuthenticationException("Invalid Credentials");
            }
            subject = loginContext.getSubject();
        } else if (bICredentials instanceof BKerberosCredentials) {
            object = ((BKerberosCredentials)bICredentials).getCredential();
            subject = GSSUtil.createSubject(object.getName(), (GSSCredential)object);
        } else {
            throw new AuthenticationException(lex.getText(LDAP_KERB_UNSUPPORTED_CREDS));
        }
        log.trace(lex.getText(LDAP_KERB_BIND));
        try {
            object = (DirContext)Subject.doAs(subject, new LdapKerberosAuthAction((BLdapV3Ext)this.getParent()));
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (Exception)privilegedActionException.getCause();
        }
    }

    private void requireKerberosFeature() throws LicenseException {
        if (!this.getLdapV3Ext().getLdapv3Feature().getb("kerberos", false)) {
            throw new FeatureNotLicensedException(lex.getText(LDAP_KERB_NOT_LICENSED));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

