/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxSession;
import com.tridium.ldap.v3.auth.BAuthenticator;
import com.tridium.ldap.v3.auth.BSimpleAuthenticator;
import java.io.Serializable;
import java.security.SecureRandom;
import javax.baja.ldap.BLdapExt;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.nre.util.Base64;
import javax.baja.security.AuthenticationException;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BFormat;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public final class BLdapV3Ext
extends BLdapExt {
    public static final Property bindFormat = BLdapV3Ext.newProperty((int)0, (BValue)BFormat.make((String)"%userName%"), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$ldap$v3$BLdapV3Ext == null ? (class$com$tridium$ldap$v3$BLdapV3Ext = BLdapV3Ext.class$("com.tridium.ldap.v3.BLdapV3Ext")) : class$com$tridium$ldap$v3$BLdapV3Ext));
    protected static final String ERR_LDAP_NOT_LICENSED = "ldap.error.notLicensed";
    protected static final String ERR_LDAP_INVALID_CREDS = "ldap.error.invalidCredentials";
    protected static final String ERR_LDAP_CANNOT_LOGIN = "ldap.error.cannotLogin";
    protected static final String ERR_LDAP_CONNECT = "ldap.error.ldapConnect";
    protected static final String LDAP_LOGIN_SUCCESS = "ldap.login.success";
    private Feature ldapv3Feature = null;
    static /* synthetic */ Class class$com$tridium$ldap$v3$BLdapV3Ext;
    static /* synthetic */ Class class$com$tridium$ldap$v3$auth$BAuthenticator;

    public BFormat getBindFormat() {
        return (BFormat)this.get(bindFormat);
    }

    public void setBindFormat(BFormat bFormat) {
        this.set(bindFormat, (BValue)bFormat, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BICredentials challenge(FoxSession foxSession) throws Exception {
        BAuthenticator bAuthenticator = this.getAuthenticator();
        BICredentials bICredentials = bAuthenticator.challenge(foxSession);
        return bICredentials;
    }

    public final BUser authenticate(BICredentials bICredentials, Context context) throws AuthenticationException {
        this.getLdapv3Feature().check();
        return this.doAuthenticate(bICredentials, context);
    }

    protected BUser doAuthenticate(BICredentials bICredentials, Context context) throws AuthenticationException {
        Object object;
        this.getLdapv3Feature().check();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        String string = null;
        if (bICredentials instanceof BIUserCredentials) {
            string = ((BIUserCredentials)bICredentials).getUsername();
        }
        BUser bUser = this.service.getUser(string);
        this.validateUser(bUser, context);
        DirContext dirContext = null;
        try {
            object = this.getAuthenticator();
            dirContext = object.authenticate(bICredentials, context);
        }
        catch (CommunicationException communicationException) {
            log.warning(lex.getText(ERR_LDAP_CONNECT, new Object[]{this.getConnectionUrl()}) + " [" + communicationException.toString() + "]");
            return this.authCachedCredentials(bICredentials, context);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            log.warning(lex.getText(ERR_LDAP_CONNECT, new Object[]{this.getConnectionUrl()}) + " [" + serviceUnavailableException.toString() + "]");
            return this.authCachedCredentials(bICredentials, context);
        }
        catch (ConfigurationException configurationException) {
            log.warning(lex.getText(ERR_LDAP_CONNECT, new Object[]{this.getConnectionUrl()}) + " [" + configurationException.toString() + "]");
            return this.authCachedCredentials(bICredentials, context);
        }
        catch (Exception exception) {
            log.error(lex.getText("ldap.error.authFailed", new Object[]{string}) + " [" + exception.toString() + "]");
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception, null);
        }
        if (dirContext == null) {
            return null;
        }
        if (log.isTraceOn()) {
            this.traceDebugSaslMechanisms(dirContext);
        }
        object = null;
        try {
            if (dirContext != null) {
                object = this.getUserAttributes(dirContext, string, bICredentials);
                if (log.isTraceOn()) {
                    this.traceDebug((Attributes)object, "User attributes");
                }
                log.trace("Preparing user for LdapUserService.");
                bUser = this.prepareUser(bICredentials, bUser, (Attributes)object, dirContext);
            }
        }
        catch (AuthenticationException authenticationException) {
            if (bUser != null) {
                bUser.authenticateFailed((BUserService)this.service);
                this.service.auditLoginAttempt(false, bUser, context);
            }
            log.error(lex.getText("ldap.error.authFailed", new Object[]{string}));
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)authenticationException, null);
        }
        catch (NamingException namingException) {
            if (bUser != null) {
                bUser.authenticateFailed((BUserService)this.service);
                this.service.auditLoginAttempt(false, bUser, context);
            }
            log.error(lex.getText("ldap.error.attributes", new Object[]{this.getUserLoginAttr() + "=" + string}) + " [" + namingException.toString() + "]");
            throw new AuthenticationException(lex.getText("ldap.error.attributes", new Object[]{this.getUserLoginAttr() + "=" + string}));
        }
        catch (Exception exception) {
            log.error(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception);
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}), (Throwable)exception, null);
        }
        finally {
            try {
                if (dirContext != null) {
                    log.trace("Closing connection to LDAP server...");
                    dirContext.close();
                    log.trace("Connection closed.");
                }
            }
            catch (Exception exception) {
                log.trace("Could not close connection.", (Throwable)exception);
            }
        }
        if (!this.service.canLogin(bUser)) {
            log.error(lex.getText(ERR_LDAP_CANNOT_LOGIN, new Object[]{string}));
            bUser.authenticateFailed((BUserService)this.service);
            this.service.auditLoginAttempt(false, bUser, context);
            throw new AuthenticationException(lex.getText(ERR_LDAP_CANNOT_LOGIN));
        }
        log.message(lex.getText(LDAP_LOGIN_SUCCESS));
        bUser.authenticateOk((BUserService)this.service);
        this.service.auditLoginAttempt(true, bUser, context);
        return bUser;
    }

    public final BUser authenticate(String string, String string2, Context context) throws AuthenticationException {
        return this.authenticate(this.makeCredentials(string, string2), context);
    }

    protected BICredentials makeCredentials(String string, String string2) {
        return new BUsernameAndPassword(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getUserAttributes(DirContext dirContext, String string, BICredentials bICredentials) throws AuthenticationException {
        Serializable serializable;
        log.trace("Searching for user entry in the LDAP directory.");
        SearchResult searchResult = null;
        String string2 = this.getUserLoginAttr() + "=" + string;
        try {
            serializable = new SearchControls();
            serializable.setSearchScope(2);
            serializable.setCountLimit(1L);
            NamingEnumeration namingEnumeration = dirContext.search(this.getUserBase(), string2, (SearchControls)serializable);
            try {
                if (namingEnumeration.hasMore()) {
                    searchResult = (SearchResult)namingEnumeration.next();
                }
            }
            finally {
                namingEnumeration.close();
            }
        }
        catch (Exception exception) {
            log.warning(lex.getText("ldap.error.ldapsearch", new Object[]{string2}) + "[" + exception + "]");
            throw new AuthenticationException(lex.getText("ldap.error.ldapsearch", new Object[]{string2}));
        }
        if (searchResult == null) {
            log.warning(lex.getText(ERR_LDAP_INVALID_CREDS, new Object[]{string}));
            throw new AuthenticationException(lex.getText(ERR_LDAP_INVALID_CREDS, new Object[]{string}));
        }
        log.trace("Getting user attributes from LDAP entry.");
        serializable = null;
        try {
            string2 = this.getUserBase();
            string2 = string2.length() > 0 ? searchResult.getName() + "," + string2 : searchResult.getName();
            this.getAuthenticator().rebind(dirContext, bICredentials, string2);
            serializable = dirContext.getAttributes(string2);
        }
        catch (Exception exception) {
            log.warning(lex.getText(ERR_LDAP_INVALID_CREDS, new Object[]{string}));
            throw new AuthenticationException(lex.getText(ERR_LDAP_INVALID_CREDS, new Object[]{string}));
        }
        return serializable;
    }

    protected BUser prepareUser(BICredentials bICredentials, BUser bUser, Attributes attributes, DirContext dirContext) throws NamingException {
        String string = "";
        String string2 = "";
        if (!(bICredentials instanceof BIUserCredentials)) {
            throw new AuthenticationException("Invalid credential type for LDAP authentication: " + bICredentials.getType());
        }
        string = ((BIUserCredentials)bICredentials).getUsername();
        if (bICredentials instanceof BUsernameAndPassword) {
            string2 = ((BUsernameAndPassword)bICredentials).getPassword().getValue();
        } else {
            try {
                byte[] byArray = new byte[16];
                new SecureRandom().nextBytes(byArray);
                string2 = Base64.encode((byte[])byArray);
            }
            catch (Exception exception) {
                throw new SecurityException();
            }
        }
        return this.prepareUser(string, string2, bUser, attributes, dirContext);
    }

    private BUser authCachedCredentials(BICredentials bICredentials, Context context) {
        if (bICredentials instanceof BUsernameAndPassword) {
            BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)bICredentials;
            return this.authCachedCredentials(bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getValue(), context);
        }
        if (bICredentials instanceof BKerberosCredentials) {
            log.message(lex.getText("ldap.login.authCached"));
            String string = ((BKerberosCredentials)bICredentials).getUsername();
            BUser bUser = this.service.getUser(string);
            if (bUser != null) {
                return bUser;
            }
            throw new AuthenticationException(lex.getText("ldap.error.authFailed", new Object[]{string}));
        }
        return null;
    }

    public final BAuthenticator getAuthenticator() {
        BAuthenticator bAuthenticator = null;
        Object[] objectArray = this.getChildren(class$com$tridium$ldap$v3$auth$BAuthenticator == null ? (class$com$tridium$ldap$v3$auth$BAuthenticator = BLdapV3Ext.class$("com.tridium.ldap.v3.auth.BAuthenticator")) : class$com$tridium$ldap$v3$auth$BAuthenticator);
        if (objectArray.length > 0) {
            bAuthenticator = (BAuthenticator)((Object)objectArray[0]);
        }
        if (bAuthenticator == null) {
            bAuthenticator = new BSimpleAuthenticator();
            this.add("authenticator", (BValue)bAuthenticator);
        }
        return bAuthenticator;
    }

    public final Feature getLdapv3Feature() throws LicenseException {
        if (this.ldapv3Feature == null) {
            try {
                this.ldapv3Feature = Sys.getLicenseManager().getFeature("tridium", "ldapv3");
            }
            catch (LicenseException licenseException) {
                log.error("Feature not licensed: " + licenseException.getMessage());
                throw licenseException;
            }
        }
        return this.ldapv3Feature;
    }

    public FoxMessage getRejectedData() {
        return this.getAuthenticator().getRejectedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceDebug(Attributes attributes, String string) {
        try {
            System.out.println("\n*************************************");
            System.out.println(string + ": ");
            NamingEnumeration namingEnumeration = attributes.getAll();
            try {
                while (namingEnumeration.hasMore()) {
                    Attribute attribute = (Attribute)namingEnumeration.next();
                    String string2 = attribute.getID();
                    int n = attribute.size();
                    for (int i = 0; i < n; ++i) {
                        System.out.println(string2 + ": " + attribute.get(i));
                    }
                }
            }
            finally {
                namingEnumeration.close();
            }
            System.out.println("*************************************\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void traceDebugSaslMechanisms(DirContext dirContext) {
        try {
            Attributes attributes = dirContext.getAttributes(this.getConnectionUrl(), new String[]{"supportedSASLMechanisms"});
            this.traceDebug(attributes, "Supported SASL mechanisms");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

