/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetOws.migrate;

import java.io.File;
import java.util.LinkedList;
import javax.baja.file.FileUtil;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.util.TextUtil;
import javax.baja.xml.XElem;

public class MigrateWsToOws {
    protected static final String MODULE_OWS = "bacOws=bacnetOws";
    protected static final String MODULE_BAC = "bac=bacnet";
    protected final File input;
    protected final File stubbed;

    public final void convert() throws Exception {
        this.log("\nMigrating " + this.input.getAbsolutePath() + " ...");
        this.stubBog();
        this.migrateBog();
    }

    protected void log(String string) {
        System.out.println(string);
    }

    private final void stubBog() throws Exception {
        XElem xElem = ((ValueDocDecoder.BogElement)new ValueDocDecoder(this.input).parse()).getXmlElement();
        LinkedList<XElem> linkedList = new LinkedList<XElem>();
        linkedList.add(xElem);
        while (!linkedList.isEmpty()) {
            XElem xElem2 = (XElem)linkedList.removeFirst();
            this.stub(xElem2);
            XElem[] xElemArray = xElem2.elems();
            int n = 0;
            while (n < xElemArray.length) {
                linkedList.add(xElemArray[n]);
                ++n;
            }
        }
        xElem.write(this.stubbed);
    }

    private final void stub(XElem xElem) throws Exception {
        String string = xElem.get("t", null);
        if (string == null) {
            return;
        }
        String[] stringArray = TextUtil.split((String)string, (char)':');
        if ("bacws".equals(stringArray[0])) {
            if ("BacnetWsNetwork".equals(stringArray[1])) {
                this.stub(xElem, MODULE_OWS, "bacOws:BacnetOwsNetwork");
            } else if ("BacnetWsDeviceFolder".equals(stringArray[1])) {
                this.stub(xElem, MODULE_OWS, "bacOws:BacnetOwsDeviceFolder");
            } else if ("LocalBacnetWsDevice".equals(stringArray[1])) {
                this.stub(xElem, MODULE_OWS, "bacOws:LocalBacnetOwsDevice");
            } else if ("BacnetWsDevice".equals(stringArray[1])) {
                this.stub(xElem, MODULE_BAC, "bac:BacnetDevice");
            } else if ("BacnetWsStack".equals(stringArray[1])) {
                this.stub(xElem, MODULE_BAC, "bac:BacnetStack");
            } else if ("BacnetWsClientLayer".equals(stringArray[1])) {
                this.stub(xElem, MODULE_BAC, "bac:BacnetClientLayer");
            }
        } else {
            this.doStub(xElem, stringArray[0], stringArray[1]);
        }
    }

    protected void stub(XElem xElem, String string, String string2) {
        xElem.setAttr("m", string);
        xElem.setAttr("t", string2);
    }

    protected void doStub(XElem xElem, String string, String string2) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void migrateBog() throws Exception {
        BComponent bComponent = new ValueDocDecoder(this.stubbed).decodeDocument().asComponent();
        this.scanStubbedStation(bComponent);
        this.doMigration();
        File file = this.input.getParentFile();
        File file2 = new File(file, "preMigrate_" + this.input.getName());
        FileUtil.move((File)this.input, (File)file2);
        this.log("Backed up original bog as: " + file2.getAbsolutePath());
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(this.input);
        valueDocEncoder.setZipped(true);
        try {
            valueDocEncoder.encodeDocument((BValue)bComponent);
            this.log("Success! Migrated bog: " + this.input.getAbsolutePath());
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            valueDocEncoder.close();
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        valueDocEncoder.close();
    }

    private final void scanStubbedStation(BComponent bComponent) {
        LinkedList<BComponent> linkedList = new LinkedList<BComponent>();
        linkedList.add(bComponent);
        while (!linkedList.isEmpty()) {
            BComponent bComponent2 = (BComponent)linkedList.removeFirst();
            if (this.scanned(bComponent2)) break;
            BComponent[] bComponentArray = bComponent2.getChildComponents();
            int n = 0;
            while (n < bComponentArray.length) {
                linkedList.add(bComponentArray[n]);
                ++n;
            }
        }
        linkedList.clear();
    }

    protected boolean scanned(BComponent bComponent) {
        return true;
    }

    protected void doMigration() throws Exception {
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            if (stringArray.length == 0) {
                MigrateWsToOws.usage("Missing bog file argument");
            }
            MigrateWsToOws.migrate(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    public static void usage(String string) {
        if (string != null) {
            System.err.println("ERROR: " + string);
        }
        System.out.println("  MigrateWsToOws <bog>\n");
        System.exit(1);
    }

    private static final void migrate(File file) throws Exception {
        Object object;
        XElem xElem = ((ValueDocDecoder.BogElement)new ValueDocDecoder(file).parse()).getXmlElement();
        LinkedList<XElem> linkedList = new LinkedList<XElem>();
        linkedList.add(xElem);
        while (!linkedList.isEmpty()) {
            object = (XElem)linkedList.removeFirst();
            XElem[] xElemArray = object.elems();
            int n = 0;
            while (n < xElemArray.length) {
                linkedList.add(xElemArray[n]);
                ++n;
            }
        }
        object = new MigrateWsToOws(file);
        ((MigrateWsToOws)object).convert();
    }

    public MigrateWsToOws(File file) {
        this.input = file;
        this.stubbed = new File(file.getParentFile(), "stub_" + file.getName());
        this.stubbed.deleteOnExit();
        Log.getLog((String)"sys.xml").setSeverity(3);
    }
}

