/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciFxDriver.ui;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JciUpgradeUtils {
    static final String[] defaultTrimFileList = new String[]{"config_backup*.bog", "console.backup*.txt", "Graphics\\brengel.png", "sysPxFile\\100PctOADualDuctConfig.px", "sysPxFile\\100PctOASingleDuctConfig.px", "sysPxFile\\FanCoilConfig.px", "sysPxFile\\FcuRtuTECConfig.px", "sysPxFile\\HeatPumpConfig.px", "sysPxFile\\MixedAirDualDuctConfig.px", "sysPxFile\\MixedAirSingleDuctConfig.px", "sysPxFile\\OtherConfig.px", "sysPxFile\\RoofTopConfig.px", "sysPxFile\\TCFanCoilConfig.px", "sysPxFile\\UnitVentilatorConfig.px", "sysPxFile\\VavDualDuctConfig.px", "sysPxFile\\VavSingleDuctConfig.px", "sysPxFile\\VavSingleDuctCZPConfig.px", "sysPxFile\\VavSingleDuctFanConfig.px", "sysPxFile\\VmaDualDuctConfig.px", "sysPxFile\\VmaSingleDuctConfig.px", "sysPxFile\\VmaSingleDuctCZPConfig.px", "sysPxFile\\VmaSingleDuctFanConfig.px", "sysPxFile\\FXFanCoilUnitGraphic.px", "sysPxFile\\FXGraphicTemplate.px", "sysPxFile\\FXHeatingSystemGraphic.px", "sysPxFile\\FXHeatPumpGraphic.px", "sysPxFile\\FXMADDGraphic.px", "sysPxFile\\FXMASDGraphic.px", "sysPxFile\\FXOADDGraphic.px", "sysPxFile\\FXOASDGraphic.px", "sysPxFile\\FXRooftopGraphic.px", "sysPxFile\\FXSecPumpGraphic.px", "sysPxFile\\FXUnitVentilatorGraphic.px", "sysPxFile\\FXVMASingleDuctGraphic.px", "sysPxFile\\FXZoningGraphic.px", "sysPxFile\\VSSeriesVSDGraphic.px"};
    BWbShell shell;
    String logMessages;

    public void addLogMessage(String string) {
        this.logMessages = this.logMessages + string + "\r\n";
        System.out.println(string);
    }

    public void saveLogMessages() {
        try {
            BOrd bOrd = BOrd.make((BOrd)this.shell.getActiveOrd(), (String)"file:^NavFile.nav");
            BIFile bIFile = (BIFile)bOrd.resolve().get();
            BFileSpace bFileSpace = bIFile.getFileSpace();
            String string = "^upgradeLog.txt";
            FilePath filePath = new FilePath(string);
            BIFile bIFile2 = bFileSpace.makeFile(filePath);
            bIFile2.write(this.logMessages.getBytes());
        }
        catch (Exception exception) {
            System.out.println("saveLogMessages, ERROR in MakeFile");
            exception.printStackTrace();
        }
    }

    public void setDefaultHostName(String string, BWbFieldEditor bWbFieldEditor) {
        if (string.length() > 0) {
            BWidget[] bWidgetArray = bWbFieldEditor.getChildWidgets();
            int n = 0;
            while (n < bWidgetArray.length) {
                BWidget bWidget = bWidgetArray[n];
                BWidget[] bWidgetArray2 = bWidget.getChildWidgets();
                int n2 = 0;
                while (n2 < bWidgetArray2.length) {
                    BWidget bWidget2 = bWidgetArray2[n2];
                    if (bWidget2 instanceof BListDropDown) {
                        if (string.indexOf(".") > 0) {
                            ((BListDropDown)bWidget2).setSelectedIndex(0);
                        } else {
                            ((BListDropDown)bWidget2).setSelectedIndex(1);
                        }
                    }
                    if (bWidget2 instanceof BTextField) {
                        ((BTextField)bWidget2).setText(string);
                        return;
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public void removeBackupFiles() {
        BOrd bOrd = BOrd.make((BOrd)this.shell.getActiveOrd(), (String)"file:^");
        BIDirectory bIDirectory = (BIDirectory)bOrd.resolve().get();
        BIFile[] bIFileArray = bIDirectory.listFiles();
        this.addLogMessage("Searching for Backup files to remove.");
        int n = 0;
        while (n < bIFileArray.length) {
            BIFile bIFile = bIFileArray[n];
            String string = "";
            try {
                string = bIFile.getFileName();
                if (string.startsWith("config_backup")) {
                    this.addLogMessage("...removing: " + string);
                    bIFile.delete();
                }
                if (string.startsWith("console.backup")) {
                    this.addLogMessage("...removing: " + string);
                    bIFile.delete();
                }
            }
            catch (Exception exception) {
                System.out.println("removeBackupFiles ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public void removeTrimFiles() {
        String[] stringArray = null;
        stringArray = this.getTrimFileList();
        this.addLogMessage("Trimming files from Station");
        boolean bl = false;
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            try {
                string = stringArray[n];
                if (string.length() > 0) {
                    if (string.startsWith("config_backup") || string.startsWith("console.backup")) {
                        if (!bl) {
                            this.removeBackupFiles();
                            bl = true;
                        }
                    } else {
                        BOrd bOrd = BOrd.make((BOrd)this.shell.getActiveOrd(), (String)"file:^config.bog");
                        BIFile bIFile = (BIFile)bOrd.resolve().get();
                        BFileSpace bFileSpace = bIFile.getFileSpace();
                        string = TextUtil.replace((String)string, (String)"\\", (String)"/");
                        FilePath filePath = new FilePath(string = "^" + string);
                        if (bFileSpace.findFile(filePath) != null) {
                            this.addLogMessage("...removing: " + filePath);
                            bFileSpace.delete(filePath);
                        }
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("removeTrimFiles ERROR: " + exception.getMessage());
            }
            ++n;
        }
    }

    public String[] getTrimFileList() {
        String[] stringArray = null;
        String string = Sys.getBajaHome().getPath() + "\\jciStandards\\Properties\\TrimFileList.txt";
        File file = new File(string);
        if (file.exists()) {
            try {
                String[] stringArray2 = FileUtil.readLines((File)file);
                stringArray = new String[stringArray2.length];
                String string2 = "";
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    string2 = stringArray2[n2];
                    if ((string2 = TextUtil.replace((String)string2, (String)" ", (String)"")).length() > 1) {
                        stringArray[n] = string2;
                        ++n;
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            stringArray = new String[defaultTrimFileList.length];
            try {
                FileWriter fileWriter = null;
                fileWriter = new FileWriter(string);
                int n = 0;
                while (n < defaultTrimFileList.length) {
                    stringArray[n] = defaultTrimFileList[n];
                    fileWriter.write(defaultTrimFileList[n] + "\r\n");
                    ++n;
                }
                fileWriter.close();
            }
            catch (Exception exception) {
                this.addLogMessage("   getFilesToTrimList, ERROR making ORD for Trim File");
            }
        }
        return stringArray;
    }

    public void trimFilesLocal(String string) {
        System.out.println("Trim Files Local Station: " + string);
        String string2 = Sys.getBajaHome().getPath() + "\\stations\\" + string + '\\';
        String[] stringArray = null;
        stringArray = this.getTrimFileList();
        String string3 = "";
        int n = 0;
        while (n < stringArray.length) {
            string3 = string2 + stringArray[n];
            System.out.println("Looking for: " + string3);
            File file = new File(string3);
            if (file.exists()) {
                file.delete();
                System.out.println("...deleting: " + string3);
            }
            ++n;
        }
    }

    public long getRootFileSizes() {
        BOrd bOrd = BOrd.make((BOrd)this.shell.getActiveOrd(), (String)"file:^");
        BIDirectory bIDirectory = (BIDirectory)bOrd.resolve().get();
        BIFile[] bIFileArray = bIDirectory.listFiles();
        long l = 0L;
        int n = 0;
        while (n < bIFileArray.length) {
            BIFile bIFile = bIFileArray[n];
            String string = "";
            String string2 = "";
            try {
                string = bIFile.getFileName();
                long l2 = this.getFileSizes(bIFile);
                l += l2;
                string2 = bIFile.isDirectory() ? " DIR: " : "File: ";
            }
            catch (Exception exception) {
                System.out.println("getRootFileSizes ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
            ++n;
        }
        return l;
    }

    public long getFileSizes(BIFile bIFile) {
        long l = 0L;
        if (bIFile.isDirectory()) {
            BIDirectory bIDirectory = (BIDirectory)bIFile;
            BIFile[] bIFileArray = bIDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                BIFile bIFile2 = bIFileArray[n];
                String string = "";
                String string2 = "";
                try {
                    string = bIFile2.getFileName();
                    long l2 = this.getFileSizes(bIFile2);
                    l += l2;
                    string2 = bIFile2.isDirectory() ? " DIR: " : "File: ";
                }
                catch (Exception exception) {
                    System.out.println("getFileSizes ERROR: " + exception.getMessage());
                    exception.printStackTrace();
                }
                ++n;
            }
        } else {
            l += bIFile.getSize();
        }
        return l;
    }

    public String getRootFileSizesCSV() {
        String string = "";
        BOrd bOrd = BOrd.make((BOrd)this.shell.getActiveOrd(), (String)"file:^");
        BIDirectory bIDirectory = (BIDirectory)bOrd.resolve().get();
        BIFile[] bIFileArray = bIDirectory.listFiles();
        long l = 0L;
        int n = 0;
        while (n < bIFileArray.length) {
            BIFile bIFile = bIFileArray[n];
            String string2 = "";
            String string3 = "";
            try {
                string2 = bIFile.getFileName();
                long l2 = this.getFileSizes(bIFile);
                l += l2;
                string3 = bIFile.isDirectory() ? "DIR" : "File";
                this.getFileSizesCSV(bIFile);
                string = string + '\"' + string3 + ':' + string2 + "\"," + l2 + '\n';
            }
            catch (Exception exception) {
                System.out.println("getRootFileSizes ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
            ++n;
        }
        return string;
    }

    public String getFileSizesCSV(BIFile bIFile) {
        String string = "";
        long l = 0L;
        if (bIFile.isDirectory()) {
            BIDirectory bIDirectory = (BIDirectory)bIFile;
            BIFile[] bIFileArray = bIDirectory.listFiles();
            int n = 0;
            while (n < bIFileArray.length) {
                BIFile bIFile2 = bIFileArray[n];
                String string2 = "";
                String string3 = "";
                try {
                    string2 = bIFile2.getFileName();
                    long l2 = this.getFileSizes(bIFile2);
                    l += l2;
                    this.getFileSizesCSV(bIFile2);
                    string3 = bIFile2.isDirectory() ? "DIR" : "File";
                    string = string + '\"' + string3 + ':' + string2 + "\"," + l2 + '\n';
                }
                catch (Exception exception) {
                    System.out.println("getFileSizesCSV ERROR: " + exception.getMessage());
                    exception.printStackTrace();
                }
                ++n;
            }
        } else {
            l += bIFile.getSize();
            string = string + "\"File:" + bIFile.getFileName() + "\"," + bIFile.getSize() + '\n';
        }
        return string;
    }

    private final /* synthetic */ void this() {
        this.logMessages = "";
    }

    public JciUpgradeUtils(BWbShell bWbShell) {
        this.this();
        this.shell = bWbShell;
    }
}

