/*
 * Decompiled with CFR 0.152.
 */
package com.jci.jciFxDriver.ui;

import com.jci.jciFxDriver.BFxService;
import com.jci.jciSupport.BJciProxyPointMixin;
import com.jci.jciSupport.JciPtExtPrototypeException;
import com.jci.jciSupport.ReflectUtils;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BNiagaraPointFolder;
import java.util.Comparator;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.BOffnormalAlgorithm;
import javax.baja.alarm.ext.fault.BEnumFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.alarm.ext.offnormal.BEnumChangeOfStateAlgorithm;
import javax.baja.alarm.ext.offnormal.BOutOfRangeAlgorithm;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BPointExtension;
import javax.baja.control.ext.BDiscreteTotalizerExt;
import javax.baja.control.ext.BNumericTotalizerExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.driver.point.BPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BTuningPolicy;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.history.ext.BBooleanCovHistoryExt;
import javax.baja.history.ext.BBooleanIntervalHistoryExt;
import javax.baja.history.ext.BEnumCovHistoryExt;
import javax.baja.history.ext.BEnumIntervalHistoryExt;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.history.ext.BNumericCovHistoryExt;
import javax.baja.history.ext.BNumericIntervalHistoryExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BJciSlickPointManager
extends BWbComponentView {
    public static final Type TYPE;
    static final Comparator ptNameComparatorAscending;
    static final Comparator ptNameComparatorDecending;
    static final Comparator ptDescComparatorAscending;
    static final Comparator ptDescComparatorDecending;
    static final Comparator ptTypeComparatorAscending;
    static final Comparator ptTypeComparatorDecending;
    static final Comparator ptAddrComparatorAscending;
    static final Comparator ptAddrComparatorDecending;
    static final Comparator ptValueComparatorAscending;
    static final Comparator ptValueComparatorDecending;
    static final BImage checkIcon;
    static final BImage stopIcon;
    static final int COL_NAME = 0;
    static final int COL_LONGNAME = 1;
    static final int COL_VALUE = 2;
    static final int COL_ENABLE = 3;
    static final int COL_TREND = 4;
    static final int COL_ALARM = 5;
    static final int COL_TOT = 6;
    static final int COL_NPT = 10;
    static final int COL_NPA = 11;
    static final int MAX_COLUMN_COUNT = 12;
    static final int COL_STATUS_FLAGS = 8;
    static final int COL_TUNING_POLICY = 7;
    static final int COL_POLL_FREQ = 9;
    protected static UiLexicon lex;
    static final BImage defaultIcon;
    static final int ALL_EXTS = 0;
    static final int ALL_ALARM_EXTS = 1;
    static final int ALL_HISTORY_EXTS = 2;
    static final int ALL_TOT_EXTS = 3;
    BAbstractButton bSave;
    BAbstractButton bCancel;
    BAbstractButton bTuning;
    BPointDeviceExt deviceExt;
    BDeviceNetwork network;
    BTable table;
    BTitlePane titlePane;
    String deviceName;
    boolean isBacnet;
    boolean isN2;
    boolean isModbus;
    Array rows;
    protected boolean setupRightClickMenus;
    protected Command newCmd;
    protected Command saveCmd;
    protected Command cancelCmd;
    protected Command tuningCmd;
    public Command[] ptExtCmds;
    public Array alarmNumericPtExtCmds;
    public Array totNumericPtExtCmds;
    public Array trendNumericPtExtCmds;
    public BMenu alarmNumericMenu;
    public BMenu totNumericMenu;
    public BMenu trendNumericMenu;
    public Array alarmBooleanPtExtCmds;
    public Array totBooleanPtExtCmds;
    public Array trendBooleanPtExtCmds;
    public BMenu alarmBooleanMenu;
    public BMenu totBooleanMenu;
    public BMenu trendBooleanMenu;
    public Array alarmEnumPtExtCmds;
    public Array totEnumPtExtCmds;
    public Array trendEnumPtExtCmds;
    public BMenu alarmEnumMenu;
    public BMenu totEnumMenu;
    public BMenu trendEnumMenu;
    public BMenu tuningPolicyMenu;
    public BMenu pollFreqMenu;
    int activerow;
    boolean didptext;
    boolean didextcpy;
    int ctr;
    static /* synthetic */ Class class$com$jci$jciFxDriver$ui$BJciSlickPointManager;
    static /* synthetic */ Class class$com$jci$jciFxDriver$ui$BJciSlickPointManager$Row;
    static /* synthetic */ Class class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
    static /* synthetic */ Class class$javax$baja$control$BPointExtension;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$javax$baja$history$ext$BHistoryExt;
    static /* synthetic */ Class class$javax$baja$alarm$ext$BAlarmSourceExt;
    static /* synthetic */ Class class$javax$baja$control$ext$BDiscreteTotalizerExt;
    static /* synthetic */ Class class$javax$baja$control$ext$BNumericTotalizerExt;
    static /* synthetic */ Class class$javax$baja$driver$point$BPointFolder;

    public Type getType() {
        return TYPE;
    }

    public String toPathString() {
        return super.toPathString() + ", FX Point Manager toPathString";
    }

    public static String getDisplayNameInParent() {
        return lex.getText("JciSlickPointManager.DisplayNameInParent");
    }

    public String toString(Context context) {
        return "JCI Point Editor";
    }

    protected int getRootColumnNumber(int n) {
        if (this.table.getModel() instanceof DynamicTableModel) {
            return ((DynamicTableModel)this.table.getModel()).toRootColumnIndex(n);
        }
        return n;
    }

    public BControlPoint[] getProtos(BObject bObject) throws JciPtExtPrototypeException {
        BComponent bComponent;
        try {
            BOrd bOrd = BOrd.make((String)"station:|slot:/fxApp/pointExtensionDefaults");
            bComponent = bOrd.get(bObject).asComponent();
        }
        catch (Exception exception) {
            throw new JciPtExtPrototypeException("could not create ord", (Throwable)exception);
        }
        bComponent.loadSlots();
        Class clazz = class$javax$baja$control$BControlPoint;
        if (clazz == null) {
            clazz = class$javax$baja$control$BControlPoint = BJciSlickPointManager.class("[Ljavax.baja.control.BControlPoint;", false);
        }
        return (BControlPoint[])bComponent.getChildren(clazz);
    }

    public BControlPoint[] getDefaultProtos() {
        BControlPoint[] bControlPointArray = new BControlPoint[]{this.generateControlPoint(0), this.generateControlPoint(1), this.generateControlPoint(2), this.generateControlPoint(0), this.generateControlPoint(1), this.generateControlPoint(2), this.generateControlPoint(0), this.generateControlPoint(1), this.generateControlPoint(2)};
        this.addDefaultTrendExt(bControlPointArray[0], 'N');
        this.addDefaultTrendExt(bControlPointArray[1], 'B');
        this.addDefaultTrendExt(bControlPointArray[2], 'E');
        this.addDefaultAlarmExt(bControlPointArray[3], 'N');
        this.addDefaultAlarmExt(bControlPointArray[4], 'B');
        this.addDefaultAlarmExt(bControlPointArray[5], 'E');
        this.addDefaultTotExt(bControlPointArray[6], 'N');
        this.addDefaultTotExt(bControlPointArray[7], 'B');
        this.addDefaultTotExt(bControlPointArray[8], 'E');
        return bControlPointArray;
    }

    protected void addDefaultAlarmExt(BControlPoint bControlPoint, char c) {
        BAlarmSourceExt bAlarmSourceExt = new BAlarmSourceExt();
        String string = null;
        switch (c) {
            case 'E': {
                bAlarmSourceExt.setFaultAlgorithm((BFaultAlgorithm)new BEnumFaultAlgorithm());
                bAlarmSourceExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BEnumChangeOfStateAlgorithm());
                string = lex.getText("JciSlickPointManager.cos");
                break;
            }
            case 'B': {
                bAlarmSourceExt.setFaultAlgorithm(new BFaultAlgorithm());
                bAlarmSourceExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BBooleanChangeOfStateAlgorithm());
                string = lex.getText("JciSlickPointManager.cos");
                break;
            }
            case 'N': {
                bAlarmSourceExt.setFaultAlgorithm((BFaultAlgorithm)new BOutOfRangeFaultAlgorithm());
                bAlarmSourceExt.setOffnormalAlgorithm((BOffnormalAlgorithm)new BOutOfRangeAlgorithm());
                string = lex.getText("JciSlickPointManager.outofrange");
                break;
            }
        }
        bAlarmSourceExt.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName%/%parent.displayName%"));
        bControlPoint.add(string, (BValue)bAlarmSourceExt);
    }

    protected void addDefaultTotExt(BControlPoint bControlPoint, char c) {
        switch (c) {
            case 'E': {
                bControlPoint.add(lex.getText("JciSlickPointManager.discrete"), (BValue)new BDiscreteTotalizerExt());
                break;
            }
            case 'B': {
                bControlPoint.add(lex.getText("JciSlickPointManager.discrete"), (BValue)new BDiscreteTotalizerExt());
                break;
            }
            case 'N': {
                bControlPoint.add(lex.getText("JciSlickPointManager.numeric"), (BValue)new BNumericTotalizerExt());
                break;
            }
        }
    }

    protected void addDefaultTrendExt(BControlPoint bControlPoint, char c) {
        BEnumCovHistoryExt bEnumCovHistoryExt;
        String string = null;
        switch (c) {
            case 'E': {
                bEnumCovHistoryExt = new BEnumCovHistoryExt();
                string = lex.getText("JciSlickPointManager.cov");
                break;
            }
            case 'B': {
                bEnumCovHistoryExt = new BBooleanCovHistoryExt();
                string = lex.getText("JciSlickPointManager.cov");
                break;
            }
            case 'N': {
                bEnumCovHistoryExt = new BNumericIntervalHistoryExt();
                string = lex.getText("JciSlickPointManager.interval");
                break;
            }
            default: {
                bEnumCovHistoryExt = null;
            }
        }
        if (bEnumCovHistoryExt != null) {
            bEnumCovHistoryExt.setHistoryName(BFormat.make((String)"%parent.parent.parent.displayName%/%parent.displayName%"));
            bEnumCovHistoryExt.setEnabled(true);
            bControlPoint.add(string, (BValue)bEnumCovHistoryExt);
        }
    }

    public BControlPoint generateControlPoint(int n) {
        if (n == 0) {
            return new BNumericPoint();
        }
        if (n == 1) {
            return new BBooleanPoint();
        }
        return new BEnumPoint();
    }

    public static BPointExtension copyFromProto(BPointExtension bPointExtension, BPointExtension bPointExtension2) {
        bPointExtension2.loadSlots();
        SlotCursor slotCursor = bPointExtension2.getProperties();
        while (slotCursor.next()) {
            String string = slotCursor.property().getName();
            BValue bValue = bPointExtension2.get(string).newCopy(true);
            Property property = bPointExtension.getProperty(string);
            if (property == null) {
                bPointExtension.add(string, bValue);
                continue;
            }
            bPointExtension.set(string, bValue);
        }
        return bPointExtension;
    }

    protected BMenu getPointActionMenu(BControlPoint bControlPoint) {
        BMenu bMenu = new BMenu();
        if (bControlPoint == null) {
            return null;
        }
        Action[] actionArray = bControlPoint.getActionsArray();
        int n = 0;
        while (n < actionArray.length) {
            Action action = actionArray[n];
            int n2 = bControlPoint.getFlags((Slot)action);
            if ((n2 & 4) == 0) {
                bMenu.add(action.getName(), (Command)new InvokeActionCommand((BWidget)this.getWbShell(), (BComponent)bControlPoint, action));
            }
            ++n;
        }
        if (bMenu.getMenuItems().length == 0) {
            return null;
        }
        return bMenu;
    }

    protected boolean makeTuningPolicyMenu() {
        boolean bl = true;
        try {
            this.network = this.getNetwork((BComponent)this.deviceExt);
            BTuningPolicyMap bTuningPolicyMap = (BTuningPolicyMap)ReflectUtils.getPropertyValue((BComplex)this.network, (String)"tuningPolicies");
            bTuningPolicyMap.loadSlots();
            BTuningPolicy[] bTuningPolicyArray = bTuningPolicyMap.getPolicies();
            int n = 0;
            while (n < bTuningPolicyArray.length) {
                if (bTuningPolicyArray[n] instanceof BTuningPolicy) {
                    BTuningPolicy bTuningPolicy = bTuningPolicyArray[n];
                    String string = bTuningPolicy.getName();
                    this.tuningPolicyMenu.add(string, (Command)new TuningPolicyCommand((BWidget)this, string));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    protected boolean makePollFreqMenu() {
        boolean bl = true;
        try {
            String string = BPollFrequency.fast.getTag();
            String string2 = BPollFrequency.slow.getTag();
            String string3 = BPollFrequency.normal.getTag();
            this.pollFreqMenu.add(string, (Command)new PollFrequencyCommand((BWidget)this, string));
            this.pollFreqMenu.add(string3, (Command)new PollFrequencyCommand((BWidget)this, string3));
            this.pollFreqMenu.add(string2, (Command)new PollFrequencyCommand((BWidget)this, string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    protected boolean makePtExtCmds() {
        BControlPoint[] bControlPointArray;
        BObject bObject = this.getWbShell().getActiveOrdTarget().get();
        try {
            bControlPointArray = this.getProtos(bObject);
            if (bControlPointArray.length == 0) {
                bControlPointArray = this.getDefaultProtos();
            }
        }
        catch (JciPtExtPrototypeException jciPtExtPrototypeException) {
            bControlPointArray = this.getDefaultProtos();
        }
        int n = 0;
        while (n < bControlPointArray.length) {
            BNumericTotalizerExt[] bNumericTotalizerExtArray;
            BControlPoint bControlPoint = bControlPointArray[n];
            String string = bControlPoint.getType().getTypeName();
            bControlPoint.loadSlots();
            Class clazz = class$javax$baja$history$ext$BHistoryExt;
            if (clazz == null) {
                clazz = BJciSlickPointManager.class("[Ljavax.baja.history.ext.BHistoryExt;", false);
            }
            BHistoryExt[] bHistoryExtArray = (BHistoryExt[])bControlPoint.getChildren(clazz);
            int n2 = 0;
            while (n2 < bHistoryExtArray.length) {
                if (string.indexOf("Boolean") > -1) {
                    this.trendBooleanPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bHistoryExtArray[n2].getName()), (BPointExtension)bHistoryExtArray[n2]));
                } else if (string.indexOf("Enum") > -1) {
                    this.trendEnumPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bHistoryExtArray[n2].getName()), (BPointExtension)bHistoryExtArray[n2]));
                } else if (string.indexOf("Numeric") > -1) {
                    this.trendNumericPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bHistoryExtArray[n2].getName()), (BPointExtension)bHistoryExtArray[n2]));
                }
                ++n2;
            }
            Class clazz2 = class$javax$baja$alarm$ext$BAlarmSourceExt;
            if (clazz2 == null) {
                clazz2 = BJciSlickPointManager.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
            }
            BAlarmSourceExt[] bAlarmSourceExtArray = (BAlarmSourceExt[])bControlPoint.getChildren(clazz2);
            int n3 = 0;
            while (n3 < bAlarmSourceExtArray.length) {
                if (string.indexOf("Boolean") > -1) {
                    this.alarmBooleanPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bAlarmSourceExtArray[n3].getName()), (BPointExtension)bAlarmSourceExtArray[n3]));
                } else if (string.indexOf("Enum") > -1) {
                    this.alarmEnumPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bAlarmSourceExtArray[n3].getName()), (BPointExtension)bAlarmSourceExtArray[n3]));
                } else if (string.indexOf("Numeric") > -1) {
                    bNumericTotalizerExtArray = bAlarmSourceExtArray[n3];
                    this.alarmNumericPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bAlarmSourceExtArray[n3].getName()), (BPointExtension)bAlarmSourceExtArray[n3]));
                }
                ++n3;
            }
            Class clazz3 = class$javax$baja$control$ext$BDiscreteTotalizerExt;
            if (clazz3 == null) {
                clazz3 = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BDiscreteTotalizerExt;", false);
            }
            BDiscreteTotalizerExt[] bDiscreteTotalizerExtArray = (BDiscreteTotalizerExt[])bControlPoint.getChildren(clazz3);
            int n4 = 0;
            while (n4 < bDiscreteTotalizerExtArray.length) {
                if (string.indexOf("Boolean") > -1) {
                    this.totBooleanPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bDiscreteTotalizerExtArray[n4].getName()), (BPointExtension)bDiscreteTotalizerExtArray[n4]));
                } else if (string.indexOf("Enum") > -1) {
                    this.totEnumPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bDiscreteTotalizerExtArray[n4].getName()), (BPointExtension)bDiscreteTotalizerExtArray[n4]));
                } else if (string.indexOf("Numeric") > -1) {
                    this.totNumericPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bDiscreteTotalizerExtArray[n4].getName()), (BPointExtension)bDiscreteTotalizerExtArray[n4]));
                }
                ++n4;
            }
            Class clazz4 = class$javax$baja$control$ext$BNumericTotalizerExt;
            if (clazz4 == null) {
                clazz4 = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BNumericTotalizerExt;", false);
            }
            bNumericTotalizerExtArray = (BNumericTotalizerExt[])bControlPoint.getChildren(clazz4);
            int n5 = 0;
            while (n5 < bNumericTotalizerExtArray.length) {
                if (string.indexOf("Boolean") > -1) {
                    this.totBooleanPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bNumericTotalizerExtArray[n5].getName()), (BPointExtension)bNumericTotalizerExtArray[n5]));
                } else if (string.indexOf("Enum") > -1) {
                    this.totEnumPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bNumericTotalizerExtArray[n5].getName()), (BPointExtension)bNumericTotalizerExtArray[n5]));
                } else if (string.indexOf("Numeric") > -1) {
                    this.totNumericPtExtCmds.add((Object)new PtExtension((BWidget)this, TextUtil.toFriendly((String)bNumericTotalizerExtArray[n5].getName()), (BPointExtension)bNumericTotalizerExtArray[n5]));
                }
                ++n5;
            }
            ++n;
        }
        n = 0;
        while (n < this.alarmNumericPtExtCmds.size()) {
            this.alarmNumericMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.alarmNumericPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.alarmBooleanPtExtCmds.size()) {
            this.alarmBooleanMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.alarmBooleanPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.alarmEnumPtExtCmds.size()) {
            this.alarmEnumMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.alarmEnumPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.totNumericPtExtCmds.size()) {
            this.totNumericMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.totNumericPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.totBooleanPtExtCmds.size()) {
            this.totBooleanMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.totBooleanPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.totEnumPtExtCmds.size()) {
            this.totEnumMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.totEnumPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.trendNumericPtExtCmds.size()) {
            this.trendNumericMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.trendNumericPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.trendBooleanPtExtCmds.size()) {
            this.trendBooleanMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.trendBooleanPtExtCmds.get(n))));
            ++n;
        }
        n = 0;
        while (n < this.trendEnumPtExtCmds.size()) {
            this.trendEnumMenu.add("ptExtComd" + this.ctr++, (Command)((PtExtension)((Object)this.trendEnumPtExtCmds.get(n))));
            ++n;
        }
        return true;
    }

    protected BGridPane makeButtonPane() {
        BInsets bInsets = BInsets.make((double)5, (double)5, (double)5, (double)5);
        BGridPane bGridPane = new BGridPane();
        this.newCmd = null;
        this.cancelCmd = new Cancel((BWidget)this);
        this.saveCmd = new Save((BWidget)this);
        this.tuningCmd = new Tuning((BWidget)this);
        this.bSave = BAbstractButton.make((Command)this.saveCmd);
        this.bCancel = BAbstractButton.make((Command)this.cancelCmd);
        this.bTuning = BAbstractButton.make((Command)this.tuningCmd);
        this.bSave.setEnabled(false);
        this.bCancel.setEnabled(false);
        this.bTuning.setEnabled(true);
        this.bSave.setPadding(bInsets);
        this.bCancel.setPadding(bInsets);
        this.bTuning.setPadding(bInsets);
        if (this.getCurrentValue() != null && this.isBacnetDevice(this.getCurrentValue())) {
            bGridPane.add("bTuning", (BValue)this.bTuning);
        }
        bGridPane.add("bCancel", (BValue)this.bCancel);
        bGridPane.add("bSave", (BValue)this.bSave);
        bGridPane.setColumnCount(3);
        return bGridPane;
    }

    public CommandArtifact doDelete() throws Exception {
        return null;
    }

    public CommandArtifact doCancel() throws Exception {
        this.bSave.setEnabled(false);
        this.bCancel.setEnabled(false);
        super.clearModified();
        super.loadValue(this.getCurrentValue());
        return null;
    }

    public CommandArtifact doSave(BObject bObject) throws Exception {
        this.bSave.setEnabled(false);
        this.bCancel.setEnabled(false);
        super.saveValue();
        return null;
    }

    public CommandArtifact doTuning(BObject bObject) throws Exception {
        BDevice bDevice = this.getCurrentValue() instanceof BDevice ? (BDevice)this.getCurrentValue() : ((BPointDeviceExt)this.getCurrentValue()).getDevice();
        if (ReflectUtils.isType((BObject)bDevice, (String)"BacnetDevice")) {
            BPointDeviceExt bPointDeviceExt = (BPointDeviceExt)ReflectUtils.getPropertyValue((BComplex)bDevice, (String)"points");
            Class clazz = class$javax$baja$control$BControlPoint;
            if (clazz == null) {
                clazz = class$javax$baja$control$BControlPoint = BJciSlickPointManager.class("[Ljavax.baja.control.BControlPoint;", false);
            }
            BControlPoint[] bControlPointArray = (BControlPoint[])bPointDeviceExt.getChildren(clazz);
            int n = 0;
            while (n < bControlPointArray.length) {
                if (bControlPointArray[n].getProxyExt() instanceof BProxyExt) {
                    BProxyExt bProxyExt = (BProxyExt)bControlPointArray[n].getProxyExt();
                    try {
                        String string = TextUtil.split((String)ReflectUtils.getPropertyValue((BComplex)bProxyExt, (String)"objectId").toString(), (char)':')[0];
                        String string2 = TextUtil.split((String)ReflectUtils.getPropertyValue((BComplex)bProxyExt, (String)"objectId").toString(), (char)':')[1];
                        BDynamicEnum bDynamicEnum = (BDynamicEnum)ReflectUtils.getPropertyValue((BComplex)bProxyExt, (String)"propertyId");
                        String string3 = ReflectUtils.getPropertyValue((BComplex)bProxyExt, (String)"writeStatus").toString();
                        if (string.equals("analogInput") || string.equals("analogOutput") || string.equals("binaryInput") || string.equals("binaryOutput")) {
                            bProxyExt.setTuningPolicyName("HardwareNormalPolicy");
                        } else if ((string3.equals("OK") || string3.equals("Writable")) && bDynamicEnum.getTag().equals("presentValue")) {
                            bProxyExt.setTuningPolicyName("NetworkInputPolicy");
                        } else if ((string3.equals("OK") || string3.equals("Writable")) && (string2.equals("3183") || bDynamicEnum.getTag().equals("relinquishDefault"))) {
                            bProxyExt.setTuningPolicyName("PersistedSlowPolicy");
                        } else {
                            bProxyExt.setTuningPolicyName("defaultPolicy");
                        }
                    }
                    catch (Exception exception) {
                        bProxyExt.setTuningPolicyName("defaultPolicy");
                    }
                }
                ++n;
            }
        }
        this.doLoadValue(this.getCurrentValue(), this.getCurrentContext());
        return null;
    }

    public CommandArtifact doPtExtension(BPointExtension bPointExtension, String string) throws Exception {
        Row row = (Row)this.rows.get(this.activerow);
        row.selectedExtensions.add((Object)bPointExtension);
        row.selectedExtensionNames.add((Object)string);
        if (bPointExtension instanceof BAlarmSourceExt) {
            row.toggleAlarm();
        } else if (bPointExtension instanceof BHistoryExt) {
            row.toggleTrend();
        } else {
            row.toggleTot();
        }
        return null;
    }

    public CommandArtifact doTuningPolicyCommand(String string) throws Exception {
        Row row = (Row)this.rows.get(this.activerow);
        row.selectedTuningPolicyName = string;
        row.toggleTuningPolicy();
        return null;
    }

    public CommandArtifact doPollFrequencyCommand(String string) throws Exception {
        Row row = (Row)this.rows.get(this.activerow);
        row.pollFreq = BPollFrequency.make((String)string);
        row.togglePollFrequency();
        return null;
    }

    public void doLoadValue(BObject bObject, Context context) {
        Class clazz;
        BDeviceNetwork bDeviceNetwork;
        Array array;
        BDeviceExt[] bDeviceExtArray;
        if (!BFxService.isFacExpBrand(this.getWbShell().getActiveOrd())) {
            System.out.println("BJciSlickPointManager DID NOT find FacExp Brand!");
            return;
        }
        ((BEdgePane)this.getContent()).setBottom((BWidget)this.makeButtonPane());
        BControlPoint[] bControlPointArray = null;
        BPointFolder bPointFolder = null;
        boolean bl = false;
        if (bObject instanceof BNiagaraPointFolder) {
            bDeviceExtArray = (BDeviceExt[])bObject;
            this.deviceExt = bDeviceExtArray.getDeviceExt();
            array = this.deviceExt.getPoints();
            this.deviceName = SlotPath.unescape((String)bDeviceExtArray.getName());
            bDeviceNetwork = this.getNetwork((BComponent)bDeviceExtArray);
            Class clazz2 = class$javax$baja$control$BControlPoint;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$control$BControlPoint = BJciSlickPointManager.class("[Ljavax.baja.control.BControlPoint;", false);
            }
            bControlPointArray = (BControlPoint[])bDeviceExtArray.getChildren(clazz2);
        } else if (bObject instanceof BNiagaraPointDeviceExt) {
            this.deviceExt = (BNiagaraPointDeviceExt)bObject;
            this.deviceName = SlotPath.unescape((String)((BNiagaraPointDeviceExt)bObject).getParent().getName());
        }
        if (this.deviceExt == null) {
            if (bObject instanceof BDevice) {
                bDeviceExtArray = ((BDevice)bObject).getDeviceExts();
                bl = true;
                int n = 0;
                while (n < bDeviceExtArray.length) {
                    bDeviceNetwork = bDeviceExtArray[n];
                    if (bDeviceNetwork instanceof BPointDeviceExt) {
                        this.deviceExt = (BPointDeviceExt)bDeviceNetwork;
                        this.deviceName = SlotPath.unescape((String)this.deviceExt.getParent().getName());
                    }
                    ++n;
                }
            } else if (bObject instanceof BPointDeviceExt) {
                this.deviceExt = (BPointDeviceExt)bObject;
                bl = true;
                this.deviceName = SlotPath.unescape((String)this.deviceExt.getParent().getName());
            } else if (bObject instanceof BPointFolder) {
                bPointFolder = (BPointFolder)bObject;
                bControlPointArray = this.getControlPointsFromFolder(bPointFolder);
                this.deviceExt = bPointFolder.getDeviceExt();
                this.deviceName = bPointFolder.getParent() instanceof BPointDeviceExt || bPointFolder.getParent() instanceof BPointFolder ? SlotPath.unescape((String)bPointFolder.getName()) : SlotPath.unescape((String)bPointFolder.getParent().getName());
            }
        }
        if (this.deviceExt == null) {
            return;
        }
        this.titlePane.setTitle(lex.getText("JciSlickPointManager.tableTitle") + ' ' + this.deviceName);
        this.registerForComponentEvents((BComponent)this.deviceExt, 100);
        bDeviceExtArray = this.deviceExt.getPoints();
        if (bObject instanceof BNiagaraPointFolder || bObject instanceof BPointFolder) {
            bDeviceExtArray = bControlPointArray;
        }
        if ((clazz = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$Row) == null) {
            clazz = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$Row = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$Row;", false);
        }
        array = new Array(clazz);
        int n = 0;
        while (n < bDeviceExtArray.length) {
            Row row = new Row((BControlPoint)bDeviceExtArray[n], bl);
            array.add((Object)row);
            ++n;
        }
        this.rows = array;
        if (!this.isBacnetDevice(bObject)) {
            this.isBacnet = false;
            if (this.isN2Device(bObject)) {
                this.isN2 = true;
            } else {
                this.isN2 = false;
                this.isModbus = this.isModbusDevice(bObject);
            }
            if (this.table.getModel() instanceof DynamicTableModel) {
                DynamicTableModel dynamicTableModel = (DynamicTableModel)this.table.getModel();
                dynamicTableModel.setColumnShowable(dynamicTableModel.toRootColumnIndex(8), false);
                dynamicTableModel.setShowColumn(dynamicTableModel.toRootColumnIndex(8), false);
            }
        } else {
            this.isBacnet = true;
            this.isN2 = false;
            this.isModbus = false;
            if (this.table.getModel() instanceof DynamicTableModel) {
                DynamicTableModel dynamicTableModel = (DynamicTableModel)this.table.getModel();
                dynamicTableModel.setColumnShowable(dynamicTableModel.toRootColumnIndex(8), true);
                dynamicTableModel.setShowColumn(dynamicTableModel.toRootColumnIndex(8), true);
            }
        }
        this.table.getModel().updateTable(true);
        if (!this.setupRightClickMenus) {
            this.makePtExtCmds();
            this.makeTuningPolicyMenu();
            if (this.isN2 || this.isModbus) {
                this.makePollFreqMenu();
            }
            this.setupRightClickMenus = true;
        }
    }

    public BDevice getDevice(BComponent bComponent) {
        try {
            BComplex bComplex = bComponent.getParent();
            while (!(bComplex instanceof BDevice)) {
                bComplex = bComplex.getParent();
            }
            return (BDevice)bComplex;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BDeviceNetwork getNetwork(BComponent bComponent) {
        try {
            BComplex bComplex = bComponent.getParent();
            while (!(bComplex instanceof BDeviceNetwork)) {
                bComplex = bComplex.getParent();
            }
            return (BDeviceNetwork)bComplex;
        }
        catch (Exception exception) {
            return null;
        }
    }

    boolean isBacnetDevice(BObject bObject) {
        boolean bl = false;
        if (ReflectUtils.isType((BObject)bObject, (String)"BacnetDevice")) {
            bl = true;
        } else if (ReflectUtils.isType((BObject)bObject, (String)"BacnetPointDeviceExt")) {
            bl = true;
        }
        return bl;
    }

    boolean isN2Device(BObject bObject) {
        boolean bl = false;
        if (ReflectUtils.isType((BObject)bObject, (String)"JciN2Device") || ReflectUtils.isType((BObject)bObject, (String)"JciN2BDevice") || ReflectUtils.isType((BObject)bObject, (String)"JciN2ODevice") || ReflectUtils.isType((BObject)bObject, (String)"JciS91Device") || ReflectUtils.isType((BObject)bObject, (String)"JciDx9100Device") || ReflectUtils.isType((BObject)bObject, (String)"JciTc9100Device") || ReflectUtils.isType((BObject)bObject, (String)"JciXt9100Device")) {
            bl = true;
        } else if (ReflectUtils.isType((BObject)bObject, (String)"JciN2PointDeviceExt") || ReflectUtils.isType((BObject)bObject, (String)"JciN2BPointDeviceExt") || ReflectUtils.isType((BObject)bObject, (String)"JciN2OPointDeviceExt") || ReflectUtils.isType((BObject)bObject, (String)"JciS91PointDeviceExt")) {
            bl = true;
        }
        return bl;
    }

    boolean isModbusDevice(BObject bObject) {
        boolean bl = false;
        if (ReflectUtils.isType((BObject)bObject, (String)"ModbusAsyncDevice") || ReflectUtils.isType((BObject)bObject, (String)"ModbusSlaveDevice") || ReflectUtils.isType((BObject)bObject, (String)"ModbusTcpDevice") || ReflectUtils.isType((BObject)bObject, (String)"ModbusTcpGatewayDevice") || ReflectUtils.isType((BObject)bObject, (String)"ModbusTcpSlaveDevice")) {
            bl = true;
        } else if (ReflectUtils.isType((BObject)bObject, (String)"ModbusClientPointDeviceExt") || ReflectUtils.isType((BObject)bObject, (String)"ModbusServerPointDeviceExt")) {
            bl = true;
        }
        return bl;
    }

    BControlPoint[] getControlPointsFromFolder(BPointFolder bPointFolder) {
        BControlPoint[] bControlPointArray = null;
        BPointFolder[] bPointFolderArray = null;
        Class clazz = class$javax$baja$control$BControlPoint;
        if (clazz == null) {
            clazz = class$javax$baja$control$BControlPoint = BJciSlickPointManager.class("[Ljavax.baja.control.BControlPoint;", false);
        }
        bControlPointArray = (BControlPoint[])bPointFolder.getChildren(clazz);
        Class clazz2 = class$javax$baja$driver$point$BPointFolder;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$driver$point$BPointFolder = BJciSlickPointManager.class("[Ljavax.baja.driver.point.BPointFolder;", false);
        }
        if ((bPointFolderArray = (BPointFolder[])bPointFolder.getChildren(clazz2)).length > 0) {
            int n = 0;
            while (n < bPointFolderArray.length) {
                bControlPointArray = this.appendControlPoints(this.getControlPointsFromFolder(bPointFolderArray[n]), bControlPointArray);
                ++n;
            }
        }
        return bControlPointArray;
    }

    BControlPoint[] appendControlPoints(BControlPoint[] bControlPointArray, BControlPoint[] bControlPointArray2) {
        BControlPoint[] bControlPointArray3 = null;
        if (bControlPointArray.length == 0) {
            bControlPointArray3 = bControlPointArray2;
        } else if (bControlPointArray2.length == 0) {
            bControlPointArray3 = bControlPointArray;
        } else {
            bControlPointArray3 = new BControlPoint[bControlPointArray.length + bControlPointArray2.length];
            int n = 0;
            while (n < bControlPointArray.length) {
                bControlPointArray3[n] = bControlPointArray[n];
                ++n;
            }
            n = 0;
            while (n < bControlPointArray2.length) {
                bControlPointArray3[bControlPointArray.length + n] = bControlPointArray2[n];
                ++n;
            }
        }
        return bControlPointArray3;
    }

    public BObject doSaveValue(BObject bObject, Context context) throws Exception {
        Context context2 = Transaction.start((BComponent)this.deviceExt, (Context)context);
        int n = 0;
        while (n < this.rows.size()) {
            ((Row)this.rows.get(n)).saveChecked(context2);
            ++n;
        }
        Transaction.end((BComponent)this.deviceExt, (Context)context2);
        this.table.repaint();
        return bObject;
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        this.table.repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.isBacnet = false;
        this.isN2 = false;
        this.isModbus = false;
        Class clazz = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$Row;
        if (clazz == null) {
            clazz = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$Row = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$Row;", false);
        }
        this.rows = new Array(clazz);
        this.setupRightClickMenus = false;
        Class clazz2 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.alarmNumericPtExtCmds = new Array(clazz2);
        Class clazz3 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz3 == null) {
            clazz3 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.totNumericPtExtCmds = new Array(clazz3);
        Class clazz4 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz4 == null) {
            clazz4 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.trendNumericPtExtCmds = new Array(clazz4);
        this.alarmNumericMenu = new BMenu();
        this.totNumericMenu = new BMenu();
        this.trendNumericMenu = new BMenu();
        Class clazz5 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz5 == null) {
            clazz5 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.alarmBooleanPtExtCmds = new Array(clazz5);
        Class clazz6 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz6 == null) {
            clazz6 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.totBooleanPtExtCmds = new Array(clazz6);
        Class clazz7 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz7 == null) {
            clazz7 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.trendBooleanPtExtCmds = new Array(clazz7);
        this.alarmBooleanMenu = new BMenu();
        this.totBooleanMenu = new BMenu();
        this.trendBooleanMenu = new BMenu();
        Class clazz8 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz8 == null) {
            clazz8 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.alarmEnumPtExtCmds = new Array(clazz8);
        Class clazz9 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz9 == null) {
            clazz9 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.totEnumPtExtCmds = new Array(clazz9);
        Class clazz10 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension;
        if (clazz10 == null) {
            clazz10 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager$PtExtension = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager$PtExtension;", false);
        }
        this.trendEnumPtExtCmds = new Array(clazz10);
        this.alarmEnumMenu = new BMenu();
        this.totEnumMenu = new BMenu();
        this.trendEnumMenu = new BMenu();
        this.tuningPolicyMenu = new BMenu();
        this.pollFreqMenu = new BMenu();
        this.didptext = false;
        this.didextcpy = false;
        this.ctr = 0;
    }

    public BJciSlickPointManager() {
        this.this();
        this.autoRegisterForComponentEvents = false;
        Model model = new Model();
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 10;
        nArray[8] = 11;
        int[] nArray2 = nArray;
        DynamicTableModel dynamicTableModel = new DynamicTableModel((TableModel)model, nArray2);
        this.table = new BTable((TableModel)dynamicTableModel, (TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.table.repaint();
        String string = lex.getText("JciSlickPointManager.tableTitle") + ' ';
        this.titlePane = BTitlePane.makePane((String)string, (BTable)this.table);
        BGridPane bGridPane = this.makeButtonPane();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)this.titlePane);
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, (double)5, (double)5, 0.0, (double)5));
        this.setContent((BWidget)bEdgePane);
    }

    static {
        Class clazz = class$com$jci$jciFxDriver$ui$BJciSlickPointManager;
        if (clazz == null) {
            clazz = class$com$jci$jciFxDriver$ui$BJciSlickPointManager = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ptNameComparatorAscending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).point.getName();
                String string2 = ((Row)object2).point.getName();
                int n = string.compareTo(string2);
                return n;
            }
        };
        ptNameComparatorDecending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).point.getName();
                String string2 = ((Row)object2).point.getName();
                int n = string2.compareTo(string);
                return n;
            }
        };
        ptDescComparatorAscending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).longName;
                String string2 = ((Row)object2).longName;
                int n = string.compareTo(string2);
                return n;
            }
        };
        ptDescComparatorDecending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).longName;
                String string2 = ((Row)object2).longName;
                int n = string2.compareTo(string);
                return n;
            }
        };
        ptTypeComparatorAscending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).ptType;
                String string2 = ((Row)object2).ptType;
                int n = string.compareTo(string2);
                return n;
            }
        };
        ptTypeComparatorDecending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).ptType;
                String string2 = ((Row)object2).ptType;
                int n = string2.compareTo(string);
                return n;
            }
        };
        ptAddrComparatorAscending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).npaText;
                String string2 = ((Row)object2).npaText;
                int n = 0;
                try {
                    Integer n2 = Integer.valueOf(string);
                    Integer n3 = Integer.valueOf(string2);
                    n = n2.compareTo(n3);
                }
                catch (NumberFormatException numberFormatException) {
                    n = string.compareTo(string2);
                }
                return n;
            }
        };
        ptAddrComparatorDecending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).npaText;
                String string2 = ((Row)object2).npaText;
                int n = 0;
                try {
                    Integer n2 = Integer.valueOf(string);
                    Integer n3 = Integer.valueOf(string2);
                    n = n3.compareTo(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = string2.compareTo(string);
                }
                return n;
            }
        };
        ptValueComparatorAscending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).point.toString();
                String string2 = ((Row)object2).point.toString();
                int n = string.compareTo(string2);
                return n;
            }
        };
        ptValueComparatorDecending = new Comparator(){

            public final int compare(Object object, Object object2) {
                String string = ((Row)object).point.toString();
                String string2 = ((Row)object2).point.toString();
                int n = string2.compareTo(string);
                return n;
            }
        };
        checkIcon = BImage.make((String)"module://icons/x16/ok.png");
        stopIcon = BImage.make((String)"module://icons/x16/stop.png");
        Class clazz2 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager;
        if (clazz2 == null) {
            clazz2 = class$com$jci$jciFxDriver$ui$BJciSlickPointManager = BJciSlickPointManager.class("[Lcom.jci.jciFxDriver.ui.BJciSlickPointManager;", false);
        }
        lex = new UiLexicon(clazz2);
        defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TuningPolicyCommand
    extends Command {
        String tuningPolicyName;

        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doTuningPolicyCommand(this.tuningPolicyName);
        }

        TuningPolicyCommand(BWidget bWidget, String string) {
            super(bWidget, string);
            this.tuningPolicyName = SlotPath.escape((String)string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PollFrequencyCommand
    extends Command {
        private String pollFrequency;

        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doPollFrequencyCommand(this.pollFrequency);
        }

        PollFrequencyCommand(BWidget bWidget, String string) {
            super(bWidget, string);
            this.pollFrequency = SlotPath.escape((String)string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PtExtension
    extends Command {
        String extensionName;
        BPointExtension extension;

        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doPtExtension(this.extension, this.extensionName);
        }

        PtExtension(BWidget bWidget, String string) {
            super(bWidget, string);
            this.extensionName = SlotPath.escape((String)string);
        }

        PtExtension(BWidget bWidget, String string, BPointExtension bPointExtension) {
            super(bWidget, string);
            this.extensionName = SlotPath.escape((String)string);
            this.extension = bPointExtension;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Cancel
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doCancel();
        }

        Cancel(BWidget bWidget) {
            super(bWidget, lex.getText("JciSlickPointManager.buttonCancel"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Save
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doSave(null);
        }

        Save(BWidget bWidget) {
            super(bWidget, lex.getText("JciSlickPointManager.buttonSave"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Tuning
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doTuning(null);
        }

        Tuning(BWidget bWidget) {
            super(bWidget, lex.getText("JciSlickPointManager.buttonTuning"));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Row {
        static final String QUESTIONMARK = "?";
        BControlPoint point;
        String ptType;
        char ptTypeChar;
        BProxyExt proxyExt;
        BPointFolder pointFolder;
        Array selectedExtensions;
        Array selectedExtensionNames;
        String selectedTuningPolicyName;
        BHistoryExt historyExt;
        BAlarmSourceExt alarmExt;
        BDiscreteTotalizerExt disTotExt;
        BNumericTotalizerExt numTotExt;
        BFacets schFacet;
        boolean needStatusFlags;
        boolean enabled;
        boolean trend;
        String trendText;
        boolean alarm;
        String alarmText;
        boolean tot;
        String totText;
        boolean sched;
        String schedText;
        boolean notDefaultPolicy;
        String longName;
        String npt;
        String npaText;
        boolean needPolFreq;
        BPollFrequency pollFreq;
        double prefWidth;

        char getPtTypeChar(String string) {
            int n = 85;
            if (string.indexOf("Boolean") > -1) {
                n = 66;
            } else if (string.indexOf("Enum") > -1) {
                n = 69;
            } else if (string.indexOf("Numeric") > -1) {
                n = 78;
            }
            return (char)n;
        }

        boolean isN2ProxyExt() {
            boolean bl = false;
            if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciN2BBooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciN2BEnumProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciN2BNumericProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciN2OBooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciN2OEnumProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciN2ONumericProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciS91BooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciS91EnumProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"JciS91NumericProxyExt")) {
                bl = true;
            }
            return bl;
        }

        boolean isLonProxyExt() {
            boolean bl = false;
            if (ReflectUtils.isType((BObject)this.proxyExt, (String)"LonBooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"LonEnumProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"LonFloatProxyExt")) {
                bl = true;
            }
            return bl;
        }

        boolean isBacnetProxyExt() {
            boolean bl = false;
            if (ReflectUtils.isType((BObject)this.proxyExt, (String)"BacnetBooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"BacnetEnumProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"BacnetNumericProxyExt")) {
                bl = true;
            }
            return bl;
        }

        boolean isModbusProxyExt() {
            boolean bl = false;
            if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusClientBooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusClientEnumBitsProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusClientNumericBitsProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusClientRegisterBitProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusClientStringProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusClientNumericProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusServerBooleanProxyExt")) {
                bl = true;
            } else if (ReflectUtils.isType((BObject)this.proxyExt, (String)"ModbusServerNumericProxyExt")) {
                bl = true;
            }
            return bl;
        }

        void updateIcons() {
            Class clazz = class$javax$baja$control$BPointExtension;
            if (clazz == null) {
                clazz = class$javax$baja$control$BPointExtension = BJciSlickPointManager.class("[Ljavax.baja.control.BPointExtension;", false);
            }
            BPointExtension[] bPointExtensionArray = (BPointExtension[])this.point.getChildren(clazz);
            Class clazz2 = class$javax$baja$control$BPointExtension;
            if (clazz2 == null) {
                clazz2 = class$javax$baja$control$BPointExtension = BJciSlickPointManager.class("[Ljavax.baja.control.BPointExtension;", false);
            }
            Array array = new Array(clazz2);
            int n = 0;
            while (n < bPointExtensionArray.length) {
                BPointExtension bPointExtension = bPointExtensionArray[n];
                if (!(bPointExtension instanceof BProxyExt)) {
                    array.add((Object)bPointExtension);
                }
                ++n;
            }
        }

        void toggleEnable() {
            this.enabled ^= true;
            BJciSlickPointManager.this.setModified();
            BJciSlickPointManager.this.table.repaint();
        }

        void toggleTrend() {
            this.trend ^= true;
            this.trendText = "" + this.trend;
            if (!this.trend) {
                this.removeExtsOfType(2);
            }
            BJciSlickPointManager.this.setModified();
            BJciSlickPointManager.this.table.repaint();
        }

        void toggleAlarm() {
            this.alarm ^= true;
            this.alarmText = "" + this.alarm;
            if (!this.alarm) {
                this.removeExtsOfType(1);
            }
            BJciSlickPointManager.this.setModified();
            BJciSlickPointManager.this.table.repaint();
        }

        void toggleTot() {
            this.tot ^= true;
            this.totText = "" + this.tot;
            if (!this.tot) {
                this.removeExtsOfType(3);
            }
            BJciSlickPointManager.this.setModified();
            BJciSlickPointManager.this.table.repaint();
        }

        void toggleTuningPolicy() {
            this.notDefaultPolicy = !this.selectedTuningPolicyName.equals("defaultPolicy");
            BJciSlickPointManager.this.setModified();
            BJciSlickPointManager.this.table.repaint();
        }

        void togglePollFrequency() {
            BJciSlickPointManager.this.setModified();
            BJciSlickPointManager.this.table.repaint();
        }

        void toggleNeedStatusFlags() {
            if (BJciSlickPointManager.this.isBacnet) {
                this.needStatusFlags ^= true;
                BJciSlickPointManager.this.setModified();
                BJciSlickPointManager.this.table.repaint();
            }
        }

        void copyAlarmFromPrototype(BPointExtension bPointExtension, String string) {
            BAlarmSourceExt bAlarmSourceExt = new BAlarmSourceExt();
            bAlarmSourceExt = (BAlarmSourceExt)BJciSlickPointManager.copyFromProto((BPointExtension)bAlarmSourceExt, bPointExtension);
            this.point.add(string + '?', (BValue)bAlarmSourceExt);
        }

        void copyTrendFromPrototype(BPointExtension bPointExtension, String string) {
            if (bPointExtension instanceof BNumericIntervalHistoryExt) {
                BNumericIntervalHistoryExt bNumericIntervalHistoryExt = new BNumericIntervalHistoryExt();
                bNumericIntervalHistoryExt = (BNumericIntervalHistoryExt)BJciSlickPointManager.copyFromProto((BPointExtension)bNumericIntervalHistoryExt, bPointExtension);
                bNumericIntervalHistoryExt.setEnabled(true);
                this.point.add(string + '?', (BValue)bNumericIntervalHistoryExt);
            } else if (bPointExtension instanceof BNumericCovHistoryExt) {
                BNumericCovHistoryExt bNumericCovHistoryExt = new BNumericCovHistoryExt();
                bNumericCovHistoryExt = (BNumericCovHistoryExt)BJciSlickPointManager.copyFromProto((BPointExtension)bNumericCovHistoryExt, bPointExtension);
                bNumericCovHistoryExt.setEnabled(true);
                this.point.add(string + '?', (BValue)bNumericCovHistoryExt);
            } else if (bPointExtension instanceof BBooleanIntervalHistoryExt) {
                BBooleanIntervalHistoryExt bBooleanIntervalHistoryExt = new BBooleanIntervalHistoryExt();
                bBooleanIntervalHistoryExt = (BBooleanIntervalHistoryExt)BJciSlickPointManager.copyFromProto((BPointExtension)bBooleanIntervalHistoryExt, bPointExtension);
                bBooleanIntervalHistoryExt.setEnabled(true);
                this.point.add(string + '?', (BValue)bBooleanIntervalHistoryExt);
            } else if (bPointExtension instanceof BBooleanCovHistoryExt) {
                BBooleanCovHistoryExt bBooleanCovHistoryExt = new BBooleanCovHistoryExt();
                bBooleanCovHistoryExt = (BBooleanCovHistoryExt)BJciSlickPointManager.copyFromProto((BPointExtension)bBooleanCovHistoryExt, bPointExtension);
                bBooleanCovHistoryExt.setEnabled(true);
                this.point.add(string + '?', (BValue)bBooleanCovHistoryExt);
            } else if (bPointExtension instanceof BEnumIntervalHistoryExt) {
                BEnumIntervalHistoryExt bEnumIntervalHistoryExt = new BEnumIntervalHistoryExt();
                bEnumIntervalHistoryExt = (BEnumIntervalHistoryExt)BJciSlickPointManager.copyFromProto((BPointExtension)bEnumIntervalHistoryExt, bPointExtension);
                bEnumIntervalHistoryExt.setEnabled(true);
                this.point.add(string + '?', (BValue)bEnumIntervalHistoryExt);
            } else if (bPointExtension instanceof BEnumCovHistoryExt) {
                BEnumCovHistoryExt bEnumCovHistoryExt = new BEnumCovHistoryExt();
                bEnumCovHistoryExt = (BEnumCovHistoryExt)BJciSlickPointManager.copyFromProto((BPointExtension)bEnumCovHistoryExt, bPointExtension);
                bEnumCovHistoryExt.setEnabled(true);
                this.point.add(string + '?', (BValue)bEnumCovHistoryExt);
            } else {
                System.out.println("Error in type of history extension " + bPointExtension.getType().getTypeInfo().getTypeClassName());
            }
        }

        void copyTotFromPrototype(BPointExtension bPointExtension, String string, String string2) {
            if (string.equals("N")) {
                try {
                    BNumericTotalizerExt bNumericTotalizerExt = new BNumericTotalizerExt();
                    bNumericTotalizerExt = (BNumericTotalizerExt)BJciSlickPointManager.copyFromProto((BPointExtension)bNumericTotalizerExt, bPointExtension);
                    this.point.add(string2 + "NumericTotalization?", (BValue)bNumericTotalizerExt);
                }
                catch (Exception exception) {
                    System.out.println("could not add numeric totalizer " + bPointExtension.getName());
                }
            } else if (string.equals("D")) {
                try {
                    BDiscreteTotalizerExt bDiscreteTotalizerExt = new BDiscreteTotalizerExt();
                    bDiscreteTotalizerExt = (BDiscreteTotalizerExt)BJciSlickPointManager.copyFromProto((BPointExtension)bDiscreteTotalizerExt, bPointExtension);
                    this.point.add(string2 + "DiscreteTotalization?", (BValue)bDiscreteTotalizerExt);
                }
                catch (Exception exception) {
                    System.out.println("could not add discrete totalizer " + bPointExtension.getName());
                }
            } else {
                System.out.println("Error in type of totalization extension " + bPointExtension.getType().getTypeInfo().getTypeClassName());
            }
        }

        void removeExtsOfType(int n) {
            if (n == 0) {
                this.selectedExtensions.clear();
                this.selectedExtensionNames.clear();
            } else {
                Class clazz = class$javax$baja$control$BPointExtension;
                if (clazz == null) {
                    clazz = class$javax$baja$control$BPointExtension = BJciSlickPointManager.class("[Ljavax.baja.control.BPointExtension;", false);
                }
                Array array = new Array(clazz);
                Class clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$String = BJciSlickPointManager.class("[Ljava.lang.String;", false);
                }
                Array array2 = new Array(clazz2);
                block5: while (!this.selectedExtensions.isEmpty()) {
                    BPointExtension bPointExtension = (BPointExtension)this.selectedExtensions.remove(0);
                    String string = (String)this.selectedExtensionNames.remove(0);
                    switch (n) {
                        case 1: {
                            if (bPointExtension instanceof BAlarmSourceExt) continue block5;
                            array.add((Object)bPointExtension);
                            array2.add((Object)string);
                            break;
                        }
                        case 2: {
                            if (bPointExtension instanceof BHistoryExt) continue block5;
                            array.add((Object)bPointExtension);
                            array2.add((Object)string);
                            break;
                        }
                        case 3: {
                            if (bPointExtension instanceof BNumericTotalizerExt || bPointExtension instanceof BDiscreteTotalizerExt) continue block5;
                            array.add((Object)bPointExtension);
                            array2.add((Object)string);
                            break;
                        }
                    }
                }
                this.selectedExtensions = array;
                this.selectedExtensionNames = array2;
            }
        }

        void saveChecked(Context context) {
            String string;
            BPointExtension bPointExtension;
            this.proxyExt.setBoolean(BProxyExt.enabled, this.enabled, context);
            while (!this.selectedExtensions.isEmpty()) {
                bPointExtension = (BPointExtension)this.selectedExtensions.remove(0);
                string = (String)this.selectedExtensionNames.remove(0);
                if (bPointExtension instanceof BAlarmSourceExt) {
                    this.saveAlarm(bPointExtension, string);
                    continue;
                }
                if (bPointExtension instanceof BHistoryExt && this.trend) {
                    this.copyTrendFromPrototype(bPointExtension, string);
                    continue;
                }
                if (bPointExtension instanceof BDiscreteTotalizerExt && this.tot) {
                    this.copyTotFromPrototype(bPointExtension, "D", string);
                    continue;
                }
                if (!(bPointExtension instanceof BNumericTotalizerExt) || !this.tot) continue;
                this.copyTotFromPrototype(bPointExtension, "N", string);
            }
            this.removeExtensions();
            if (BJciSlickPointManager.this.isBacnet) {
                if (this.needStatusFlags) {
                    bPointExtension = this.point.getFacets();
                    string = BFacets.make((BFacets)bPointExtension, (String)"statusFlags", (BIDataValue)BBoolean.make((boolean)true));
                    this.point.setFacets((BFacets)string);
                } else {
                    bPointExtension = this.point.getFacets();
                    string = BFacets.makeRemove((BFacets)bPointExtension, (String)"statusFlags");
                    this.point.setFacets((BFacets)string);
                }
            }
            if (this.notDefaultPolicy) {
                this.proxyExt.setTuningPolicyName(this.selectedTuningPolicyName);
            } else {
                this.proxyExt.setTuningPolicyName("defaultPolicy");
            }
            if (this.needPolFreq && ReflectUtils.hasProperty((BComplex)this.proxyExt, (String)"pollFrequency")) {
                ReflectUtils.setPropertyValue((BComplex)this.proxyExt, (String)"pollFrequency", (BValue)this.pollFreq);
            }
        }

        protected void removeExtensions() {
            int n;
            Object[] objectArray;
            if (!this.alarm) {
                try {
                    Class clazz = class$javax$baja$alarm$ext$BAlarmSourceExt;
                    if (clazz == null) {
                        clazz = class$javax$baja$alarm$ext$BAlarmSourceExt = BJciSlickPointManager.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
                    }
                    objectArray = this.point.getChildren(clazz);
                    n = 0;
                    while (n < objectArray.length) {
                        this.point.remove((BComplex)((BAlarmSourceExt)objectArray[n]));
                        ++n;
                    }
                    this.alarmExt = null;
                }
                catch (Exception exception) {
                    this.alarmExt = null;
                }
            }
            if (!this.trend) {
                try {
                    Class clazz = class$javax$baja$history$ext$BHistoryExt;
                    if (clazz == null) {
                        clazz = class$javax$baja$history$ext$BHistoryExt = BJciSlickPointManager.class("[Ljavax.baja.history.ext.BHistoryExt;", false);
                    }
                    objectArray = this.point.getChildren(clazz);
                    n = 0;
                    while (n < objectArray.length) {
                        this.point.remove((BComplex)((BHistoryExt)objectArray[n]));
                        ++n;
                    }
                    this.historyExt = null;
                }
                catch (Exception exception) {
                    this.historyExt = null;
                }
            }
            if (!this.tot) {
                try {
                    Class clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt;
                    if (clazz == null) {
                        clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BDiscreteTotalizerExt;", false);
                    }
                    objectArray = this.point.getChildren(clazz);
                    n = 0;
                    while (n < objectArray.length) {
                        this.point.remove((BComplex)((BDiscreteTotalizerExt)objectArray[n]));
                        ++n;
                    }
                    this.disTotExt = null;
                }
                catch (Exception exception) {
                    this.disTotExt = null;
                }
                try {
                    Class clazz = class$javax$baja$control$ext$BNumericTotalizerExt;
                    if (clazz == null) {
                        clazz = class$javax$baja$control$ext$BNumericTotalizerExt = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BNumericTotalizerExt;", false);
                    }
                    objectArray = this.point.getChildren(clazz);
                    n = 0;
                    while (n < objectArray.length) {
                        this.point.remove((BComplex)((BNumericTotalizerExt)objectArray[n]));
                        ++n;
                    }
                    this.numTotExt = null;
                }
                catch (Exception exception) {
                    this.numTotExt = null;
                }
            }
        }

        protected void saveAlarm(BPointExtension bPointExtension, String string) {
            if (this.alarm) {
                this.copyAlarmFromPrototype(bPointExtension, string);
            }
        }

        protected void saveTrend(BPointExtension bPointExtension, String string) {
            if (this.trend) {
                this.copyTrendFromPrototype(bPointExtension, string);
            }
        }

        protected void saveTot(BPointExtension bPointExtension, String string, String string2) {
            if (this.tot) {
                this.copyTotFromPrototype(bPointExtension, string, string2);
            }
        }

        protected void doLink(BComponent bComponent, String string, BComponent bComponent2, String string2) {
            try {
                Slot slot = bComponent.getSlot(string);
                Slot slot2 = bComponent2.getSlot(string2);
                LinkCheck linkCheck = bComponent2.checkLink(bComponent, slot, slot2, null);
                if (linkCheck.isValid()) {
                    BLink bLink = bComponent2.makeLink(bComponent, slot, slot2, null);
                    bComponent2.add(null, (BValue)bLink);
                } else {
                    System.out.println("doLink was not Valid, reason = " + linkCheck.getInvalidReason() + ", source = " + bComponent + ", target = " + bComponent2);
                }
            }
            catch (Exception exception) {
                System.out.println("Link failed: " + exception.getMessage());
            }
        }

        BAlarmTransitionBits toAlarmTransitionBits() {
            int n = this.alarm;
            return BAlarmTransitionBits.make((int)n);
        }

        private final /* synthetic */ void this() {
            Class clazz = class$javax$baja$control$BPointExtension;
            if (clazz == null) {
                clazz = class$javax$baja$control$BPointExtension = BJciSlickPointManager.class("[Ljavax.baja.control.BPointExtension;", false);
            }
            this.selectedExtensions = new Array(clazz);
            Class clazz2 = class$java$lang$String;
            if (clazz2 == null) {
                clazz2 = class$java$lang$String = BJciSlickPointManager.class("[Ljava.lang.String;", false);
            }
            this.selectedExtensionNames = new Array(clazz2);
            this.selectedTuningPolicyName = "defaultPolicy";
            this.pollFreq = BPollFrequency.normal;
        }

        Row(BControlPoint bControlPoint, boolean bl) {
            BFacets bFacets;
            Object object;
            Object object2;
            this.this();
            boolean bl2 = false;
            this.point = bControlPoint;
            this.pointFolder = null;
            if (bl && bControlPoint.getParent().getParent() instanceof BPointFolder) {
                this.pointFolder = (BPointFolder)bControlPoint.getParent().getParent();
            }
            this.proxyExt = (BProxyExt)bControlPoint.getProxyExt();
            this.enabled = this.proxyExt.getEnabled();
            this.selectedTuningPolicyName = this.proxyExt.getTuningPolicyName();
            this.notDefaultPolicy = !this.selectedTuningPolicyName.equals("defaultPolicy");
            this.needPolFreq = false;
            if (this.isN2ProxyExt()) {
                object2 = ReflectUtils.getPropertyGeneralValue((BComplex)this.proxyExt, (String)"longName");
                if (object2 != null) {
                    this.longName = object2.toString();
                    bl2 = true;
                }
                if ((object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"networkPointType")) != null) {
                    this.npt = object2.toString();
                }
                if ((object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"networkPointAddress")) != null) {
                    this.npaText = object2.toString();
                }
                if ((object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"pollFrequency")) != null) {
                    this.needPolFreq = true;
                    this.pollFreq = (BPollFrequency)object2;
                }
            }
            if (this.isModbusProxyExt()) {
                object = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"absoluteAddress");
                if (object != null) {
                    this.npaText = object.toString();
                    bl2 = true;
                }
                if ((object = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"pollFrequency")) != null) {
                    this.needPolFreq = true;
                    this.pollFreq = (BPollFrequency)object;
                }
                try {
                    bFacets = (BJciProxyPointMixin)this.proxyExt.getMixIn(BJciProxyPointMixin.TYPE);
                    object2 = bFacets.getDescription();
                    if (object2 == null || ((String)object2).length() <= 0) {
                        object2 = "";
                    }
                }
                catch (Exception exception) {
                    object2 = "";
                }
                this.longName = object2;
            }
            if (this.isLonProxyExt()) {
                object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"targetComp");
                if (object2 != null) {
                    this.longName = SlotPath.unescape((String)object2.toString());
                    bl2 = true;
                }
                if ((object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"targetName")) != null) {
                    this.npaText = TextUtil.toFriendly((String)object2.toString());
                }
            }
            if (this.isBacnetProxyExt()) {
                bFacets = bControlPoint.getFacets();
                boolean bl3 = bFacets.getb("statusFlags", false);
                this.needStatusFlags = bl3;
                try {
                    BJciProxyPointMixin bJciProxyPointMixin = (BJciProxyPointMixin)this.proxyExt.getMixIn(BJciProxyPointMixin.TYPE);
                    object = bJciProxyPointMixin.getDescription();
                    if (object == null || ((String)object).length() <= 0) {
                        object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"propertyId");
                        if (object2 != null) {
                            object = object2.toString();
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                }
                catch (Exception exception) {
                    object = "";
                }
                this.longName = object;
                object2 = ReflectUtils.getPropertyValue((BComplex)this.proxyExt, (String)"objectId");
                if (object2 != null) {
                    this.npaText = object2.toString();
                }
            }
            if (!bl2) {
                try {
                    object2 = (BJciProxyPointMixin)this.proxyExt.getMixIn(BJciProxyPointMixin.TYPE);
                    this.longName = object2.getDescription();
                    this.npaText = "";
                }
                catch (Exception exception) {
                    this.longName = "";
                    this.npaText = "";
                }
            }
            this.ptType = bControlPoint.getType().getTypeName();
            this.ptTypeChar = this.getPtTypeChar(this.ptType);
            try {
                Class clazz = class$javax$baja$history$ext$BHistoryExt;
                if (clazz == null) {
                    clazz = class$javax$baja$history$ext$BHistoryExt = BJciSlickPointManager.class("[Ljavax.baja.history.ext.BHistoryExt;", false);
                }
                this.historyExt = (BHistoryExt)bControlPoint.getChildren(clazz)[0];
                boolean bl4 = false;
                if (this.historyExt != null) {
                    bl4 = true;
                }
                this.trend = bl4;
                this.trendText = "" + this.trend;
            }
            catch (Exception exception) {
                this.trend = false;
                this.trendText = lex.getText("JciSlickPointManager.valueDefault");
            }
            try {
                Class clazz = class$javax$baja$alarm$ext$BAlarmSourceExt;
                if (clazz == null) {
                    clazz = class$javax$baja$alarm$ext$BAlarmSourceExt = BJciSlickPointManager.class("[Ljavax.baja.alarm.ext.BAlarmSourceExt;", false);
                }
                this.alarmExt = (BAlarmSourceExt)bControlPoint.getChildren(clazz)[0];
                boolean bl5 = false;
                if (this.alarmExt.getAlarmEnable().getBits() != 0) {
                    bl5 = true;
                }
                this.alarm = bl5;
                this.alarmText = "" + this.alarm;
            }
            catch (Exception exception) {
                this.alarmText = lex.getText("JciSlickPointManager.valueDefault");
            }
            try {
                this.disTotExt = null;
                this.numTotExt = null;
                this.tot = false;
                switch (this.ptTypeChar) {
                    case 'B': {
                        Class clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt;
                        if (clazz == null) {
                            clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BDiscreteTotalizerExt;", false);
                        }
                        this.disTotExt = (BDiscreteTotalizerExt)bControlPoint.getChildren(clazz)[0];
                        if (this.disTotExt != null) {
                            this.tot = true;
                        }
                        this.totText = "" + this.tot;
                        break;
                    }
                    case 'E': {
                        Class clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt;
                        if (clazz == null) {
                            clazz = class$javax$baja$control$ext$BDiscreteTotalizerExt = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BDiscreteTotalizerExt;", false);
                        }
                        this.disTotExt = (BDiscreteTotalizerExt)bControlPoint.getChildren(clazz)[0];
                        if (this.disTotExt != null) {
                            this.tot = true;
                        }
                        this.totText = "" + this.tot;
                        break;
                    }
                    case 'N': {
                        Class clazz = class$javax$baja$control$ext$BNumericTotalizerExt;
                        if (clazz == null) {
                            clazz = class$javax$baja$control$ext$BNumericTotalizerExt = BJciSlickPointManager.class("[Ljavax.baja.control.ext.BNumericTotalizerExt;", false);
                        }
                        this.numTotExt = (BNumericTotalizerExt)bControlPoint.getChildren(clazz)[0];
                        if (this.numTotExt != null) {
                            this.tot = true;
                        }
                        this.totText = "" + this.tot;
                        break;
                    }
                    default: {
                        this.totText = lex.getText("JciSlickPointManager.valueDefault");
                    }
                }
                this.totText = "" + this.tot;
            }
            catch (Exception exception) {
                this.totText = lex.getText("JciSlickPointManager.valueDefault");
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TableModel {
        public BImage getRowIcon(int n) {
            Row row = (Row)BJciSlickPointManager.this.rows.get(n);
            BImage bImage = BImage.make((BIcon)BIcon.std((String)"blank.png"));
            if (row.ptTypeChar == 'B') {
                bImage = BImage.make((BIcon)BIcon.std((String)"control/booleanPoint.png"));
            } else if (row.ptTypeChar == 'E') {
                bImage = BImage.make((BIcon)BIcon.std((String)"control/enumPoint.png"));
            } else if (row.ptTypeChar == 'N') {
                bImage = BImage.make((BIcon)BIcon.std((String)"control/numericPoint.png"));
            }
            return bImage;
        }

        public int getRowCount() {
            return BJciSlickPointManager.this.rows.size();
        }

        public int getColumnCount() {
            return 12;
        }

        public String getColumnName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return lex.getText("JciSlickPointManager.columnName");
                }
                case 2: {
                    return lex.getText("JciSlickPointManager.columnValue");
                }
                case 3: {
                    return lex.getText("JciSlickPointManager.columnEnabled");
                }
                case 4: {
                    return lex.getText("JciSlickPointManager.columnTrend");
                }
                case 5: {
                    return lex.getText("JciSlickPointManager.columnAlarm");
                }
                case 6: {
                    return lex.getText("JciSlickPointManager.columnTotalization");
                }
                case 8: {
                    return lex.getText("JciSlickPointManager.columnStatusFlags");
                }
                case 1: {
                    return lex.getText("JciSlickPointManager.columnDescription");
                }
                case 10: {
                    return lex.getText("JciSlickPointManager.columnPointType");
                }
                case 11: {
                    return lex.getText("JciSlickPointManager.columnAddress");
                }
                case 7: {
                    return lex.getText("JciSlickPointManager.columnTuningPolicy");
                }
                case 9: {
                    return lex.getText("JciSlickPointManager.columnPollFreq");
                }
            }
            return lex.getText("JciSlickPointManager.columnUnknown");
        }

        public Object getValueAt(int n, int n2) {
            Row row = (Row)BJciSlickPointManager.this.rows.get(n);
            int n3 = n2;
            switch (n3) {
                case 0: {
                    if (row.pointFolder != null) {
                        String string = row.point.getDisplayName(null) + '_' + row.pointFolder.getDisplayName(null);
                        return string;
                    }
                    return row.point.getDisplayName(null);
                }
                case 2: {
                    return row.point.toString();
                }
                case 3: {
                    return String.valueOf(row.enabled);
                }
                case 8: {
                    return String.valueOf(row.needStatusFlags);
                }
                case 4: {
                    return row.trendText;
                }
                case 5: {
                    return row.alarmText;
                }
                case 6: {
                    return row.totText;
                }
                case 1: {
                    return row.longName;
                }
                case 10: {
                    return row.ptType;
                }
                case 11: {
                    return row.npaText;
                }
                case 7: {
                    return row.selectedTuningPolicyName;
                }
                case 9: {
                    if (BJciSlickPointManager.this.isN2 || BJciSlickPointManager.this.isModbus) {
                        return row.pollFreq.getTag();
                    }
                    return "";
                }
            }
            return lex.getText("JciSlickPointManager.valueUnknown");
        }

        public boolean isColumnSortable(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public void sortByColumn(int n, boolean bl) {
            int n2 = n;
            if (this.isColumnSortable(n2)) {
                switch (n2) {
                    case 0: {
                        if (bl) {
                            BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptNameComparatorAscending);
                            break;
                        }
                        BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptNameComparatorDecending);
                        break;
                    }
                    case 1: {
                        if (bl) {
                            BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptDescComparatorAscending);
                            break;
                        }
                        BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptDescComparatorDecending);
                        break;
                    }
                    case 2: {
                        if (bl) {
                            BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptValueComparatorAscending);
                            break;
                        }
                        BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptValueComparatorDecending);
                        break;
                    }
                    case 10: {
                        if (bl) {
                            BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptTypeComparatorAscending);
                            break;
                        }
                        BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptTypeComparatorDecending);
                        break;
                    }
                    case 11: {
                        if (bl) {
                            BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptAddrComparatorAscending);
                            break;
                        }
                        BJciSlickPointManager.this.rows = BJciSlickPointManager.this.rows.sort(ptAddrComparatorDecending);
                        break;
                    }
                }
                BJciSlickPointManager.this.table.getModel().updateTable(true);
                BJciSlickPointManager.this.table.repaint();
            }
        }

        Model() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TableController {
        public void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            BMouseEvent bMouseEvent2;
            BJciSlickPointManager.this.bSave.setEnabled(true);
            BJciSlickPointManager.this.bCancel.setEnabled(true);
            int n3 = BJciSlickPointManager.this.getRootColumnNumber(n2);
            super.cellPressed(bMouseEvent, n, n2);
            Row row = (Row)BJciSlickPointManager.this.rows.get(n);
            if (n3 == 3) {
                row.toggleEnable();
            }
            if (BJciSlickPointManager.this.isBacnet && n3 == 8) {
                row.toggleNeedStatusFlags();
            }
            if (n3 == 4) {
                if (!row.trend) {
                    bMouseEvent2 = new BMouseEvent(502, bMouseEvent.getWidget(), bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), true);
                    this.cellPopup(bMouseEvent2, n, n2);
                } else {
                    row.toggleTrend();
                }
            }
            if (n3 == 5) {
                if (!row.alarm) {
                    bMouseEvent2 = new BMouseEvent(502, bMouseEvent.getWidget(), bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), true);
                    this.cellPopup(bMouseEvent2, n, n2);
                } else {
                    row.toggleAlarm();
                }
            }
            if (n3 == 6) {
                if (!row.tot) {
                    bMouseEvent2 = new BMouseEvent(502, bMouseEvent.getWidget(), bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), true);
                    this.cellPopup(bMouseEvent2, n, n2);
                } else {
                    row.toggleTot();
                }
            }
            if (n3 == 7) {
                bMouseEvent2 = new BMouseEvent(502, bMouseEvent.getWidget(), bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), true);
                this.cellPopup(bMouseEvent2, n, n2);
            }
            if (n3 == 9 && BJciSlickPointManager.this.isN2) {
                row.needPolFreq = true;
                bMouseEvent2 = new BMouseEvent(502, bMouseEvent.getWidget(), bMouseEvent.getModifiers(), bMouseEvent.getX(), bMouseEvent.getY(), bMouseEvent.getClickCount(), true);
                this.cellPopup(bMouseEvent2, n, n2);
            }
        }

        public void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
            int n3 = BJciSlickPointManager.this.getRootColumnNumber(n2);
            if (n3 == 4 || n3 == 5 || n3 == 6 || n3 == 0 || n3 == 2 || n3 == 7 || n3 == 9) {
                BJciSlickPointManager.this.bSave.setEnabled(true);
                BJciSlickPointManager.this.bCancel.setEnabled(true);
                super.cellPopup(bMouseEvent, n, n2);
            }
        }

        protected BMenu makePopup(TableSubject tableSubject) {
            BJciSlickPointManager.this.activerow = tableSubject.getActiveRow();
            int n = BJciSlickPointManager.this.getRootColumnNumber(this.getMouseOverColumn());
            Row row = (Row)BJciSlickPointManager.this.rows.get(BJciSlickPointManager.this.activerow);
            BControlPoint bControlPoint = row.point;
            String string = bControlPoint.getType().getTypeName();
            if (string.indexOf("Boolean") > -1) {
                switch (n) {
                    case 4: {
                        return BJciSlickPointManager.this.trendBooleanMenu;
                    }
                    case 5: {
                        return BJciSlickPointManager.this.alarmBooleanMenu;
                    }
                    case 6: {
                        return BJciSlickPointManager.this.totBooleanMenu;
                    }
                    case 0: {
                        return BJciSlickPointManager.this.getPointActionMenu(bControlPoint);
                    }
                    case 2: {
                        return BJciSlickPointManager.this.getPointActionMenu(bControlPoint);
                    }
                    case 7: {
                        return BJciSlickPointManager.this.tuningPolicyMenu;
                    }
                    case 9: {
                        return BJciSlickPointManager.this.pollFreqMenu;
                    }
                }
                return null;
            }
            if (string.indexOf("Numeric") > -1) {
                switch (n) {
                    case 4: {
                        return BJciSlickPointManager.this.trendNumericMenu;
                    }
                    case 5: {
                        return BJciSlickPointManager.this.alarmNumericMenu;
                    }
                    case 6: {
                        return BJciSlickPointManager.this.totNumericMenu;
                    }
                    case 0: {
                        return BJciSlickPointManager.this.getPointActionMenu(bControlPoint);
                    }
                    case 2: {
                        return BJciSlickPointManager.this.getPointActionMenu(bControlPoint);
                    }
                    case 7: {
                        return BJciSlickPointManager.this.tuningPolicyMenu;
                    }
                    case 9: {
                        return BJciSlickPointManager.this.pollFreqMenu;
                    }
                }
                return null;
            }
            if (string.indexOf("Enum") > -1) {
                switch (n) {
                    case 4: {
                        return BJciSlickPointManager.this.trendEnumMenu;
                    }
                    case 5: {
                        return BJciSlickPointManager.this.alarmEnumMenu;
                    }
                    case 6: {
                        return BJciSlickPointManager.this.totEnumMenu;
                    }
                    case 0: {
                        return BJciSlickPointManager.this.getPointActionMenu(bControlPoint);
                    }
                    case 2: {
                        return BJciSlickPointManager.this.getPointActionMenu(bControlPoint);
                    }
                    case 7: {
                        return BJciSlickPointManager.this.tuningPolicyMenu;
                    }
                    case 9: {
                        return BJciSlickPointManager.this.pollFreqMenu;
                    }
                }
                return null;
            }
            return null;
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            Row row = (Row)BJciSlickPointManager.this.rows.get(n);
            BControlPoint bControlPoint = row.point;
            BWbShell bWbShell = BJciSlickPointManager.this.getWbShell();
            if (bControlPoint != null && bWbShell != null) {
                bWbShell.hyperlink(new HyperlinkInfo(bControlPoint.getNavOrd(), (BInputEvent)bMouseEvent));
            }
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CellRenderer
    extends TableCellRenderer {
        public BBrush getForeground(TableCellRenderer.Cell cell) {
            BBrush bBrush = super.getForeground(cell);
            try {
                BControlPoint bControlPoint = ((Row)BJciSlickPointManager.this.rows.get((int)cell.row)).point;
                BColor bColor = (BColor)bControlPoint.getStatus().getForegroundColor(null);
                if (bColor != null) {
                    return bColor.toBrush();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return bBrush;
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BBrush bBrush = super.getBackground(cell);
            try {
                BControlPoint bControlPoint = ((Row)BJciSlickPointManager.this.rows.get((int)cell.row)).point;
                BColor bColor = (BColor)bControlPoint.getStatus().getBackgroundColor(null);
                if (bColor != null) {
                    return bColor.toBrush();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return bBrush;
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return super.getPreferredCellWidth(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            BColor bColor = BColor.white;
            if (bColor != null) {
                return bColor.toBrush();
            }
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            BColor bColor = BColor.darkSlateBlue;
            if (bColor != null) {
                return bColor.toBrush();
            }
            return this.getBackground(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            Row row = (Row)BJciSlickPointManager.this.rows.get(cell.row);
            int n = BJciSlickPointManager.this.getRootColumnNumber(cell.column);
            boolean bl = false;
            boolean bl2 = false;
            switch (n) {
                case 3: {
                    bl = row.enabled;
                    break;
                }
                case 8: {
                    if (BJciSlickPointManager.this.isBacnet) {
                        bl2 = false;
                        bl = row.needStatusFlags;
                        break;
                    }
                    bl = false;
                    bl2 = true;
                    row.needStatusFlags = false;
                    break;
                }
                case 4: {
                    bl = row.trend;
                    break;
                }
                case 5: {
                    bl = row.alarm;
                    break;
                }
                case 6: {
                    bl = row.tot;
                    break;
                }
                default: {
                    super.paintCell(graphics, cell);
                    return;
                }
            }
            this.paintCellBackground(graphics, cell);
            if (bl2) {
                graphics.drawImage(stopIcon, 10.0, 0.0);
            }
            if (bl) {
                graphics.drawImage(checkIcon, 10.0, 0.0);
            }
        }

        CellRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Delete
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            return BJciSlickPointManager.this.doDelete();
        }

        Delete(BWidget bWidget) {
            super(bWidget, "Delete");
        }
    }
}

