/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.discover.auto;

import com.tridium.ddf.BDdfDevice;
import com.tridium.ddf.BDdfNetwork;
import com.tridium.ddf.BDdfPointDeviceExt;
import com.tridium.ddf.DdfLexicon;
import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.req.BIDdfDiscoverRequest;
import com.tridium.ddf.comm.req.BIDdfPingRequest;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.IDdfPingable;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.util.DdfRequestUtil;
import com.tridium.ddf.discover.BDdfDiscoveryJob;
import com.tridium.ddf.discover.BIDdfDiscoveryHost;
import com.tridium.ddf.discover.BIDdfDiscoveryObject;
import com.tridium.ddf.discover.IDdfDiscoverer;
import com.tridium.ddf.discover.auto.BDdfAutoDiscoveryPreferences;
import com.tridium.ddf.discover.auto.DdfAutoDiscoveryLexicon;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.ddf.identify.BIDdfDiscoverParams;
import com.tridium.ddf.point.BDdfProxyExt;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFolder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDdfAutoDiscoveryJob
extends BDdfDiscoveryJob {
    public static final Property discoveryPreferences = BDdfAutoDiscoveryJob.newProperty((int)0, (BValue)new BDdfAutoDiscoveryPreferences(), null);
    public static final Type TYPE;
    private BIDdfDiscoveryHost discoveryHost;
    static /* synthetic */ Class class$com$tridium$ddf$discover$auto$BDdfAutoDiscoveryJob;
    static /* synthetic */ Class class$javax$baja$control$BControlPoint;
    static /* synthetic */ Class class$com$tridium$ddf$comm$req$IDdfPingable;
    static /* synthetic */ Class class$com$tridium$ddf$comm$req$IDdfReadable;

    public BDdfAutoDiscoveryPreferences getDiscoveryPreferences() {
        return (BDdfAutoDiscoveryPreferences)this.get(discoveryPreferences);
    }

    public void setDiscoveryPreferences(BDdfAutoDiscoveryPreferences bDdfAutoDiscoveryPreferences) {
        this.set(discoveryPreferences, (BValue)bDdfAutoDiscoveryPreferences, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void run(Context context) throws Exception {
        this.clearRootDiscoveryObjects();
        this.autoLearn();
        BIDdfDiscoveryObject[] bIDdfDiscoveryObjectArray = this.getRootDiscoveryObjects();
        if (bIDdfDiscoveryObjectArray != null && bIDdfDiscoveryObjectArray.length < 1) {
            if (this.discoveryHost instanceof BDdfNetwork) {
                throw new BajaRuntimeException(DdfAutoDiscoveryLexicon.noDevicesFound);
            }
            throw new BajaRuntimeException(DdfAutoDiscoveryLexicon.noPointsFound);
        }
    }

    protected Type[] getDiscoveryRequestTypes() {
        BDdfIdParams bDdfIdParams = this.getDiscoveryPreferences().getMin();
        if (bDdfIdParams instanceof BIDdfDiscoverParams) {
            return ((BIDdfDiscoverParams)((Object)bDdfIdParams)).getDiscoverRequestTypes();
        }
        throw new BajaRuntimeException(DdfLexicon.ddfDiscoverParamsNeedsImplemented(bDdfIdParams.getType()));
    }

    protected void autoLearn() throws Exception {
        Type[] typeArray = this.getDiscoveryRequestTypes();
        int n = 0;
        while (n < typeArray.length) {
            if (typeArray[n].is(BIDdfDiscoverRequest.TYPE)) {
                this.learnFromRequestType(typeArray[n], 100 / typeArray.length);
            } else {
                this.discoveryHost.getDdfCommunicator().getLog().error(DdfAutoDiscoveryLexicon.typeMustImplementDiscoveryRequest(typeArray[n]));
            }
            ++n;
        }
    }

    protected void learnFromRequestType(Type type, int n) {
        BIDdfDiscoverParams bIDdfDiscoverParams = (BIDdfDiscoverParams)this.getDiscoveryPreferences().getMin().newCopy();
        BIDdfDiscoverParams bIDdfDiscoverParams2 = (BIDdfDiscoverParams)this.getDiscoveryPreferences().getMax().newCopy();
        int n2 = bIDdfDiscoverParams.countTo(bIDdfDiscoverParams2);
        BIDdfDiscoverParams bIDdfDiscoverParams3 = bIDdfDiscoverParams;
        BIDdfDiscoverParams bIDdfDiscoverParams4 = bIDdfDiscoverParams;
        while (!bIDdfDiscoverParams4.isAfter(bIDdfDiscoverParams3) && !bIDdfDiscoverParams3.isAfter(bIDdfDiscoverParams2)) {
            if (this.getJobState() == BJobState.canceling) {
                throw new JobCancelException();
            }
            this.learn((BIDdfDiscoverRequest)type.getInstance(), bIDdfDiscoverParams3);
            this.progress(this.getProgress() + (int)((float)n / (float)n2));
            bIDdfDiscoverParams4 = bIDdfDiscoverParams3;
            bIDdfDiscoverParams3 = bIDdfDiscoverParams3.getNext();
        }
        if (n2 == Integer.MAX_VALUE) {
            this.progress(this.getProgress() + n);
        }
    }

    private final BComponent[] getDatabaseObjects() {
        if (this.discoveryHost instanceof BDdfNetwork) {
            BDdfNetwork bDdfNetwork = (BDdfNetwork)((Object)this.discoveryHost);
            BDevice[] bDeviceArray = bDdfNetwork.getDevices();
            return bDeviceArray;
        }
        if (this.discoveryHost instanceof BDdfPointDeviceExt) {
            Class clazz = class$javax$baja$control$BControlPoint;
            if (clazz == null) {
                clazz = class$javax$baja$control$BControlPoint = BDdfAutoDiscoveryJob.class("[Ljavax.baja.control.BControlPoint;", false);
            }
            Array array = new Array(clazz);
            BDdfDevice bDdfDevice = (BDdfDevice)((BDdfPointDeviceExt)this.discoveryHost).getDevice();
            BDeviceExt[] bDeviceExtArray = bDdfDevice.getDeviceExts();
            int n = 0;
            while (n < bDeviceExtArray.length) {
                if (bDeviceExtArray[n] instanceof BPointDeviceExt) {
                    BPointDeviceExt bPointDeviceExt = (BPointDeviceExt)bDeviceExtArray[n];
                    array.addAll((Object[])bPointDeviceExt.getPoints());
                }
                ++n;
            }
            return (BComponent[])array.trim();
        }
        throw new IllegalStateException("Not Implemented For Database Parent Type: " + this.discoveryHost.getType().getTypeName());
    }

    private final IDdfPingable[] getPingableSource(BDdfIdParams bDdfIdParams) {
        Class clazz = class$com$tridium$ddf$comm$req$IDdfPingable;
        if (clazz == null) {
            clazz = class$com$tridium$ddf$comm$req$IDdfPingable = BDdfAutoDiscoveryJob.class("[Lcom.tridium.ddf.comm.req.IDdfPingable;", false);
        }
        Array array = new Array(clazz);
        BComponent[] bComponentArray = this.getDatabaseObjects();
        int n = 0;
        while (n < bComponentArray.length) {
            BDdfDevice bDdfDevice;
            BDdfIdParams bDdfIdParams2;
            if (bComponentArray[n] instanceof BDdfDevice && (bDdfIdParams2 = (bDdfDevice = (BDdfDevice)bComponentArray[n]).getDeviceId()).getType().equals(bDdfIdParams.getType()) && bDdfDevice.getDeviceId().equals(bDdfIdParams)) {
                array.add((Object)bDdfDevice);
            }
            ++n;
        }
        return (IDdfPingable[])array.trim();
    }

    private final IDdfReadable[] getReadableSource(BDdfIdParams bDdfIdParams) {
        Class clazz = class$com$tridium$ddf$comm$req$IDdfReadable;
        if (clazz == null) {
            clazz = class$com$tridium$ddf$comm$req$IDdfReadable = BDdfAutoDiscoveryJob.class("[Lcom.tridium.ddf.comm.req.IDdfReadable;", false);
        }
        Array array = new Array(clazz);
        BComponent[] bComponentArray = this.getDatabaseObjects();
        int n = 0;
        while (n < bComponentArray.length) {
            BDdfIdParams bDdfIdParams2;
            BAbstractProxyExt bAbstractProxyExt;
            if (bComponentArray[n] instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponentArray[n]).getProxyExt()) instanceof BDdfProxyExt && (bDdfIdParams2 = ((BDdfProxyExt)bAbstractProxyExt).getReadParameters()).getType().equals(bDdfIdParams.getType()) && bDdfIdParams2.equivalent(bDdfIdParams)) {
                array.add((Object)bAbstractProxyExt);
            }
            ++n;
        }
        return (IDdfReadable[])array.trim();
    }

    protected void learn(BIDdfDiscoverRequest bIDdfDiscoverRequest, BIDdfDiscoverParams bIDdfDiscoverParams) {
        bIDdfDiscoverRequest.setResponseTimeout(this.getDiscoveryPreferences().getTimeout());
        bIDdfDiscoverRequest.setRemainingRetryCount(this.getDiscoveryPreferences().getRetryCount());
        bIDdfDiscoverRequest.setDiscoverParameters((BDdfIdParams)((Object)bIDdfDiscoverParams));
        bIDdfDiscoverRequest.setDiscoverer(new IDdfDiscoverer(){

            public final BJob getJob() {
                return BDdfAutoDiscoveryJob.this;
            }

            public final void discoverFail(String string) {
                BDdfAutoDiscoveryJob.this.log().message(string);
            }

            public final void discoverOk(BIDdfDiscoveryObject[] bIDdfDiscoveryObjectArray) {
                Object object = BDdfAutoDiscoveryJob.this.discoveryHost.getDiscoveryFolder();
                if (object == null) {
                    object = BDdfAutoDiscoveryJob.this;
                }
                int n = 0;
                while (n < bIDdfDiscoveryObjectArray.length) {
                    object.add("d?", (BValue)bIDdfDiscoveryObjectArray[n]);
                    ++n;
                }
            }

            public final Context getDiscoverContext() {
                if (BDdfAutoDiscoveryJob.this.discoveryHost instanceof BDdfNetwork) {
                    return IDdfFacetConst.CONTEXT_DISCOVERING_DEVICES;
                }
                return IDdfFacetConst.CONTEXT_DISCOVERING_POINTS;
            }
        });
        if (this.discoveryHost instanceof BDdfNetwork) {
            if (bIDdfDiscoverRequest instanceof BIDdfPingRequest) {
                bIDdfDiscoverRequest.setDeviceId((BDdfIdParams)((BDdfIdParams)((Object)bIDdfDiscoverParams)).newCopy());
                ((BIDdfPingRequest)((Object)bIDdfDiscoverRequest)).setPingableSource(this.getPingableSource((BDdfIdParams)((BDdfIdParams)((Object)bIDdfDiscoverParams)).newCopy()));
            }
        } else if (this.discoveryHost instanceof BDdfPointDeviceExt) {
            bIDdfDiscoverRequest.setDeviceId((BDdfIdParams)((BDdfDevice)((BDdfPointDeviceExt)this.discoveryHost).getDevice()).getDeviceId().newCopy());
            if (bIDdfDiscoverRequest instanceof BIDdfReadRequest) {
                ((BIDdfReadRequest)((Object)bIDdfDiscoverRequest)).setReadParameters((BDdfIdParams)((BDdfIdParams)((Object)bIDdfDiscoverParams)).newCopy());
                ((BIDdfReadRequest)((Object)bIDdfDiscoverRequest)).setReadableSource(this.getReadableSource((BDdfIdParams)((Object)bIDdfDiscoverParams)));
            }
        }
        DdfRequestUtil.communicateSync(this.discoveryHost.getDdfCommunicator(), bIDdfDiscoverRequest);
    }

    public BIDdfDiscoveryHost getDiscoveryHost() {
        return this.discoveryHost;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.discoveryHost = null;
    }

    public BDdfAutoDiscoveryJob() {
        this.this();
    }

    public BDdfAutoDiscoveryJob(BIDdfDiscoveryHost bIDdfDiscoveryHost) {
        this.this();
        this.discoveryHost = bIDdfDiscoveryHost;
        BFolder bFolder = bIDdfDiscoveryHost.getDiscoveryFolder();
        if (bFolder != null) {
            this.setDiscoveryFolder(bFolder.getSlotPathOrd());
        }
    }

    static {
        Class clazz = class$com$tridium$ddf$discover$auto$BDdfAutoDiscoveryJob;
        if (clazz == null) {
            clazz = class$com$tridium$ddf$discover$auto$BDdfAutoDiscoveryJob = BDdfAutoDiscoveryJob.class("[Lcom.tridium.ddf.discover.auto.BDdfAutoDiscoveryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

