/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddf.comm.req.util;

import com.tridium.ddf.IDdfFacetConst;
import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddf.comm.defaultComm.DdfDefaultCommLexicon;
import com.tridium.ddf.comm.req.BIDdfReadRequest;
import com.tridium.ddf.comm.req.IDdfReadable;
import com.tridium.ddf.comm.req.util.DdfRequestLexicon;
import com.tridium.ddf.comm.rsp.BIDdfReadResponse;
import com.tridium.ddf.comm.rsp.BIDdfResponse;
import com.tridium.ddf.comm.rsp.DdfResponseException;
import javax.baja.sys.BajaRuntimeException;

public class DdfReadRequestUtil
implements IDdfFacetConst {
    public static void processResponse(BIDdfReadRequest bIDdfReadRequest, BIDdfReadResponse bIDdfReadResponse) {
        if (bIDdfReadRequest.getAutoReadOk()) {
            DdfReadRequestUtil.callReadOk(bIDdfReadRequest, bIDdfReadResponse);
        }
    }

    private static final void callReadOk(BIDdfReadRequest bIDdfReadRequest, BIDdfReadResponse bIDdfReadResponse) {
        IDdfReadable[] iDdfReadableArray = bIDdfReadRequest.getReadableSource();
        if (iDdfReadableArray != null) {
            int n = 0;
            while (n < iDdfReadableArray.length) {
                DdfReadRequestUtil.callReadOk(iDdfReadableArray[n], bIDdfReadResponse);
                ++n;
            }
        }
    }

    static void callReadOk(IDdfReadable iDdfReadable, BIDdfReadResponse bIDdfReadResponse) {
        try {
            iDdfReadable.readOk(bIDdfReadResponse.parseReadValue(iDdfReadable));
        }
        catch (Exception exception) {
            iDdfReadable.readFail(DdfDefaultCommLexicon.parseError(exception));
        }
    }

    public static void processTimeout(BIDdfReadRequest bIDdfReadRequest) {
        IDdfReadable[] iDdfReadableArray;
        if (bIDdfReadRequest.getAutoReadFailOnTimeout() && (iDdfReadableArray = bIDdfReadRequest.getReadableSource()) != null) {
            int n = 0;
            while (n < iDdfReadableArray.length) {
                iDdfReadableArray[n].readFail(DdfRequestLexicon.requestTimeout);
                ++n;
            }
        }
    }

    public static void processLateResponse(BIDdfReadRequest bIDdfReadRequest, BIDdfReadResponse bIDdfReadResponse) {
        if (bIDdfReadRequest.getAutoReadOkLate()) {
            DdfReadRequestUtil.callReadOk(bIDdfReadRequest, bIDdfReadResponse);
        }
    }

    public static BIDdfResponse processReceive(BIDdfReadRequest bIDdfReadRequest, IDdfDataFrame iDdfDataFrame) throws DdfResponseException {
        BIDdfResponse bIDdfResponse = bIDdfReadRequest.processReceive(iDdfDataFrame);
        if (bIDdfResponse == null || bIDdfResponse instanceof BIDdfReadResponse) {
            return bIDdfResponse;
        }
        throw new BajaRuntimeException(DdfRequestLexicon.pleaseFixDriver(bIDdfReadRequest.getType()), (Throwable)new BajaRuntimeException(DdfRequestLexicon.readReqMustUseReadRsp(bIDdfReadRequest.getType())));
    }

    public static void processErrorResponse(BIDdfReadRequest bIDdfReadRequest, DdfResponseException ddfResponseException) {
        IDdfReadable[] iDdfReadableArray;
        if (bIDdfReadRequest.getAutoReadFailOnError() && (iDdfReadableArray = bIDdfReadRequest.getReadableSource()) != null) {
            int n = 0;
            while (n < iDdfReadableArray.length) {
                iDdfReadableArray[n].readFail(DdfDefaultCommLexicon.responseError(ddfResponseException));
                ++n;
            }
        }
    }
}

