/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dmp.util;

import com.tridium.dmp.BDmpDevice;
import com.tridium.dmp.enums.BDmpInstructs;
import com.tridium.dmp.util.FletcherChecksum;
import javax.baja.log.Log;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BString;

public class DmpCommandRunnable
implements Runnable {
    private BDmpDevice dev;
    private BDmpInstructs instruct;
    private String params;

    public void run() {
        Object object;
        if (this.dev.getNetwork().getLog().isTraceOn()) {
            Log.getLog((String)"dmp").trace("do command " + (Object)((Object)this.instruct));
        }
        if (this.dev.getAccountNumber().equals("")) {
            Log.getLog((String)"dmp").warning("Dmp account number has not been set.");
        }
        String string = "";
        switch (this.instruct.getOrdinal()) {
            case 8: {
                this.dev.setArmDisarmFail(false);
                if (this.params == null) {
                    this.params = "";
                    object = TextUtil.split((String)this.dev.getArmableAreaList(), (char)',');
                    int n = 0;
                    while (n < ((String[])object).length) {
                        if (!object[n].equals("")) {
                            this.params = this.params + object[n].substring(1);
                        }
                        ++n;
                    }
                }
                string = this.instruct.enumToCommand() + this.params + ",YN" + this.dev.getNextSequenceNum();
                break;
            }
            case 1: {
                string = this.instruct.enumToCommand();
                this.dev.sendCommand("@" + this.dev.getAccountNumber() + string + '\n');
                return;
            }
            case 12: {
                this.dev.setSequenceNumber(0);
                string = this.instruct.enumToCommand() + '0';
                break;
            }
            case 15: 
            case 16: {
                string = this.instruct.enumToCommand() + this.params + this.dev.getNextSequenceNum();
                break;
            }
            case 9: {
                this.dev.setArmDisarmFail(false);
                string = this.instruct.enumToCommand() + this.params + ',' + this.dev.getNextSequenceNum();
                break;
            }
            default: {
                string = this.instruct.enumToCommand() + this.dev.getNextSequenceNum();
            }
        }
        object = FletcherChecksum.getFletcherChecksum(string);
        Log.getLog((String)"dmp").trace("@" + this.dev.getAccountNumber() + string + (String)object + '\n');
        this.dev.sendCommand("@" + this.dev.getAccountNumber() + string + (String)object + '\n');
    }

    public DmpCommandRunnable(BDmpDevice bDmpDevice, BDmpInstructs bDmpInstructs, BString bString) {
        this.dev = bDmpDevice;
        this.instruct = bDmpInstructs;
        if (bString != null) {
            this.params = bString.getString();
        }
    }
}

