/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dmp.messages;

import com.tridium.dmp.enums.BDmpInstructs;
import com.tridium.dmp.messages.DmpCommand;
import com.tridium.dmp.messages.DmpFragmentable;
import com.tridium.dmp.util.DmpInputStream;
import com.tridium.dmp.util.DmpIoException;
import com.tridium.dmp.util.FletcherChecksum;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import javax.baja.log.Log;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DmpReceiveZoneInfo
extends DmpFragmentable {
    public String account;
    public String cmdCode;
    int sequenceNum;
    public String responseSign;
    public boolean nak;

    public static DmpReceiveZoneInfo make(BAddress bAddress, String string, boolean bl, String string2, String string3, DmpInputStream dmpInputStream, DmpInputStream dmpInputStream2) {
        DmpReceiveZoneInfo dmpReceiveZoneInfo = new DmpReceiveZoneInfo(bAddress);
        dmpReceiveZoneInfo.account = string;
        dmpReceiveZoneInfo.nak = bl;
        dmpReceiveZoneInfo.responseSign = string2;
        dmpReceiveZoneInfo.cmdCode = string3;
        dmpReceiveZoneInfo.tin = dmpInputStream;
        dmpReceiveZoneInfo.fletcher = dmpInputStream2;
        dmpReceiveZoneInfo.sequenceNum = Integer.parseInt(dmpInputStream2.restOfBufferToString().substring(0, 1));
        return dmpReceiveZoneInfo;
    }

    public NMessage getFragmentAck() {
        try {
            if (this.tin.peekChar() == '-') {
                return null;
            }
        }
        catch (DmpIoException dmpIoException) {
            dmpIoException.printStackTrace();
        }
        String string = BDmpInstructs.zoneStatusRequestContinued.enumToCommand() + this.sequenceNum;
        String string2 = FletcherChecksum.getFletcherChecksum(string);
        Log.getLog((String)"dmp").trace("@" + this.account + string + string2 + '\n');
        return new DmpCommand("@" + this.account + string + string2 + '\n');
    }

    public Object getHash() {
        return new Integer(this.sequenceNum);
    }

    public boolean isReceivedMessage() {
        return true;
    }

    private final /* synthetic */ void this() {
        this.account = "";
        this.cmdCode = "";
        this.responseSign = "";
        this.nak = false;
    }

    public DmpReceiveZoneInfo(BAddress bAddress) {
        super(bAddress);
        this.this();
    }
}

