/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dmp;

import com.tridium.dmp.BDmpNetwork;
import com.tridium.dmp.enums.BDmpInstructs;
import com.tridium.dmp.enums.BZoneEnum;
import com.tridium.dmp.messages.DmpCommand;
import com.tridium.dmp.point.BDmpDiscoverPointsJob;
import com.tridium.dmp.point.BDmpPointDeviceExt;
import com.tridium.dmp.point.BDmpProxyExt;
import com.tridium.dmp.ui.page.BDmpArmAreasPage;
import com.tridium.dmp.ui.page.BDmpArmSysPage;
import com.tridium.dmp.ui.page.BDmpBypassPage;
import com.tridium.dmp.ui.page.BDmpConfigOccupiedPage;
import com.tridium.dmp.ui.page.BDmpDisarmPage;
import com.tridium.dmp.ui.page.BDmpNotificationPage;
import com.tridium.dmp.ui.page.BDmpOccupiedPage;
import com.tridium.dmp.ui.page.BDmpPage;
import com.tridium.dmp.ui.page.BDmpSummaryPage;
import com.tridium.dmp.ui.page.BDmpTestPage;
import com.tridium.dmp.util.DmpCommandRunnable;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.poll.BINPollable;
import java.util.Stack;
import javax.baja.control.BControlPoint;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDmpDevice
extends BNDevice
implements BIPollable,
BINPollable {
    public static final Property pollFrequency = BDmpDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property points = BDmpDevice.newProperty((int)0, (BValue)new BDmpPointDeviceExt(), null);
    public static final Property accountNumber = BDmpDevice.newProperty((int)0, (String)"", (BFacets)BFacets.makeInt((int)1, (int)((char)-1)));
    public static final Property armableAreaList = BDmpDevice.newProperty((int)1, (String)"", null);
    public static final Property zoneList = BDmpDevice.newProperty((int)1, (String)"", null);
    public static final Property armed24HourZoneList = BDmpDevice.newProperty((int)1, (String)"", null);
    public static final Property systemReady = BDmpDevice.newProperty((int)1, (boolean)true, null);
    public static final Property systemArmed = BDmpDevice.newProperty((int)1, (boolean)false, null);
    public static final Property armedAreas = BDmpDevice.newProperty((int)1, (String)"", null);
    public static final Property maxZones = BDmpDevice.newProperty((int)1, (int)0, null);
    public static final Property maxAreas = BDmpDevice.newProperty((int)1, (int)0, null);
    public static final Property zoneAreaList = BDmpDevice.newProperty((int)5, (String)"", null);
    public static final Property zonePointInfo = BDmpDevice.newProperty((int)5, (String)"", null);
    public static final Property systemStatus = BDmpDevice.newProperty((int)5, (String)"", null);
    public static final Property bypassedZones = BDmpDevice.newProperty((int)1, (String)"", null);
    public static final Property sequenceNumber = BDmpDevice.newProperty((int)7, (int)-1, null);
    public static final Property occupiedAreas = BDmpDevice.newProperty((int)5, (String)"", null);
    public static final Property displayChanger = BDmpDevice.newProperty((int)0x20000006, (boolean)false, null);
    public static final Property armDisarmFail = BDmpDevice.newProperty((int)6, (boolean)false, null);
    public static final Property line1 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property line2 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property line3 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property line4 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusString(), null);
    public static final Property invertLine1 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property invertLine2 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property invertLine3 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property invertLine4 = BDmpDevice.newProperty((int)0x10000006, (BValue)new BStatusBoolean(false), null);
    public static final Property currentPage = BDmpDevice.newProperty((int)6, (BValue)new BDmpSummaryPage(), null);
    public static final Property hasIn = BDmpDevice.newProperty((int)7, (boolean)false, null);
    public static final Property hasUp = BDmpDevice.newProperty((int)7, (boolean)false, null);
    public static final Property hasDown = BDmpDevice.newProperty((int)7, (boolean)false, null);
    public static final Property hasBack = BDmpDevice.newProperty((int)7, (boolean)false, null);
    public static final Action command = BDmpDevice.newAction((int)4, (BValue)BDmpInstructs.connect, null);
    public static final Action connectToPanel = BDmpDevice.newAction((int)0, null);
    public static final Action disconnectFromPanel = BDmpDevice.newAction((int)0, null);
    public static final Action armSystem = BDmpDevice.newAction((int)0, null);
    public static final Action disarmSystem = BDmpDevice.newAction((int)0, null);
    public static final Action updatePoints = BDmpDevice.newAction((int)0, null);
    public static final Action updateDisplay = BDmpDevice.newAction((int)4, null);
    public static final Action bypass = BDmpDevice.newAction((int)4, (BValue)BString.make((String)""), null);
    public static final Action resetBypass = BDmpDevice.newAction((int)4, (BValue)BString.make((String)""), null);
    public static final Action armAreas = BDmpDevice.newAction((int)4, (BValue)BString.make((String)""), null);
    public static final Action disarmAreas = BDmpDevice.newAction((int)4, (BValue)BString.make((String)""), null);
    public static final Action silenceAlarm = BDmpDevice.newAction((int)0, null);
    public static final Action keyPressed = BDmpDevice.newAction((int)2052, (BValue)BString.make((String)""), null);
    public static final Action submitPointDiscoveryJob = BDmpDevice.newAction((int)4, null);
    public static final Type TYPE;
    long lastSend;
    long lastReceive;
    public IntHashMap zoneMap;
    public IntHashMap systemMap;
    public IntHashMap areaMap;
    private Stack lastPage;
    NComm comm;
    static /* synthetic */ Class class$com$tridium$dmp$BDmpDevice;

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency bPollFrequency) {
        this.set(pollFrequency, (BValue)bPollFrequency, null);
    }

    public BDmpPointDeviceExt getPoints() {
        return (BDmpPointDeviceExt)this.get(points);
    }

    public void setPoints(BDmpPointDeviceExt bDmpPointDeviceExt) {
        this.set(points, (BValue)bDmpPointDeviceExt, null);
    }

    public String getAccountNumber() {
        return this.getString(accountNumber);
    }

    public void setAccountNumber(String string) {
        this.setString(accountNumber, string, null);
    }

    public String getArmableAreaList() {
        return this.getString(armableAreaList);
    }

    public void setArmableAreaList(String string) {
        this.setString(armableAreaList, string, null);
    }

    public String getZoneList() {
        return this.getString(zoneList);
    }

    public void setZoneList(String string) {
        this.setString(zoneList, string, null);
    }

    public String getArmed24HourZoneList() {
        return this.getString(armed24HourZoneList);
    }

    public void setArmed24HourZoneList(String string) {
        this.setString(armed24HourZoneList, string, null);
    }

    public boolean getSystemReady() {
        return this.getBoolean(systemReady);
    }

    public void setSystemReady(boolean bl) {
        this.setBoolean(systemReady, bl, null);
    }

    public boolean getSystemArmed() {
        return this.getBoolean(systemArmed);
    }

    public void setSystemArmed(boolean bl) {
        this.setBoolean(systemArmed, bl, null);
    }

    public String getArmedAreas() {
        return this.getString(armedAreas);
    }

    public void setArmedAreas(String string) {
        this.setString(armedAreas, string, null);
    }

    public int getMaxZones() {
        return this.getInt(maxZones);
    }

    public void setMaxZones(int n) {
        this.setInt(maxZones, n, null);
    }

    public int getMaxAreas() {
        return this.getInt(maxAreas);
    }

    public void setMaxAreas(int n) {
        this.setInt(maxAreas, n, null);
    }

    public String getZoneAreaList() {
        return this.getString(zoneAreaList);
    }

    public void setZoneAreaList(String string) {
        this.setString(zoneAreaList, string, null);
    }

    public String getZonePointInfo() {
        return this.getString(zonePointInfo);
    }

    public void setZonePointInfo(String string) {
        this.setString(zonePointInfo, string, null);
    }

    public String getSystemStatus() {
        return this.getString(systemStatus);
    }

    public void setSystemStatus(String string) {
        this.setString(systemStatus, string, null);
    }

    public String getBypassedZones() {
        return this.getString(bypassedZones);
    }

    public void setBypassedZones(String string) {
        this.setString(bypassedZones, string, null);
    }

    public int getSequenceNumber() {
        return this.getInt(sequenceNumber);
    }

    public void setSequenceNumber(int n) {
        this.setInt(sequenceNumber, n, null);
    }

    public String getOccupiedAreas() {
        return this.getString(occupiedAreas);
    }

    public void setOccupiedAreas(String string) {
        this.setString(occupiedAreas, string, null);
    }

    public boolean getDisplayChanger() {
        return this.getBoolean(displayChanger);
    }

    public void setDisplayChanger(boolean bl) {
        this.setBoolean(displayChanger, bl, null);
    }

    public boolean getArmDisarmFail() {
        return this.getBoolean(armDisarmFail);
    }

    public void setArmDisarmFail(boolean bl) {
        this.setBoolean(armDisarmFail, bl, null);
    }

    public BStatusString getLine1() {
        return (BStatusString)this.get(line1);
    }

    public void setLine1(BStatusString bStatusString) {
        this.set(line1, (BValue)bStatusString, null);
    }

    public BStatusString getLine2() {
        return (BStatusString)this.get(line2);
    }

    public void setLine2(BStatusString bStatusString) {
        this.set(line2, (BValue)bStatusString, null);
    }

    public BStatusString getLine3() {
        return (BStatusString)this.get(line3);
    }

    public void setLine3(BStatusString bStatusString) {
        this.set(line3, (BValue)bStatusString, null);
    }

    public BStatusString getLine4() {
        return (BStatusString)this.get(line4);
    }

    public void setLine4(BStatusString bStatusString) {
        this.set(line4, (BValue)bStatusString, null);
    }

    public BStatusBoolean getInvertLine1() {
        return (BStatusBoolean)this.get(invertLine1);
    }

    public void setInvertLine1(BStatusBoolean bStatusBoolean) {
        this.set(invertLine1, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getInvertLine2() {
        return (BStatusBoolean)this.get(invertLine2);
    }

    public void setInvertLine2(BStatusBoolean bStatusBoolean) {
        this.set(invertLine2, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getInvertLine3() {
        return (BStatusBoolean)this.get(invertLine3);
    }

    public void setInvertLine3(BStatusBoolean bStatusBoolean) {
        this.set(invertLine3, (BValue)bStatusBoolean, null);
    }

    public BStatusBoolean getInvertLine4() {
        return (BStatusBoolean)this.get(invertLine4);
    }

    public void setInvertLine4(BStatusBoolean bStatusBoolean) {
        this.set(invertLine4, (BValue)bStatusBoolean, null);
    }

    public BDmpPage getCurrentPage() {
        return (BDmpPage)this.get(currentPage);
    }

    public void setCurrentPage(BDmpPage bDmpPage) {
        this.set(currentPage, (BValue)bDmpPage, null);
    }

    public boolean getHasIn() {
        return this.getBoolean(hasIn);
    }

    public void setHasIn(boolean bl) {
        this.setBoolean(hasIn, bl, null);
    }

    public boolean getHasUp() {
        return this.getBoolean(hasUp);
    }

    public void setHasUp(boolean bl) {
        this.setBoolean(hasUp, bl, null);
    }

    public boolean getHasDown() {
        return this.getBoolean(hasDown);
    }

    public void setHasDown(boolean bl) {
        this.setBoolean(hasDown, bl, null);
    }

    public boolean getHasBack() {
        return this.getBoolean(hasBack);
    }

    public void setHasBack(boolean bl) {
        this.setBoolean(hasBack, bl, null);
    }

    public void command(BDmpInstructs bDmpInstructs) {
        this.invoke(command, (BValue)bDmpInstructs, null);
    }

    public void connectToPanel() {
        this.invoke(connectToPanel, null, null);
    }

    public void disconnectFromPanel() {
        this.invoke(disconnectFromPanel, null, null);
    }

    public void armSystem() {
        this.invoke(armSystem, null, null);
    }

    public void disarmSystem() {
        this.invoke(disarmSystem, null, null);
    }

    public void updatePoints() {
        this.invoke(updatePoints, null, null);
    }

    public void updateDisplay() {
        this.invoke(updateDisplay, null, null);
    }

    public void bypass(BString bString) {
        this.invoke(bypass, (BValue)bString, null);
    }

    public void resetBypass(BString bString) {
        this.invoke(resetBypass, (BValue)bString, null);
    }

    public void armAreas(BString bString) {
        this.invoke(armAreas, (BValue)bString, null);
    }

    public void disarmAreas(BString bString) {
        this.invoke(disarmAreas, (BValue)bString, null);
    }

    public void silenceAlarm() {
        this.invoke(silenceAlarm, null, null);
    }

    public void keyPressed(BString bString) {
        this.invoke(keyPressed, (BValue)bString, null);
    }

    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BDmpNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getAccountNumber().equals("")) {
            Log.getLog((String)"dmp").warning("Dmp account number has not been set.");
        } else {
            this.command(BDmpInstructs.connect);
            this.command(BDmpInstructs.resetPanelVersion);
            this.command(BDmpInstructs.softwareVersionDifferences);
            this.command(BDmpInstructs.fletcherChecksum);
        }
        ((BDmpNetwork)this.getNetwork()).getPollScheduler().subscribe(this);
        this.getCurrentPage().start();
        this.updateDisplay();
    }

    public void stopped() throws Exception {
        this.command(BDmpInstructs.disconnect);
        ((BDmpNetwork)this.getNetwork()).getPollScheduler().unsubscribe(this);
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == accountNumber && this.isRunning()) {
            this.connectToPanel();
        } else if (property == health) {
            if (this.getHealth().inFailure()) {
                this.configFail(this.getHealth().getLastFailCause());
            } else {
                this.configOk();
            }
        }
    }

    public void doPing() {
        if (this.isDeviceActive()) {
            this.pingOk();
        } else {
            this.pingFail("not receiving response from device ");
        }
    }

    public void received() {
        this.lastReceive = System.currentTimeMillis();
        this.pingOk();
    }

    public boolean isDeviceActive() {
        if (this.lastReceive == 0L) {
            this.setSystemReady(false);
            return false;
        }
        if (this.lastSend < this.lastReceive) {
            this.setSystemReady(true);
            this.addElemSystemMap(3, 'N');
            return true;
        }
        long l = System.currentTimeMillis();
        if (l < this.lastSend + 100L) {
            this.setSystemReady(true);
            this.addElemSystemMap(3, 'N');
            return true;
        }
        this.addElemSystemMap(3, 'T');
        this.setSystemReady(false);
        return false;
    }

    public void doCommand(BDmpInstructs bDmpInstructs) {
        if (this.isRunning()) {
            this.postAsync(new DmpCommandRunnable(this, bDmpInstructs, null));
        }
    }

    public DmpCommand getDisconnectMessage() {
        return new DmpCommand("@" + this.getAccountNumber() + BDmpInstructs.disconnect.enumToCommand() + '\n');
    }

    public void doArmSystem() {
        this.command(BDmpInstructs.arm);
    }

    public void doDisarmSystem() {
        this.setArmDisarmFail(false);
        String string = this.getArmedAreas();
        if (!string.equals("")) {
            string = TextUtil.replace((String)string, (String)",0", (String)"");
            string = string.substring(1);
            this.disarmAreas(BString.make((String)string));
        }
    }

    public void doBypass(BString bString) {
        this.postAsync(new DmpCommandRunnable(this, BDmpInstructs.bypass, bString));
    }

    public void doResetBypass(BString bString) {
        this.postAsync(new DmpCommandRunnable(this, BDmpInstructs.resetBypass, bString));
    }

    public void doSilenceAlarm() {
        this.command(BDmpInstructs.silenceAlarm);
    }

    public void doUpdatePoints() {
        this.command(BDmpInstructs.systemStatusRequest);
        this.command(BDmpInstructs.zoneStatusRequest);
        BControlPoint[] bControlPointArray = this.getPoints().getPoints();
        int n = 0;
        while (n < bControlPointArray.length) {
            ((BDmpProxyExt)bControlPointArray[n].getProxyExt()).checkValue();
            ++n;
        }
    }

    public void doArmAreas(BString bString) {
        this.postAsync(new DmpCommandRunnable(this, BDmpInstructs.arm, bString));
    }

    public void doDisarmAreas(BString bString) {
        this.postAsync(new DmpCommandRunnable(this, BDmpInstructs.disarm, bString));
    }

    public void sendCommand(String string) {
        this.getNetwork().getLog().trace("Sending:\"" + string + '\"');
        DmpCommand dmpCommand = new DmpCommand(string);
        BDmpNetwork bDmpNetwork = (BDmpNetwork)this.getNetwork();
        try {
            bDmpNetwork.comm().sendMessage((NMessage)dmpCommand);
        }
        catch (Throwable throwable) {
            this.getNetwork().getLog().trace(throwable.toString());
        }
        this.lastSend = System.currentTimeMillis();
    }

    public int getNextSequenceNum() {
        int n = (this.getSequenceNumber() + 1) % 10;
        this.setSequenceNumber(n);
        return n;
    }

    public void doConnectToPanel() {
        if (this.getAccountNumber().equals("")) {
            Log.getLog((String)"dmp").warning("Dmp account number has not been set.");
        } else {
            this.command(BDmpInstructs.connect);
            this.command(BDmpInstructs.resetPanelVersion);
            this.command(BDmpInstructs.softwareVersionDifferences);
            this.command(BDmpInstructs.fletcherChecksum);
        }
    }

    public void doDisconnectFromPanel() {
        this.command(BDmpInstructs.disconnect);
    }

    public BOrd doSubmitPointDiscoveryJob(Context context) {
        return new BDmpDiscoverPointsJob(this).submit(context);
    }

    public void doPoll() {
        this.ping();
        if (this.getAccountNumber().equals("")) {
            Log.getLog((String)"dmp").warning("Dmp account number has not been set.");
        } else {
            this.command(BDmpInstructs.hold);
            this.command(BDmpInstructs.zoneStatusRequest);
            this.command(BDmpInstructs.systemStatusRequest);
        }
    }

    public IntHashMap getZoneMap() {
        return this.zoneMap;
    }

    public BZoneEnum getZone(int n) {
        return (BZoneEnum)((Object)this.zoneMap.get(n));
    }

    public void addElemZoneMap(int n, BZoneEnum bZoneEnum) {
        this.zoneMap.put(n, (Object)bZoneEnum);
    }

    public void clearZoneMap() {
        this.zoneMap.clear();
    }

    public IntHashMap getSystemMap() {
        return this.systemMap;
    }

    public Character getSystemPoint(int n) {
        return (Character)this.systemMap.get(n);
    }

    public void addElemSystemMap(int n, char c) {
        this.systemMap.put(n, (Object)new Character(c));
    }

    public void clearSystemMap() {
        this.systemMap.clear();
    }

    public IntHashMap getAreaMap() {
        return this.areaMap;
    }

    public Boolean getArea(int n) {
        return (Boolean)this.areaMap.get(n);
    }

    public void addElemAreaMap(int n, boolean bl) {
        this.areaMap.put(n, (Object)new Boolean(bl));
    }

    public void clearAreaMap() {
        this.areaMap.clear();
    }

    public void setLines(String[] stringArray) {
        this.updateCursor();
        BStatusString[] bStatusStringArray = new BStatusString[]{this.getLine1(), this.getLine2(), this.getLine3(), this.getLine4()};
        int n = 0;
        while (n < stringArray.length && n < bStatusStringArray.length) {
            bStatusStringArray[n].setValue(stringArray[n]);
            ++n;
        }
        this.setDisplayChanger(this.getDisplayChanger() ^ true);
    }

    public String getLines() {
        BStatusString[] bStatusStringArray = new BStatusString[]{this.getLine1(), this.getLine2(), this.getLine3(), this.getLine4()};
        String[] stringArray = new String[bStatusStringArray.length];
        int n = 0;
        while (n < bStatusStringArray.length) {
            stringArray[n] = bStatusStringArray[n].getValue();
            ++n;
        }
        return TextUtil.join((String[])stringArray, (char)'\n');
    }

    public void doKeyPressed(BString bString) {
        this.getNetwork().getLog().trace("DISPLAY: " + bString);
        if (bString.equals((Object)BString.make((String)"<F1>"))) {
            this.goBack();
        } else if (bString.equals((Object)BString.make((String)"<F2>"))) {
            this.getCurrentPage().up();
        } else if (bString.equals((Object)BString.make((String)"<F3>"))) {
            this.getCurrentPage().down();
        } else if (bString.equals((Object)BString.make((String)"Select"))) {
            BDmpPage bDmpPage = this.getCurrentPage().in();
            this.goToNextPage(bDmpPage);
        } else if (bString.equals((Object)BString.make((String)"Home"))) {
            this.lastPage = new Stack();
            this.setCurrentPage(new BDmpSummaryPage());
            this.getCurrentPage().start();
            this.updateDisplay();
            this.setDisplayChanger(this.getDisplayChanger() ^ true);
        } else if (bString.equals((Object)BString.make((String)"ARM"))) {
            if (this.getCurrentPage() instanceof BDmpArmSysPage) {
                this.command(BDmpInstructs.arm);
                BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage();
                bDmpNotificationPage.setPageCaller(((Object)((Object)this.getCurrentPage())).getClass());
                this.goToNextPage(bDmpNotificationPage);
            } else {
                this.goToNextPage(new BDmpArmSysPage());
            }
        } else if (bString.equals((Object)BString.make((String)"ARMAREA"))) {
            if (this.getCurrentPage() instanceof BDmpArmAreasPage) {
                BDmpArmAreasPage bDmpArmAreasPage = (BDmpArmAreasPage)this.getCurrentPage();
                String string = bDmpArmAreasPage.getSelectedAreas();
                if (string != null && !string.equals("")) {
                    this.armAreas(BString.make((String)string));
                    BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage(string);
                    bDmpNotificationPage.setPageCaller(((Object)((Object)this.getCurrentPage())).getClass());
                    this.goToNextPage(bDmpNotificationPage);
                } else {
                    BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage();
                    bDmpNotificationPage.setNoneSelected();
                    this.goToNextPage(bDmpNotificationPage);
                }
            } else {
                this.goToNextPage(new BDmpArmAreasPage());
            }
        } else if (bString.equals((Object)BString.make((String)"DISARM"))) {
            if (this.getCurrentPage() instanceof BDmpDisarmPage) {
                BDmpDisarmPage bDmpDisarmPage = (BDmpDisarmPage)this.getCurrentPage();
                String string = bDmpDisarmPage.getSelectedAreas();
                if (string != null && !string.equals("")) {
                    this.disarmAreas(BString.make((String)string));
                    BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage(string);
                    bDmpNotificationPage.setPageCaller(((Object)((Object)this.getCurrentPage())).getClass());
                    this.goToNextPage(bDmpNotificationPage);
                } else {
                    BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage();
                    bDmpNotificationPage.setNoneSelected();
                    this.goToNextPage(bDmpNotificationPage);
                }
            } else {
                this.goToNextPage(new BDmpDisarmPage());
            }
        } else if (bString.equals((Object)BString.make((String)"TEST"))) {
            if (!(this.getCurrentPage() instanceof BDmpTestPage)) {
                this.goToNextPage(new BDmpTestPage());
            }
        } else if (bString.equals((Object)BString.make((String)"BYPASS"))) {
            this.bypassAction();
        } else if (bString.equals((Object)BString.make((String)"OCCUPIED"))) {
            if (this.getCurrentPage() instanceof BDmpOccupiedPage) {
                String string = this.getOccupiedAreas();
                if (string != null && !string.equals("")) {
                    this.armAreas(BString.make((String)string));
                    BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage(string);
                    bDmpNotificationPage.setPageCaller(((Object)((Object)this.getCurrentPage())).getClass());
                    this.goToNextPage(bDmpNotificationPage);
                } else {
                    BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage();
                    bDmpNotificationPage.setNoneSelected();
                    this.goToNextPage(bDmpNotificationPage);
                }
            } else {
                BDmpConfigOccupiedPage bDmpConfigOccupiedPage;
                String string;
                if (this.getCurrentPage() instanceof BDmpConfigOccupiedPage && (string = (bDmpConfigOccupiedPage = (BDmpConfigOccupiedPage)this.getCurrentPage()).getSelectedAreas()) != null && !string.equals("")) {
                    this.setOccupiedAreas(string);
                }
                this.goToNextPage(new BDmpOccupiedPage());
            }
        }
        this.updateDisplay();
    }

    private final void goBack() {
        if (!this.lastPage.empty()) {
            BDmpPage bDmpPage = (BDmpPage)((Object)this.lastPage.pop());
            bDmpPage.initPosition();
            this.setCurrentPage(bDmpPage);
            this.updateDisplay();
            this.setDisplayChanger(this.getDisplayChanger() ^ true);
        }
    }

    private final void goToNextPage(BDmpPage bDmpPage) {
        if (bDmpPage != null) {
            this.lastPage.push(this.getCurrentPage());
            this.setCurrentPage(bDmpPage);
            this.getCurrentPage().start();
            this.getCurrentPage().initPosition();
            this.updateDisplay();
            this.setDisplayChanger(this.getDisplayChanger() ^ true);
        }
    }

    private final void bypassAction() {
        if (this.getCurrentPage() instanceof BDmpBypassPage) {
            String[] stringArray;
            BDmpBypassPage bDmpBypassPage = (BDmpBypassPage)this.getCurrentPage();
            String[] stringArray2 = bDmpBypassPage.getBypassedZones();
            if (stringArray2 != null) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.bypass(BString.make((String)stringArray2[n]));
                    ++n;
                }
            }
            if ((stringArray = bDmpBypassPage.getResetBypassZones()) != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.resetBypass(BString.make((String)stringArray[n]));
                    ++n;
                }
            }
            if (stringArray2 != null || stringArray != null) {
                BDmpNotificationPage bDmpNotificationPage = new BDmpNotificationPage();
                bDmpNotificationPage.setPageCaller(((Object)((Object)this.getCurrentPage())).getClass());
                this.goToNextPage(bDmpNotificationPage);
            }
        } else {
            this.goToNextPage(new BDmpBypassPage());
        }
    }

    public void doUpdateDisplay() {
        this.getCurrentPage().update();
    }

    public void updateCursor() {
        int n = this.getCurrentPage().getCursorLine();
        BStatusBoolean[] bStatusBooleanArray = new BStatusBoolean[]{this.getInvertLine1(), this.getInvertLine2(), this.getInvertLine3(), this.getInvertLine4()};
        int n2 = 0;
        while (n2 < bStatusBooleanArray.length) {
            if (n == n2) {
                bStatusBooleanArray[n2].setValue(true);
            } else {
                bStatusBooleanArray[n2].setValue(false);
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lastSend = 0L;
        this.lastReceive = 0L;
        this.zoneMap = new IntHashMap();
        this.systemMap = new IntHashMap();
        this.areaMap = new IntHashMap();
        this.lastPage = new Stack();
        this.comm = null;
    }

    public BDmpDevice() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$dmp$BDmpDevice;
        if (clazz == null) {
            clazz = class$com$tridium$dmp$BDmpDevice = BDmpDevice.class("[Lcom.tridium.dmp.BDmpDevice;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

