/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import com.tridium.ddf.comm.BIDdfCommunicator;
import com.tridium.ddf.comm.req.BIDdfRequest;
import com.tridium.ddfHttp.comm.BDdfHttpCommunicator;
import com.tridium.ddfHttp.comm.BDdfHttpTransmitter;
import com.tridium.ddfHttp.comm.DdfAuthenticationHelper;
import com.tridium.ddfHttp.comm.req.BIDdfHttpStreamRequest;
import com.tridium.platform.tcpip.BTcpIpPlatformService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.baja.net.HttpConnection;
import javax.baja.net.HttpException;
import javax.baja.net.UrlConnection;
import javax.baja.nre.util.IntHashMap;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DdfHttpHelper {
    public static final Lexicon LEX;
    protected String mostRecentUrlString;
    protected String mostRecentRequestMethod;
    protected String mostRecentUrlAddress;
    String mostRecentUrlRightOfQuestionMark;
    protected String mostRecentUrlPostData;
    protected BIDdfRequest mostRecentDdfRequest;
    protected URL mostRecentJavaUrl;
    protected BDdfHttpCommunicator httpCommunicator;
    protected UrlConnection mostRecentBajaUrlConnection;
    protected boolean receiverReadyToReceive;
    protected boolean httpHelperStopped;
    protected BDdfHttpTransmitter ddfHttpTransmitter;
    protected LinkedList openHttpConnections;
    protected IntHashMap authenticationHelpers;
    protected ConnectionWatchdogThread connectionWatchdogThread;
    static /* synthetic */ Class class$com$tridium$ddfHttp$comm$DdfHttpHelper;

    protected String getWatchdogThreadName() {
        String string = "ConnectionWatchdog";
        String string2 = DdfHttpHelper.getThreadSuffix((BIDdfCommunicator)this.httpCommunicator);
        if (string2 != null && string2.length() > 0) {
            string = string + ':' + string2;
        }
        string = string + ':' + this.httpCommunicator.getHandle();
        return string;
    }

    protected static String getThreadSuffix(BIDdfCommunicator bIDdfCommunicator) {
        if (bIDdfCommunicator instanceof BComplex) {
            if (((BComplex)bIDdfCommunicator).getParent() != null) {
                return ((BComplex)bIDdfCommunicator).getParent().getName();
            }
            return "";
        }
        return "";
    }

    public void stopHelping() {
        this.httpHelperStopped = true;
        this.cleanupListOfOutstandingUrlConnections();
    }

    protected void cleanupListOfOutstandingUrlConnections() {
        ListIterator listIterator = this.openHttpConnections.listIterator();
        while (listIterator.hasNext()) {
            UrlConnection urlConnection = (UrlConnection)listIterator.next();
            if (!urlConnection.isOpen()) continue;
            urlConnection.close();
        }
    }

    public synchronized void transmitWhenReadyToReceive(BIDdfRequest bIDdfRequest) throws Exception {
        block7: {
            if (this.httpHelperStopped) {
                throw new BajaRuntimeException("Ddf Http Helper Stopped");
            }
            if (!(bIDdfRequest instanceof BIDdfHttpStreamRequest) && !this.receiverReadyToReceive) {
                this.wait();
            }
            try {
                this.transmit(bIDdfRequest);
            }
            catch (IOException iOException) {
                int n;
                this.ddfHttpTransmitter.getDdfCommunicator().getLog().error(iOException.toString());
                if (bIDdfRequest instanceof BIDdfHttpStreamRequest && (n = bIDdfRequest.getRemainingRetryCount()) > 0) {
                    bIDdfRequest.setRemainingRetryCount(n - 1);
                    this.ddfHttpTransmitter.setRetransmissionCount(this.ddfHttpTransmitter.getRetransmissionCount() + 1L);
                    this.transmitWhenReadyToReceive(bIDdfRequest);
                }
            }
            catch (IcmpPingFailure icmpPingFailure) {
                String string;
                String string2 = string = this.mostRecentUrlPostData == null ? "GET" : "POST";
                if (this.httpCommunicator.getLog().isTraceOn()) {
                    this.httpCommunicator.getLog().trace("HTTP " + string + " Failed - " + icmpPingFailure.getLocalizedMessage());
                }
                if (!(bIDdfRequest instanceof BValue)) break block7;
                this.httpCommunicator.getTransactionManager().checkOutstandingTimeout((BValue)bIDdfRequest);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void transmit(BIDdfRequest bIDdfRequest) throws Exception {
        this.mostRecentDdfRequest = bIDdfRequest;
        this.httpCommunicator = this.ddfHttpTransmitter.getHttpCommunicator();
        this.parseJavaUrl();
        if (this.ddfHttpTransmitter.getDdfCommunicator().getLog().isTraceOn()) {
            this.trace();
        }
        if (this.connectionWatchdogThread == null) {
            this.connectionWatchdogThread = new ConnectionWatchdogThread();
            this.connectionWatchdogThread.start();
        }
        this.transmitHttp();
        if (!(bIDdfRequest instanceof BIDdfHttpStreamRequest)) {
            this.notifyAll();
            return;
        }
        if (this.httpCommunicator.getLog().isTraceOn()) {
            this.httpCommunicator.getLog().trace("HTTP <Rx Stream>");
        }
        boolean bl = true;
        try {
            try {
                bl = ((BIDdfHttpStreamRequest)bIDdfRequest).processHttpStream(this.mostRecentBajaUrlConnection);
            }
            catch (Exception exception) {
                this.httpCommunicator.getLog().error(LEX.getText("DriverUnableToProcessHttpStream"), (Throwable)exception);
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (bl) {
                this.mostRecentBajaUrlConnection.close();
                throw throwable;
            }
            this.cleanupClosedOutstandingStreams();
            this.openHttpConnections.add(this.mostRecentBajaUrlConnection);
            throw throwable;
        }
        {
            Object var4_6 = null;
            if (bl) {
                this.mostRecentBajaUrlConnection.close();
                return;
            }
            this.cleanupClosedOutstandingStreams();
            this.openHttpConnections.add(this.mostRecentBajaUrlConnection);
            return;
        }
    }

    protected void cleanupClosedOutstandingStreams() {
        ListIterator listIterator = this.openHttpConnections.listIterator();
        while (listIterator.hasNext()) {
            UrlConnection urlConnection = (UrlConnection)listIterator.next();
            if (urlConnection.isOpen()) continue;
            listIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] waitReceiveNextAndClose() throws Exception, HttpException {
        try {
            if (this.httpHelperStopped) {
                throw new BajaRuntimeException("Ddf Http Helper Stopped");
            }
            this.receiverReadyToReceive = true;
            this.notifyAll();
            this.wait();
            byte[] byArray = this.readContentAndClose();
            Object var2_2 = null;
            this.receiverReadyToReceive = false;
            return byArray;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.receiverReadyToReceive = false;
            throw throwable;
        }
    }

    protected byte[] readContent() throws Exception {
        return this.mostRecentBajaUrlConnection.readContent();
    }

    public byte[] readContentAndClose() throws Exception, HttpException {
        this.verifyOk();
        byte[] byArray = this.readContent();
        this.closeConnection();
        return byArray;
    }

    protected void closeConnection() {
        this.mostRecentBajaUrlConnection.close();
    }

    protected void makeConnection() throws Exception {
        try {
            Sys.getService((Type)BTcpIpPlatformService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
        }
        catch (RuntimeException runtimeException) {}
        this.mostRecentBajaUrlConnection = new UrlConnection(this.mostRecentJavaUrl);
        this.mostRecentBajaUrlConnection.setTimeout(this.httpCommunicator.getSoTimeout(this.mostRecentDdfRequest));
    }

    protected int doGetOrPost() throws Exception {
        if (this.mostRecentRequestMethod.equals("GET")) {
            return this.mostRecentBajaUrlConnection.connect();
        }
        return this.mostRecentBajaUrlConnection.post(this.mostRecentUrlAddress, this.httpCommunicator.getHttpContentType(this.mostRecentDdfRequest), this.mostRecentUrlPostData.getBytes());
    }

    protected void transmitHttp() throws Exception {
        this.makeConnection();
        this.considerPreAuthentication();
        int n = this.doGetOrPost();
        this.reviewStatusCode(n);
    }

    protected void reviewStatusCode(int n) throws Exception {
        if (n == 401) {
            this.addAuthenticationBasedOnHttpResponse();
            this.doGetOrPost();
        }
    }

    protected void verifyOk() throws HttpException {
        this.mostRecentBajaUrlConnection.checkOk();
    }

    protected BUsernameAndPassword getUserNameAndPasswordForTransaction() {
        return (BUsernameAndPassword)this.ddfHttpTransmitter.getHttpCommunicator().getHttpCredentials(this.mostRecentDdfRequest);
    }

    protected DdfAuthenticationHelper makeAuthenticationHelper(BUsernameAndPassword bUsernameAndPassword) {
        return new DdfAuthenticationHelper(this.mostRecentJavaUrl, bUsernameAndPassword, this.mostRecentBajaUrlConnection);
    }

    protected void addAuthenticationBasedOnHttpResponse() throws Exception {
        BUsernameAndPassword bUsernameAndPassword = this.getUserNameAndPasswordForTransaction();
        DdfAuthenticationHelper ddfAuthenticationHelper = this.makeAuthenticationHelper(bUsernameAndPassword);
        this.authenticationHelpers.put(this.computeHashCodeForAuthenticationHelper(this.mostRecentJavaUrl, bUsernameAndPassword), (Object)ddfAuthenticationHelper);
        if (this.mostRecentBajaUrlConnection.shouldClose()) {
            this.mostRecentBajaUrlConnection.close();
            this.makeConnection();
        }
        ddfAuthenticationHelper.addRequestAuthorization((HttpConnection)this.mostRecentBajaUrlConnection);
    }

    protected int computeHashCodeForAuthenticationHelper(URL uRL, BUsernameAndPassword bUsernameAndPassword) {
        String string = new String(this.mostRecentUrlRightOfQuestionMark + ':' + bUsernameAndPassword.getUsername() + ':' + bUsernameAndPassword.getPassword().getString());
        return string.hashCode();
    }

    protected void considerPreAuthentication() throws Exception {
        BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)this.ddfHttpTransmitter.getHttpCommunicator().getHttpCredentials(this.mostRecentDdfRequest);
        int n = this.computeHashCodeForAuthenticationHelper(this.mostRecentJavaUrl, bUsernameAndPassword);
        DdfAuthenticationHelper ddfAuthenticationHelper = (DdfAuthenticationHelper)this.authenticationHelpers.get(n);
        if (ddfAuthenticationHelper != null) {
            ddfAuthenticationHelper.addRequestAuthorization((HttpConnection)this.mostRecentBajaUrlConnection);
        }
    }

    protected void parseJavaUrl() throws MalformedURLException {
        this.parseUrlString();
        this.parseRequestMethod();
        this.parseAddressAndData();
        this.mostRecentJavaUrl = new URL(this.mostRecentUrlAddress);
    }

    protected void trace() {
        StringBuffer stringBuffer = new StringBuffer("HTTP ");
        if (this.mostRecentUrlPostData == null) {
            stringBuffer.append("GET ");
        } else {
            stringBuffer.append("POST");
        }
        stringBuffer.append(this.mostRecentUrlString);
        this.httpCommunicator.getLog().trace(stringBuffer.toString());
    }

    protected void parseUrlString() {
        this.mostRecentUrlString = new String(this.mostRecentDdfRequest.toByteArray());
    }

    protected void parseRequestMethod() {
        int n = this.mostRecentUrlString.indexOf(32);
        this.mostRecentRequestMethod = n >= 0 ? this.mostRecentUrlString.substring(0, n).trim().toUpperCase() : "GET";
    }

    protected void parseAddressAndData() {
        int n = this.mostRecentUrlString.indexOf(" ");
        int n2 = this.mostRecentUrlString.indexOf("?");
        if (n < 0) {
            n = 0;
        }
        if (n2 >= 0 && !this.mostRecentRequestMethod.equals("GET")) {
            this.mostRecentUrlRightOfQuestionMark = this.mostRecentUrlAddress = this.mostRecentUrlString.substring(n + 1, n2);
            this.mostRecentUrlPostData = this.mostRecentUrlString.substring(n2 + 1);
        } else {
            this.mostRecentUrlAddress = this.mostRecentUrlString.substring(n);
            this.mostRecentUrlRightOfQuestionMark = n2 >= 0 ? this.mostRecentUrlString.substring(n, n2) : this.mostRecentUrlAddress;
            this.mostRecentUrlPostData = null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.mostRecentRequestMethod = null;
        this.mostRecentUrlAddress = null;
        this.mostRecentUrlRightOfQuestionMark = null;
        this.mostRecentUrlPostData = null;
        this.mostRecentJavaUrl = null;
        this.httpCommunicator = null;
        this.mostRecentBajaUrlConnection = null;
        this.receiverReadyToReceive = false;
        this.httpHelperStopped = false;
        this.openHttpConnections = new LinkedList();
        this.authenticationHelpers = new IntHashMap();
    }

    public DdfHttpHelper(BDdfHttpTransmitter bDdfHttpTransmitter) {
        this.this();
        this.ddfHttpTransmitter = bDdfHttpTransmitter;
    }

    static {
        Class clazz = class$com$tridium$ddfHttp$comm$DdfHttpHelper;
        if (clazz == null) {
            clazz = class$com$tridium$ddfHttp$comm$DdfHttpHelper = DdfHttpHelper.class("[Lcom.tridium.ddfHttp.comm.DdfHttpHelper;", false);
        }
        LEX = Lexicon.make((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class IcmpPingFailure
    extends Exception {
        private static final long serialVersionUID = 6843545216875115467L;

        public IcmpPingFailure(String string) {
            super(string);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ConnectionWatchdogThread
    extends Thread {
        public Queue watchdogQ = new Queue();
        public boolean isAlive;

        public void stopWatchdog() {
            this.isAlive = false;
            this.interrupt();
        }

        public void run() {
            this.isAlive = true;
            while (this.isAlive) {
                try {
                    Runnable runnable = this.watchdogQ.todo(500);
                    this.process(runnable);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        protected void process(Runnable runnable) throws Exception {
            if (runnable != null) {
                runnable.run();
            }
        }

        public ConnectionWatchdogThread() {
            super(DdfHttpHelper.this.getWatchdogThreadName());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PreemptConnectionAfterTimeout
    implements Runnable {
        public long interval;
        public volatile boolean needToPreEmptUponWake = true;

        public synchronized void run() {
            try {
                if (DdfHttpHelper.this.httpCommunicator.getLog().isTraceOn()) {
                    DdfHttpHelper.this.httpCommunicator.getLog().trace("Countdown to pre-empt in " + this.interval + " millis.");
                }
                this.wait(this.interval);
                if (this.needToPreEmptUponWake && DdfHttpHelper.this.mostRecentBajaUrlConnection != null) {
                    if (DdfHttpHelper.this.httpCommunicator.getLog().isTraceOn()) {
                        DdfHttpHelper.this.httpCommunicator.getLog().trace("Pre-empting HTTP connection.");
                    }
                    DdfHttpHelper.this.mostRecentBajaUrlConnection.close();
                } else if (DdfHttpHelper.this.httpCommunicator.getLog().isTraceOn()) {
                    DdfHttpHelper.this.httpCommunicator.getLog().trace("No need to pre-empt HTTP connection.");
                }
            }
            catch (InterruptedException interruptedException) {}
        }

        public synchronized void cancelPreemptionCountdown() {
            this.needToPreEmptUponWake = false;
            this.notifyAll();
        }

        public void beginPreemptionCountdown() {
            DdfHttpHelper.this.connectionWatchdogThread.watchdogQ.enqueue((Object)this);
        }

        public PreemptConnectionAfterTimeout(BIDdfRequest bIDdfRequest) {
            this.interval = DdfHttpHelper.this.httpCommunicator.getSoTimeout(bIDdfRequest);
            if (this.interval <= 0L) {
                this.interval = DdfHttpHelper.this.httpCommunicator.getHttpReceiver().getResponseTimeout().getMillis();
            }
        }
    }
}

