/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfHttp.comm;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Random;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpConnection;
import javax.baja.net.UrlConnection;
import javax.baja.nre.util.Base64;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BUsernameAndPassword;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DdfAuthenticationHelper {
    protected static Random clientRandom = new Random();
    protected Perl5Compiler regExpCompiler;
    protected PatternMatcher oroMatcher;
    protected int nc;
    protected BIpHost webHost;
    protected int webPort;
    protected BUsernameAndPassword webUsernameAndPassword;
    protected String webAuthenticateHeader;
    protected String webUri;

    public boolean isDigestAuthentication() throws Exception {
        return this.getAuthenticationType(this.webAuthenticateHeader).equalsIgnoreCase("digest");
    }

    public boolean isBasicAuthentication() throws Exception {
        return this.getAuthenticationType(this.webAuthenticateHeader).equalsIgnoreCase("basic");
    }

    public String getAuthenticationType(String string) throws Exception {
        Pattern pattern = this.regExpCompiler.compile("\\s*(\\S*)", 1);
        if (this.oroMatcher.contains(string, pattern)) {
            MatchResult matchResult = this.oroMatcher.getMatch();
            return matchResult.group(1);
        }
        return null;
    }

    public boolean addRequestAuthorization(HttpConnection httpConnection) throws Exception {
        if (this.isDigestAuthentication()) {
            return this.addDigestAuthorization(httpConnection);
        }
        if (this.isBasicAuthentication()) {
            return this.addBasicAuthorization(httpConnection);
        }
        return false;
    }

    public boolean addBasicAuthorization(HttpConnection httpConnection) {
        if (this.webUsernameAndPassword == null) {
            return false;
        }
        String string = this.webUsernameAndPassword.getUsername() + ':' + this.webUsernameAndPassword.getPassword().getString();
        String string2 = Base64.encode((byte[])string.getBytes());
        httpConnection.setRequestHeader("Authorization", "Basic " + string2);
        return true;
    }

    public boolean addDigestAuthorization(HttpConnection httpConnection) throws Exception {
        if (this.webAuthenticateHeader == null) {
            return false;
        }
        String string = this.getValue("realm", this.webAuthenticateHeader);
        String string2 = this.getValue("nonce", this.webAuthenticateHeader);
        String string3 = this.getValue("qop", this.webAuthenticateHeader);
        if (string2 == null || this.webUsernameAndPassword == null) {
            return false;
        }
        ++this.nc;
        String string4 = this.getCnonce();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Digest username=").append(DdfAuthenticationHelper.quote(this.webUsernameAndPassword.getUsername())).append(", ");
        stringBuffer.append("realm=").append(DdfAuthenticationHelper.quote(string)).append(", ");
        stringBuffer.append("nonce=").append(DdfAuthenticationHelper.quote(string2)).append(", ");
        stringBuffer.append("uri=").append(DdfAuthenticationHelper.quote(this.webUri)).append(", ");
        stringBuffer.append("nc=").append(this.nc).append(", ");
        stringBuffer.append("qop=").append(DdfAuthenticationHelper.unquote(string3)).append(", ");
        stringBuffer.append("cnonce=\"").append(string4).append("\", ");
        stringBuffer.append("response=\"");
        stringBuffer.append(this.hexMD5(this.hexMD5(DdfAuthenticationHelper.unquote(this.webUsernameAndPassword.getUsername()) + ':' + DdfAuthenticationHelper.unquote(string) + ':' + this.webUsernameAndPassword.getPassword().getString()) + ':' + DdfAuthenticationHelper.unquote(string2) + ':' + this.nc + ':' + string4 + ':' + DdfAuthenticationHelper.unquote(string3) + ':' + this.hexMD5(httpConnection.getRequestMethod() + ':' + this.webUri)));
        stringBuffer.append("\"");
        httpConnection.setRequestHeader("Authorization", stringBuffer.toString());
        return true;
    }

    protected String getCnonce() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeUTF("cnonce");
        dataOutputStream.writeInt(this.nc);
        dataOutputStream.writeUTF(this.webHost.getHostname());
        dataOutputStream.writeInt(this.webPort);
        dataOutputStream.writeLong(System.currentTimeMillis());
        dataOutputStream.writeInt(clientRandom.nextInt());
        return this.hexMD5(new String(byteArrayOutputStream.toByteArray()));
    }

    protected String hexMD5(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = messageDigest.digest(string.getBytes());
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(TextUtil.toLowerCase((String)TextUtil.byteToHexString((int)byArray[n])));
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String getValue(String string, String string2) throws Exception {
        if (string2 != null) {
            String string3 = this.getInQuotes(string, string2);
            if (string3 == null) {
                return this.getNotInQuotes(string, string2);
            }
            return string3;
        }
        return null;
    }

    protected String getInQuotes(String string, String string2) throws Exception {
        Pattern pattern = this.regExpCompiler.compile("\\b" + string + "\\s*=\\s*\"(.*?)\"", 1);
        if (this.oroMatcher.contains(string2, pattern)) {
            MatchResult matchResult = this.oroMatcher.getMatch();
            return matchResult.group(1);
        }
        return null;
    }

    protected String getNotInQuotes(String string, String string2) throws Exception {
        Pattern pattern = this.regExpCompiler.compile("\\b" + string + "\\s*=\\s*([^\\s,]*)", 1);
        if (this.oroMatcher.contains(string2, pattern)) {
            MatchResult matchResult = this.oroMatcher.getMatch();
            return matchResult.group(1);
        }
        return null;
    }

    protected static String quote(String string) {
        if (string.length() == 0) {
            return "\"\"";
        }
        if (string.charAt(0) == '\"') {
            return string;
        }
        return "\"" + string + '\"';
    }

    protected static String unquote(String string) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.charAt(0) == '\"') {
            stringBuffer.deleteCharAt(0);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '\"') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.regExpCompiler = new Perl5Compiler();
        this.oroMatcher = new Perl5Matcher();
        this.nc = 0;
        this.webHost = null;
        this.webPort = 80;
        this.webUsernameAndPassword = null;
        this.webAuthenticateHeader = null;
        this.webUri = null;
    }

    public DdfAuthenticationHelper(URL uRL, BUsernameAndPassword bUsernameAndPassword, UrlConnection urlConnection) {
        this.this();
        this.webHost = new BIpHost(uRL.getHost());
        this.webPort = uRL.getPort() == -1 ? 80 : uRL.getPort();
        this.webUsernameAndPassword = bUsernameAndPassword;
        this.webAuthenticateHeader = urlConnection.getResponseHeader("WWW-Authenticate");
        this.webUri = uRL.getFile();
    }
}

