/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.io;

import com.tridium.obix.io.ObixBuffer;
import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.PermissionErr;
import com.tridium.obix.util.UnsupportedErr;
import com.tridium.obix.util.WrapperException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.history.BHistorySpace;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.security.AuthenticationException;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObixEncoder {
    private Hashtable attrs;
    private ObixBuffer buffer;
    private boolean contract;
    private boolean debug;
    private String docHref;
    private String docPath;
    private boolean facets;
    private String href;
    private int indent;
    private boolean is;
    private String lobbyPath;
    private String name;
    private boolean ref;
    private OutputStream out;
    private XWriter writer;
    private boolean forceNoRef;
    private boolean encodeSimpleContracts;

    public Map attributes() {
        return this.attrs;
    }

    public boolean isContract() {
        return this.contract;
    }

    public void setContract(boolean bl) {
        this.contract = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getEncodeIs() {
        return this.is;
    }

    public void setEncodeIs(boolean bl) {
        this.is = bl;
    }

    public boolean getEncodeFacets() {
        return this.facets;
    }

    public void setEncodeFacets(boolean bl) {
        this.facets = bl;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isRef() {
        return this.ref;
    }

    public void setRef(boolean bl) {
        this.ref = bl;
    }

    public void setForceNoRef(boolean bl) {
        this.forceNoRef = bl;
    }

    public boolean isForceNoRef() {
        return this.forceNoRef;
    }

    public String getChildHref(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (this.docHref != null && string != null && string.equals(this.docHref) && string.endsWith("/")) {
            return string2 + '/';
        }
        if (string == null) {
            return string2 + '/';
        }
        return ObixUtils.concat(string, string2 + '/');
    }

    public String getDocHref() {
        return this.docHref;
    }

    public String getDocPath() {
        return this.docPath;
    }

    public String getLobbyPath() {
        return this.lobbyPath;
    }

    public void abort() {
        this.buffer.reset();
    }

    public void commit() {
        try {
            this.writer.flush();
            int n = this.buffer.size();
            if (n == 0) {
                return;
            }
            if (this.debug) {
                System.out.write(this.buffer.getBytes(), 0, n);
            }
            this.out.write(this.buffer.getBytes(), 0, n);
            this.out.flush();
            this.buffer.reset();
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public XWriter getWriter() {
        return this.writer;
    }

    public int indent() {
        return ++this.indent;
    }

    public int outdent() {
        if (this.indent == 0) {
            throw new IllegalStateException("Server error; attempt to outdent beyond doc root.");
        }
        return --this.indent;
    }

    public void encode(BComponent bComponent) {
        this.encode(bComponent.getOrdInSession().resolve());
    }

    public void encode(OrdTarget ordTarget) {
        if (!ordTarget.canRead()) {
            throw new PermissionErr(ordTarget.getUser().getName() + " cannot read this object");
        }
        this.encodeTarget(ordTarget);
    }

    public void encodeFully(BComponent bComponent) {
        this.encodeSimpleContracts = true;
        this.forceNoRef = true;
        this.encode(bComponent.getOrdInSession().resolve());
    }

    public void encodeFully(OrdTarget ordTarget) {
        this.encodeSimpleContracts = true;
        this.forceNoRef = true;
        if (!ordTarget.canRead()) {
            throw new PermissionErr(ordTarget.getUser().getName() + " cannot read this object");
        }
        this.encodeTarget(ordTarget);
    }

    public void encode(Throwable throwable) {
        String string;
        this.writer.flush();
        this.abort();
        if (throwable instanceof WrapperException) {
            throwable = ((WrapperException)throwable).getWrapped();
        }
        if ((string = throwable.getMessage()) == null || string.trim().length() == 0) {
            string = throwable.toString();
        }
        Obj obj = new Obj().initErr(this.href, string);
        obj.setHref(this.href);
        if (throwable instanceof BadUriErr) {
            obj.setIs("obix:BadUriErr");
        } else if (throwable instanceof PermissionErr) {
            obj.setIs("obix:PermissionErr");
        } else if (throwable instanceof UnsupportedErr) {
            obj.setIs("obix:UnsupportedErr");
        } else if (throwable instanceof UnresolvedException) {
            obj.setIs("obix:BadUriErr");
        } else if (throwable instanceof AuthenticationException) {
            obj.setIs("obix:PermissionErr");
        } else if (throwable instanceof PermissionException) {
            obj.setIs("obix:PermissionErr");
        } else {
            throwable.printStackTrace();
        }
        obj.write(this, false);
    }

    public void encodeNull() {
        new Obj().setNull(Boolean.TRUE).write(this, false);
    }

    public boolean encodeSimpleContracts() {
        return this.encodeSimpleContracts;
    }

    protected void configChild(String string, OrdTarget ordTarget) {
        this.reset();
        boolean bl = false;
        String string2 = null;
        try {
            Property[] propertyArray;
            this.contract = false;
            BObject bObject = ordTarget.get();
            if (!this.forceNoRef) {
                boolean bl2 = false;
                if (bObject instanceof BComponent || bObject instanceof BINavNode) {
                    bl2 = this.ref = true;
                }
            }
            if (bObject instanceof BComplex) {
                this.name = ((BComplex)bObject).getName();
            }
            if (this.name == null && (propertyArray = ordTarget.getSlotInComponent()) instanceof Action) {
                this.name = propertyArray.getName();
            }
            if (this.name == null && (propertyArray = ordTarget.getPropertyPathInComponent()) != null) {
                this.name = propertyArray[propertyArray.length - 1].getName();
            }
            if (this.name == null && bObject instanceof BINavNode) {
                this.name = ((BINavNode)bObject).getNavName();
            }
            if (this.name != null) {
                if (bObject instanceof BVirtualComponent) {
                    bl = true;
                } else if (ordTarget.getComponent() instanceof BVirtualComponent) {
                    bl = true;
                }
                if (bl) {
                    string2 = this.name;
                    this.name = ObixUtils.ndUnescape(SlotPath.unescape((String)this.name));
                    this.href = this.getChildHref(string, string2);
                } else {
                    this.href = this.getChildHref(string, this.name);
                }
            } else {
                this.href = "|" + ordTarget.getOrd().encodeToString();
            }
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    protected void encodeTarget(OrdTarget ordTarget) {
        BObject bObject = ordTarget.get();
        if (bObject instanceof BIObixEncodable) {
            ((BIObixEncodable)bObject).encode(this, (Context)ordTarget);
            return;
        }
        Slot slot = ordTarget.getSlotInComponent();
        if (slot instanceof Action) {
            this.encodeOp(ordTarget);
        } else {
            this.encodeData(ordTarget);
        }
    }

    protected void encodeData(OrdTarget ordTarget) {
        try {
            BIObixAgent bIObixAgent = this.getAgent(ordTarget);
            if (bIObixAgent != null && !bIObixAgent.encode(ordTarget, this)) {
                return;
            }
            BObject bObject = ordTarget.get();
            Config config = new Config();
            Obj obj = new Obj();
            obj.setHref(this.href);
            obj.setName(this.name);
            if (bObject.isNull()) {
                obj.setNull(Boolean.TRUE);
            }
            if (bIObixAgent != null) {
                obj.addContract(bIObixAgent.getContract());
                obj.addPrimaryContract(bIObixAgent.getPrimaryContract());
            }
            ObixUtils.encode(this, obj, bObject, ordTarget);
            BComplex bComplex = ordTarget.getParent();
            Slot slot = ordTarget.getSlotInComponent();
            if (bComplex != null && slot != null) {
                obj.setDisplayName(bComplex.getDisplayName(slot, null));
            }
            if (this.ref) {
                obj.makeRef();
                obj.write(this, false, bIObixAgent);
                return;
            }
            OrdTarget[] ordTargetArray = this.getKids(ordTarget, bObject);
            if (bIObixAgent != null) {
                ordTargetArray = bIObixAgent.getChildren(ordTargetArray);
            }
            if (bIObixAgent == null && ordTargetArray == null) {
                obj.write(this, false);
                return;
            }
            obj.write(this, true, bIObixAgent);
            String string = this.href;
            int n = 0;
            if (ordTargetArray != null) {
                n = ordTargetArray.length;
            }
            int n2 = n;
            int n3 = 0;
            while (n3 < n2) {
                this.configChild(string, ordTargetArray[n3]);
                if (bIObixAgent == null || bIObixAgent.encodeChild(ordTargetArray[n3], this)) {
                    this.encodeTarget(ordTargetArray[n3]);
                }
                ++n3;
            }
            config.restore();
            if (bIObixAgent != null) {
                bIObixAgent.encodeFinishing();
            }
            obj.endElem(this);
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    protected void encodeOp(OrdTarget ordTarget) {
        Obj obj = new Obj();
        try {
            Action action = (Action)ordTarget.getSlotInComponent();
            obj.setElement("op");
            obj.setName(this.name);
            obj.setHref(this.href);
            BComponent bComponent = ordTarget.getComponent();
            String string = action.getDefaultDisplayName((Context)ordTarget);
            if (bComponent != null) {
                string = bComponent.getDisplayName((Slot)action, null);
            }
            obj.setDisplayName(string);
            Type type = action.getReturnType();
            if (type != null) {
                ObixUtils.encodeContracts(obj, type, this);
                obj.setOut(obj.getIs());
                obj.setIs(null);
            }
            if ((type = action.getParameterType()) != null) {
                ObixUtils.encodeContracts(obj, type, this);
                obj.setIn(obj.getIs());
                obj.setIs(null);
            }
        }
        catch (Exception exception) {
            return;
        }
        obj.write(this, false);
    }

    protected OrdTarget[] getKids(OrdTarget ordTarget, BObject bObject) {
        OrdTarget ordTarget2;
        Object object;
        Object object2;
        BOrd bOrd = ordTarget.getOrd();
        BOrd bOrd2 = null;
        Vector<BOrd> vector = null;
        if (bObject instanceof BComplex) {
            object2 = (BINavNode[])bObject;
            object = object2.getSlots();
            while (object.next()) {
                ordTarget2 = object.slot();
                if (!this.canSee((BComplex)object2, (Slot)ordTarget2)) continue;
                bOrd2 = BOrd.make((String)("slot:" + ordTarget2.getName()));
                if (vector == null) {
                    vector = new Vector<BOrd>();
                }
                vector.addElement(bOrd2);
            }
        } else if (bObject instanceof BINavNode) {
            object2 = ((BINavNode)bObject).getNavChildren();
            if (bObject instanceof BHistorySpace) {
                object2 = ((BHistorySpace)bObject).listDevices();
            }
            int n = ((BINavNode[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                bOrd2 = BOrd.make((BOrd)bOrd, (BOrd)object2[n2].getNavOrd().relativizeToSession());
                if (bObject instanceof BVirtualComponentSpace) {
                    bOrd2 = BOrd.make((String)ObixUtils.ndUnescape(bOrd2.toString()));
                }
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement(bOrd2);
                ++n2;
            }
        }
        if (vector == null) {
            return null;
        }
        object2 = vector.elements();
        object = null;
        while (object2.hasMoreElements()) {
            bOrd2 = (BOrd)object2.nextElement();
            try {
                ordTarget2 = bOrd2.resolve(bObject, (Context)ordTarget);
                if (!ordTarget2.canRead()) continue;
                if (object == null) {
                    object = new Vector();
                }
                object.addElement(ordTarget2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = bOrd2.encodeToString();
                throw new RuntimeException("Cannot resolve " + string + ": " + exception.getMessage());
            }
        }
        if (object == null) {
            return null;
        }
        ordTarget2 = new OrdTarget[object.size()];
        object.copyInto((Object[])ordTarget2);
        return ordTarget2;
    }

    boolean canSee(BComplex bComplex, Slot slot) {
        if (slot.isTopic()) {
            return false;
        }
        return !Flags.isHidden((BComplex)bComplex, (Slot)slot);
    }

    private final BIObixAgent getAgent(OrdTarget ordTarget) {
        BObject bObject = ordTarget.get();
        if (bObject instanceof BIObixAgent) {
            return (BIObixAgent)bObject;
        }
        AgentList agentList = bObject.getAgents((Context)ordTarget);
        int n = agentList.size();
        int n2 = 0;
        while (n2 < n) {
            AgentInfo agentInfo = agentList.get(n2);
            if (agentInfo.getAgentType().is(BIObixAgent.TYPE.getTypeInfo())) {
                return (BIObixAgent)agentInfo.getInstance();
            }
            ++n2;
        }
        return null;
    }

    private final void reset() {
        this.attrs.clear();
        this.href = null;
        this.name = null;
        this.ref = false;
    }

    private final /* synthetic */ void this() {
        this.attrs = new Hashtable();
        this.contract = false;
        this.debug = false;
        this.facets = true;
        this.indent = 0;
        this.is = true;
        this.lobbyPath = "/obix";
        this.ref = false;
        this.forceNoRef = false;
        this.encodeSimpleContracts = false;
    }

    public ObixEncoder(String string, String string2, OutputStream outputStream) throws IOException {
        this.this();
        this.buffer = new ObixBuffer();
        this.docHref = string2;
        this.href = string2;
        this.lobbyPath = string;
        this.out = outputStream;
        this.writer = new XWriter((OutputStream)this.buffer);
        int n = string2.indexOf(string);
        if (n >= 0) {
            this.docPath = string2.substring(n + string.length());
        }
    }

    protected ObixEncoder(ObixEncoder obixEncoder) throws IOException {
        this.this();
        obixEncoder.getWriter().flush();
        this.attrs = obixEncoder.attrs;
        this.buffer = new ObixBuffer();
        this.contract = obixEncoder.contract;
        this.debug = obixEncoder.debug;
        this.docHref = obixEncoder.docHref;
        this.docPath = obixEncoder.docPath;
        this.facets = obixEncoder.facets;
        this.href = obixEncoder.docHref;
        this.indent = obixEncoder.indent;
        this.is = obixEncoder.is;
        this.lobbyPath = obixEncoder.lobbyPath;
        this.name = obixEncoder.name;
        this.out = obixEncoder.buffer;
        this.ref = obixEncoder.ref;
        this.writer = new XWriter((OutputStream)this.buffer);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Config {
        boolean _contract;
        boolean _facets;
        String _href;
        boolean _is;
        String _name;
        boolean _ref;

        void restore() {
            ObixEncoder.this.contract = this._contract;
            ObixEncoder.this.facets = this._facets;
            ObixEncoder.this.href = this._href;
            ObixEncoder.this.is = this._is;
            ObixEncoder.this.name = this._name;
            ObixEncoder.this.ref = this._ref;
        }

        Config() {
            this._contract = ObixEncoder.this.contract;
            this._href = ObixEncoder.this.href;
            this._facets = ObixEncoder.this.facets;
            this._is = ObixEncoder.this.is;
            this._name = ObixEncoder.this.name;
            this._ref = ObixEncoder.this.ref;
        }
    }
}

