/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver;

import com.tridium.obix.driver.export.BObixExportFolder;
import com.tridium.obix.driver.util.BObixThreadPool;
import com.tridium.obix.driver.util.BObixTuningPolicyMap;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.history.BHistoryNetworkExt;
import javax.baja.driver.ping.BPingHealth;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.TextUtil;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixClientFolder;
import javax.baja.obix.driver.BObixServer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixNetwork
extends BDeviceNetwork
implements BIService {
    public static final Property alarmSourceInfo = BObixNetwork.newProperty((int)4, (BValue)new BAlarmSourceInfo(), null);
    public static final Property health = BObixNetwork.newProperty((int)4, (BValue)new BPingHealth(), null);
    public static final Property threadPool = BObixNetwork.newProperty((int)0, (BValue)new BObixThreadPool(), null);
    public static final Property tuningPolicies = BObixNetwork.newProperty((int)0, (BValue)new BObixTuningPolicyMap(), null);
    public static final Property server = BObixNetwork.newProperty((int)0, (BValue)new BObixServer(), null);
    public static final Property exports = BObixNetwork.newProperty((int)0, (BValue)new BObixExportFolder(), null);
    public static final Property historyPolicies = BObixNetwork.newProperty((int)0, (BValue)new BHistoryNetworkExt(), null);
    public static final Action println = BObixNetwork.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE;
    private HashMap limitz;
    static /* synthetic */ Class class$javax$baja$obix$driver$BObixNetwork;

    public BObixThreadPool getThreadPool() {
        return (BObixThreadPool)this.get(threadPool);
    }

    public void setThreadPool(BObixThreadPool bObixThreadPool) {
        this.set(threadPool, (BValue)bObixThreadPool, null);
    }

    public BTuningPolicyMap getTuningPolicies() {
        return (BTuningPolicyMap)this.get(tuningPolicies);
    }

    public void setTuningPolicies(BTuningPolicyMap bTuningPolicyMap) {
        this.set(tuningPolicies, (BValue)bTuningPolicyMap, null);
    }

    public BObixServer getServer() {
        return (BObixServer)this.get(server);
    }

    public void setServer(BObixServer bObixServer) {
        this.set(server, (BValue)bObixServer, null);
    }

    public BObixExportFolder getExports() {
        return (BObixExportFolder)this.get(exports);
    }

    public void setExports(BObixExportFolder bObixExportFolder) {
        this.set(exports, (BValue)bObixExportFolder, null);
    }

    public BHistoryNetworkExt getHistoryPolicies() {
        return (BHistoryNetworkExt)this.get(historyPolicies);
    }

    public void setHistoryPolicies(BHistoryNetworkExt bHistoryNetworkExt) {
        this.set(historyPolicies, (BValue)bHistoryNetworkExt, null);
    }

    public void println(BString bString) {
        this.invoke(println, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void doPrintln(BString bString) {
        System.out.println("\n\n********\n" + bString + "\n********\n");
    }

    public void enqueue(Runnable runnable) {
        this.getThreadPool().post(runnable);
    }

    public Type getDeviceFolderType() {
        return BObixClientFolder.TYPE;
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "obixDriver");
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] bINavNodeArray = super.getNavChildren();
        if (bINavNodeArray == null) {
            return new BINavNode[]{this.getExports()};
        }
        BINavNode[] bINavNodeArray2 = new BINavNode[bINavNodeArray.length + 1];
        bINavNodeArray2[0] = this.getExports();
        System.arraycopy(bINavNodeArray, 0, bINavNodeArray2, 1, bINavNodeArray.length);
        return bINavNodeArray2;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public void serviceStarted() {
    }

    public void serviceStopped() {
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        if (this.limitz != null) {
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)"Obix License Limits", 3);
            spyWriter.w((Object)"<tr>").th((Object)"Feature").th((Object)"Used").th((Object)"Limit").w((Object)"</tr>\n");
            Iterator iterator = this.limitz.values().iterator();
            while (iterator.hasNext()) {
                LicenzLimit licenzLimit = (LicenzLimit)iterator.next();
                String string = licenzLimit.limit == Integer.MAX_VALUE ? "none" : "" + licenzLimit.limit;
                spyWriter.tr((Object)licenzLimit.key, (Object)("" + licenzLimit.used), (Object)string);
            }
            spyWriter.endTable();
        }
        super.spy(spyWriter);
    }

    public final void started() throws Exception {
        try {
            super.started();
            if (Sys.getService((Type)TYPE) != this) {
                this.configFail("Duplicate ObixNetwork");
                throw new IllegalStateException("Only one ObixNetwork allowed per station.");
            }
            this.checkObixLicense();
            this.networkStarted();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.getLog().error("ObixNetwork not registered as a service!", (Throwable)serviceNotFoundException);
        }
    }

    protected void networkStarted() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String checkObixLimit(String string) {
        if (this.limitz == null) {
            return null;
        }
        HashMap hashMap = this.limitz;
        synchronized (hashMap) {
            LicenzLimit licenzLimit = (LicenzLimit)this.limitz.get(string);
            if (licenzLimit == null) {
                return "Unlicensed: " + string;
            }
            ++licenzLimit.used;
            if (licenzLimit.used > licenzLimit.limit) {
                return "Exceeded " + licenzLimit.key + " of " + licenzLimit.limit;
            }
            return null;
        }
    }

    private final void checkObixLicense() {
        try {
            Feature feature = this.getObixFeature();
            if (feature == null) {
                return;
            }
            this.limitz = new HashMap();
            String[] stringArray = feature.list();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.endsWith(".limit")) {
                    String string2 = feature.get(string);
                    int n2 = Integer.MAX_VALUE;
                    if (string2 != null && !TextUtil.toLowerCase((String)string2).equals("none")) {
                        n2 = Integer.parseInt(string2);
                    }
                    LicenzLimit licenzLimit = new LicenzLimit();
                    licenzLimit.key = string;
                    licenzLimit.used = 0;
                    licenzLimit.limit = n2;
                    this.limitz.put(string, licenzLimit);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.configFatal("Unlicensed: " + exception);
            this.getLog().error("Unlicensed: " + this.toPathString(), (Throwable)exception);
        }
    }

    private final Feature getObixFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "obixDriver");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$javax$baja$obix$driver$BObixNetwork;
        if (clazz == null) {
            clazz = class$javax$baja$obix$driver$BObixNetwork = BObixNetwork.class("[Ljavax.baja.obix.driver.BObixNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    static class LicenzLimit {
        String key;
        int limit;
        int used;

        public String toString() {
            return this.key + '(' + this.used + '/' + this.limit + ')';
        }

        LicenzLimit() {
        }
    }
}

