/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.watch;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.server.BObixOp;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.watch.BWatchEntry;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.naming.OrdTarget;
import javax.baja.obix.driver.BObixServer;
import javax.baja.obix.io.BIObixWatchable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixWatch
extends BObixAgent
implements BObixOp.Parent,
ObixConstants {
    public static final String WATCH_IN = "obix:WatchIn";
    public static final String WATCH_OUT = "obix:WatchOut";
    public static final Property lease = BObixWatch.newProperty((int)256, (BValue)BRelTime.make((long)10000L), null);
    public static final Property expires = BObixWatch.newProperty((int)260, (BValue)BAbsTime.DEFAULT, null);
    public static final Property add = BObixWatch.newProperty((int)256, (BValue)new BObixOp("add", "obix:WatchIn", "obix:WatchOut"), null);
    public static final Property remove = BObixWatch.newProperty((int)256, (BValue)new BObixOp("remove", "obix:WatchIn", "obix:Nil"), null);
    public static final Property pollChanges = BObixWatch.newProperty((int)256, (BValue)new BObixOp("pollChanges", "obix:Nil", "obix:WatchOut"), null);
    public static final Property pollRefresh = BObixWatch.newProperty((int)256, (BValue)new BObixOp("pollRefresh", "obix:Nil", "obix:WatchOut"), null);
    public static final Property delete = BObixWatch.newProperty((int)256, (BValue)new BObixOp("delete", "obix:Nil", "obix:Nil"), null);
    public static final Type TYPE;
    Hashtable entries;
    private Object mutex;
    BObixServer server;
    Subscription subscriber;
    static /* synthetic */ Class class$com$tridium$obix$watch$BObixWatch;

    public BRelTime getLease() {
        return (BRelTime)this.get(lease);
    }

    public void setLease(BRelTime bRelTime) {
        this.set(lease, (BValue)bRelTime, null);
    }

    public BAbsTime getExpires() {
        return (BAbsTime)this.get(expires);
    }

    public void setExpires(BAbsTime bAbsTime) {
        this.set(expires, (BValue)bAbsTime, null);
    }

    public BObixOp getAdd() {
        return (BObixOp)this.get(add);
    }

    public void setAdd(BObixOp bObixOp) {
        this.set(add, (BValue)bObixOp, null);
    }

    public BObixOp getRemove() {
        return (BObixOp)this.get(remove);
    }

    public void setRemove(BObixOp bObixOp) {
        this.set(remove, (BValue)bObixOp, null);
    }

    public BObixOp getPollChanges() {
        return (BObixOp)this.get(pollChanges);
    }

    public void setPollChanges(BObixOp bObixOp) {
        this.set(pollChanges, (BValue)bObixOp, null);
    }

    public BObixOp getPollRefresh() {
        return (BObixOp)this.get(pollRefresh);
    }

    public void setPollRefresh(BObixOp bObixOp) {
        this.set(pollRefresh, (BValue)bObixOp, null);
    }

    public BObixOp getDelete() {
        return (BObixOp)this.get(delete);
    }

    public void setDelete(BObixOp bObixOp) {
        this.set(delete, (BValue)bObixOp, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(BObixOp bObixOp, ObixDecoder obixDecoder, ObixEncoder obixEncoder) {
        Object object = this.mutex;
        synchronized (object) {
            block11: {
                block10: {
                    this.renewLease();
                    if (!bObixOp.getOpName().equals("add")) break block10;
                    this.doAdd(obixDecoder, obixEncoder);
                    break block11;
                }
                if (bObixOp.getOpName().equals("remove")) {
                    this.doRemove(obixDecoder, obixEncoder);
                } else if (bObixOp.getOpName().equals("pollChanges")) {
                    this.doPollChanges(obixEncoder, obixDecoder);
                } else if (bObixOp.getOpName().equals("pollRefresh")) {
                    this.doPollRefresh(obixEncoder, obixDecoder);
                } else if (bObixOp.getOpName().equals("delete")) {
                    obixEncoder.encodeNull();
                    this.getParent().asComponent().remove(this.getName());
                }
            }
            this.renewLease();
            return;
        }
    }

    public boolean isExpired() {
        return this.getExpires().isBefore(Clock.time());
    }

    public void renewLease() {
        this.setExpires(Clock.time().add(this.getLease()));
    }

    public String processAttr(String string, String string2) {
        this.renewLease();
        if (string.equals("is")) {
            return "obix:Watch";
        }
        return string2;
    }

    public void stopped() {
        this.doCleanup();
    }

    protected void doAdd(ObixDecoder obixDecoder, ObixEncoder obixEncoder) {
        try {
            XElem[] xElemArray = this.getHrefs(obixDecoder);
            Obj obj = new Obj().setIs(WATCH_OUT);
            obj.write(obixEncoder, true);
            obj.initList("values", "obix:obj").write(obixEncoder, true);
            obixEncoder.commit();
            int n = xElemArray.length;
            BIObixWatchable bIObixWatchable = null;
            BObixServer bObixServer = this.getServer();
            int n2 = 0;
            while (n2 < n) {
                String string = xElemArray[n2].get("val", null);
                if (string != null) {
                    bIObixWatchable = (BIObixWatchable)this.entries.get(string);
                    if (bIObixWatchable == null) {
                        try {
                            OrdTarget ordTarget = bObixServer.resolve(string, obixDecoder);
                            bIObixWatchable = this.getAgent(ordTarget);
                            bIObixWatchable.watchInit(xElemArray[n2], ordTarget);
                            this.entries.put(string, bIObixWatchable);
                        }
                        catch (Exception exception) {
                            obixEncoder.setHref(string);
                            obixEncoder.encode(exception);
                        }
                    }
                    if (bIObixWatchable != null) {
                        try {
                            bIObixWatchable.watchRefresh(obixEncoder, obixDecoder);
                        }
                        catch (Exception exception) {
                            obixEncoder.setHref(string);
                            obixEncoder.encode(exception);
                        }
                    }
                    obixEncoder.commit();
                }
                ++n2;
            }
            obj.setElement("list").endElem(obixEncoder);
            obj.reset().endElem(obixEncoder);
        }
        catch (Exception exception) {
            obixEncoder.encode(exception);
        }
    }

    protected void doPollChanges(ObixEncoder obixEncoder, Context context) {
        Obj obj = new Obj().setIs(WATCH_OUT);
        obj.write(obixEncoder, true);
        obj.initList("values", "obix:obj").write(obixEncoder, true);
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            ((BIObixWatchable)enumeration.nextElement()).watchChanges(obixEncoder, context);
        }
        obj.setElement("list").endElem(obixEncoder);
        obj.reset().endElem(obixEncoder);
    }

    protected void doPollRefresh(ObixEncoder obixEncoder, Context context) {
        Obj obj = new Obj().setIs(WATCH_OUT);
        obj.write(obixEncoder, true);
        obj.initList("values", "obix:obj").write(obixEncoder, true);
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            ((BIObixWatchable)enumeration.nextElement()).watchRefresh(obixEncoder, context);
        }
        obj.setElement("list").endElem(obixEncoder);
        obj.reset().endElem(obixEncoder);
    }

    protected void doRemove(ObixDecoder obixDecoder, ObixEncoder obixEncoder) {
        try {
            XElem[] xElemArray = this.getHrefs(obixDecoder);
            int n = xElemArray.length;
            int n2 = 0;
            while (n2 < n) {
                BIObixWatchable bIObixWatchable;
                String string = xElemArray[n2].get("val", null);
                if (string != null && (bIObixWatchable = (BIObixWatchable)this.entries.remove(string)) != null) {
                    bIObixWatchable.watchCleanup();
                }
                ++n2;
            }
            obixEncoder.encodeNull();
        }
        catch (Exception exception) {
            obixEncoder.encode(exception);
            return;
        }
    }

    void doCleanup() {
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            ((BIObixWatchable)enumeration.nextElement()).watchCleanup();
        }
    }

    BObixServer getServer() {
        if (this.server == null) {
            BObixWatch bObixWatch = this;
            while (bObixWatch != null && this.server == null) {
                if (bObixWatch instanceof BObixServer) {
                    this.server = (BObixServer)((Object)bObixWatch);
                }
                bObixWatch = bObixWatch.getParent();
            }
        }
        return this.server;
    }

    private final BIObixWatchable getAgent(OrdTarget ordTarget) {
        BObject bObject = ordTarget.get();
        if (bObject instanceof BIObixWatchable) {
            return (BIObixWatchable)bObject;
        }
        AgentList agentList = bObject.getAgents((Context)ordTarget);
        int n = agentList.size();
        int n2 = 0;
        while (n2 < n) {
            AgentInfo agentInfo = agentList.get(n2);
            if (agentInfo.getAgentType().is(BIObixWatchable.TYPE.getTypeInfo())) {
                return (BIObixWatchable)agentInfo.getInstance();
            }
            ++n2;
        }
        return new BWatchEntry(this);
    }

    protected XElem[] getHrefs(ObixDecoder obixDecoder) throws Exception {
        XElem xElem = obixDecoder.getDocument();
        xElem = xElem.elem("list");
        return xElem.elems();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.entries = new Hashtable();
        this.mutex = new Object();
        this.subscriber = new Subscription();
    }

    public BObixWatch() {
        this.this();
        this.renewLease();
    }

    static {
        Class clazz = class$com$tridium$obix$watch$BObixWatch;
        if (clazz == null) {
            clazz = class$com$tridium$obix$watch$BObixWatch = BObixWatch.class("[Lcom.tridium.obix.watch.BObixWatch;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Subscription
    extends Subscriber {
        Hashtable subscriptions;

        public void subscribe(BWatchEntry bWatchEntry) {
            BWatchEntry bWatchEntry2;
            BComponent bComponent = bWatchEntry.getComponent();
            if (bComponent == null) {
                return;
            }
            if (this.subscriptions == null) {
                this.subscriptions = new Hashtable();
            }
            if ((bWatchEntry2 = (BWatchEntry)this.subscriptions.get(bComponent)) != null) {
                bWatchEntry.next = bWatchEntry2;
            }
            this.subscriptions.put(bComponent, bWatchEntry);
            super.subscribe(bComponent);
        }

        public void unsubscribe(BWatchEntry bWatchEntry) {
            if (this.subscriptions == null) {
                return;
            }
            BComponent bComponent = bWatchEntry.getComponent();
            if (bComponent == null) {
                return;
            }
            BWatchEntry bWatchEntry2 = (BWatchEntry)this.subscriptions.get(bComponent);
            if (bWatchEntry2 == null) {
                return;
            }
            if (bWatchEntry2 == bWatchEntry) {
                bWatchEntry2 = bWatchEntry2.next;
                if (bWatchEntry2 == null) {
                    super.unsubscribe(bComponent);
                    this.subscriptions.remove(bComponent);
                }
            } else {
                BWatchEntry bWatchEntry3 = bWatchEntry2;
                bWatchEntry2 = bWatchEntry2.next;
                while (bWatchEntry2 != null) {
                    if (bWatchEntry2 == bWatchEntry) {
                        bWatchEntry3.next = bWatchEntry2.next;
                        return;
                    }
                    bWatchEntry3 = bWatchEntry2;
                    bWatchEntry2 = bWatchEntry2.next;
                }
            }
        }

        public void event(BComponentEvent bComponentEvent) {
            switch (bComponentEvent.getId()) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    this.markChanges(bComponentEvent);
                }
            }
        }

        public void markChanges(BComponentEvent bComponentEvent) {
            BComponent bComponent = bComponentEvent.getSourceComponent();
            Slot slot = bComponentEvent.getSlot();
            BWatchEntry bWatchEntry = (BWatchEntry)this.subscriptions.get(bComponent);
            while (bWatchEntry != null) {
                if (bWatchEntry.getSlot() == null || bWatchEntry.getSlot() == slot) {
                    bWatchEntry.changed = true;
                }
                bWatchEntry = bWatchEntry.next;
            }
        }

        Subscription() {
        }
    }
}

