/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.util;

import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BAlarmLobbyAgent;
import com.tridium.obix.server.BContractLobbyAgent;
import com.tridium.obix.server.BStationLobbyAgent;
import com.tridium.obix.server.BUnitLobbyAgent;
import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.util.ObixConstants;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.PermissionErr;
import com.tridium.obix.util.WrapperException;
import com.tridium.program.BCode;
import com.tridium.sys.Nre;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.obix.driver.lobby.BObixLobby;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.BIObixWritable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.security.BPassword;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XWriter;

public class ObixUtils
implements ObixConstants {
    private static final long MILLIS_MIN = 60000L;
    private static final long MILLIS_HOUR = 3600000L;
    private static final long MILLIS_DAY = 86400000L;
    private static final long MAX_EXECUTE_WAIT_TICKS = 5000L;
    private static final BIcon objIcon = new BComponent().getIcon();

    public static boolean bool(String string) {
        if (string.equals("false")) {
            return false;
        }
        if (string.equals("0")) {
            return false;
        }
        return !string.equalsIgnoreCase("false");
    }

    public static boolean bool(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        return ObixUtils.bool(string);
    }

    public static XElem child(String string, XElem xElem) {
        int n = xElem.contentSize();
        int n2 = 0;
        while (n2 < n) {
            XElem xElem2;
            String string2;
            XContent xContent = xElem.content(n2);
            if (xContent instanceof XElem && (string2 = (xElem2 = (XElem)xContent).get("name", "")).equals(string)) {
                return xElem2;
            }
            ++n2;
        }
        return null;
    }

    public static String concat(String string, String string2) {
        if (string.equals("")) {
            return string2;
        }
        boolean bl = string.endsWith("/");
        boolean bl2 = string2.startsWith("/");
        if (bl && bl2) {
            return string + string2.substring(1);
        }
        if (bl || bl2) {
            return string + string2;
        }
        return string + '/' + string2;
    }

    public static String dateTime(BAbsTime bAbsTime) {
        return bAbsTime.encodeToString();
    }

    public static BAbsTime dateTime(String string) {
        try {
            return (BAbsTime)BAbsTime.DEFAULT.decodeFromString(string);
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    public static String duration(long l) {
        boolean bl;
        boolean bl2 = false;
        if (l < 0L) {
            bl2 = true;
        }
        if (bl = bl2) {
            l = -l;
        }
        int n = (int)(l / 86400000L);
        int n2 = (int)((l %= 86400000L) / 3600000L);
        int n3 = (int)((l %= 3600000L) / 60000L);
        int n4 = (int)((l %= 60000L) / 1000L);
        long l2 = l % 1000L;
        return ObixUtils.duration(bl, 0, 0, n, n2, n3, n4, l2);
    }

    public static long duration(String string) {
        if (string == null || string.length() == 0) {
            return 0L;
        }
        long l = 0L;
        try {
            boolean bl = false;
            DurationParser durationParser = new DurationParser(string);
            if (durationParser.cur == 45) {
                bl = true;
                durationParser.consume();
            } else if (durationParser.cur == 43) {
                durationParser.consume();
            }
            durationParser.consume(80);
            if (durationParser.cur == -1) {
                throw new Exception();
            }
            int n = durationParser.num();
            if (durationParser.cur == 68) {
                durationParser.consume();
                l += (long)n * 24L * 60L * 60L * 1000L;
                n = durationParser.num();
            }
            if (n >= 0 && durationParser.cur == 72) {
                if (!durationParser.time) {
                    throw new Exception();
                }
                durationParser.consume();
                l += (long)n * 60L * 60L * 1000L;
                n = durationParser.num();
            }
            if (n >= 0 && durationParser.cur == 77) {
                if (!durationParser.time) {
                    throw new Exception();
                }
                durationParser.consume();
                l += (long)n * 60L * 1000L;
                n = durationParser.num();
            }
            if (n >= 0 && durationParser.cur == 83 || durationParser.cur == 46) {
                if (!durationParser.time) {
                    throw new Exception();
                }
                l += (long)n * 1000L;
                if (durationParser.cur == 46) {
                    durationParser.consume();
                    l += (long)durationParser.frac();
                }
                durationParser.consume(83);
            }
            if (durationParser.cur != -1) {
                throw new Exception();
            }
            if (bl) {
                l *= (long)-1;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid duration: " + string);
        }
        return l;
    }

    public static void encode(ObixEncoder obixEncoder, Obj obj, BObject bObject, OrdTarget ordTarget) throws Exception {
        BIcon bIcon;
        try {
            bIcon = bObject.getIcon();
            if (!bIcon.equals((Object)objIcon)) {
                BOrd bOrd = bIcon.getOrdList().get(0);
                obj.setIcon("/ord?" + bOrd.toString(null));
            }
        }
        catch (Exception exception) {}
        obj.setDisplay(bObject.toString((Context)ordTarget));
        if (bObject instanceof BComplex) {
            bIcon = (BComplex)bObject;
            if (obixEncoder.getName() != null) {
                obj.setDisplayName(bIcon.getDisplayName((Context)ordTarget));
            }
            ObixUtils.encodeContracts(obj, bObject, obixEncoder);
        } else if (bObject instanceof BValue) {
            bIcon = ObixUtils.getSlot(ordTarget);
            if (bIcon != null && obixEncoder.getName() != null) {
                obj.setDisplayName(bIcon.getDefaultDisplayName((Context)ordTarget));
            }
            if (bObject instanceof BSimple) {
                if (ordTarget.canWrite()) {
                    obj.setWritable(Boolean.TRUE);
                }
                ObixUtils.encodeSimple(obixEncoder, obj, (BSimple)bObject, (Context)ordTarget);
                if (obixEncoder.encodeSimpleContracts() && obj.getElement() == "str" && !(bObject instanceof BString)) {
                    ObixUtils.encodeContracts(obj, bObject, obixEncoder);
                }
            } else {
                ObixUtils.encodeContracts(obj, bObject, obixEncoder);
            }
        } else if (bObject instanceof BINavNode) {
            bIcon = (BINavNode)bObject;
            obj.setDisplay(bIcon.getClass().getName());
            if (obixEncoder.getName() != null) {
                obj.setDisplayName(bIcon.getNavDisplayName((Context)ordTarget));
            }
        }
    }

    public static void encodeContracts(Obj obj, BObject bObject, ObixEncoder obixEncoder) throws Exception {
        ObixUtils.encodeContracts(obj, bObject.getType(), obixEncoder);
    }

    public static void encodeContracts(Obj obj, Type type, ObixEncoder obixEncoder) throws Exception {
        Type type2 = type;
        while (type2 != null) {
            if (type2 == BComponent.TYPE || type2 == BStruct.TYPE || type2 == BObject.TYPE || type2 == BValue.TYPE) {
                return;
            }
            if (type2.is(BSimple.TYPE)) {
                if (type.is(BAbsTime.TYPE)) {
                    obj.addContract("obix:abstime");
                } else if (type.is(BRelTime.TYPE)) {
                    obj.addContract("obix:reltime");
                } else if (type.is(BIBoolean.TYPE)) {
                    obj.addContract("obix:bool");
                } else if (type.is(BIEnum.TYPE)) {
                    obj.addContract("obix:enum");
                } else if (type.is(BOrd.TYPE)) {
                    obj.addContract("obix:uri");
                } else if (type.is(BInteger.TYPE)) {
                    obj.addContract("obix:int");
                } else if (type.is(BFloat.TYPE)) {
                    obj.addContract("obix:real");
                } else if (type.is(BDouble.TYPE)) {
                    obj.addContract("obix:real");
                } else if (!type2.isAbstract()) {
                    obj.addContract(ObixUtils.makeContractUri(obixEncoder, type2));
                }
                return;
            }
            if (!type2.isAbstract()) {
                obj.addContract(ObixUtils.makeContractUri(obixEncoder, type2));
            }
            type2 = type2.getSuperType();
        }
    }

    public static void encodeSimple(ObixEncoder obixEncoder, Obj obj, BSimple bSimple, Context context) throws Exception {
        if (bSimple instanceof BAbsTime) {
            BString bString;
            obj.setIs(null);
            obj.setElement("abstime");
            BAbsTime bAbsTime = (BAbsTime)bSimple;
            obj.setVal(ObixUtils.dateTime(bAbsTime));
            BFacets bFacets = context.getFacets();
            String string = null;
            if (bFacets != null && (bString = (BString)bFacets.getFacet("TimeZone")) != null) {
                string = bString.getString();
            }
            if (string == null) {
                string = bAbsTime.getTimeZone().getId();
            }
            obj.setTz(string);
        } else if (bSimple instanceof BRelTime) {
            obj.setIs(null);
            obj.setElement("reltime");
            obj.setVal(ObixUtils.duration(((BRelTime)bSimple).getMillis()));
        } else if (bSimple instanceof BIBoolean) {
            obj.setElement("bool");
            BIBoolean bIBoolean = (BIBoolean)bSimple;
            obj.setVal(String.valueOf(bIBoolean.getBoolean()));
            BFacets bFacets = context.getFacets();
            if (bFacets == null) {
                bFacets = bIBoolean.getBooleanFacets();
            }
            if (ObixUtils.isBoolFacets(bFacets)) {
                BString bString = null;
                bString = bIBoolean.getBoolean() ? (BString)bFacets.get("trueText") : (BString)bFacets.get("falseText");
                if (bString != null) {
                    obj.setDisplay(bString.toString(context));
                }
                if (obj.getHref() != null) {
                    obj.setRange(ObixUtils.makeBoolRangeUri(obj.getHref()));
                }
            }
        } else if (bSimple instanceof BIEnum) {
            obj.setIs(null);
            obj.setElement("enum");
            BIEnum bIEnum = (BIEnum)bSimple;
            int n = bIEnum.getEnum().getOrdinal();
            BEnumRange bEnumRange = (BEnumRange)context.getFacets().get("range");
            if (bEnumRange == null || bEnumRange.getOrdinals().length == 0) {
                bEnumRange = bIEnum.getEnum().getRange();
            }
            obj.setVal(bEnumRange.getTag(n));
            obj.setDisplay(bEnumRange.getDisplayTag(n, context));
            int[] nArray = bEnumRange.getOrdinals();
            int[] nArray2 = null;
            Type type = bEnumRange.getFrozenType();
            if (type != null) {
                nArray2 = ((BEnum)type.getInstance()).getRange().getOrdinals();
            }
            if (nArray2 != null && nArray2.length == nArray.length) {
                if (type.is(BWeekday.TYPE)) {
                    obj.setRange("obix:Weekday");
                } else if (type.is(BMonth.TYPE)) {
                    obj.setRange("obix:Month");
                } else {
                    obj.setRange(ObixUtils.makeRangeUri(ObixUtils.makeContractUri(obixEncoder, bEnumRange.getFrozenType())));
                }
            } else if (obj.getHref() != null) {
                obj.setRange(ObixUtils.makeRangeUri(obj.getHref()));
            }
        } else if (bSimple instanceof BINumeric) {
            ObixUtils.encodeNumeric(obixEncoder, obj, (BINumeric)bSimple, context);
        } else if (bSimple instanceof BString) {
            obj.setElement("str");
            obj.setVal(bSimple.toString());
            ObixUtils.checkForProgramCode(obj, context);
        } else if (bSimple instanceof BOrd) {
            obj.setElement("uri");
            obj.setVal(bSimple.toString(context));
        } else if (bSimple instanceof BPassword) {
            obj.setElement("str");
            obj.setVal("");
        } else {
            obj.setElement("str");
            try {
                obj.setVal(bSimple.encodeToString());
            }
            catch (Throwable throwable) {}
            ObixUtils.checkForProgramCode(obj, context);
        }
    }

    private static final void checkForProgramCode(Obj obj, Context context) {
        String string;
        OrdTarget ordTarget;
        if (context instanceof OrdTarget && (ordTarget = (OrdTarget)context).getComponent() instanceof BCode && ((string = ordTarget.getPropertyInParent().getName()) == "source" || string == "classFile")) {
            obj.setVal("");
            obj.setDisplay("");
        }
    }

    public static BComplex getParent(OrdTarget ordTarget) {
        BComponent bComponent = ordTarget.getComponent();
        Property[] propertyArray = ordTarget.getPropertyPathInComponent();
        if (propertyArray == null) {
            return bComponent;
        }
        int n = propertyArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            bComponent = (BComplex)bComponent.get(propertyArray[n2]);
            ++n2;
        }
        return bComponent;
    }

    public static Slot getSlot(OrdTarget ordTarget) {
        Property[] propertyArray = ordTarget.getPropertyPathInComponent();
        if (propertyArray == null || propertyArray.length == 0) {
            return ordTarget.getSlotInComponent();
        }
        return propertyArray[propertyArray.length - 1];
    }

    public static int num(String string, int n) {
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static String makeAlarmUri(ObixEncoder obixEncoder, String string) {
        if (string == null) {
            return null;
        }
        return ObixUtils.concat(ObixUtils.concat(obixEncoder.getLobbyPath(), BAlarmLobbyAgent.LOBBY_NAME), string);
    }

    public static String makeBoolRangeUri(String string) {
        int n = string.indexOf("~param");
        if (n > 0) {
            string = string.substring(0, n);
        }
        return ObixUtils.concat(string, "~bool");
    }

    public static String makeContractUri(ObixEncoder obixEncoder, Type type) throws Exception {
        return ObixUtils.concat(ObixUtils.concat(obixEncoder.getLobbyPath(), BContractLobbyAgent.LOBBY_NAME), type.getTypeSpec().encodeToString());
    }

    public static String makeSlotPathUri(ObixEncoder obixEncoder, String string) {
        return ObixUtils.concat(ObixUtils.concat(obixEncoder.getLobbyPath(), BStationLobbyAgent.LOBBY_NAME), string);
    }

    public static String makeRangeUri(String string) {
        if (string == null) {
            return "~range";
        }
        return ObixUtils.concat(string, "~range");
    }

    public static String makeUnitUri(ObixEncoder obixEncoder, BUnit bUnit) {
        if (bUnit == null || bUnit.isNull()) {
            return null;
        }
        return ObixUtils.concat(ObixUtils.concat(obixEncoder.getLobbyPath(), BUnitLobbyAgent.LOBBY_NAME), bUnit.getUnitName());
    }

    public static String resource(String string, String string2) {
        int n = string2.indexOf(string);
        if (n < 0) {
            throw new BadUriErr();
        }
        if ((string2 = string2.substring(n + string.length())).equals("") || string2.equals("/")) {
            return "/";
        }
        if (string2.endsWith("/")) {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static void serviceInvoke(OrdTarget ordTarget, ObixDecoder obixDecoder, ObixEncoder obixEncoder) throws Exception {
        BObject bObject = ordTarget.get();
        if (bObject instanceof BIObixInvocable) {
            ((BIObixInvocable)bObject).invoke(obixDecoder, obixEncoder);
        } else {
            Action action = (Action)ordTarget.getSlotInComponent();
            if (bObject instanceof BObixLobby && action == null) {
                obixEncoder.encode(ordTarget);
                return;
            }
            BValue bValue = null;
            if (action.getParameterDefault() != null) {
                bValue = obixDecoder.decode(action.getParameterDefault());
            }
            BValue bValue2 = ordTarget.getComponent().invoke(action, bValue, (Context)ordTarget);
            int n = Nre.engineManager.getCycles();
            long l = Clock.ticks();
            int n2 = ObixUtils.waitForPointExecute(ordTarget, n, l);
            obixEncoder.setHref(null);
            if (bValue2 instanceof BIObixEncodable) {
                ((BIObixEncodable)bValue2).encode(obixEncoder, (Context)ordTarget);
            } else {
                OrdTarget ordTarget2 = ordTarget.getOrd().getParent().resolve(null);
                obixEncoder.encode(new ObixTarget(ordTarget2, (BObject)bValue2));
            }
            if (obixEncoder.isDebug()) {
                System.out.println("EngineManager cycles waiting for post-invoke execution = " + n2);
            }
        }
    }

    public static void serviceWrite(OrdTarget ordTarget, ObixDecoder obixDecoder, ObixEncoder obixEncoder) throws Exception {
        BObject bObject = ordTarget.get();
        try {
            BValue bValue;
            if (bObject instanceof BIObixWritable) {
                ((BIObixWritable)bObject).write(obixDecoder);
            } else {
                if (bObject != null) {
                    bObject = bObject.asValue().newCopy(true);
                }
                bValue = obixDecoder.decode(bObject.asValue());
                BComponent bComponent = ordTarget.getComponent();
                String string = ordTarget.getPropertyInParent().getName();
                if (bComponent instanceof BCode && (string == "source" || string == "classFile")) {
                    throw new PermissionException("Cannot write program code");
                }
                Property[] propertyArray = ordTarget.getPropertyPathInComponent();
                int n = propertyArray.length - 1;
                int n2 = 0;
                while (n2 < n) {
                    bComponent = (BComplex)bComponent.get(propertyArray[n2]);
                    ++n2;
                }
                bComponent.set(propertyArray[n], bValue, (Context)ordTarget.getUser());
            }
            bValue = ordTarget.getOrd().resolve();
            obixEncoder.encode((OrdTarget)bValue);
        }
        catch (PermissionException permissionException) {
            throw new PermissionErr(ordTarget.getUser().getName() + " cannot write this object");
        }
    }

    public static String servletUri(String string, String string2) {
        int n = string.indexOf("://");
        n = n > 0 ? string.indexOf(47, n + 3) : string.indexOf(47);
        if (n < 0) {
            return string;
        }
        n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n + string2.length()) + '/';
    }

    public static String toPath(OrdTarget ordTarget) {
        BComponent bComponent = ordTarget.getComponent();
        String string = bComponent.toPathString();
        Property[] propertyArray = ordTarget.getPropertyPathInComponent();
        if (propertyArray == null) {
            return string;
        }
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = ObixUtils.concat(string, propertyArray[n2].getName());
            ++n2;
        }
        return string;
    }

    public static String[] toPathArray(String string) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == '/') {
                if (stringBuffer.length() > 0) {
                    vector.addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String toString(XElem xElem) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XWriter xWriter = new XWriter((OutputStream)byteArrayOutputStream);
            xElem.write(xWriter);
            xWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String ndEscape(String string) {
        if (string.length() == 0) {
            return "";
        }
        string = SlotPath.escape((String)string);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '$') {
                cArray[n] = 37;
            }
            ++n;
        }
        return new String(cArray);
    }

    public static String ndUnescape(String string) {
        if (string.length() == 0) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%') {
                cArray[n] = 36;
            }
            ++n;
        }
        String string2 = new String(cArray);
        int n2 = string2.indexOf("|virtual:");
        if (n2 < 0) {
            return SlotPath.unescape((String)string2);
        }
        String string3 = string2.substring(0, n2 + 9);
        string3 = string3 + SlotPath.unescape((String)string2.substring(n2 + 9));
        return string3;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string2.length();
        while (n >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + n3;
            n = string.indexOf(string2, n2);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    static void encodeNumeric(ObixEncoder obixEncoder, Obj obj, BINumeric bINumeric, Context context) throws Exception {
        int n;
        double d;
        boolean bl = bINumeric instanceof BInteger;
        obj.setIs(null);
        if (bl) {
            obj.setElement("int");
            obj.setVal(new Integer((int)bINumeric.getNumeric()).toString());
        } else {
            obj.setElement("real");
            obj.setVal(String.valueOf(bINumeric.getNumeric()));
        }
        BFacets bFacets = context.getFacets();
        if (bFacets == null) {
            bFacets = bINumeric.getNumericFacets();
        }
        if (bFacets.get("min") != null && !Double.isInfinite(d = bFacets.getd("min", 0.0))) {
            if (bl) {
                obj.setMin(String.valueOf((int)d));
            } else {
                obj.setMin(String.valueOf(d));
            }
        }
        if (bFacets.get("max") != null && !Double.isInfinite(d = bFacets.getd("max", 0.0))) {
            if (bl) {
                obj.setMax(String.valueOf((int)d));
            } else {
                obj.setMax(String.valueOf(d));
            }
        }
        if (bFacets.get("units") != null) {
            BUnit bUnit = (BUnit)bFacets.get("units");
            if (UnitDatabase.getUnit((String)bUnit.getUnitName()) != null) {
                obj.setUnits("obix:units/" + bUnit.getUnitName());
            } else {
                obj.setUnits(ObixUtils.makeUnitUri(obixEncoder, bUnit));
            }
        }
        if (bFacets.get("precision") != null && (n = bFacets.geti("precision", 1)) != 1) {
            obj.setPrecision(String.valueOf(n));
        }
    }

    private static final String duration(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (n != 0) {
            stringBuffer.append(n).append('Y');
        }
        if (n2 != 0) {
            stringBuffer.append(n2).append('M');
        }
        if (n3 != 0) {
            stringBuffer.append(n3).append("D");
        }
        stringBuffer.append("T");
        if (n4 != 0) {
            stringBuffer.append(n4).append('H');
        }
        if (n5 != 0) {
            stringBuffer.append(n5).append('M');
        }
        stringBuffer.append(n6);
        if (l != 0L) {
            stringBuffer.append('.').append(l);
        }
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    private static final boolean isBoolFacets(BFacets bFacets) {
        if (bFacets.isNull()) {
            return false;
        }
        if (bFacets.get("trueText") != null) {
            return true;
        }
        return bFacets.get("falseText") != null;
    }

    private static final int waitForPointExecute(OrdTarget ordTarget, int n, long l) {
        BComponent bComponent = ordTarget.getComponent();
        long l2 = l + 5000L;
        int n2 = 0;
        if (bComponent instanceof BControlPoint) {
            int n3 = Nre.engineManager.getCycles();
            long l3 = Clock.ticks();
            long l4 = 10L;
            while (n3 == n && l3 < l2) {
                try {
                    Thread.sleep(l4);
                }
                catch (InterruptedException interruptedException) {}
                n3 = Nre.engineManager.getCycles();
                l3 = Clock.ticks();
                l4 += 10L;
                ++n2;
            }
            return n2;
        }
        return -1;
    }

    static class DurationParser {
        String s;
        int off;
        int cur;
        boolean curIsDigit;
        boolean time;

        int frac() {
            int n = 0;
            if (this.curIsDigit) {
                n += this.digit() * 100;
                this.consume();
                if (this.curIsDigit) {
                    n += this.digit() * 10;
                    this.consume();
                    if (this.curIsDigit) {
                        n += this.digit();
                        this.consume();
                        while (this.curIsDigit) {
                            this.consume();
                        }
                    }
                }
            }
            return n;
        }

        int num() {
            if (this.cur == 84) {
                this.time = true;
                this.consume();
            }
            int n = 0;
            while (this.curIsDigit) {
                n = n * 10 + this.digit();
                this.consume();
            }
            return n;
        }

        int digit() {
            return this.cur - 48;
        }

        void consume(int n) {
            if (this.cur != n) {
                throw new IllegalStateException();
            }
            this.consume();
        }

        void consume() {
            ++this.off;
            if (this.off < this.s.length()) {
                this.cur = this.s.charAt(this.off);
                boolean bl = false;
                if (48 <= this.cur && this.cur <= 57) {
                    bl = true;
                }
                this.curIsDigit = bl;
            } else {
                this.cur = -1;
                this.curIsDigit = false;
            }
        }

        DurationParser(String string) {
            this.s = string;
            this.cur = string.charAt(0);
        }
    }
}

