/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.Array;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAlarmServiceAgent
extends BObixAgent {
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$obix$server$BAlarmServiceAgent;
    static /* synthetic */ Class class$java$lang$String;

    public Type getType() {
        return TYPE;
    }

    public static void encodeAlarm(BAlarmRecord bAlarmRecord, ObixEncoder obixEncoder, Obj obj, Context context) {
        String[] stringArray;
        OrdTarget ordTarget;
        BObject bObject;
        obj.reset().setName(obixEncoder.getName());
        obj.addContract("obix:Alarm obix:AckAlarm");
        String string = bAlarmRecord.getAlarmData().gets("msgText", null);
        if (string != null) {
            obj.setDisplay(string);
        }
        if ((bObject = bAlarmRecord.getAlarmValue()) != null) {
            obj.addContract("obix:PointAlarm");
        }
        if (bAlarmRecord.getAlarmTransition() != BSourceState.alert) {
            obj.addContract("obix:StatefulAlarm");
        }
        String string2 = null;
        try {
            string2 = ObixUtils.makeAlarmUri(obixEncoder, bAlarmRecord.getUuid().encodeToString());
        }
        catch (Exception exception) {}
        obj.setHref(string2);
        obj.write(obixEncoder, true);
        Class clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = BAlarmServiceAgent.class("[Ljava.lang.String;", false);
        }
        Array array = new Array(clazz);
        if (string2 != null) {
            obj.initOp("ack", "obix:AlarmAckIn", "obix:AlarmAckOut");
            obj.setHref(ObixUtils.concat(string2, "ack"));
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
        }
        boolean bl = false;
        BOrdList bOrdList = bAlarmRecord.getSource();
        if (bOrdList.size() > 0) {
            try {
                BOrd bOrd = bOrdList.get(0);
                ordTarget = bOrd.resolve((BObject)Sys.getStation(), context);
                stringArray = ObixUtils.toPath(ordTarget);
                obj.initRef("source", ObixUtils.makeSlotPathUri(obixEncoder, (String)stringArray));
                BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                bl = true;
            }
            catch (Exception exception) {}
        }
        boolean bl2 = false;
        if (bObject != null && bObject.isSimple()) {
            try {
                ObixUtils.encodeSimple(obixEncoder, obj.reset(), bObject.asSimple(), context);
                obj.setName("alarmValue");
                BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                bl2 = true;
            }
            catch (Exception exception) {}
        }
        if (bAlarmRecord.isAcknowledged() && !bAlarmRecord.getAckTime().isNull()) {
            obj.initAbstime("ackTimestamp", bAlarmRecord.getAckTime());
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
            obj.initStr("ackUser", bAlarmRecord.getUser());
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
        }
        if (!bAlarmRecord.getNormalTime().isNull()) {
            obj.initAbstime("normalTimestamp", bAlarmRecord.getNormalTime());
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
        }
        obj.initAbstime("timestamp", bAlarmRecord.getTimestamp());
        BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
        try {
            obj.initStr("niagara-uuid", bAlarmRecord.getUuid().encodeToString());
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
            obj.initInt("priority", bAlarmRecord.getPriority());
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
            obj.initStr("alarmClass", bAlarmRecord.getAlarmClass());
            BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
        ordTarget = bAlarmRecord.getAlarmData();
        stringArray = ordTarget.list();
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            BObject bObject2 = ordTarget.get(string3);
            if (!string3.equals("alarmValue") || !bl2) {
                if (string3.equals("source") && bl) {
                    obj.initStr("originalSource", bObject2.toString());
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                } else if (string3.equals("priority")) {
                    obj.initInt("originalPriority", Integer.parseInt(bObject2.toString()));
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                } else if (string3.equals("alarmClass")) {
                    obj.initStr("originalAlarmClass", bObject2.toString());
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                } else if (bObject2 instanceof BBoolean) {
                    obj.initBool(string3, ((BBoolean)bObject2).getBoolean());
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                } else if (bObject2 instanceof BDouble) {
                    obj.initReal(string3, ((BDouble)bObject2).getDouble());
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                } else if (bObject2 instanceof BInteger) {
                    obj.initInt(string3, ((BInteger)bObject2).getInt());
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                } else {
                    obj.initStr(string3, bObject2.toString());
                    BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
                }
            }
            ++n;
        }
        obj.initStr("sourceStation", Sys.getStation().getStationName());
        BAlarmServiceAgent.safeWrite(array, obj, obixEncoder);
        obj.reset().endElem(obixEncoder);
    }

    private static final void safeWrite(Array array, Obj obj, ObixEncoder obixEncoder) {
        String string = obj.getName();
        if (!array.contains((Object)string)) {
            array.add((Object)string);
            obj.write(obixEncoder, false);
        } else if (obixEncoder.isDebug()) {
            System.out.println("obj '" + obj + "' not written: duplicate element!");
        }
    }

    public void encodeFinishing() throws Exception {
        super.encodeFinishing();
        ObixEncoder obixEncoder = this.getEncoder();
        String string = obixEncoder.getHref();
        Obj obj = new Obj();
        BAlarmService bAlarmService = (BAlarmService)this.getTarget().get();
        BAlarmDatabase bAlarmDatabase = bAlarmService.getAlarmDb();
        if (bAlarmDatabase != null) {
            int n = 0;
            Cursor cursor = bAlarmDatabase.getOpenAlarms();
            while (cursor.next()) {
                ++n;
            }
            obj.initInt("count", n).setMin(String.valueOf(0));
        } else {
            obj.initInt("count", 0).setMin(String.valueOf(0));
        }
        obj.write(obixEncoder, false);
        obj.initOp("query", "obix:AlarmFilter", "obix:AlarmQueryOut");
        obj.setHref(obixEncoder.getChildHref(string, "~alarmQuery"));
        obj.write(obixEncoder, false);
        obj.initFeed("feed", "obix:AlarmFilter", "obix:Alarm");
        obj.setHref(obixEncoder.getChildHref(string, "~alarmFeed"));
        obj.write(obixEncoder, false);
    }

    public String processAttr(String string, String string2) {
        if (string.equals("is")) {
            return BAlarmServiceAgent.addToList(string2, "obix:AlarmSubject");
        }
        return string2;
    }

    static IterationResults iterateResults(BInteger bInteger, BICollection bICollection, Obj obj, ObixEncoder obixEncoder, Context context) {
        int n = 0;
        BAbsTime bAbsTime = null;
        BAbsTime bAbsTime2 = null;
        int n2 = Integer.MAX_VALUE;
        if (bInteger != null) {
            n2 = bInteger.getInt();
        }
        Object object = null;
        Cursor cursor = bICollection.cursor();
        if (cursor.next()) {
            object = (BAlarmRecord)cursor.get();
        }
        if (object != null) {
            bAbsTime2 = bAbsTime = object.getLastUpdate();
        }
        while (n < n2 && object != null) {
            if (bAbsTime2.isBefore(object.getLastUpdate())) {
                bAbsTime2 = object.getLastUpdate();
            }
            BAlarmServiceAgent.encodeAlarm(object, obixEncoder, obj.reset(), context);
            obixEncoder.commit();
            ++n;
            object = cursor.next() ? (BAlarmRecord)cursor.get() : null;
        }
        IterationResults iterationResults = new IterationResults();
        iterationResults.count = n;
        iterationResults.first = bAbsTime;
        iterationResults.last = bAbsTime2;
        return iterationResults;
    }

    static String queryChanges(BAbsTime bAbsTime, BAbsTime bAbsTime2, BAlarmClass bAlarmClass) {
        StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select *");
        boolean bl = false;
        if (bAlarmClass != null) {
            if (!bl) {
                bl = true;
                stringBuffer.append(" where");
            }
            stringBuffer.append(" alarmClass = '").append(bAlarmClass.getName()).append("'");
        }
        if (bAbsTime != null && !bAbsTime.isNull()) {
            if (!bl) {
                bl = true;
                stringBuffer.append(" where");
            } else {
                stringBuffer.append(" and");
            }
            stringBuffer.append(" lastUpdate > '");
            stringBuffer.append(bAbsTime.encodeToString()).append("'");
        }
        if (bAbsTime2 != null && !bAbsTime2.isNull()) {
            if (!bl) {
                bl = true;
                stringBuffer.append(" where");
            } else {
                stringBuffer.append(" and");
            }
            stringBuffer.append(" lastUpdate <= '").append(bAbsTime2.encodeToString()).append("'");
        }
        return stringBuffer.toString();
    }

    static String queryRefresh(BAbsTime bAbsTime, BAbsTime bAbsTime2, BAlarmClass bAlarmClass) {
        StringBuffer stringBuffer = new StringBuffer("alarm:|bql:select * from openAlarms");
        boolean bl = false;
        if (bAlarmClass != null) {
            if (!bl) {
                bl = true;
                stringBuffer.append(" where");
            }
            stringBuffer.append(" alarmClass = '").append(bAlarmClass.getName()).append("'");
        }
        if (bAbsTime != null && !bAbsTime.isNull()) {
            if (!bl) {
                bl = true;
                stringBuffer.append(" where");
            } else {
                stringBuffer.append(" and");
            }
            stringBuffer.append(" lastUpdate >= '");
            stringBuffer.append(bAbsTime.encodeToString()).append("'");
        }
        if (bAbsTime2 != null && !bAbsTime2.isNull()) {
            if (!bl) {
                bl = true;
                stringBuffer.append(" where");
            } else {
                stringBuffer.append(" and");
            }
            stringBuffer.append(" lastUpdate <= '").append(bAbsTime2.encodeToString()).append("'");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$obix$server$BAlarmServiceAgent;
        if (clazz == null) {
            clazz = class$com$tridium$obix$server$BAlarmServiceAgent = BAlarmServiceAgent.class("[Lcom.tridium.obix.server.BAlarmServiceAgent;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    static class IterationResults {
        int count;
        BAbsTime first;
        BAbsTime last;

        IterationResults() {
        }
    }
}

