/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.schedule;

import com.tridium.obix.driver.schedule.BObixScheduleDeviceExt;
import com.tridium.obix.driver.schedule.BObixScheduleExport;
import javax.baja.obix.driver.BObixClient;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import obix.Abstime;
import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Uri;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BR2ScheduleDeviceExt
extends BObixScheduleDeviceExt {
    public static final Property eventsPerUpdate = BR2ScheduleDeviceExt.newProperty((int)0, (int)25, (BFacets)BFacets.makeInt((int)0, (int)50));
    public static final Property maxLookAheadDays = BR2ScheduleDeviceExt.newProperty((int)0, (int)30, (BFacets)BFacets.makeInt((BUnit)BUnit.getUnit((String)"day"), (int)1, (int)90));
    public static final Property forceEventAtMidnight = BR2ScheduleDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE;
    private static Uri contract;
    private static Uri eventContractUri;
    private static Contract eventContract;
    static /* synthetic */ Class class$com$tridium$obix$driver$schedule$BR2ScheduleDeviceExt;

    public int getEventsPerUpdate() {
        return this.getInt(eventsPerUpdate);
    }

    public void setEventsPerUpdate(int n) {
        this.setInt(eventsPerUpdate, n, null);
    }

    public int getMaxLookAheadDays() {
        return this.getInt(maxLookAheadDays);
    }

    public void setMaxLookAheadDays(int n) {
        this.setInt(maxLookAheadDays, n, null);
    }

    public boolean getForceEventAtMidnight() {
        return this.getBoolean(forceEventAtMidnight);
    }

    public void setForceEventAtMidnight(boolean bl) {
        this.setBoolean(forceEventAtMidnight, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void execute(BObixScheduleExport bObixScheduleExport) {
        BAbsTime bAbsTime;
        BObixClient bObixClient = this.getObixClient();
        List list = new List("eventList", eventContract);
        BAbstractSchedule bAbstractSchedule = bObixScheduleExport.getSchedule();
        if (!(bAbstractSchedule instanceof BBooleanSchedule)) {
            return;
        }
        BBooleanSchedule bBooleanSchedule = (BBooleanSchedule)bAbstractSchedule;
        BAbsTime bAbsTime2 = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.DEFAULT);
        BAbsTime bAbsTime3 = bAbsTime2.add(BRelTime.makeHours((int)(24 * this.getMaxLookAheadDays())));
        int n = 0;
        if (this.getForceEventAtMidnight()) {
            while (bAbsTime2.isBefore(bAbsTime3) && n < this.getEventsPerUpdate()) {
                bAbsTime = bBooleanSchedule.nextCov(bAbsTime2);
                boolean bl = this.getValue((BAbstractSchedule)bBooleanSchedule, bAbsTime2);
                if (bAbsTime == null) {
                    if (this.getLog().isTraceOn()) {
                        System.out.println("t1 is null! add full days at default for remaining events");
                    }
                    while (n++ < this.getEventsPerUpdate()) {
                        if (bl) {
                            this.addEvent((BAbstractSchedule)bBooleanSchedule, bAbsTime2, BAbsTime.make((BAbsTime)bAbsTime2.nextDay(), (BTime)BTime.DEFAULT), list);
                        } else {
                            this.addEvent((BAbstractSchedule)bBooleanSchedule, bAbsTime2, bAbsTime2, list);
                        }
                        bAbsTime2 = BAbsTime.make((BAbsTime)bAbsTime2.nextDay(), (BTime)BTime.DEFAULT);
                    }
                    break;
                }
                if (this.getLog().isTraceOn()) {
                    System.out.println("while(" + n + "): t0=" + bAbsTime2 + " t1=" + bAbsTime + " v=" + bl);
                }
                while (!bAbsTime2.dateEquals(bAbsTime) && n < this.getEventsPerUpdate()) {
                    BAbsTime bAbsTime4 = BAbsTime.make((BAbsTime)bAbsTime2.nextDay(), (BTime)BTime.DEFAULT);
                    this.addEvent((BAbstractSchedule)bBooleanSchedule, bAbsTime2, bl ? bAbsTime4 : bAbsTime2, list);
                    ++n;
                    bAbsTime2 = bAbsTime4;
                }
                this.addEvent((BAbstractSchedule)bBooleanSchedule, bAbsTime2, bl ? bAbsTime : bAbsTime2, list);
                ++n;
                bAbsTime2 = bAbsTime;
            }
        } else {
            boolean bl = this.getValue((BAbstractSchedule)bBooleanSchedule, bAbsTime2);
            while (bAbsTime2.isBefore(bAbsTime3) && n < this.getEventsPerUpdate()) {
                bAbsTime = bBooleanSchedule.nextCov(bAbsTime2);
                bl = this.getValue((BAbstractSchedule)bBooleanSchedule, bAbsTime2);
                if (bl) {
                    this.addEvent((BAbstractSchedule)bBooleanSchedule, bAbsTime2, bAbsTime, list);
                    ++n;
                }
                bAbsTime2 = bAbsTime;
            }
        }
        if (this.getLog().isTraceOn()) {
            System.out.println("\n\neventList from execute():");
            list.dump();
        }
        bAbsTime = (Abstime)bObixClient.obixInvoke(new Uri(bObixScheduleExport.getSubordinate() + ".schedule"), (Obj)list);
        bObixScheduleExport.setSubordinateExpires(BAbsTime.make((long)bAbsTime.getMillis()));
    }

    public Uri getScheduleContract() {
        return contract;
    }

    private final BAbsTime addEvent(BAbstractSchedule bAbstractSchedule, BAbsTime bAbsTime, BAbsTime bAbsTime2, List list) {
        String string = "defaultOutput";
        BAbstractSchedule bAbstractSchedule2 = bAbstractSchedule.getOutputSource(bAbsTime);
        if (bAbstractSchedule2 != bAbstractSchedule) {
            string = bAbstractSchedule2.getParent().getParent().getName();
        }
        Obj obj = this.makeEvent(bAbsTime, bAbsTime2);
        this.addEvent(list, string, obj);
        return bAbsTime2;
    }

    private final void addEvent(List list, String string, Obj obj) {
        Obj obj2 = list.get(string);
        if (obj2 == null) {
            list.add(string, obj);
        } else {
            int n = 0;
            while (obj2 != null) {
                obj2 = list.get(string + ++n);
            }
            list.add(string + n, obj);
        }
    }

    private final boolean getValue(BAbstractSchedule bAbstractSchedule, BAbsTime bAbsTime) {
        BStatusValue bStatusValue = bAbstractSchedule.getOutput(bAbsTime);
        if (!(bStatusValue instanceof BIBoolean)) {
            throw new IllegalArgumentException("Obix Schedule Export must reference BooleanSchedule type!");
        }
        boolean bl = false;
        if (!bStatusValue.isNull()) {
            bl = ((BIBoolean)bStatusValue).getBoolean();
        }
        return bl;
    }

    private final Obj makeEvent(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        Obj obj = new Obj();
        obj.setIs(eventContract);
        obj.add("dtstart", (Obj)new Abstime(bAbsTime.getMillis()));
        obj.add("dtend", (Obj)new Abstime(bAbsTime2.getMillis()));
        return obj;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$obix$driver$schedule$BR2ScheduleDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$schedule$BR2ScheduleDeviceExt = BR2ScheduleDeviceExt.class("[Lcom.tridium.obix.driver.schedule.BR2ScheduleDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        contract = new Uri("/obix/def/tridium.apps.ScheduleNode");
        eventContractUri = new Uri("/obix/def/tridiumx.obix.ScheduleEvent");
        eventContract = new Contract(new Uri[]{eventContractUri});
    }
}

