/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.schedule;

import com.tridium.obix.driver.schedule.BObixScheduleDeviceExt;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixScheduleExport
extends BDescriptor
implements BIStatus {
    public static final Property executionTime = BObixScheduleExport.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)5))), null);
    public static final Property subordinate = BObixScheduleExport.newProperty((int)0, (String)"", null);
    public static final Property subordinateExpires = BObixScheduleExport.newProperty((int)3, (BValue)Clock.time(), null);
    public static final Property supervisor = BObixScheduleExport.newProperty((int)8, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:Component"));
    public static final Property supervisorVersion = BObixScheduleExport.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    public static final Action forceSync = BObixScheduleExport.newAction((int)0, null);
    public static final Type TYPE;
    private BObixScheduleDeviceExt deviceExt;
    private boolean licenseChecked;
    private boolean fatalFault;
    private String fatalFaultCause;
    static /* synthetic */ Class class$com$tridium$obix$driver$schedule$BObixScheduleExport;

    public String getSubordinate() {
        return this.getString(subordinate);
    }

    public void setSubordinate(String string) {
        this.setString(subordinate, string, null);
    }

    public BAbsTime getSubordinateExpires() {
        return (BAbsTime)this.get(subordinateExpires);
    }

    public void setSubordinateExpires(BAbsTime bAbsTime) {
        this.set(subordinateExpires, (BValue)bAbsTime, null);
    }

    public BOrd getSupervisor() {
        return (BOrd)this.get(supervisor);
    }

    public void setSupervisor(BOrd bOrd) {
        this.set(supervisor, (BValue)bOrd, null);
    }

    public BAbsTime getSupervisorVersion() {
        return (BAbsTime)this.get(supervisorVersion);
    }

    public void setSupervisorVersion(BAbsTime bAbsTime) {
        this.set(supervisorVersion, (BValue)bAbsTime, null);
    }

    public void forceSync() {
        this.invoke(forceSync, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled()) {
            this.getObixNetwork().enqueue(new Runnable(){

                public final void run() {
                    BObixScheduleExport.this.checkObixLicense();
                }
            });
        }
        this.sExportAtSteadyState();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled) && !this.isDisabled()) {
            this.checkObixLicense();
        }
    }

    public void doExecute() {
        this.executeInProgress();
        try {
            if (this.fatalFault) {
                this.executeFail(this.fatalFaultCause);
                return;
            }
            if (!(this.getSchedule() instanceof BBooleanSchedule)) {
                this.executeFail("Wrong Source Schedule Type:" + this.getSchedule().getType());
            }
            if (this.getSubordinateExpires().isAfter(this.getExecutionTime().getNextTrigger()) && this.getSupervisorVersion().equals((Object)BObixScheduleExport.getVersionOf(this.getSchedule()))) {
                this.setFaultCause("");
                this.setState(BDescriptorState.idle);
                this.updateStatus();
                return;
            }
            this.getObixScheduleDeviceExt().execute(this);
            this.setSupervisorVersion(BObixScheduleExport.getVersionOf(this.getSchedule()));
            this.executeOk();
        }
        catch (Exception exception) {
            this.getLog().error("Obix Schedule Export", (Throwable)exception);
            this.executeFail(exception);
        }
    }

    public void doForceSync() {
        this.setSupervisorVersion(BAbsTime.NULL);
        this.setSubordinateExpires(BAbsTime.NULL);
        this.setState(BDescriptorState.idle);
        this.execute();
    }

    public Log getLog() {
        return this.getObixScheduleDeviceExt().getLog();
    }

    public BObixClient getObixClient() {
        return this.getObixScheduleDeviceExt().getObixClient();
    }

    public BObixScheduleDeviceExt getObixScheduleDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BObixScheduleDeviceExt) {
                this.deviceExt = (BObixScheduleDeviceExt)bComplex;
                return this.deviceExt;
            }
            bComplex = bComplex.getParent();
        }
        throw new IllegalStateException();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public BAbstractSchedule getSchedule() {
        BAbstractSchedule bAbstractSchedule = null;
        try {
            bAbstractSchedule = (BAbstractSchedule)this.getSupervisor().resolve((BObject)this).get();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException(this.getSupervisor().toString(null), (Throwable)exception);
        }
        if (bAbstractSchedule == null) {
            throw new IllegalArgumentException("Cannot resolve: " + this.getSupervisor().toString(null));
        }
        return bAbstractSchedule;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == execute) {
            return super.post(action, bValue, context);
        }
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public IFuture postExecute(Action action, BValue bValue, Context context) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public void stopped() throws Exception {
        this.setStatus(BStatus.down);
        this.deviceExt = null;
        super.stopped();
    }

    protected static BAbsTime getVersionOf(BAbstractSchedule bAbstractSchedule) {
        return (BAbsTime)bAbstractSchedule.get("lastModified");
    }

    protected void sExportAtSteadyState() throws Exception {
    }

    private final void checkObixLicense() {
        String string;
        if (this.licenseChecked) {
            return;
        }
        Boolean bl = this.getObixClient().isTridiumServer();
        if (bl == null) {
            return;
        }
        if (!bl.booleanValue() && (string = this.getObixNetwork().checkObixLimit("foreignSchedule.limit")) != null) {
            this.configFatal(string);
        }
        this.licenseChecked = true;
    }

    private final void configFatal(String string) {
        this.fatalFault = true;
        this.fatalFaultCause = string;
        this.executeFail(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceExt = null;
        this.licenseChecked = false;
        this.fatalFault = false;
        this.fatalFaultCause = null;
    }

    public BObixScheduleExport() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$schedule$BObixScheduleExport;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$schedule$BObixScheduleExport = BObixScheduleExport.class("[Lcom.tridium.obix.driver.schedule.BObixScheduleExport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

