/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixPointDeviceExt;
import com.tridium.obix.driver.point.BObixPointDiscoveryResult;
import com.tridium.obix.driver.point.BObixProxyExt;
import com.tridium.obix.driver.util.BObixDiscoveryJob;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import obix.Enum;
import obix.Int;
import obix.Obj;
import obix.Real;
import obix.Reltime;
import obix.Uri;
import obix.Val;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixPointDiscoveryJob
extends BObixDiscoveryJob {
    public static final Action fetch = BObixPointDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE;
    private static Uri lobby;
    protected BValue uri;
    protected BObixPointDeviceExt ext;
    static /* synthetic */ Class class$com$tridium$obix$driver$point$BObixPointDiscoveryJob;

    public BObixPointDiscoveryResult fetch(BString bString) {
        return (BObixPointDiscoveryResult)this.invoke(fetch, (BValue)bString, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doDiscover() {
        try {
            this.progress(25);
            BObixPointDiscoveryResult bObixPointDiscoveryResult = this.read(this.uri.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)bObixPointDiscoveryResult);
            this.success();
        }
        catch (Throwable throwable) {
            this.failed(throwable);
        }
    }

    public BObixPointDiscoveryResult doFetch(BString bString) {
        try {
            return this.read(bString.getString(), Context.decoding);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.failed(throwable);
            return null;
        }
    }

    public BObixPointDiscoveryResult getResult() {
        return (BObixPointDiscoveryResult)this.get("result");
    }

    protected boolean checkAddRef(Obj obj) {
        boolean bl = false;
        if (obj.getNormalizedHref() != null) {
            bl = true;
        }
        return bl;
    }

    protected boolean checkAddResult(BObixPointDiscoveryResult bObixPointDiscoveryResult, Obj obj) {
        boolean bl = false;
        if (bObixPointDiscoveryResult != null) {
            bl = true;
        }
        return bl;
    }

    protected BObixPointDiscoveryResult read(String string, Context context) throws Exception {
        Obj obj = this.ext.getObixClient().obixRead(new Uri(string));
        return this.result(obj);
    }

    private final Uri normalize(Obj obj, Uri uri) {
        if (uri == null || uri.get().equals("")) {
            return null;
        }
        if (obj == null) {
            return uri;
        }
        Uri uri2 = obj.getRoot().getHref();
        if (uri2 == null || uri2.get().equals("")) {
            return uri;
        }
        return uri.normalize(uri2);
    }

    private final BObixPointDiscoveryResult result(Obj obj) throws Exception {
        Uri uri;
        Obj[] objArray;
        BObixPointDiscoveryResult bObixPointDiscoveryResult = new BObixPointDiscoveryResult();
        BObixClient bObixClient = this.ext.getObixClient();
        bObixPointDiscoveryResult.setHref(bObixClient.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            bObixPointDiscoveryResult.setObixName(obj.getName());
        } else if (obj.is(lobby)) {
            bObixPointDiscoveryResult.setObixName("lobby");
        }
        BFacets bFacets = BFacets.DEFAULT;
        if (obj.isVal()) {
            if (obj.isBool()) {
                bFacets = BFacets.makeBoolean();
                objArray = (Obj[])obj;
                bObixPointDiscoveryResult.setValue((BValue)BBoolean.make((boolean)objArray.get()));
            } else if (obj.isReal()) {
                bFacets = BFacets.makeNumeric();
                objArray = (Real)obj;
                bObixPointDiscoveryResult.setValue((BValue)BDouble.make((double)objArray.get()));
            } else if (obj.isInt()) {
                bFacets = BFacets.makeInt();
                objArray = (Int)obj;
                bObixPointDiscoveryResult.setValue((BValue)BDouble.make((double)objArray.get()));
            } else if (obj.isEnum()) {
                bFacets = BFacets.makeEnum();
                objArray = (Enum)obj;
                uri = this.normalize((Obj)objArray, objArray.getRange());
                try {
                    if (uri == null) {
                        bObixPointDiscoveryResult.setValue((BValue)BString.make((String)objArray.get()));
                    }
                    BEnumRange bEnumRange = bObixClient.makeEnumRange(uri);
                    bObixPointDiscoveryResult.setValue((BValue)bEnumRange.get(SlotPath.escape((String)objArray.get())));
                    bFacets = BFacets.make((BFacets)bFacets, (String)"range", (BIDataValue)bEnumRange);
                }
                catch (Exception exception) {
                    try {
                        int n = Integer.parseInt(objArray.get());
                        bObixPointDiscoveryResult.setValue((BValue)BDynamicEnum.make((int)n));
                    }
                    catch (Exception exception2) {
                        throw exception;
                    }
                }
            } else if (obj.isReltime()) {
                bFacets = BFacets.makeNumeric();
                objArray = (Reltime)obj;
                bObixPointDiscoveryResult.setValue((BValue)BDouble.make((double)objArray.get()));
                bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond"));
            } else {
                objArray = (Val)obj;
                bObixPointDiscoveryResult.setValue((BValue)BString.make((String)objArray.encodeVal()));
            }
            if (obj.isWritable()) {
                bObixPointDiscoveryResult.setMode(BReadWriteMode.readWrite);
            } else {
                bObixPointDiscoveryResult.setMode(BReadWriteMode.readonly);
            }
        }
        if (obj.getIs() != null) {
            bObixPointDiscoveryResult.setIs(obj.getIs().toString());
        }
        bFacets = BObixProxyExt.makeFacets(bFacets, obj, bObixClient);
        bObixPointDiscoveryResult.setFacets(bFacets);
        if (obj.isWritable()) {
            bObixPointDiscoveryResult.setMode(BReadWriteMode.readWrite);
        } else if (bFacets.gets("writeOp", null) != null) {
            bObixPointDiscoveryResult.setMode(BReadWriteMode.readWrite);
        } else {
            bObixPointDiscoveryResult.setMode(BReadWriteMode.readonly);
        }
        objArray = obj.list();
        uri = bObixPointDiscoveryResult.getKids();
        int n = 0;
        while (n < objArray.length) {
            if (!objArray[n].isOp() && !objArray[n].isFeed()) {
                Object object;
                String string = objArray[n].getName();
                if (string == null || string.equals("")) {
                    string = objArray[n].getDisplayName();
                }
                if (string == null || string.equals("")) {
                    object = objArray[n].getIs();
                    string = object != null && object.contains(lobby) ? "lobby" : objArray[n].getElement();
                }
                string = SlotPath.escape((String)string);
                string = string + '?';
                if (objArray[n].isRef()) {
                    if (this.checkAddRef(objArray[n])) {
                        uri.add(string, (BValue)BString.make((String)objArray[n].getNormalizedHref().get()));
                    }
                } else if (objArray[n].getHref() != null && this.checkAddResult((BObixPointDiscoveryResult)((Object)(object = this.result(objArray[n]))), objArray[n])) {
                    uri.add(string, (BValue)object);
                }
            }
            ++n;
        }
        return bObixPointDiscoveryResult;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BObixPointDiscoveryJob() {
    }

    public BObixPointDiscoveryJob(BObixPointDeviceExt bObixPointDeviceExt, BValue bValue) {
        super(bObixPointDeviceExt.getObixNetwork());
        this.ext = bObixPointDeviceExt;
        this.uri = bValue;
    }

    static {
        Class clazz = class$com$tridium$obix$driver$point$BObixPointDiscoveryJob;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$point$BObixPointDiscoveryJob = BObixPointDiscoveryJob.class("[Lcom.tridium.obix.driver.point.BObixPointDiscoveryJob;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        lobby = new Uri("obix:Lobby");
    }
}

