/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.point;

import com.tridium.obix.driver.point.BObixPointDiscoveryJob;
import com.tridium.obix.driver.point.BObixPointFolder;
import com.tridium.obix.driver.point.BObixProxyExt;
import com.tridium.obix.driver.util.BObixSubscription;
import com.tridium.util.ComponentTreeCursor;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ErrException;
import obix.net.ObixSession;
import obix.net.SessionWatch;
import obix.net.WatchListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixPointDeviceExt
extends BPointDeviceExt
implements WatchListener {
    public static final Property watchInterval = BObixPointDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)2000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property watchUri = BObixPointDeviceExt.newProperty((int)1, (String)"", null);
    public static final Property debugWatch = BObixPointDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action getClient = BObixPointDeviceExt.newAction((int)4, null);
    public static final Action read = BObixPointDeviceExt.newAction((int)20, null);
    public static final Action submitPointDiscoveryJob = BObixPointDeviceExt.newAction((int)4, null);
    public static final Action subscribe = BObixPointDeviceExt.newAction((int)20, null);
    public static final Action refreshWatch = BObixPointDeviceExt.newAction((int)16, null);
    public static final Action forceUpdate = BObixPointDeviceExt.newAction((int)24, null);
    public static final Action write = BObixPointDeviceExt.newAction((int)20, null);
    public static final Type TYPE;
    public static final double REFRESH_SAFETY_FACTOR = 0.75;
    private boolean attached;
    private boolean batchWorks;
    private ObixEncoder debugger;
    private Log log;
    private Object mutexRead;
    private Object mutexSubscribe;
    private Object mutexUnsubscribe;
    private Object mutexWrite;
    private Object mutexWatch;
    private TreeMap pendingRead;
    private ArrayList pendingSubscribe;
    private TreeMap pendingUnsubscribe;
    private TreeMap pendingWrite;
    private boolean reading;
    private boolean subscribing;
    private SortedMap subscriptions;
    private SessionWatch watch;
    private Log sublog;
    Clock.Ticket refreshTicket;
    private long refreshPeriod;
    static /* synthetic */ Class class$com$tridium$obix$driver$point$BObixPointDeviceExt;
    static /* synthetic */ Class class$com$tridium$obix$driver$point$BObixProxyExt;

    public BRelTime getWatchInterval() {
        return (BRelTime)this.get(watchInterval);
    }

    public void setWatchInterval(BRelTime bRelTime) {
        this.set(watchInterval, (BValue)bRelTime, null);
    }

    public String getWatchUri() {
        return this.getString(watchUri);
    }

    public void setWatchUri(String string) {
        this.setString(watchUri, string, null);
    }

    public boolean getDebugWatch() {
        return this.getBoolean(debugWatch);
    }

    public void setDebugWatch(boolean bl) {
        this.setBoolean(debugWatch, bl, null);
    }

    public BOrd getClient() {
        return (BOrd)this.invoke(getClient, null, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    public void refreshWatch() {
        this.invoke(refreshWatch, null, null);
    }

    public void forceUpdate() {
        this.invoke(forceUpdate, null, null);
    }

    public void write() {
        this.invoke(write, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void attach() {
        this.attached = true;
        this.subscribe();
        this.read();
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (!property.equals((Object)watchInterval)) return;
        try {
            Object object = this.mutexWatch;
            synchronized (object) {
                if (this.watch == null) return;
                long l = this.getWatchInterval().getMillis();
                long l2 = this.watch.getLease();
                long l3 = Math.max(l * (long)2, l2 + this.getObixClient().getWatchSafetyFactor().getMillis());
                this.watch.setLease(l3);
                this.watch.setPollPeriod(l);
                return;
            }
        }
        catch (Exception exception) {
            throw new LocalizableRuntimeException("obix", "Invalid watch interval:" + this.getWatchInterval(), (Throwable)exception);
        }
    }

    public void changed(Obj obj) {
        this.debug(obj);
        Uri uri = obj.getHref();
        if (uri == null) {
            return;
        }
        String string = uri.get();
        BObixProxyExt bObixProxyExt = (BObixProxyExt)this.subscriptions.get(string);
        if (bObixProxyExt != null) {
            bObixProxyExt.readOk(obj);
        } else {
            this.getLog().warning("No recipient for " + string + '(' + obj.toDisplayString() + ')');
        }
        this.getObixClient().pingOk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closed(SessionWatch sessionWatch) {
        Object object = this.mutexWatch;
        synchronized (object) {
            if (sessionWatch == this.watch) {
                this.watch = null;
                this.setWatchUri("");
                this.getLog().message("Watch closed " + sessionWatch.getWatchObj().getHref().get() + " on " + this.thd());
                BObixClient bObixClient = this.getObixClient();
                bObixClient.doPing();
                if (bObixClient.getState().isEngaged()) {
                    ArrayList arrayList = new ArrayList(this.subscriptions.values());
                    this.detach();
                    Object object2 = this.mutexSubscribe;
                    synchronized (object2) {
                        Iterator iterator = arrayList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                this.pendingSubscribe.addAll(arrayList);
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 6, 7, 8, 10] lbl21 : MonitorExitStatement: MONITOREXIT : var6_5
                                this.attach();
                                break;
                            }
                            ((BObixProxyExt)iterator.next()).setSubscription(BObixSubscription.pending);
                        }
                    }
                }
            } else {
                this.getLog().warning("Unknown watch closed " + sessionWatch.getWatchObj().getHref().get());
            }
            return;
        }
    }

    public void detach() {
        this.detach(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void detach(boolean bl) {
        Object object;
        block14: {
            if (this.sublog.isTraceOn()) {
                this.sublog.trace("detach(" + bl + ") on Points in " + (Object)((Object)this.getObixClient()) + ":: kill watch " + this.watch, new Throwable());
            }
            object = this.mutexSubscribe;
            synchronized (object) {
                block13: {
                    if (!bl) break block13;
                    ArrayList arrayList = new ArrayList(this.subscriptions.values());
                    Iterator iterator = arrayList.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.pendingSubscribe.addAll(arrayList);
                            break block14;
                        }
                        ((BObixProxyExt)iterator.next()).setSubscription(BObixSubscription.pending);
                    }
                }
                this.pendingSubscribe.clear();
            }
        }
        this.subscriptions.clear();
        object = this.mutexRead;
        synchronized (object) {
            this.pendingRead.clear();
        }
        object = this.mutexWatch;
        synchronized (object) {
            if (this.watch != null) {
                this.watch.delete();
                this.watch = null;
                this.refreshTicket.cancel();
                this.refreshPeriod = 3600000L;
                this.setWatchUri("");
            }
            // MONITOREXIT @DISABLED, blocks:[2, 5] lbl41 : MonitorExitStatement: MONITOREXIT : var2_2
            this.attached = false;
            return;
        }
    }

    public void doDumpSubs() {
        this.doDumpSubs(null, null);
    }

    public BOrd doGetClient() {
        return this.getObixClient().getSlotPathOrd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRead() {
        Object object = this.mutexRead;
        synchronized (object) {
            if (this.reading) {
                return;
            }
            if (!this.isRunning()) {
                return;
            }
            if (!this.attached) {
                return;
            }
            this.reading = true;
        }
        try {
            this.performRead();
            Object var2_4 = null;
            this.reading = false;
            if (this.pendingRead.size() <= 0) return;
            this.read();
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.reading = false;
            if (this.pendingRead.size() <= 0) throw throwable;
            this.read();
            throw throwable;
        }
    }

    public BOrd doSubmitPointDiscoveryJob(Context context) {
        return new BObixPointDiscoveryJob(this, this.getObixClient().get("lobby")).submit(context);
    }

    /*
     * Exception decompiling
     */
    public void doSubscribe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [4 : 108->145)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public void doForceUpdate() {
        var1_1 = new ComponentTreeCursor((BComponent)this, null);
        if (true) ** GOTO lbl6
        do {
            var2_2 = (BObixProxyExt)var1_1.get();
            var2_2.doForceUpdate();
lbl6:
            // 2 sources

            if ((v0 = BObixPointDeviceExt.class$com$tridium$obix$driver$point$BObixProxyExt) != null) continue;
            v0 = BObixPointDeviceExt.class("[Lcom.tridium.obix.driver.point.BObixProxyExt;", false);
        } while (var1_1.next(v0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRefreshWatch() {
        Object object = this.mutexWatch;
        synchronized (object) {
            block9: {
                if (this.watch == null) break block9;
                try {
                    if (this.getLog().isTraceOn()) {
                        this.getLog().trace("refreshWatch! " + Clock.time().toString((Context)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE)));
                    }
                    this.watch.pollRefresh();
                    if (this.subscriptions.size() <= 0) break block9;
                    long l = Long.MAX_VALUE;
                    Iterator iterator = this.subscriptions.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (l != Long.MAX_VALUE) break;
                            this.refreshTicket.cancel();
                            break block9;
                        }
                        long l2 = ((BObixProxyExt)iterator.next()).getTuningPolicy().getStaleTime().getMillis();
                        if (l2 <= 0L || l2 >= l) continue;
                        l = l2;
                    }
                    if ((long)((double)l * 0.75) > this.refreshPeriod) {
                        this.refreshPeriod = (long)((double)l * 0.75);
                        this.scheduleRefresh();
                    }
                }
                catch (Exception exception) {
                    this.getLog().message("Watch Poll Refresh failed on " + (Object)((Object)this) + " in " + (Object)((Object)this.getObixClient()), (Throwable)exception);
                }
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void doWrite() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 46->50)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getParent();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public Log getLog() {
        if (this.log == null) {
            try {
                this.log = Log.getLog((String)(this.getObixClient().getLog().getLogName() + "-Points"));
            }
            catch (Exception exception) {
                this.log = this.getObixClient().getLog();
            }
        }
        return this.log;
    }

    public Type getPointFolderType() {
        return BObixPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BObixProxyExt.TYPE;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (this.sublog.isTraceOn()) {
            System.out.println("### post(" + action + ") on " + this.thd());
        }
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(BObixProxyExt bObixProxyExt) {
        Object object = this.mutexRead;
        synchronized (object) {
            this.pendingRead.put(bObixProxyExt.getHref(), bObixProxyExt);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            this.read();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(BObixProxyExt bObixProxyExt, Context context) {
        if (this.sublog.isTraceOn()) {
            System.out.println("s1+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
        this.updateRefreshPeriod(bObixProxyExt.getTuningPolicy().getStaleTime());
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.add(bObixProxyExt);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
            this.subscribe();
        }
        if (this.sublog.isTraceOn()) {
            System.out.println("s1-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unsubscribe(String string, BObixProxyExt bObixProxyExt, Context context) {
        if (this.sublog.isTraceOn()) {
            System.out.println("u1+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            this.pendingUnsubscribe.put(string, bObixProxyExt);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var4_4
            this.subscribe();
        }
        if (this.sublog.isTraceOn()) {
            System.out.println("u1-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
    }

    public void updateRefreshPeriod(BRelTime bRelTime) {
        if (bRelTime == null) {
            return;
        }
        long l = (long)((double)bRelTime.getMillis() * 0.75);
        if (l == 0L) {
            return;
        }
        if (l < this.refreshPeriod) {
            this.refreshPeriod = l;
        }
    }

    private final void scheduleRefresh() {
        if (!this.isRunning()) {
            return;
        }
        if (this.refreshPeriod > 0L) {
            this.refreshTicket.cancel();
            this.refreshTicket = Clock.schedulePeriodically((BComponent)this, (BAbsTime)BAbsTime.now(), (BRelTime)BRelTime.make((long)this.refreshPeriod), (Action)refreshWatch, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(BObixProxyExt bObixProxyExt, Context context) {
        Object object = this.mutexWrite;
        synchronized (object) {
            this.pendingWrite.put(bObixProxyExt.getHref(), bObixProxyExt);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var3_3
            this.write();
            return;
        }
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        spyWriter.startProps("ObixPointDeviceExt");
        spyWriter.prop((Object)"attached", this.attached);
        spyWriter.prop((Object)"batchWorks", this.batchWorks);
        spyWriter.prop((Object)"watch", (Object)this.watch);
        if (this.watch != null) {
            this.spy(this.watch, spyWriter);
        }
        spyWriter.prop((Object)"reading", this.reading);
        spyWriter.prop((Object)"subscribing", this.subscribing);
        spyWriter.prop((Object)"pendingRead", this.pendingRead.size());
        spyWriter.prop((Object)"pendingSubscribe", this.pendingSubscribe.size());
        spyWriter.prop((Object)"pendingUnsubscribe", this.pendingUnsubscribe.size());
        spyWriter.prop((Object)"pendingWrite", this.pendingWrite.size());
        spyWriter.prop((Object)"subscriptions", this.subscriptions.size());
        spyWriter.prop((Object)"refreshTicket", (Object)this.refreshTicket);
        spyWriter.prop((Object)"refreshPeriod", (double)this.refreshPeriod);
        spyWriter.endProps();
        super.spy(spyWriter);
    }

    public void started() throws Exception {
        super.started();
        try {
            this.sublog = Log.getLog((String)(this.getObixClient().getLog().getLogName() + "-Subscription"));
        }
        catch (Exception exception) {
            this.sublog = Log.getLog((String)"obix.subscription");
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.refreshTicket.cancel();
    }

    protected Obj getForceObj(Obj obj) {
        return obj;
    }

    protected Uri getFullNormalizedHref(Op op, Obj obj) {
        if (op == null || op.getHref() == null) {
            return null;
        }
        return op.getNormalizedHref();
    }

    protected BRelTime getRefreshPeriod() {
        return BRelTime.make((long)this.refreshPeriod);
    }

    /*
     * Exception decompiling
     */
    protected void performRead() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [1 : 15->43)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSubscribe() {
        block31: {
            block32: {
                block29: {
                    var1_1 = null;
                    if (this.sublog.isTraceOn()) {
                        System.out.println("ps+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
                    }
                    this.scheduleRefresh();
                    var2_2 = this.mutexSubscribe;
                    synchronized (var2_2) {
                        if (this.pendingSubscribe.size() > 0) {
                            var1_1 = this.pendingSubscribe;
                            this.pendingSubscribe = new ArrayList<E>();
                        }
                    }
                    if (this.sublog.isTraceOn()) {
                        var4_3 = "sub0:--";
                        if (var1_1 != null && var1_1.size() > 0) {
                            var4_3 = "sub0:" + (Object)((BObixProxyExt)var1_1.get(0)).getSubscription();
                        }
                        v1 = new StringBuffer("### performSubscribe after mutexSub: pSub=");
                        v2 = 0;
                        if (var1_1 != null) {
                            v2 = var1_1.size();
                        }
                        System.out.println(v1.append(v2).append("; w=").append(this.watch).append(" w.s=").append(this.watch != null ? "" + this.watch.getSession() : "null").append((String)var4_3).append(" on ").append(this.thd()).toString());
                    }
                    if (var1_1 == null) break block31;
                    var4_3 = this.mutexWatch;
                    synchronized (var4_3) {
                        if (this.watch != null && this.watch.getSession() != null) break block29;
                        ** try [egrp 2[TRYBLOCK] [3 : 348->474)] { 
lbl29:
                        // 1 sources

                        {
                            var6_4 = this.getWatchInterval().getMillis();
                            this.watch = this.getObixClient().makeWatch(this.getName(), var6_4, this);
                            var8_7 = this.watch.getLease();
                            var10_10 = Math.max(var6_4 * (long)2, var8_7 + this.getObixClient().getWatchSafetyFactor().getMillis());
                            this.watch.setLease(var10_10);
                            this.watch.setPollPeriod(var6_4);
                            this.setWatchUri(this.watch.getWatchObj().getHref().get());
                            this.getLog().message("Watch created " + this.getWatchUri());
                        }
lbl43:
                        // 1 sources

                        catch (Exception var6_5) {
                            this.getLog().error("Watch creation failed", (Throwable)var6_5);
                        }
                    }
                }
                var6_6 = null;
                var7_11 = var1_1.iterator();
                var4_3 = this.mutexWatch;
                synchronized (var4_3) {
                    block30: {
                        if (this.watch != null) break block30;
                        while (var7_11.hasNext()) {
                            var6_6 = (BObixProxyExt)var7_11.next();
                            if (!var6_6.getSubscription().isPending()) continue;
                            var6_6.subscribeFailTryPolling("Could not create watch");
                        }
                        break block32;
                    }
                    try {
                        while (var7_11.hasNext()) {
                            var6_6 = (BObixProxyExt)var7_11.next();
                            var8_8 = (BObixProxyExt)this.subscriptions.get(var6_6.getHref());
                            if (var8_8 != null && var8_8 != var6_6) {
                                var6_6.subscribeFail("Href already subscribed by " + var8_8.toPathString());
                                continue;
                            }
                            try {
                                if (!var6_6.getSubscription().isPending()) continue;
                                var9_12 = this.watch.add(new Uri(var6_6.getHref()));
                                this.getObixClient().pingOk();
                                if (var9_12.isErr()) {
                                    var6_6.subscribeFail(ObixEncoder.toString((Obj)var9_12));
                                    this.subscriptions.remove(var6_6.getHref());
                                    this.retrySubscribe(var6_6, var7_11);
                                }
                                this.subscriptions.put(var9_12.getHref().get(), var6_6);
                                var6_6.subscribeOk();
                                var6_6.readOk(var9_12);
                            }
                            catch (ErrException var9_13) {
                                if (var9_13.err.getHref().get().equals(var6_6.getHref())) {
                                    var6_6.subscribeFail(var9_13.getMessage());
                                    this.subscriptions.remove(var6_6.getHref());
                                    continue;
                                }
                                var6_6.subscribeFail(var9_13.getMessage());
                                if (this.sublog.isTraceOn()) {
                                    this.doDumpSubs("tmp", var1_1);
                                }
                                this.subscriptions.remove(var6_6.getHref());
                                this.retrySubscribe(var6_6, var7_11);
                            }
                            catch (Exception var9_14) {
                                var6_6.subscribeFail(var9_14.toString());
                                if (this.sublog.isTraceOn()) {
                                    this.doDumpSubs("tmp", var1_1);
                                }
                                this.subscriptions.remove(var6_6.getHref());
                                this.getLog().error("Error Subscribing " + var6_6.toPathString() + ": watch=" + this.watch + " w.session=" + (this.watch != null ? "" + this.watch.getSession() : "null") + " on thd " + this.thd());
                                if (this.watch != null && this.watch.getSession() != null) continue;
                                this.retrySubscribe(var6_6, var7_11);
                            }
                        }
                    }
                    catch (Exception var8_9) {
                        if (var6_6 == null) ** GOTO lbl114
                        this.subscriptions.remove(var6_6.getHref());
                        var6_6.subscribeFail(var8_9.toString());
                        this.getLog().error("Subscribing " + var6_6.toPathString(), (Throwable)var8_9);
                    }
                }
            }
            var1_1 = null;
        }
        if (this.sublog.isTraceOn()) {
            System.out.println("ps-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performUnsubscribe() {
        TreeMap treeMap = null;
        if (this.sublog.isTraceOn()) {
            System.out.println("pu+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            if (this.pendingUnsubscribe.size() > 0) {
                treeMap = this.pendingUnsubscribe;
                this.pendingUnsubscribe = new TreeMap();
            }
        }
        if (this.sublog.isTraceOn()) {
            StringBuffer stringBuffer = new StringBuffer("### performUnsubscribe after mutexUnsub: pUnsub=");
            int n = 0;
            if (treeMap != null) {
                n = treeMap.size();
            }
            System.out.println(stringBuffer.append(n).append("; w=").append(this.watch).append(" w.s=").append(this.watch != null ? "" + this.watch.getSession() : "null").append(" on ").append(this.thd()).toString());
        }
        if (treeMap != null) {
            Object object2;
            Object[] objectArray;
            Vector<Uri> vector = new Vector<Uri>(treeMap.size());
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                objectArray = (Object[])iterator.next();
                object2 = (BObixProxyExt)treeMap.get(objectArray);
                if (this.subscriptions.get(objectArray) != object2) continue;
                vector.addElement(new Uri((String)objectArray));
            }
            if (vector.size() == 0) {
                return;
            }
            objectArray = new Uri[vector.size()];
            vector.copyInto(objectArray);
            object2 = this.mutexWatch;
            synchronized (object2) {
                if (this.watch != null) {
                    try {
                        this.watch.remove((Uri[])objectArray);
                    }
                    catch (Exception exception) {}
                }
            }
            int n = objectArray.length;
            while (--n >= 0) {
                this.subscriptions.remove(objectArray[n].get());
            }
            treeMap = null;
        }
        if (this.sublog.isTraceOn()) {
            System.out.println("pu-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performWrite() {
        BatchIn batchIn;
        TreeMap treeMap;
        block8: {
            treeMap = null;
            Object object = this.mutexWrite;
            synchronized (object) {
                if (this.pendingWrite.size() > 0) {
                    treeMap = this.pendingWrite;
                    this.pendingWrite = new TreeMap();
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                if (treeMap == null) return;
                batchIn = null;
                if (!this.batchWorks) break block8;
            }
            try {
                batchIn = this.getObixClient().makeBatch();
            }
            catch (Exception exception) {
                this.getLog().error(this.toPathString() + " batch failure", (Throwable)exception);
                this.batchWorks = false;
            }
        }
        if (batchIn != null) {
            this.write(treeMap, batchIn);
            return;
        } else {
            this.write(treeMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void retrySubscribe(BObixProxyExt var1_1, Iterator var2_2) {
        if (this.sublog.isTraceOn()) {
            System.out.println("es+:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.watch + '\t' + this.thd());
        }
        var3_3 = this.mutexSubscribe;
        synchronized (var3_3) {
            this.pendingSubscribe.add(var1_1);
            while (true) {
                if (!var2_2.hasNext()) {
                    this.pendingSubscribe.addAll(this.subscriptions.values());
                    break;
                }
                var1_1 = (BObixProxyExt)var2_2.next();
                this.pendingSubscribe.add(var1_1);
            }
        }
        var3_3 = this.mutexWatch;
        synchronized (var3_3) {
            block12: {
                if (this.watch == null || this.watch.getSession() == null) break block12;
                ** try [egrp 2[TRYBLOCK] [3 : 209->219)] { 
lbl25:
                // 1 sources

                {
                    this.watch.delete();
                }
lbl30:
                // 1 sources

                catch (Exception v2) {}
            }
            this.watch = null;
            this.refreshTicket.cancel();
            this.refreshPeriod = 3600000L;
            this.setWatchUri("");
            ** if (!this.sublog.isTraceOn()) goto lbl38
        }
lbl-1000:
        // 1 sources

        {
            System.out.println("es-:" + this.subscribing + '\t' + this.pendingSubscribe.size() + '\t' + this.pendingUnsubscribe.size() + '\t' + this.subscriptions.size() + '\t' + this.thd());
        }
lbl38:
        // 2 sources

    }

    private final void debug(Obj obj) {
        if (!this.getDebugWatch()) {
            return;
        }
        try {
            if (this.debugger == null) {
                this.debugger = new ObixEncoder((OutputStream)System.out);
            }
            System.out.println(this.toPathString() + " Points:");
            this.debugger.encode(obj);
            this.debugger.flush();
        }
        catch (Exception exception) {}
    }

    private final void doDumpSubs(String string, Collection collection) {
        System.out.println("pendingSubscribe:" + this.pendingSubscribe.size());
        System.out.println("pendingUnsubscribe:" + this.pendingUnsubscribe.size());
        System.out.println("pendingRead:" + this.pendingRead.size());
        System.out.println("pendingWrite:" + this.pendingWrite.size());
        System.out.println("subscriptions:" + this.subscriptions.size());
        if (collection != null) {
            System.out.println(string + ':' + collection.size());
        }
    }

    private final void spy(SessionWatch sessionWatch, SpyWriter spyWriter) {
        spyWriter.prop((Object)"  w.size", sessionWatch.size());
        ObixSession obixSession = sessionWatch.getSession();
        spyWriter.prop((Object)"  w.session", (Object)obixSession);
        spyWriter.prop((Object)"  w.watchObj", (Object)sessionWatch.getWatchObj().getHref());
        spyWriter.prop((Object)"  w.lease", (Object)String.valueOf(sessionWatch.getLease()));
        spyWriter.prop((Object)"  w.pollPeriod", (Object)String.valueOf(sessionWatch.getPollPeriod()));
        spyWriter.prop((Object)"  w.lastAttempt", (Object)String.valueOf(sessionWatch.lastPollAttempt()));
        spyWriter.prop((Object)"  w.lastSuccess", (Object)String.valueOf(sessionWatch.lastPollSuccess()));
    }

    private final void write(TreeMap treeMap) {
        Iterator iterator = treeMap.values().iterator();
        BObixProxyExt bObixProxyExt = null;
        while (iterator.hasNext()) {
            bObixProxyExt = (BObixProxyExt)iterator.next();
            try {
                bObixProxyExt.performWrite();
            }
            catch (Exception exception) {
                this.getLog().error("Write failed: " + bObixProxyExt.toPathString(), (Throwable)exception);
                bObixProxyExt.writeFail(exception.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void write(TreeMap var1_1, BatchIn var2_2) {
        block7: {
            var3_3 = var1_1.values().iterator();
            var4_4 = null;
            while (var3_3.hasNext()) {
                var4_4 = (BObixProxyExt)var3_3.next();
                var4_4.batchWrite(var2_2);
            }
            var5_5 = null;
            try {
                if (this.getObixClient().getDebugRequests()) {
                    var2_2.dump();
                }
                var6_6 = var2_2.commit();
                if (this.getObixClient().getDebugResponses()) {
                    var6_6.dump();
                }
                var5_5 = var6_6.list();
                break block7;
            }
            catch (Exception var6_7) {
                var7_9 = var6_7.toString();
                var3_3 = var1_1.values().iterator();
                ** while (var3_3.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                var4_4 = (BObixProxyExt)var3_3.next();
                var4_4.writeFail(var7_9);
                continue;
            }
lbl23:
            // 1 sources

            return;
        }
        var6_8 = var5_5.length;
        var3_3 = var1_1.values().iterator();
        var7_10 = 0;
        while (var7_10 < var6_8) {
            var4_4 = (BObixProxyExt)var3_3.next();
            var4_4.batchWriteResult(var5_5[var7_10]);
            ++var7_10;
        }
    }

    private final String thd() {
        return Thread.currentThread().getName();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.attached = false;
        this.batchWorks = true;
        this.debugger = null;
        this.log = null;
        this.mutexRead = new Object();
        this.mutexSubscribe = new Object();
        this.mutexUnsubscribe = new Object();
        this.mutexWrite = new Object();
        this.mutexWatch = new Object();
        this.pendingRead = new TreeMap();
        this.pendingSubscribe = new ArrayList();
        this.pendingUnsubscribe = new TreeMap();
        this.pendingWrite = new TreeMap();
        this.reading = false;
        this.subscribing = false;
        this.subscriptions = Collections.synchronizedSortedMap(new TreeMap());
        this.watch = null;
        this.sublog = null;
        this.refreshTicket = Clock.expiredTicket;
        this.refreshPeriod = 3600000L;
    }

    public BObixPointDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$point$BObixPointDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$point$BObixPointDeviceExt = BObixPointDeviceExt.class("[Lcom.tridium.obix.driver.point.BObixPointDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

