/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.history;

import com.tridium.history.SchemaChangeException;
import com.tridium.obix.driver.history.ArchiveInvocation;
import com.tridium.obix.driver.history.BObixHistoryDeviceExt;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BDescriptor;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BBooleanTrendRecord;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.log.Log;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.IFuture;
import obix.Abstime;
import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Str;
import obix.Uri;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixHistoryImport
extends BHistoryImport
implements BIStatus {
    public static final Property href = BObixHistoryImport.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    private BObixHistoryDeviceExt deviceExt;
    private boolean firstExecute;
    private boolean licenseChecked;
    private boolean fatalFault;
    private String fatalFaultCause;
    private String recordInfo;
    static /* synthetic */ Class class$com$tridium$obix$driver$history$BObixHistoryImport;

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String string) {
        this.setString(href, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void atSteadyState() throws Exception {
        super.atSteadyState();
        if (!this.isDisabled()) {
            this.getObixNetwork().enqueue(new Runnable(){

                public final void run() {
                    BObixHistoryImport.this.checkObixLicense();
                }
            });
        }
        this.hImportAtSteadyState();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)enabled) && !this.isDisabled()) {
            this.checkObixLicense();
        }
    }

    public void doExecute() {
        block38: {
            if (this.fatalFault) {
                this.executeFail(this.fatalFaultCause);
                return;
            }
            if (this.getHistoryId().isNull()) {
                this.executeFail("History id is null.");
                return;
            }
            this.executeInProgress();
            Str str = new Str("empty");
            try {
                String string;
                String string2;
                BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryDatabase bHistoryDatabase = bHistoryService.getDatabase();
                if (bHistoryDatabase == null) {
                    this.executeFail("Local history database not available.");
                    return;
                }
                BHistoryId bHistoryId = this.getHistoryId().fromShorthand(this.getObixClient().getName());
                BIHistory bIHistory = null;
                BAbsTime bAbsTime = null;
                if (bHistoryDatabase.exists(bHistoryId)) {
                    bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                    bAbsTime = bIHistory.getLastTimestamp();
                }
                Obj obj = new Obj();
                String string3 = this.getHref();
                if (!string3.endsWith("/")) {
                    string3 = string3 + '/';
                }
                obj.setIs(new Contract("obix:HistoryFilter"));
                if (bAbsTime != null) {
                    obj.add((Obj)new Abstime("start", bAbsTime.getMillis() + 1L));
                }
                if (!(string2 = (str = this.getObixClient().obixInvoke(new Uri(string3), obj)).getHref().getPath()).equals("/") && !str.getHref().getPath().endsWith(string3)) {
                    this.getLog().trace("Mismatch: returned href [" + str.getHref().getPath() + "] doesn't equal requested href [" + string3 + "]\n");
                    this.executeFail("Mismatch: respHref != reqHref");
                    return;
                }
                Obj obj2 = str.get("recInfo");
                String string4 = string = obj2 != null ? obj2.getStr() : null;
                if (this.recordInfo != null && !string.equals(this.recordInfo)) {
                    this.getLog().trace("Record type mismatch on " + (Object)((Object)this) + " (id=" + bHistoryId + ") [" + this.getHref() + "]: Incoming record info " + string + " does not match current record info " + this.recordInfo);
                    this.executeFail("Record Type mismatch");
                    this.recordInfo = string;
                    return;
                }
                this.recordInfo = string;
                Obj obj3 = str.get("data");
                Obj[] objArray = obj3.list();
                int n = objArray.length;
                if (objArray == null || n == 0) {
                    this.executeOk();
                    return;
                }
                BHistoryConfig bHistoryConfig = new BHistoryConfig();
                bHistoryConfig.setId(bHistoryId);
                this.updateConfig((Obj)str, bHistoryConfig);
                BFacets bFacets = (BFacets)this.getConfigOverrides().get("valueFacets");
                if (this.firstExecute) {
                    this.firstExecute = false;
                    if (bFacets != null) {
                        BFacets bFacets2;
                        String string5 = bFacets.gets("boolUri", null);
                        if (string5 != null && (bFacets2 = this.getObixClient().makeBoolRange(new Uri(string5))) != null) {
                            bFacets = BFacets.make((BFacets)bFacets, (BFacets)bFacets2);
                        }
                        if ((string5 = bFacets.gets("enumUri", null)) != null && (bFacets2 = this.getObixClient().makeEnumRange(new Uri(string5))) != null) {
                            bFacets = BFacets.make((BFacets)bFacets, (String)"range", (BIDataValue)bFacets2);
                        }
                        if ((string5 = bFacets.gets("unitsUri", null)) != null && (bFacets2 = this.getObixClient().makeUnits(new Uri(string5))) != null) {
                            bFacets = BFacets.make((BFacets)bFacets, (String)"units", (BIDataValue)bFacets2);
                        }
                    }
                    this.getConfigOverrides().set("valueFacets", (BValue)bFacets);
                }
                bHistoryConfig = this.makeLocalConfig(bHistoryConfig);
                if (bIHistory == null) {
                    try {
                        this.getLog().trace("Creating db history for href " + this.getHref() + " with config:" + bHistoryConfig + " {id=" + bHistoryConfig.getId() + "; rectype=" + bHistoryConfig.getRecordType() + "; schema=" + bHistoryConfig.getSchema() + '}');
                        try {
                            this.getLog().trace("current config type:" + bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getRecordType() + " schema=" + bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getSchema());
                        }
                        catch (Exception exception) {
                            this.getLog().trace("Cannot show old config type:" + exception);
                        }
                        try {
                            this.getLog().trace("new config type:" + bHistoryConfig.getRecordType() + "; schema=" + bHistoryConfig.getSchema());
                        }
                        catch (Exception exception) {
                            this.getLog().trace("Cannot show old config type:" + exception);
                        }
                        bHistoryDatabase.createHistory(bHistoryConfig);
                        bIHistory = bHistoryDatabase.getHistory(bHistoryId);
                    }
                    catch (SchemaChangeException schemaChangeException) {
                        this.getLog().trace("SchemaChangeException for href " + this.getHref() + " [id=" + this.getHistoryId() + ']' + (Object)((Object)schemaChangeException), (Throwable)schemaChangeException);
                        try {
                            this.getLog().trace("current config type:" + bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getRecordType() + " schema=" + bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getSchema());
                        }
                        catch (Exception exception) {
                            this.getLog().trace("Cannot show old config type:" + exception);
                        }
                        try {
                            this.getLog().trace("new config type:" + bHistoryConfig.getRecordType() + "; schema=" + bHistoryConfig.getSchema());
                        }
                        catch (Exception exception) {
                            this.getLog().trace("Cannot show old config type:" + exception);
                        }
                        throw schemaChangeException;
                    }
                }
                boolean bl = true;
                try {
                    if (bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getRecordType().equals((Object)bHistoryConfig.getRecordType())) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    this.getLog().trace("Check history config for oBIX history import on " + this.getHref() + ": Could not determine config change:" + exception);
                }
                if (bl && this.getLog().isTraceOn()) {
                    this.getLog().trace("Reconfigure history for href " + this.getHref() + " [id=" + this.getHistoryId() + "]; resp href=" + str.getHref().getPath());
                    this.getLog().trace("response data:" + obj3);
                    obj3.dump();
                    this.getLog().trace("response data:" + obj3);
                    obj3.dump();
                    try {
                        this.getLog().trace("current config type:" + bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getRecordType() + " schema=" + bHistoryDatabase.getHistory(this.getHistoryId()).getConfig().getSchema());
                    }
                    catch (Exception exception) {
                        this.getLog().trace("Cannot show old config type:" + exception);
                    }
                    try {
                        this.getLog().trace("new config type:" + bHistoryConfig.getRecordType() + "; schema=" + bHistoryConfig.getSchema());
                    }
                    catch (Exception exception) {
                        this.getLog().trace("Cannot show old config type:" + exception);
                    }
                }
                bHistoryDatabase.reconfigureHistory(bHistoryConfig);
                BTimeZone bTimeZone = null;
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    Obj obj4 = objArray[n2];
                    BHistoryRecord bHistoryRecord = bHistoryConfig.makeRecord();
                    Abstime abstime = (Abstime)obj4.get("timestamp");
                    if (abstime != null) {
                        if (bTimeZone == null && (bTimeZone = BTimeZone.getTimeZone((String)((TimeZone)(object = abstime.getTimeZone())).getID())) == null) {
                            bTimeZone = BTimeZone.make((String)((TimeZone)object).getID(), (int)((TimeZone)object).getRawOffset());
                        }
                        bHistoryRecord.setTimestamp(BAbsTime.make((long)abstime.getMillis(), bTimeZone));
                    }
                    object = obj4.get("value");
                    BStatusValue bStatusValue = this.getObixClient().makeStatusValue((Obj)object, bFacets);
                    bHistoryRecord.set("status", (BValue)bStatusValue.getStatus());
                    bHistoryRecord.set("value", bStatusValue.getValueValue());
                    bIHistory.append((BIHistoryRecordSet)bHistoryRecord);
                    ++n2;
                }
                this.executeOk();
            }
            catch (Exception exception) {
                this.getLog().error("Error importing history for href " + this.getHref() + " in " + (Object)((Object)this.getObixClient()), (Throwable)exception);
                this.executeFail(exception);
                if (!this.getLog().isTraceOn()) break block38;
                this.getLog().trace("results");
                str.dump();
            }
        }
    }

    public Type getDeviceExtType() {
        return BObixHistoryDeviceExt.TYPE;
    }

    public Log getLog() {
        return this.getObixHistoryDeviceExt().getLog();
    }

    public BObixClient getObixClient() {
        return this.getObixHistoryDeviceExt().getObixClient();
    }

    public BObixHistoryDeviceExt getObixHistoryDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BObixHistoryDeviceExt) {
                this.deviceExt = (BObixHistoryDeviceExt)bComplex;
                return this.deviceExt;
            }
            bComplex = bComplex.getParent();
        }
        throw new IllegalStateException();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action == BDescriptor.execute) {
            if (this.fatalFault || this.isFatalFault() || this.isDisabled()) {
                return null;
            }
            if (this.isDown()) {
                this.executeFail("Device is down");
                return null;
            }
            if (this.getState() != BDescriptorState.idle) {
                return null;
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            return this.postExecute(action, bValue, context);
        }
        return super.post(action, bValue, context);
    }

    public IFuture postExecute(Action action, BValue bValue, Context context) {
        return this.getObixHistoryDeviceExt().post(new ArchiveInvocation(this, action, bValue, context));
    }

    public void stopped() throws Exception {
        this.setStatus(BStatus.down);
        this.deviceExt = null;
        super.stopped();
    }

    protected void hImportAtSteadyState() throws Exception {
    }

    void updateConfig(Obj obj, BHistoryConfig bHistoryConfig) {
        BFacets bFacets;
        Abstime abstime;
        Uri uri;
        List list = (List)obj.get("data");
        Contract contract = list.getOf();
        Obj obj2 = null;
        int n = contract.size();
        while (--n >= 0) {
            uri = contract.get(n);
            if (uri.isResolved() && (obj2 = uri.getResolved().get("value")) != null) break;
        }
        Obj[] objArray = list.list();
        uri = null;
        if (objArray.length > 0) {
            TimeZone timeZone;
            uri = objArray[0];
            abstime = (Abstime)uri.get("timestamp");
            bFacets = null;
            if (abstime != null && (bFacets = BTimeZone.getTimeZone((String)(timeZone = abstime.getTimeZone()).getID())) == null) {
                bFacets = BTimeZone.make((String)timeZone.getID(), (int)timeZone.getRawOffset());
            }
            if (bFacets == null) {
                bFacets = BTimeZone.getLocal();
            }
            bHistoryConfig.setTimeZone((BTimeZone)bFacets);
        }
        if (obj2 == null && uri != null) {
            obj2 = uri.get("value");
        }
        if (obj2 != null) {
            abstime = this.getObixClient().makeFacets(BFacets.DEFAULT, obj2);
            bFacets = (BFacets)this.getConfigOverrides().get("valueFacets");
            if (bFacets == null) {
                this.getConfigOverrides().add("valueFacets", (BValue)abstime);
            } else {
                abstime = BFacets.make((BFacets)bFacets, (BFacets)abstime);
                this.getConfigOverrides().set("valueFacets", (BValue)abstime);
            }
            if (obj2.isBool()) {
                bHistoryConfig.setRecordType(BBooleanTrendRecord.TYPE.getTypeSpec());
            } else if (obj2.isEnum()) {
                bHistoryConfig.setRecordType(BEnumTrendRecord.TYPE.getTypeSpec());
            } else if (obj2.isInt() || obj2.isReal() || obj2.isReltime()) {
                bHistoryConfig.setRecordType(BNumericTrendRecord.TYPE.getTypeSpec());
            } else {
                bHistoryConfig.setRecordType(BStringTrendRecord.TYPE.getTypeSpec());
            }
        }
    }

    private final void checkObixLicense() {
        String string;
        if (this.licenseChecked) {
            return;
        }
        Boolean bl = this.getObixClient().isTridiumServer();
        if (bl == null) {
            return;
        }
        if (!bl.booleanValue() && (string = this.getObixNetwork().checkObixLimit("foreignHistory.limit")) != null) {
            this.configFatal(string);
        }
        this.licenseChecked = true;
    }

    private final void configFatal(String string) {
        this.fatalFault = true;
        this.fatalFaultCause = string;
        this.executeFail(string);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceExt = null;
        this.firstExecute = true;
        this.licenseChecked = false;
        this.fatalFault = false;
        this.fatalFaultCause = null;
        this.recordInfo = null;
    }

    public BObixHistoryImport() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$history$BObixHistoryImport;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$history$BObixHistoryImport = BObixHistoryImport.class("[Lcom.tridium.obix.driver.history.BObixHistoryImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

