/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.export;

import com.tridium.obix.server.BObixOp;
import com.tridium.obix.server.BObixStatusAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.WrapperException;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringWritable;
import javax.baja.control.enums.BPriorityLevel;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixInvocable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixExport
extends BComponent
implements BIObixEncodable,
BIObixInvocable,
BIStatus {
    public static final Property point = BObixExport.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property priority = BObixExport.newProperty((int)0, (BValue)BPriorityLevel.level_10, null);
    public static final Property facets = BObixExport.newProperty((int)0, (BValue)BFacets.NULL, null);
    public static final Property status = BObixExport.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultReason = BObixExport.newProperty((int)1, (String)"", null);
    public static final Property writePoint = BObixExport.newProperty((int)1, (BValue)new BObixOp("write", "obix:WritePointIn", "obix:Point"), null);
    public static final Action configure = BObixExport.newAction((int)24, null);
    public static final Type TYPE;
    public static final BEnumRange DISALLOWED_PRIORITIES;
    private static String OUT;
    private static String FIN;
    static /* synthetic */ Class class$com$tridium$obix$driver$export$BObixExport;

    public BOrd getPoint() {
        return (BOrd)this.get(point);
    }

    public void setPoint(BOrd bOrd) {
        this.set(point, (BValue)bOrd, null);
    }

    public BPriorityLevel getPriority() {
        return (BPriorityLevel)this.get(priority);
    }

    public void setPriority(BPriorityLevel bPriorityLevel) {
        this.set(priority, (BValue)bPriorityLevel, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets bFacets) {
        this.set(facets, (BValue)bFacets, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultReason() {
        return this.getString(faultReason);
    }

    public void setFaultReason(String string) {
        this.setString(faultReason, string, null);
    }

    public BComponent getWritePoint() {
        return (BComponent)this.get(writePoint);
    }

    public void setWritePoint(BComponent bComponent) {
        this.set(writePoint, (BValue)bComponent, null);
    }

    public void configure() {
        this.invoke(configure, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if ((property == point || property == priority) && context != Context.decoding) {
            this.configure();
        }
    }

    public void doConfigure(Context context) {
        try {
            BObject bObject;
            Property property;
            Property property2 = this.getProperty(OUT);
            if (property2 != null) {
                property = this.getKnobs((Slot)property2);
                if (property != null) {
                    int n = 0;
                    while (n < ((Property)property).length) {
                        property[n].getTargetComponent().remove((BComplex)property[n].getLink());
                        ++n;
                    }
                }
                this.remove(property2, context);
            }
            if ((property = this.getProperty(FIN)) != null) {
                BLink[] bLinkArray = this.getLinks((Slot)property);
                if (bLinkArray != null) {
                    int n = 0;
                    while (n < bLinkArray.length) {
                        this.remove((BComplex)bLinkArray[n]);
                        ++n;
                    }
                }
                this.remove(property, context);
            }
            if (!((bObject = this.getPoint().resolve((BObject)Sys.getStation(), context).get()) instanceof BIWritablePoint) || !(bObject instanceof BControlPoint)) {
                this.setFaultReason(this.getPoint().toString(context) + " is not a writable point.");
                this.setStatus(BStatus.fault);
                return;
            }
            BStatusValue bStatusValue = null;
            BControlPoint bControlPoint = (BControlPoint)bObject;
            String string = this.writeOp().getOpIn();
            if (bControlPoint instanceof BBooleanWritable) {
                bStatusValue = this.getInVal((BIWritablePoint)((BBooleanWritable)bControlPoint));
                this.writeOp().setOpIn("/obix/def/baja:StatusBoolean " + string);
            } else if (bControlPoint instanceof BNumericWritable) {
                bStatusValue = this.getInVal((BIWritablePoint)((BNumericWritable)bControlPoint));
                this.writeOp().setOpIn("/obix/def/baja:StatusNumeric " + string);
            } else if (bControlPoint instanceof BEnumWritable) {
                bStatusValue = this.getInVal((BIWritablePoint)((BEnumWritable)bControlPoint));
                this.writeOp().setOpIn("/obix/def/baja:StatusEnum " + string);
            } else if (bControlPoint instanceof BStringWritable) {
                bStatusValue = this.getInVal((BIWritablePoint)((BStringWritable)bControlPoint));
                this.writeOp().setOpIn("/obix/def/baja:StatusString " + string);
            } else {
                this.setFaultReason("Unexpected point type: " + bControlPoint.getClass().getName());
                this.setStatus(BStatus.fault);
                return;
            }
            Property property3 = bStatusValue.getPropertyInParent();
            if (bControlPoint.isLinkTarget((Slot)property3)) {
                this.setFaultReason(this.getPoint().toString(context) + " is already linked in priority " + this.getPriority().getDisplayTag(context));
                this.setStatus(BStatus.fault);
                return;
            }
            this.add(OUT, bStatusValue.newCopy(true), context);
            bControlPoint.add("obixLink?", (BValue)bControlPoint.makeLink((BComponent)this, (Slot)this.getProperty(OUT), (Slot)property3, context));
            this.add(FIN, bStatusValue.newCopy(true), context);
            this.add("obixLink?", (BValue)this.makeLink((BComponent)bControlPoint, (Slot)bControlPoint.getOutProperty(), (Slot)this.getProperty(FIN), context));
            this.setFacets(bControlPoint.getFacets());
            this.setFaultReason("");
            this.setStatus(BStatus.ok);
        }
        catch (Exception exception) {
            this.setFaultReason(exception.toString());
            this.setStatus(BStatus.fault);
        }
    }

    private final BStatusValue getInVal(BIWritablePoint bIWritablePoint) {
        BPriorityLevel bPriorityLevel = this.getPriority();
        if (bPriorityLevel == BPriorityLevel.fallback) {
            if (bIWritablePoint instanceof BBooleanWritable) {
                return ((BBooleanWritable)bIWritablePoint).getFallback();
            }
            if (bIWritablePoint instanceof BNumericWritable) {
                return ((BNumericWritable)bIWritablePoint).getFallback();
            }
            if (bIWritablePoint instanceof BBooleanWritable) {
                return ((BBooleanWritable)bIWritablePoint).getFallback();
            }
            return ((BStringWritable)bIWritablePoint).getFallback();
        }
        return bIWritablePoint.getInStatusValue(bPriorityLevel);
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public void encode(ObixEncoder obixEncoder, Context context) {
        this.encode(obixEncoder, context, true);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)priority)) {
            return BFacets.make((String)"range", (BIDataValue)DISALLOWED_PRIORITIES, (String)"fieldEditor", (BIDataValue)BString.make((String)"obixDriver:LimitedFrozenEnumFE"));
        }
        return this.getFacets();
    }

    public void invoke(ObixDecoder obixDecoder, ObixEncoder obixEncoder) {
        try {
            BStatusValue bStatusValue = (BStatusValue)this.get(OUT);
            obixDecoder.addFacets(this.getFacets());
            BValue bValue = obixDecoder.decode();
            if (bValue == null) {
                bStatusValue.setStatus(BStatus.nullStatus);
            } else if (bValue instanceof BComplex) {
                BComplex bComplex = (BComplex)bValue;
                BValue bValue2 = bComplex.get("value");
                if (bValue2 == null) {
                    bStatusValue.setStatus(BStatus.nullStatus);
                } else {
                    if (bStatusValue instanceof BStatusEnum) {
                        ((BStatusEnum)bStatusValue).setValue((BEnum)bValue2.newCopy(true));
                    } else {
                        bStatusValue.setValueValue(bValue2.newCopy(true));
                    }
                    if (bStatusValue.getStatus().isNull()) {
                        bStatusValue.setStatus(BStatus.ok);
                    }
                }
            } else {
                bStatusValue.setStatusNull(false);
                if (bValue instanceof BDouble) {
                    bStatusValue.setValueValue(bValue.newCopy(true));
                } else if (bValue instanceof BBoolean) {
                    bStatusValue.setValueValue(bValue.newCopy(true));
                } else if (bValue instanceof BString) {
                    bStatusValue.setValueValue(bValue.newCopy(true));
                }
            }
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
        obixEncoder.setName(null);
        this.encode(obixEncoder, obixDecoder, false);
    }

    public void started() throws Exception {
        if (this.getProperty(OUT) == null) {
            this.configure();
        }
    }

    public String toString(Context context) {
        Property property = this.getProperty(FIN);
        if (property != null && !this.isLinkTarget((Slot)property)) {
            property = null;
        }
        if (property == null) {
            property = this.getProperty(OUT);
        }
        if (property == null) {
            return "Not configured";
        }
        return this.get(property).toString(context);
    }

    private final void encode(ObixEncoder obixEncoder, Context context, boolean bl) {
        try {
            Property property = this.getProperty(FIN);
            if (property != null && !this.isLinkTarget((Slot)property)) {
                property = null;
            }
            if (property == null || !bl) {
                property = this.getProperty(OUT);
            }
            if (property == null) {
                return;
            }
            String string = obixEncoder.getHref();
            BStatusValue bStatusValue = (BStatusValue)this.get(property);
            Obj obj = new Obj();
            obj.setName(obixEncoder.getName());
            obj.setHref(ObixUtils.makeSlotPathUri(obixEncoder, ObixUtils.concat(this.toPathString(), property.getName())));
            BOrd bOrd = BOrd.make((String)("slot:" + property.getName()));
            ObixUtils.encode(obixEncoder, obj, (BObject)bStatusValue.getValueValue(), bOrd.resolve((BObject)this, context));
            obj.setIs("obix:WritablePoint obix:Point");
            obj.setHref(string);
            obj.setStatus(BObixStatusAgent.getStatus((BIStatus)bStatusValue.getStatus()));
            obj.setWritable(null);
            if (bStatusValue.getStatus().isNull()) {
                obj.setNull(Boolean.TRUE);
            }
            if (obixEncoder.isRef()) {
                obj.makeRef();
                obj.write(obixEncoder, false);
            } else if (bl) {
                Object object;
                obj.write(obixEncoder, true);
                String string2 = obj.getElement();
                BOrd bOrd2 = this.getPoint();
                OrdQuery[] ordQueryArray = bOrd2.parse();
                if (ordQueryArray.length == 1 && ordQueryArray[0] instanceof SlotPath) {
                    obj.initRef("target", ObixUtils.makeSlotPathUri(obixEncoder, ordQueryArray[0].getBody()));
                } else {
                    object = bOrd2.get((BObject)Sys.getStation()).asComponent();
                    obj.initRef("target", ObixUtils.makeSlotPathUri(obixEncoder, object.getSlotPath().getBody()));
                }
                obj.write(obixEncoder, false);
                object = obixEncoder.getName();
                obixEncoder.setName("writePoint");
                obixEncoder.setHref(obixEncoder.getChildHref(obixEncoder.getHref(), "writePoint"));
                this.writeOp().encode(obixEncoder, context);
                obj.setElement(string2);
                obj.endElem(obixEncoder);
                obixEncoder.setName((String)object);
            } else {
                obj.write(obixEncoder, false);
            }
        }
        catch (Exception exception) {
            throw new WrapperException(exception);
        }
    }

    private final BObixOp writeOp() {
        return (BObixOp)this.getWritePoint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$obix$driver$export$BObixExport;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$export$BObixExport = BObixExport.class("[Lcom.tridium.obix.driver.export.BObixExport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        DISALLOWED_PRIORITIES = BEnumRange.make((int[])new int[1], (String[])new String[]{BPriorityLevel.none.getTag()});
        OUT = "out";
        FIN = "feedback";
    }
}

