/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.alarm;

import com.tridium.obix.driver.alarm.BObixAlarmDeviceExt;
import com.tridium.obix.driver.util.BObixSubscription;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BICollection;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Abstime;
import obix.Contract;
import obix.Obj;
import obix.Str;
import obix.Uri;
import obix.Val;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixAlarmImport
extends BComponent
implements BIStatus,
BIAlarmSource {
    public static final Property alarmClass = BObixAlarmImport.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property href = BObixAlarmImport.newProperty((int)0, (String)"", null);
    public static final Property lastReceivedTime = BObixAlarmImport.newProperty((int)9, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property subscription = BObixAlarmImport.newProperty((int)67, (BValue)BObixSubscription.unsubscribed, null);
    public static final Property status = BObixAlarmImport.newProperty((int)1, (BValue)BStatus.down, null);
    public static final Property faultCause = BObixAlarmImport.newProperty((int)3, (String)"", null);
    public static final Action ackAlarm = BObixAlarmImport.newAction((int)0, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE;
    static Uri ACK_ALARM;
    static Uri STATEFUL_ALARM;
    private static BAlarmService service;
    private BObixAlarmDeviceExt deviceExt;
    private BOrdList source;
    protected String subscribedHref;
    static /* synthetic */ Class class$com$tridium$obix$driver$alarm$BObixAlarmImport;

    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    public void setAlarmClass(String string) {
        this.setString(alarmClass, string, null);
    }

    public String getHref() {
        return this.getString(href);
    }

    public void setHref(String string) {
        this.setString(href, string, null);
    }

    public BAbsTime getLastReceivedTime() {
        return (BAbsTime)this.get(lastReceivedTime);
    }

    public void setLastReceivedTime(BAbsTime bAbsTime) {
        this.set(lastReceivedTime, (BValue)bAbsTime, null);
    }

    public BObixSubscription getSubscription() {
        return (BObixSubscription)this.get(subscription);
    }

    public void setSubscription(BObixSubscription bObixSubscription) {
        this.set(subscription, (BValue)bObixSubscription, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public BBoolean ackAlarm(BAlarmRecord bAlarmRecord) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)bAlarmRecord, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && context != Context.decoding && property == href) {
            this.getLog().trace("Alarm subject href changed - " + this.toPathString());
            this.getObixAlarmDeviceExt().unsubscribe(this.subscribedHref, this, context);
            this.getObixAlarmDeviceExt().subscribe(this.getHref(), this, context);
        }
        super.changed(property, context);
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) {
        try {
            this.getLog().trace("AckAlarm (" + this.getHref() + ") " + bAlarmRecord.toSummaryString());
            BString bString = (BString)bAlarmRecord.getAlarmFacet("ackHref");
            if (bString == null) {
                this.getLog().error("No href for alarm: " + bAlarmRecord.toSummaryString());
                return BBoolean.FALSE;
            }
            Uri uri = new Uri(bString.getString());
            Obj obj = new Obj();
            obj.setIs(new Contract("obix:AlarmAckIn"));
            Str str = new Str();
            str.setName("ackUser");
            str.setStr(bAlarmRecord.getUser());
            obj.add((Obj)str);
            Obj obj2 = this.getObixClient().obixInvoke(uri, obj);
            if (obj2 == null) {
                this.getLog().error("Empty response for ack: " + bAlarmRecord.toSummaryString());
                return BBoolean.FALSE;
            }
            if (obj2.isErr()) {
                this.getLog().error(obj2.toDisplayString());
                bAlarmRecord.setAckState(BAckState.unacked);
            } else {
                Obj obj3 = obj2.get("alarm");
                if (obj3 == null) {
                    this.getLog().error("Empty response for ack: " + bAlarmRecord.toSummaryString());
                    bAlarmRecord.setAckState(BAckState.unacked);
                } else {
                    this.updateAlarm(bAlarmRecord, obj3);
                }
            }
        }
        catch (Exception exception) {
            this.getLog().error("AckAlarm (" + this.getHref() + ')', (Throwable)exception);
            bAlarmRecord.setAckState(BAckState.unacked);
        }
        this.route(bAlarmRecord);
        boolean bl = false;
        if (bAlarmRecord.getAckState() == BAckState.acked) {
            bl = true;
        }
        return BBoolean.make((boolean)bl);
    }

    public Type getDeviceExtType() {
        return BObixAlarmDeviceExt.TYPE;
    }

    public Log getLog() {
        return this.getObixAlarmDeviceExt().getLog();
    }

    public BObixClient getObixClient() {
        return this.getObixAlarmDeviceExt().getObixClient();
    }

    public BObixAlarmDeviceExt getObixAlarmDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BObixAlarmDeviceExt) {
                this.deviceExt = (BObixAlarmDeviceExt)bComplex;
                return this.deviceExt;
            }
            bComplex = bComplex.getParent();
        }
        throw new IllegalStateException();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public void started() throws Exception {
        this.source = null;
        BObixAlarmDeviceExt bObixAlarmDeviceExt = this.getObixAlarmDeviceExt();
        if (bObixAlarmDeviceExt.isAttached()) {
            bObixAlarmDeviceExt.subscribe(this.getHref(), this, null);
        }
    }

    public void stopped() throws Exception {
        if (this.getSubscription().isSubscribed()) {
            this.getObixAlarmDeviceExt().unsubscribe(this.subscribedHref, this, null);
        }
        this.deviceExt = null;
        super.stopped();
    }

    protected BOrdList asSource() {
        if (this.source == null) {
            this.source = BOrdList.make((BOrd)this.getSlotPathOrd());
        }
        return this.source;
    }

    protected BAlarmRecord getExistingRecord(String string) throws Exception {
        BOrd bOrd = BOrd.make((String)("alarm:|bql:select * where alarmData.href = '" + string + '\''));
        BICollection bICollection = (BICollection)bOrd.resolve((BObject)Sys.getStation()).get();
        Cursor cursor = bICollection.cursor();
        if (cursor.next()) {
            return (BAlarmRecord)cursor.get();
        }
        return null;
    }

    protected BOrdList makeSource(BComponent bComponent) {
        return BOrdList.make((BOrd)bComponent.getSlotPathOrd());
    }

    protected void processFeed(Obj obj) {
        this.setLastReceivedTime(Clock.time());
        BObixClient bObixClient = this.getObixClient();
        Obj[] objArray = obj.list();
        try {
            int n = objArray.length;
            Obj obj2 = null;
            int n2 = 0;
            while (n2 < n) {
                String string;
                obj2 = objArray[n2];
                BAlarmRecord bAlarmRecord = this.makeAlarm(obj2);
                String string2 = bObixClient.getRelativeUri(obj2.getHref()).get();
                BAlarmRecord bAlarmRecord2 = this.getExistingRecord(string2);
                BString bString = (BString)bAlarmRecord.getAlarmFacet("sourceStation");
                if (bString != null && (string = bString.getString()).equals(Sys.getStation().getStationName())) {
                    this.getLog().trace("Duplicate alarm: skipping alarm processing for alarm " + obj2.toString());
                } else if (bAlarmRecord2 == null) {
                    this.getLog().trace("Alarm received - " + obj2.toString());
                    this.route(bAlarmRecord);
                } else if (!this.equivalent(bAlarmRecord2, bAlarmRecord) && this.shouldRoute(bAlarmRecord2, bAlarmRecord)) {
                    bAlarmRecord2 = (BAlarmRecord)bAlarmRecord2.newCopy(true);
                    this.getLog().trace("Alarm being updated - " + obj2.toString());
                    this.route(this.updateAlarm(bAlarmRecord2, bAlarmRecord));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.getLog().error("Receiving alarm event", (Throwable)exception);
        }
    }

    protected void setSource(BAlarmRecord bAlarmRecord, Obj obj) throws Exception {
        bAlarmRecord.addAlarmFacet("sourceName", (BIDataValue)BString.make((String)(this.getObixClient().getName() + '-' + this.getName())));
        bAlarmRecord.setSource(this.asSource());
    }

    protected boolean shouldRoute(BAlarmRecord bAlarmRecord, BAlarmRecord bAlarmRecord2) {
        return true;
    }

    protected void subscribeFail(String string) {
        this.getLog().error("Subscribe failure (" + string + ") " + this.toPathString());
        this.setSubscription(BObixSubscription.unsubscribed);
        this.setStatus(BStatus.fault);
        this.setFaultCause(string);
    }

    protected void subscribeOk(Obj obj) {
        try {
            BAlarmRecord bAlarmRecord;
            this.subscribedHref = this.getHref();
            this.getLog().trace("Subscribe success - " + this.getHref());
            Map map = this.getOpenAlarms();
            this.getLog().trace("Existing record count = " + map.size());
            Map map2 = this.getAlarms(obj);
            this.getLog().trace("Incoming record count = " + map2.size());
            Iterator iterator = map.keySet().iterator();
            int n = 0;
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                BAlarmRecord bAlarmRecord2 = (BAlarmRecord)map.get(string);
                bAlarmRecord = (BAlarmRecord)map2.get(string);
                if (bAlarmRecord == null) {
                    ++n;
                    this.close(bAlarmRecord2);
                    continue;
                }
                if (this.equivalent(bAlarmRecord2, bAlarmRecord)) continue;
                ++n2;
                this.route(this.updateAlarm(bAlarmRecord2, bAlarmRecord));
            }
            iterator = map2.keySet().iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (map.get(string) != null || !(bAlarmRecord = (BAlarmRecord)map2.get(string)).isOpen()) continue;
                this.route(bAlarmRecord);
                ++n3;
            }
            this.getLog().trace("Existing records closed = " + n);
            this.getLog().trace("Existing records updated = " + n2);
            this.getLog().trace("New open records = " + n3);
            this.setSubscription(BObixSubscription.subscribed);
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        }
        catch (Exception exception) {
            this.getLog().error("Failure creating subscription", (Throwable)exception);
            this.subscribeFail(exception.toString());
            this.getObixAlarmDeviceExt().unsubscribe(this.subscribedHref, this, null);
        }
    }

    protected void unsubscribe() {
        this.setSubscription(BObixSubscription.unsubscribed);
        this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)true));
        if (this.isRunning()) {
            this.getLog().trace("Unsubscribed - " + this.getHref());
        }
    }

    private final void close(BAlarmRecord bAlarmRecord) {
        bAlarmRecord.setAckState(BAckState.acked);
        bAlarmRecord.setAckTime(Clock.time());
        bAlarmRecord.setSourceState(BSourceState.normal);
        this.route(bAlarmRecord);
    }

    private final boolean equal(Object object, Object object2) {
        if (object == null) {
            boolean bl = false;
            if (object2 == null) {
                bl = true;
            }
            return bl;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    private final boolean equivalent(BAlarmRecord bAlarmRecord, BAlarmRecord bAlarmRecord2) {
        if (!bAlarmRecord.getTimestamp().equals((Object)bAlarmRecord2.getTimestamp())) {
            return false;
        }
        if (bAlarmRecord.getAckRequired() != bAlarmRecord2.getAckRequired()) {
            return false;
        }
        if (!bAlarmRecord.getSourceState().equals((Object)bAlarmRecord2.getSourceState())) {
            return false;
        }
        if (!bAlarmRecord.getNormalTime().equals((Object)bAlarmRecord2.getNormalTime())) {
            return false;
        }
        if (!bAlarmRecord.getAckTime().equals((Object)bAlarmRecord2.getAckTime())) {
            return false;
        }
        if (!this.equal(bAlarmRecord.getUser(), bAlarmRecord2.getUser())) {
            return false;
        }
        BFacets bFacets = BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (BFacets)bAlarmRecord2.getAlarmData());
        return bAlarmRecord.getAlarmData().equals((Object)bFacets);
    }

    private final Map getAlarms(Obj obj) {
        TreeMap<String, BAlarmRecord> treeMap = new TreeMap<String, BAlarmRecord>();
        Obj[] objArray = obj.list();
        int n = objArray.length;
        while (--n >= 0) {
            BAlarmRecord bAlarmRecord = this.makeAlarm(objArray[n]);
            treeMap.put(this.getHref(bAlarmRecord), bAlarmRecord);
        }
        return treeMap;
    }

    private final String getHref(BAlarmRecord bAlarmRecord) {
        BString bString = (BString)bAlarmRecord.getAlarmFacet("href");
        if (bString != null) {
            return bString.getString();
        }
        return null;
    }

    private final Map getOpenAlarms() throws Exception {
        TreeMap<String, BValue> treeMap = new TreeMap<String, BValue>();
        Cursor cursor = this.svc().getAlarmDb().getAlarmsForSource(this.asSource());
        BAlarmRecord bAlarmRecord = null;
        while (cursor.next()) {
            bAlarmRecord = (BAlarmRecord)cursor.get();
            if (!bAlarmRecord.isOpen()) continue;
            treeMap.put(this.getHref(bAlarmRecord), bAlarmRecord.newCopy(true));
        }
        return treeMap;
    }

    private final String getVal(Obj obj) {
        if (obj.isVal()) {
            return ((Val)obj).encodeVal();
        }
        if (obj.isRef()) {
            return obj.toString();
        }
        return obj.toDisplayString();
    }

    private final BAlarmRecord makeAlarm(Obj obj) {
        BAlarmRecord bAlarmRecord = new BAlarmRecord();
        return this.updateAlarm(bAlarmRecord, obj);
    }

    private final void route(BAlarmRecord bAlarmRecord) {
        if (bAlarmRecord == null) {
            return;
        }
        this.svc().routeAlarm(bAlarmRecord);
    }

    private final BAlarmService svc() {
        if (service != null && service.isRunning()) {
            return service;
        }
        try {
            service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            this.getLog().error("Cannot find AlarmService", (Throwable)serviceNotFoundException);
        }
        return service;
    }

    private final BAlarmRecord updateAlarm(BAlarmRecord bAlarmRecord, BAlarmRecord bAlarmRecord2) {
        if (bAlarmRecord.getAckRequired() != bAlarmRecord2.getAckRequired()) {
            bAlarmRecord.setAckRequired(bAlarmRecord2.getAckRequired());
        }
        if (!bAlarmRecord.getAckTime().equals((Object)bAlarmRecord2.getAckTime())) {
            bAlarmRecord.setAckTime(bAlarmRecord2.getAckTime());
        }
        if (!bAlarmRecord.getAckState().equals((Object)bAlarmRecord2.getAckState())) {
            bAlarmRecord.setAckState(bAlarmRecord2.getAckState());
        }
        if (!bAlarmRecord.getNormalTime().equals((Object)bAlarmRecord2.getNormalTime())) {
            bAlarmRecord.setNormalTime(bAlarmRecord2.getNormalTime());
        }
        if (!bAlarmRecord.getSourceState().equals((Object)bAlarmRecord2.getSourceState())) {
            bAlarmRecord.setSourceState(bAlarmRecord2.getSourceState());
        }
        if (!bAlarmRecord.getTimestamp().equals((Object)bAlarmRecord2.getTimestamp())) {
            bAlarmRecord.setTimestamp(bAlarmRecord2.getTimestamp());
        }
        if (!this.equal(bAlarmRecord.getUser(), bAlarmRecord2.getUser())) {
            bAlarmRecord.setUser(bAlarmRecord2.getUser());
        }
        bAlarmRecord.setAlarmData(BFacets.make((BFacets)bAlarmRecord.getAlarmData(), (BFacets)bAlarmRecord2.getAlarmData()));
        return bAlarmRecord;
    }

    private final BAlarmRecord updateAlarm(BAlarmRecord bAlarmRecord, Obj obj) {
        BObixClient bObixClient = this.getObixClient();
        bAlarmRecord.addAlarmFacet("href", (BIDataValue)BString.make((String)bObixClient.getRelativeUri(obj.getHref()).get()));
        try {
            this.setSource(bAlarmRecord, obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (obj.getDisplay() != null) {
            bAlarmRecord.addAlarmFacet("msgText", (BIDataValue)BString.make((String)obj.getDisplay()));
        }
        bAlarmRecord.setAlarmClass(this.getAlarmClass());
        if (obj.is(ACK_ALARM)) {
            bAlarmRecord.setAckRequired(true);
            bAlarmRecord.setAckState(BAckState.unacked);
        } else {
            bAlarmRecord.setAckRequired(false);
        }
        if (obj.is(STATEFUL_ALARM)) {
            bAlarmRecord.setSourceState(BSourceState.offnormal);
        } else {
            bAlarmRecord.setSourceState(BSourceState.normal);
        }
        bAlarmRecord.addAlarmFacet("feedName", (BIDataValue)BString.make((String)this.getName()));
        Obj[] objArray = obj.list();
        int n = objArray.length;
        while (--n >= 0) {
            String string = objArray[n].getName();
            if (objArray[n].isNull()) continue;
            if (string.equals("timestamp")) {
                if (objArray[n].isAbstime()) {
                    long l = ((Abstime)objArray[n]).getMillis();
                    bAlarmRecord.setTimestamp(BAbsTime.make((long)l));
                    continue;
                }
                bAlarmRecord.addAlarmFacet("timestamp", (BIDataValue)BString.make((String)this.getVal(objArray[n])));
                continue;
            }
            if (string.equals("normalTimestamp")) {
                if (objArray[n].isAbstime()) {
                    long l = ((Abstime)objArray[n]).getMillis();
                    bAlarmRecord.setNormalTime(BAbsTime.make((long)l));
                    bAlarmRecord.setSourceState(BSourceState.normal);
                    continue;
                }
                bAlarmRecord.addAlarmFacet("normalTimestamp", (BIDataValue)BString.make((String)this.getVal(objArray[n])));
                continue;
            }
            if (string.equals("ackTimestamp")) {
                if (objArray[n].isAbstime()) {
                    long l = ((Abstime)objArray[n]).getMillis();
                    if (l <= 0L) continue;
                    bAlarmRecord.setAckTime(BAbsTime.make((long)l));
                    bAlarmRecord.setAckState(BAckState.acked);
                    continue;
                }
                bAlarmRecord.addAlarmFacet("ackTimestamp", (BIDataValue)BString.make((String)this.getVal(objArray[n])));
                continue;
            }
            if (string.equals("ackUser")) {
                bAlarmRecord.setUser(this.getVal(objArray[n]));
                continue;
            }
            if (string.equals("ack")) {
                bAlarmRecord.addAlarmFacet("ackHref", (BIDataValue)BString.make((String)bObixClient.getRelativeUri(objArray[n].getHref()).get()));
                continue;
            }
            if (string.equals("niagara-uuid") && objArray[n].isStr()) {
                bAlarmRecord.setUuid(BUuid.make((String)((Str)objArray[n]).getStr()));
                continue;
            }
            if (string.equals("notificationClass")) {
                String string2 = this.getVal(objArray[n]);
                BAlarmClass bAlarmClass = this.svc().lookupAlarmClass(string2);
                if (bAlarmClass.getName().equals("defaultAlarmClass") && !string2.equals("defaultAlarmClass")) continue;
                bAlarmRecord.setAlarmClass(string2);
                continue;
            }
            bAlarmRecord.addAlarmFacet(SlotPath.escape((String)string), (BIDataValue)BString.make((String)this.getVal(objArray[n])));
        }
        return bAlarmRecord;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.deviceExt = null;
        this.source = null;
        this.subscribedHref = null;
    }

    public BObixAlarmImport() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$alarm$BObixAlarmImport;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$alarm$BObixAlarmImport = BObixAlarmImport.class("[Lcom.tridium.obix.driver.alarm.BObixAlarmImport;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        ACK_ALARM = new Uri("obix:AckAlarm");
        STATEFUL_ALARM = new Uri("obix:StatefulAlarm");
        service = null;
    }
}

