/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.driver.alarm;

import com.tridium.obix.driver.alarm.BObixAlarmDiscoveryJob;
import com.tridium.obix.driver.alarm.BObixAlarmImport;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.driver.alarm.BAlarmDeviceExt;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.BObixNetwork;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import obix.Obj;
import obix.io.ObixEncoder;
import obix.net.SessionWatch;
import obix.net.WatchListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BObixAlarmDeviceExt
extends BAlarmDeviceExt
implements WatchListener {
    public static final Property alarmClass = BObixAlarmDeviceExt.newProperty((int)6, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE")));
    public static final Property watchInterval = BObixAlarmDeviceExt.newProperty((int)0, (BValue)BRelTime.make((long)2000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE));
    public static final Property watchUri = BObixAlarmDeviceExt.newProperty((int)3, (String)"", null);
    public static final Property debugWatch = BObixAlarmDeviceExt.newProperty((int)0, (boolean)false, null);
    public static final Action getClient = BObixAlarmDeviceExt.newAction((int)4, null);
    public static final Action submitAlarmDiscoveryJob = BObixAlarmDeviceExt.newAction((int)4, null);
    public static final Action subscribe = BObixAlarmDeviceExt.newAction((int)20, null);
    public static final Type TYPE;
    private boolean attached;
    private ObixEncoder debugger;
    private Log log;
    private Object mutexSubscribe;
    private Object mutexUnsubscribe;
    private TreeMap pendingSubscribe;
    private TreeMap pendingUnsubscribe;
    private boolean subscribing;
    private TreeMap subscriptions;
    private SessionWatch watch;
    static /* synthetic */ Class class$com$tridium$obix$driver$alarm$BObixAlarmDeviceExt;

    public BRelTime getWatchInterval() {
        return (BRelTime)this.get(watchInterval);
    }

    public void setWatchInterval(BRelTime bRelTime) {
        this.set(watchInterval, (BValue)bRelTime, null);
    }

    public String getWatchUri() {
        return this.getString(watchUri);
    }

    public void setWatchUri(String string) {
        this.setString(watchUri, string, null);
    }

    public boolean getDebugWatch() {
        return this.getBoolean(debugWatch);
    }

    public void setDebugWatch(boolean bl) {
        this.setBoolean(debugWatch, bl, null);
    }

    public BOrd getClient() {
        return (BOrd)this.invoke(getClient, null, null);
    }

    public BOrd submitAlarmDiscoveryJob() {
        return (BOrd)this.invoke(submitAlarmDiscoveryJob, null, null);
    }

    public void subscribe() {
        this.invoke(subscribe, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void attach() {
        this.attached = true;
        BObixAlarmImport[] bObixAlarmImportArray = this.getProxies();
        Object object = this.mutexSubscribe;
        synchronized (object) {
            int n = bObixAlarmImportArray.length;
            while (true) {
                if (--n < 0) {
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.subscribe();
                    return;
                }
                this.pendingSubscribe.put(bObixAlarmImportArray[n].getHref(), bObixAlarmImportArray[n]);
            }
        }
    }

    public void changed(Obj obj) {
        this.setLastReceivedTime(Clock.time());
        this.debug(obj);
        BObixAlarmImport bObixAlarmImport = (BObixAlarmImport)((Object)this.subscriptions.get(obj.getHref().get()));
        if (bObixAlarmImport == null) {
            this.getLog().warning("No recipient for " + obj.toDisplayString());
        } else {
            bObixAlarmImport.processFeed(obj);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)watchInterval)) {
            try {
                if (this.watch != null) {
                    long l = this.getWatchInterval().getMillis();
                    long l2 = this.watch.getLease();
                    long l3 = Math.max(l * (long)2, l2 + this.getObixClient().getWatchSafetyFactor().getMillis());
                    this.watch.setLease(l3);
                    this.watch.setPollPeriod(l);
                }
            }
            catch (Exception exception) {
                throw new LocalizableRuntimeException("obix", "Invalid watch interval:" + this.getWatchInterval(), (Throwable)exception);
            }
        }
    }

    public void closed(SessionWatch sessionWatch) {
        if (sessionWatch == this.watch) {
            this.watch = null;
            this.setWatchUri("");
            this.getLog().trace("Watch closed " + sessionWatch.getWatchObj().getHref().get());
            BObixClient bObixClient = this.getObixClient();
            if (bObixClient.getState().isEngaged()) {
                bObixClient.pingFail("Alarm watch unexpectedly closed.");
            }
        } else {
            this.getLog().warning("Unknown watch closed " + sessionWatch.getWatchObj().getHref().get());
        }
    }

    public void detach() {
        Iterator iterator = this.subscriptions.values().iterator();
        while (iterator.hasNext()) {
            BObixAlarmImport bObixAlarmImport = (BObixAlarmImport)((Object)iterator.next());
            bObixAlarmImport.unsubscribe();
        }
        this.subscriptions.clear();
        if (this.watch != null) {
            this.watch.delete();
            this.watch = null;
            this.setWatchUri("");
        }
        this.attached = false;
    }

    public BBoolean doAckAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        BString bString = (BString)bAlarmRecord.getAlarmFacet("feedName");
        if (bString != null) {
            BObixAlarmImport bObixAlarmImport = (BObixAlarmImport)this.get(bString.getString());
            if (bObixAlarmImport != null) {
                return bObixAlarmImport.doAckAlarm(bAlarmRecord);
            }
            return BBoolean.FALSE;
        }
        throw new BajaRuntimeException("Cannot find feedName to acknowledge alarm!");
    }

    public BOrd doGetClient() {
        return this.getObixClient().getSlotPathOrd();
    }

    public void doRouteAlarm(BAlarmRecord bAlarmRecord) throws Exception {
        throw new RuntimeException("Not supported.");
    }

    public BOrd doSubmitAlarmDiscoveryJob(Context context) {
        return new BObixAlarmDiscoveryJob(this, this.getObixClient().get("lobby")).submit(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSubscribe() {
        Object object = this.mutexSubscribe;
        synchronized (object) {
            if (this.subscribing) {
                return;
            }
            if (!this.isRunning()) {
                return;
            }
            if (!this.attached) {
                return;
            }
            this.subscribing = true;
        }
        try {
            this.performUnsubscribe();
            this.performSubscribe();
            Object var2_4 = null;
            this.subscribing = false;
            if (this.pendingSubscribe.size() > 0) {
                this.subscribe();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.subscribing = false;
            if (this.pendingSubscribe.size() > 0) {
                this.subscribe();
                throw throwable;
            }
            if (this.pendingUnsubscribe.size() <= 0) throw throwable;
            this.subscribe();
            throw throwable;
        }
        if (this.pendingUnsubscribe.size() <= 0) return;
        this.subscribe();
    }

    public Type getAlarmImportType() {
        return BObixAlarmImport.TYPE;
    }

    public Type getDeviceType() {
        return BObixClient.TYPE;
    }

    public Log getLog() {
        if (this.log == null) {
            try {
                this.log = Log.getLog((String)(this.getObixClient().getLog().getLogName() + "-Alarms"));
            }
            catch (Exception exception) {
                this.log = this.getObixClient().getLog();
            }
        }
        return this.log;
    }

    public BObixClient getObixClient() {
        return (BObixClient)this.getParent();
    }

    public BObixNetwork getObixNetwork() {
        return this.getObixClient().getObixNetwork();
    }

    public boolean isAttached() {
        return this.attached;
    }

    public boolean isChildLegal(BComponent bComponent) {
        return true;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        this.getObixNetwork().enqueue((Runnable)new Invocation((BComponent)this, action, bValue, context));
        return null;
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps();
        spyWriter.trTitle((Object)"ObixAlarmDeviceExt", 2);
        spyWriter.prop((Object)"attached", this.attached);
        spyWriter.prop((Object)"debugger", (Object)this.debugger);
        spyWriter.prop((Object)"log", (Object)this.getLog().getLogName());
        spyWriter.prop((Object)"pendingSubscribe", (Object)this.pendingSubscribe);
        spyWriter.prop((Object)"pendingUnsubscribe", (Object)this.pendingUnsubscribe);
        spyWriter.prop((Object)"subscribing", this.subscribing);
        spyWriter.prop((Object)"subscriptions", (Object)this.subscriptions);
        spyWriter.prop((Object)"watch", (Object)this.watch);
        spyWriter.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void subscribe(String string, BObixAlarmImport bObixAlarmImport, Context context) {
        Object object = this.mutexSubscribe;
        synchronized (object) {
            this.pendingSubscribe.put(string, bObixAlarmImport);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var4_4
            this.subscribe();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unsubscribe(String string, BObixAlarmImport bObixAlarmImport, Context context) {
        Object object = this.mutexUnsubscribe;
        synchronized (object) {
            this.pendingUnsubscribe.put(string, bObixAlarmImport);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var4_4
            this.subscribe();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void performSubscribe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [1 : 15->43)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void performUnsubscribe() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 0[TRYBLOCK] [1 : 15->43)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void debug(Obj obj) {
        if (!this.getDebugWatch()) {
            return;
        }
        try {
            if (this.debugger == null) {
                this.debugger = new ObixEncoder((OutputStream)System.out);
            }
            System.out.println(this.toPathString() + " Alarms:");
            this.debugger.encode(obj);
            this.debugger.flush();
        }
        catch (Exception exception) {}
    }

    private final BObixAlarmImport[] getProxies() {
        ArrayList arrayList = new ArrayList();
        this.getProxies((BComponent)this, arrayList);
        return arrayList.toArray(new BObixAlarmImport[arrayList.size()]);
    }

    private final void getProxies(BComponent bComponent, ArrayList arrayList) {
        SlotCursor slotCursor = bComponent.loadSlots().getProperties();
        while (slotCursor.nextComponent()) {
            BComponent bComponent2 = slotCursor.get().asComponent();
            if (bComponent2 instanceof BObixAlarmImport) {
                arrayList.add(bComponent2);
                continue;
            }
            this.getProxies(bComponent2, arrayList);
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.attached = false;
        this.debugger = null;
        this.log = null;
        this.mutexSubscribe = new Object();
        this.mutexUnsubscribe = new Object();
        this.pendingSubscribe = new TreeMap();
        this.pendingUnsubscribe = new TreeMap();
        this.subscribing = false;
        this.subscriptions = new TreeMap();
        this.watch = null;
    }

    public BObixAlarmDeviceExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$obix$driver$alarm$BObixAlarmDeviceExt;
        if (clazz == null) {
            clazz = class$com$tridium$obix$driver$alarm$BObixAlarmDeviceExt = BObixAlarmDeviceExt.class("[Lcom.tridium.obix.driver.alarm.BObixAlarmDeviceExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

