/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.rtsp;

import java.io.IOException;
import java.io.InputStream;
import javax.baja.io.ByteBuffer;
import javax.baja.rtsp.RtpPacket;
import javax.baja.rtsp.RtspConnection;
import javax.baja.sys.Clock;
import javax.baja.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RtpStream
extends InputStream {
    protected static final long msb0baseTime = 2085978496000L;
    protected static final long msb1baseTime = -2208988800000L;
    public long time;
    RtspConnection rtspConnection;
    long dataReceived;
    long lastTick;
    double bandwidth;
    long frameCount;
    long frameTime;
    long rtcpTime;
    Queue packetQueue;
    int packetCount;
    int lastSequence;
    int packetLost;
    int port;
    int udpbuffersize;
    public byte[] rtpDataBuffer;
    public Object monitor;
    public boolean marker;
    public boolean useQueue;
    ByteBuffer frameRead;
    public RtspConnection.SessionObject session;

    void setRtspConnection(RtspConnection rtspConnection) {
        this.rtspConnection = rtspConnection;
    }

    RtspConnection getRtspConnection() {
        return this.rtspConnection;
    }

    public void close() throws IOException {
        this.clearPacketQueue();
        super.close();
    }

    public void setPortandBuffer(int n, int n2) {
        this.port = n;
        this.udpbuffersize = n2;
    }

    public int read() throws IOException {
        throw new IOException("Please use the readPacketMethod instead");
    }

    public void addPacket(RtpPacket rtpPacket, boolean bl) throws Exception {
        if (rtpPacket == null) {
            return;
        }
        if (!bl) {
            this.useRtcp(rtpPacket);
            return;
        }
        if (this.lastSequence == 0) {
            this.lastSequence = rtpPacket.seq_num;
        } else if (rtpPacket.seq_num - this.lastSequence > 1 && rtpPacket.seq_num - this.lastSequence < 100) {
            this.packetLost += rtpPacket.seq_num - this.lastSequence - 1;
        } else {
            this.lastSequence = rtpPacket.seq_num;
        }
        ++this.packetCount;
        this.packetQueue.enqueue((Object)rtpPacket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RtpPacket readPacket() throws Exception {
        RtpPacket rtpPacket = (RtpPacket)this.packetQueue.dequeue(100);
        RtpStream rtpStream = this;
        synchronized (rtpStream) {
            this.notifyAll();
            return rtpPacket;
        }
    }

    public void useRtcp(RtpPacket rtpPacket) {
        long l = Clock.ticks();
        if (this.lastTick == 0L) {
            this.dataReceived = 0L;
        } else if (l - this.lastTick != 0L) {
            this.bandwidth = this.dataReceived / (l - this.lastTick) * 1000L / 1024L;
        }
        this.dataReceived = 0L;
        this.lastTick = l;
        this.time = this.getTime(rtpPacket.ntpTimeStamp1, rtpPacket.ntpTimeStamp2);
    }

    public long getTime() {
        return this.time;
    }

    public int size() {
        return this.packetQueue.size();
    }

    public void clearPacketQueue() {
        this.packetQueue.clear();
    }

    public byte[] readFrame() throws Exception {
        this.frameRead.reset();
        boolean bl = false;
        while (!bl) {
            RtpPacket rtpPacket = this.readPacket();
            if (rtpPacket != null) {
                bl = rtpPacket.marker;
                this.frameRead.write(rtpPacket.payload, 0, rtpPacket.pay_length);
                continue;
            }
            bl = true;
        }
        ++this.frameCount;
        return this.frameRead.toByteArray();
    }

    public long getFrameTime() {
        return this.frameTime;
    }

    public long getTime(long l, long l2) {
        long l3 = l & 0xFFFFFFFFL;
        long l4 = l2 & 0xFFFFFFFFL;
        l4 = Math.round(1000.0 * (double)l4 / 4.294967296E9);
        long l5 = l3 & 0x80000000L;
        if (l5 == 0L) {
            return 2085978496000L + l3 * 1000L + l4;
        }
        return -2208988800000L + l3 * 1000L + l4;
    }

    public String getBandwidth() {
        if (this.bandwidth == 0.0) {
            return "Calculating...";
        }
        return this.bandwidth + " KBPS";
    }

    public double getPacketLoss() {
        double d = 0.0;
        if (this.packetLost <= 0) {
            return 0.0;
        }
        d = this.packetLost / this.packetCount;
        return d;
    }

    public int getPacketCount() {
        return this.packetCount;
    }

    public int numPacketLost() {
        return this.packetLost;
    }

    public long getFrameCount() {
        return this.frameCount;
    }

    public int getPort() {
        return this.port;
    }

    public int getUdpBufferSize() {
        return this.udpbuffersize;
    }

    private final /* synthetic */ void this() {
        this.time = 0L;
        this.dataReceived = 0L;
        this.lastTick = 0L;
        this.bandwidth = 0.0;
        this.frameCount = 0L;
        this.frameTime = 0L;
        this.rtcpTime = 0L;
        this.packetCount = 0;
        this.lastSequence = 0;
        this.packetLost = 0;
        this.port = 0;
        this.udpbuffersize = 0;
        this.rtpDataBuffer = new byte[0];
        this.monitor = new Object();
        this.marker = false;
        this.useQueue = false;
        this.frameRead = new ByteBuffer();
    }

    RtpStream() {
        this.this();
        this.packetQueue = new Queue();
    }
}

