/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.bql;

import com.tridium.bql.compiler.BqlParser;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.collection.BEmptyTable;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;

public abstract class BqlQuery
implements OrdQuery {
    protected String scheme = "bql";
    private String body;
    private String unescaped;

    public static BqlQuery make(String string) {
        return BqlQuery.make("bql", string);
    }

    public static BqlQuery make(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            EmptyBqlQuery emptyBqlQuery = new EmptyBqlQuery();
            emptyBqlQuery.body = "";
            emptyBqlQuery.scheme = string;
            return emptyBqlQuery;
        }
        String string3 = SlotPath.unescape((String)string2);
        BqlTokenizer bqlTokenizer = new BqlTokenizer(string3);
        BqlParser bqlParser = new BqlParser();
        BqlQuery bqlQuery = bqlParser.parse(bqlTokenizer);
        bqlQuery.body = string2;
        bqlQuery.unescaped = string3;
        bqlQuery.scheme = string;
        return bqlQuery;
    }

    public abstract OrdTarget resolve(OrdTarget var1);

    public String getScheme() {
        return this.scheme;
    }

    public String getBody() {
        return this.body;
    }

    public String getUnescaped() {
        if (this.unescaped == null) {
            this.unescaped = this.body == null ? "" : SlotPath.unescape((String)this.body);
        }
        return this.unescaped;
    }

    protected void setBody(String string) {
        this.body = string;
    }

    public boolean isHost() {
        return false;
    }

    public boolean isSession() {
        return false;
    }

    public void normalize(OrdQueryList ordQueryList, int n) {
    }

    public String toString() {
        return this.getScheme() + ':' + this.getBody();
    }

    public static String toBqlLiteral(BSimple bSimple) {
        String string = null;
        String string2 = bSimple.getType().getModule().getModuleName().equals("baja") ? bSimple.getType().getTypeName() : bSimple.getType().toString();
        try {
            string = bSimple.encodeToString();
        }
        catch (Exception exception) {
            string = bSimple.toString();
        }
        return string2 + " '" + SlotPath.escape((String)string) + "'";
    }

    private static class EmptyBqlQuery
    extends BqlQuery {
        public OrdTarget resolve(OrdTarget ordTarget) {
            return new OrdTarget(ordTarget, (BObject)new BEmptyTable());
        }

        private EmptyBqlQuery() {
        }
    }
}

