/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.util;

import com.tridium.bql.util.BDynamicTimeRangeType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDynamicTimeRange
extends BSimple {
    public static final BDynamicTimeRange DEFAULT = BDynamicTimeRange.make(BAbsTime.NULL, BAbsTime.NULL);
    public static final BDynamicTimeRange TODAY = new BDynamicTimeRange(BDynamicTimeRangeType.today);
    public static final BDynamicTimeRange LAST_24_HOURS = new BDynamicTimeRange(BDynamicTimeRangeType.last24Hours);
    public static final BDynamicTimeRange YESTERDAY = new BDynamicTimeRange(BDynamicTimeRangeType.yesterday);
    public static final BDynamicTimeRange WEEK_TO_DATE = new BDynamicTimeRange(BDynamicTimeRangeType.weekToDate);
    public static final BDynamicTimeRange LAST_WEEK = new BDynamicTimeRange(BDynamicTimeRangeType.lastWeek);
    public static final BDynamicTimeRange LAST_7_DAYS = new BDynamicTimeRange(BDynamicTimeRangeType.last7Days);
    public static final BDynamicTimeRange MONTH_TO_DATE = new BDynamicTimeRange(BDynamicTimeRangeType.monthToDate);
    public static final BDynamicTimeRange LAST_MONTH = new BDynamicTimeRange(BDynamicTimeRangeType.lastMonth);
    public static final BDynamicTimeRange YEAR_TO_DATE = new BDynamicTimeRange(BDynamicTimeRangeType.yearToDate);
    public static final BDynamicTimeRange LAST_YEAR = new BDynamicTimeRange(BDynamicTimeRangeType.lastYear);
    private static final HashMap byId = new HashMap();
    private static final BTime LAST_INSTANT;
    public static final Type TYPE;
    private BDynamicTimeRangeType rangeType;
    private BAbsTime startTime;
    private BAbsTime endTime;
    static /* synthetic */ Class class$com$tridium$bql$util$BDynamicTimeRange;

    public static final BDynamicTimeRange make(BDynamicTimeRangeType bDynamicTimeRangeType) {
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.today) {
            return TODAY;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.last24Hours) {
            return LAST_24_HOURS;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.yesterday) {
            return YESTERDAY;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.weekToDate) {
            return WEEK_TO_DATE;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.lastWeek) {
            return LAST_WEEK;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.last7Days) {
            return LAST_7_DAYS;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.monthToDate) {
            return MONTH_TO_DATE;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.lastMonth) {
            return LAST_MONTH;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.yearToDate) {
            return YEAR_TO_DATE;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.lastYear) {
            return LAST_YEAR;
        }
        if (bDynamicTimeRangeType == BDynamicTimeRangeType.timeRange) {
            throw new IllegalArgumentException("Must provide time bounds with timeRange.");
        }
        throw new IllegalArgumentException();
    }

    public static final BDynamicTimeRange make(String string) {
        BDynamicTimeRange bDynamicTimeRange = null;
        String string2 = string.toLowerCase();
        bDynamicTimeRange = (BDynamicTimeRange)((Object)byId.get(string2));
        if (bDynamicTimeRange == null) {
            throw new IllegalArgumentException("Invalid period id: " + string);
        }
        return bDynamicTimeRange;
    }

    public static final BDynamicTimeRange make(BAbsTime bAbsTime, BAbsTime bAbsTime2) {
        BDynamicTimeRange bDynamicTimeRange = new BDynamicTimeRange();
        bDynamicTimeRange.rangeType = BDynamicTimeRangeType.timeRange;
        if (!bAbsTime.isNull() && !bAbsTime2.isNull() && bAbsTime.isAfter(bAbsTime2)) {
            throw new IllegalArgumentException("Start time is after endTime time.");
        }
        bDynamicTimeRange.startTime = bAbsTime;
        bDynamicTimeRange.endTime = bAbsTime2;
        return bDynamicTimeRange;
    }

    public static final BDynamicTimeRange fromOrdParams(String string) {
        String string2 = string.substring("period=".length());
        if (!string2.startsWith(BDynamicTimeRangeType.timeRange.getTag())) {
            return BDynamicTimeRange.make(BDynamicTimeRangeType.make(string2));
        }
        BAbsTime bAbsTime = BAbsTime.NULL;
        BAbsTime bAbsTime2 = BAbsTime.NULL;
        String[] stringArray = TextUtil.splitAndTrim((String)string2, (char)';');
        int n = 0;
        while (n < stringArray.length) {
            try {
                if (stringArray[n].startsWith("start=")) {
                    bAbsTime = BAbsTime.make((String)stringArray[n].substring("start=".length()));
                } else if (stringArray[n].startsWith("end=")) {
                    bAbsTime2 = BAbsTime.make((String)stringArray[n].substring("end=".length()));
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n;
        }
        return BDynamicTimeRange.make(bAbsTime, bAbsTime2);
    }

    public final BDynamicTimeRangeType getRangeType() {
        return this.rangeType;
    }

    public final BAbsTime getFixedStartTime() {
        return this.startTime;
    }

    public final BAbsTime getFixedEndTime() {
        return this.endTime;
    }

    public final BAbsTime getStartTime(BAbsTime bAbsTime) {
        if (this.rangeType == BDynamicTimeRangeType.timeRange) {
            return this.startTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)bAbsTime, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last24Hours) {
            return bAbsTime.subtract(BRelTime.DAY);
        }
        if (this.rangeType == BDynamicTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)bAbsTime.prevDay(), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.weekToDate) {
            BAbsTime bAbsTime2 = bAbsTime;
            while (bAbsTime2.getWeekday() != BWeekday.sunday) {
                bAbsTime2 = bAbsTime2.prevDay();
            }
            return BAbsTime.make((BAbsTime)bAbsTime2, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.lastWeek) {
            BAbsTime bAbsTime3 = bAbsTime;
            while (bAbsTime3.getWeekday() != BWeekday.sunday) {
                bAbsTime3 = bAbsTime3.prevDay();
            }
            bAbsTime3 = bAbsTime3.prevDay();
            while (bAbsTime3.getWeekday() != BWeekday.sunday) {
                bAbsTime3 = bAbsTime3.prevDay();
            }
            return BAbsTime.make((BAbsTime)bAbsTime3, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last7Days) {
            BAbsTime bAbsTime4 = bAbsTime;
            int n = 0;
            while (n < 7) {
                bAbsTime4 = bAbsTime4.prevDay();
                ++n;
            }
            return BAbsTime.make((BAbsTime)bAbsTime4, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicTimeRangeType.monthToDate) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)bAbsTime.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)bAbsTime.getTimeZone());
        }
        if (this.rangeType == BDynamicTimeRangeType.lastMonth) {
            BAbsTime bAbsTime5 = bAbsTime.prevMonth();
            return BAbsTime.make((int)bAbsTime5.getYear(), (BMonth)bAbsTime5.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)bAbsTime.getTimeZone());
        }
        if (this.rangeType == BDynamicTimeRangeType.yearToDate) {
            return BAbsTime.make((int)bAbsTime.getYear(), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)bAbsTime.getTimeZone());
        }
        if (this.rangeType == BDynamicTimeRangeType.lastYear) {
            return BAbsTime.make((int)(bAbsTime.getYear() - 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)bAbsTime.getTimeZone());
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public final BAbsTime getEndTime(BAbsTime bAbsTime) {
        if (this.rangeType == BDynamicTimeRangeType.timeRange) {
            return this.endTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)bAbsTime, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last24Hours) {
            return bAbsTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)bAbsTime.prevDay(), (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.weekToDate) {
            return bAbsTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.lastWeek) {
            BAbsTime bAbsTime2 = bAbsTime;
            while (bAbsTime2.getWeekday() != BWeekday.sunday) {
                bAbsTime2 = bAbsTime2.prevDay();
            }
            bAbsTime2 = bAbsTime2.prevDay();
            return BAbsTime.make((BAbsTime)bAbsTime2, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.last7Days) {
            BAbsTime bAbsTime3 = bAbsTime;
            bAbsTime3 = bAbsTime3.prevDay();
            return BAbsTime.make((BAbsTime)bAbsTime3, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicTimeRangeType.monthToDate) {
            return bAbsTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.lastMonth) {
            BAbsTime bAbsTime4 = bAbsTime.prevMonth();
            return BAbsTime.make((int)bAbsTime4.getYear(), (BMonth)bAbsTime4.getMonth(), (int)BAbsTime.getDaysInMonth((int)bAbsTime4.getYear(), (BMonth)bAbsTime4.getMonth()), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
        }
        if (this.rangeType == BDynamicTimeRangeType.yearToDate) {
            return bAbsTime;
        }
        if (this.rangeType == BDynamicTimeRangeType.lastYear) {
            return BAbsTime.make((int)(bAbsTime.getYear() - 1), (BMonth)BMonth.december, (int)BAbsTime.getDaysInMonth((int)(bAbsTime.getYear() - 1), (BMonth)BMonth.december), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public final String toOrdParams() {
        BAbsTime bAbsTime;
        if (this.rangeType != BDynamicTimeRangeType.timeRange) {
            return "period=" + this.rangeType.getTag();
        }
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("period=").append(this.rangeType.getTag());
        BAbsTime bAbsTime2 = this.getFixedStartTime();
        if (bAbsTime2 != null && !bAbsTime2.isNull()) {
            stringBuffer.append(';').append("start=").append(bAbsTime2.encodeToString());
        }
        if ((bAbsTime = this.getFixedEndTime()) != null && !bAbsTime.isNull()) {
            stringBuffer.append(';').append("end=").append(bAbsTime.encodeToString());
        }
        return stringBuffer.toString();
    }

    public final int hashCode() {
        int n = 23 + this.rangeType.hashCode();
        n = n * 37 + this.startTime.hashCode();
        return n * 37 + this.endTime.hashCode();
    }

    public final boolean equals(Object object) {
        if (object instanceof BDynamicTimeRange) {
            BDynamicTimeRange bDynamicTimeRange = (BDynamicTimeRange)((Object)object);
            boolean bl = false;
            if (this.rangeType == bDynamicTimeRange.rangeType && this.startTime.equals((Object)bDynamicTimeRange.startTime) && this.endTime.equals((Object)bDynamicTimeRange.endTime)) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        this.rangeType.encode(dataOutput);
        this.startTime.encode(dataOutput);
        this.endTime.encode(dataOutput);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        BDynamicTimeRange bDynamicTimeRange = new BDynamicTimeRange();
        bDynamicTimeRange.rangeType = (BDynamicTimeRangeType)BDynamicTimeRangeType.timeRange.decode(dataInput);
        bDynamicTimeRange.startTime = (BAbsTime)BAbsTime.DEFAULT.decode(dataInput);
        bDynamicTimeRange.endTime = (BAbsTime)BAbsTime.DEFAULT.decode(dataInput);
        return bDynamicTimeRange;
    }

    public final String encodeToString() throws IOException {
        if (this.rangeType != BDynamicTimeRangeType.timeRange) {
            return this.rangeType.encodeToString();
        }
        return this.rangeType.encodeToString() + ":startTime=" + this.startTime.encodeToString() + ";endTime=" + this.endTime.encodeToString();
    }

    public final BObject decodeFromString(String string) throws IOException {
        int n = string.indexOf(58);
        if (n == -1) {
            return BDynamicTimeRange.make(string);
        }
        int n2 = string.indexOf(59);
        BDynamicTimeRange bDynamicTimeRange = new BDynamicTimeRange();
        String string2 = string.substring(0, n);
        if (!string2.equals(BDynamicTimeRangeType.timeRange.getTag())) {
            throw new IOException("Invalid string encoding: " + string);
        }
        bDynamicTimeRange.rangeType = BDynamicTimeRangeType.timeRange;
        String string3 = string.substring(n + 1, n2);
        int n3 = string3.indexOf(61);
        if (n3 == -1) {
            throw new IOException("Invalid string encoding: " + string);
        }
        if (!string3.substring(0, n3).equals("startTime")) {
            throw new IOException("Invalid string encoding: " + string);
        }
        bDynamicTimeRange.startTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(string3.substring(n3 + 1));
        String string4 = string.substring(n2 + 1);
        n3 = string4.indexOf(61);
        if (n3 == -1) {
            throw new IOException("Invalid string encoding: " + string);
        }
        if (!string4.substring(0, n3).equals("endTime")) {
            throw new IOException("Invalid string encoding: " + string);
        }
        bDynamicTimeRange.endTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(string4.substring(n3 + 1));
        return bDynamicTimeRange;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BDynamicTimeRange() {
        this(BDynamicTimeRangeType.today);
    }

    private BDynamicTimeRange(BDynamicTimeRangeType bDynamicTimeRangeType) {
        this.rangeType = bDynamicTimeRangeType;
        this.startTime = this.endTime = BAbsTime.NULL;
    }

    static {
        byId.put(BDynamicTimeRangeType.today.getTag().toLowerCase(), TODAY);
        byId.put(BDynamicTimeRangeType.last24Hours.getTag().toLowerCase(), LAST_24_HOURS);
        byId.put(BDynamicTimeRangeType.yesterday.getTag().toLowerCase(), YESTERDAY);
        byId.put(BDynamicTimeRangeType.weekToDate.getTag().toLowerCase(), WEEK_TO_DATE);
        byId.put(BDynamicTimeRangeType.lastWeek.getTag().toLowerCase(), LAST_WEEK);
        byId.put(BDynamicTimeRangeType.last7Days.getTag().toLowerCase(), LAST_7_DAYS);
        byId.put(BDynamicTimeRangeType.monthToDate.getTag().toLowerCase(), MONTH_TO_DATE);
        byId.put(BDynamicTimeRangeType.lastMonth.getTag().toLowerCase(), LAST_MONTH);
        byId.put(BDynamicTimeRangeType.yearToDate.getTag().toLowerCase(), YEAR_TO_DATE);
        byId.put(BDynamicTimeRangeType.lastYear.getTag().toLowerCase(), LAST_YEAR);
        LAST_INSTANT = BTime.make((int)23, (int)59, (int)59, (int)999);
        Class clazz = class$com$tridium$bql$util$BDynamicTimeRange;
        if (clazz == null) {
            clazz = class$com$tridium$bql$util$BDynamicTimeRange = BDynamicTimeRange.class("[Lcom.tridium.bql.util.BDynamicTimeRange;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

