/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.projection;

import com.tridium.bql.Projection;
import com.tridium.bql.collection.BqlColumnList;
import com.tridium.bql.projection.BProjectionTable;
import com.tridium.bql.projection.ColumnProjectionColumn;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.sys.Context;

public class NoProjection
implements Projection {
    protected final ColumnList overrideCols;

    public final BITable getTable(BICollection bICollection, Context context) {
        BITable bITable = bICollection.toTable();
        BqlColumnList bqlColumnList = new BqlColumnList();
        this.addProjColumns(bqlColumnList, bITable.getColumns());
        return new BProjectionTable(bqlColumnList, bITable);
    }

    protected void addProjColumns(BqlColumnList bqlColumnList, ColumnList columnList) {
        int n;
        Column[] columnArray = columnList.list();
        if (this.overrideCols != null) {
            columnArray = new Column[this.overrideCols.size()];
            n = 0;
            while (n < columnArray.length) {
                columnArray[n] = columnList.get(this.overrideCols.get(n).getName());
                ++n;
            }
        }
        n = 0;
        while (n < columnArray.length) {
            if (columnArray[n] == null) {
                throw new IllegalStateException();
            }
            if (bqlColumnList.get(columnArray[n].getName()) == null && this.acceptColumn(columnArray[n])) {
                bqlColumnList.addColumn(new ColumnProjectionColumn(columnArray[n], null));
            }
            ++n;
        }
    }

    protected boolean acceptColumn(Column column) {
        if (this.overrideCols == null) {
            return true;
        }
        boolean bl = false;
        if (this.overrideCols.get(column.getName()) != null) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return " ";
    }

    public NoProjection() {
        this(null);
    }

    public NoProjection(ColumnList columnList) {
        this.overrideCols = columnList;
    }
}

