/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.BBqlExtent;
import com.tridium.bql.BSelect;
import com.tridium.bql.BTop;
import com.tridium.bql.compiler.BqlTokenizer;
import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.ExprParser;
import com.tridium.bql.compiler.ExprUtil;
import com.tridium.bql.compiler.RuntimeCompilerException;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnexpectedSymbolException;
import com.tridium.bql.compiler.UnexpectedTokenTypeException;
import com.tridium.bql.expression.BPath;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjection;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SelectParser
implements Constants {
    private static Lexicon lex = Lexicon.make((String)"bql");
    private BqlTokenizer tokens;
    private Token current;
    private BSelect query;
    private ExprParser exprParser;
    private boolean isAll;
    private BProjection projection;

    public static BSelect parse(BqlTokenizer bqlTokenizer) {
        SelectParser selectParser = new SelectParser(bqlTokenizer);
        return selectParser.parse();
    }

    public BSelect parse() {
        this.next();
        this.match(13);
        this.top();
        this.quantifier();
        this.projection();
        this.extent();
        this.predicate();
        this.having();
        this.ordering();
        this.tokens.push(this.current);
        return this.query;
    }

    protected void top() {
        if (this.current.type != 42) {
            return;
        }
        this.match(42);
        this.query.top(new BTop(Long.parseLong(this.match((int)3).lex)));
    }

    protected void quantifier() {
        switch (this.current.type) {
            case 19: {
                this.projection = Columns.distinctProjection();
                this.match(19);
                break;
            }
            case 20: {
                this.projection = Columns.projection();
                this.match(20);
                break;
            }
            default: {
                this.projection = Columns.projection();
            }
        }
    }

    protected void projection() {
        int n;
        switch (this.current.type) {
            case 6: {
                if (this.current.opType != 2) break;
            }
            case 12: {
                this.next();
                this.isAll = true;
                this.projection.add(Columns.make((BExpression)new BPath("*")));
                break;
            }
        }
        if (!this.isAll) {
            n = 1;
            while (this.current.type != 16 && this.current.type != 15 && this.current.type != 17 && this.current.type != 18 && this.current.type != 41 && this.current.type != 37 && this.current.type != 8 && this.current.type != 2) {
                if (this.isAll) {
                    throw new RuntimeCompilerException(this.current.index, this.lexText("projection.tooManyColumns"));
                }
                if (n == 0) {
                    this.match(11);
                }
                n = 0;
                this.tokens.push(this.current);
                this.projection.add(Columns.make((BExpression)this.expression()).as(this.as()));
            }
        }
        n = this.projection.getProjectionColumns().length;
        if (this.projection.isDistinct() && (n == 0 || this.isAll)) {
            throw new RuntimeCompilerException(this.current.index, this.lexText("projection.distinct.noColumns"));
        }
        if (n != 0) {
            this.query.select(this.projection);
        }
    }

    protected String as() {
        if (this.current.type == 14) {
            this.match(14);
            return this.match((int)5).lex;
        }
        return null;
    }

    protected void extent() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = Integer.MAX_VALUE;
        boolean bl2 = false;
        if (this.current.type == 16) {
            this.match(16);
            boolean bl3 = false;
            this.tokens.setShowWhite(true);
            while (!bl3) {
                switch (this.current.type) {
                    case 2: 
                    case 8: 
                    case 15: 
                    case 17: 
                    case 18: 
                    case 37: 
                    case 41: {
                        bl3 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(this.current.lex);
                        this.next();
                    }
                }
            }
            this.tokens.setShowWhite(false);
            if (this.current.type == 0) {
                this.next();
            }
        }
        while (this.current.type == 17 || this.current.type == 18) {
            switch (this.current.type) {
                case 17: {
                    if (bl) {
                        throw new RuntimeCompilerException(this.current.index, this.lexText("duplicate.depth"));
                    }
                    bl = true;
                    n = this.depth();
                    break;
                }
                case 18: {
                    if (bl2) {
                        throw new RuntimeCompilerException(this.current.index, this.lexText("duplicate.stop"));
                    }
                    this.match(18);
                    bl2 = true;
                    break;
                }
            }
        }
        this.query.from(new BBqlExtent(stringBuffer.toString().trim(), n, bl2));
    }

    protected int depth() {
        this.match(17);
        int n = Integer.MAX_VALUE;
        Token token = this.match(6);
        if (token.opType != 5) {
            throw new UnexpectedSymbolException(token.index, "=", Constants.OPTYPE_STRINGS[token.opType]);
        }
        if (this.current.type == 6 && this.current.opType == 2) {
            this.next();
        } else {
            n = Integer.parseInt(this.match((int)3).lex);
        }
        return n;
    }

    protected void predicate() {
        int n = this.current.index;
        if (this.current.type == 15) {
            BExpression bExpression = this.expression();
            if (!ExprUtil.isBoolean(bExpression)) {
                throw new RuntimeCompilerException(n, this.lexText("qualifier.required.boolean"), "<predicate>");
            }
            if (ExprUtil.isAggregateExpr(bExpression)) {
                throw new RuntimeCompilerException(n, this.lexText("predicate.noAggregates"), "<predicate>");
            }
            this.query.where(bExpression);
        }
    }

    protected void having() {
        if (this.current.type != 41) {
            return;
        }
        int n = this.current.index;
        BExpression bExpression = this.expression();
        if (!ExprUtil.isBoolean(bExpression)) {
            throw new RuntimeCompilerException(n, this.lexText("having.required.boolean"), "<having>");
        }
        if (!ExprUtil.isAggregateExpr(bExpression)) {
            throw new RuntimeCompilerException(n, this.lexText("having.required.aggrExpr"), "<having>");
        }
        if (this.isAll) {
            throw new RuntimeCompilerException(n, this.lexText("having.noStar"), "<having>");
        }
        this.query.having(bExpression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ordering() {
        if (this.current.type != 37) {
            return;
        }
        this.match(37);
        this.match(38);
        BOrdering bOrdering = new BOrdering();
        BProjectionColumn[] bProjectionColumnArray = this.query.hasProjection() ? this.query.getProjection().getProjectionColumns() : new BProjectionColumn[]{};
        boolean bl = true;
        do {
            BOrderByColumn bOrderByColumn = null;
            if (!bl) {
                this.match(11);
            }
            bl = false;
            if (this.current.type == 3) {
                int n = Integer.parseInt(this.match((int)3).lex);
                if (bProjectionColumnArray.length <= 0 || n > bProjectionColumnArray.length) throw new RuntimeCompilerException(this.current.index, this.lexText("orderby.unresolved.columnNum"), Integer.toString(n));
                bOrderByColumn = Columns.orderBy((int)n);
            } else if (this.current.type == 5) {
                String string = this.match((int)5).lex;
                int n = 0;
                while (n < bProjectionColumnArray.length && bOrderByColumn == null) {
                    if (bProjectionColumnArray[n].hasAlias() && bProjectionColumnArray[n].getAlias().equals(string)) {
                        bOrderByColumn = Columns.orderBy((int)(n + 1));
                    }
                    ++n;
                }
                if (bOrderByColumn == null) {
                    throw new RuntimeCompilerException(this.current.index, this.lexText("orderby.unresolved.alias"), string);
                }
            } else {
                this.tokens.push(this.current);
                BExpression bExpression = this.expression();
                if (ExprUtil.isAggregateExpr(bExpression) && this.isAll) {
                    throw new RuntimeCompilerException(this.current.index, this.lexText("orderby.noAggrWithStar"), "<order by>");
                }
                bOrderByColumn = Columns.orderBy((BExpression)bExpression);
            }
            switch (this.current.type) {
                case 40: {
                    this.match(40);
                    bOrderByColumn.desc();
                    break;
                }
                case 39: {
                    this.match(39);
                    break;
                }
            }
            bOrdering.add(bOrderByColumn);
        } while (this.current.type != 2);
        this.query.orderBy(bOrdering);
    }

    private final BExpression expression() {
        if (this.exprParser == null) {
            this.exprParser = new ExprParser();
        }
        BExpression bExpression = this.exprParser.parse(this.tokens);
        this.next();
        return bExpression;
    }

    private final void next() {
        this.current = this.tokens.next();
    }

    private final Token match(int n) {
        Token token = this.current;
        if (this.current.type != n) {
            throw new UnexpectedTokenTypeException(this.current.index, n, this.current.type);
        }
        this.next();
        return token;
    }

    private final String lexText(String string) {
        return lex.get(string, string);
    }

    private final /* synthetic */ void this() {
        this.isAll = false;
    }

    public SelectParser(BqlTokenizer bqlTokenizer) {
        this.this();
        this.tokens = bqlTokenizer;
        this.query = new BSelect();
        this.projection = null;
        this.isAll = false;
    }
}

