/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.Constants;
import com.tridium.bql.expression.BAggregateFunction;
import com.tridium.bql.expression.BBqlFunction;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BFieldExpression;
import javax.baja.query.expression.BSimpleExpression;
import javax.baja.query.expression.BUnaryExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;

public abstract class ExprUtil
implements Constants {
    private static final int BOOL_EXPR = 1;
    private static final int COMP_EXPR = 2;
    private static final int CONST_EXPR = 4;
    private static final int AGG_EXPR = 8;
    private static final String EXPR_FLAGS = "exprFlags";
    private static final String OP_ID = "opId";

    public static String toExprStr(BExpression bExpression) {
        BqlVisitor bqlVisitor = new BqlVisitor();
        bqlVisitor.visit(bExpression);
        return bqlVisitor.getQueryString();
    }

    public static boolean isUnary(BExpression bExpression) {
        return bExpression instanceof BUnaryExpression;
    }

    public static boolean isBinary(BExpression bExpression) {
        return bExpression instanceof BBinaryExpression;
    }

    public static boolean isSimple(BExpression bExpression) {
        return bExpression instanceof BSimpleExpression;
    }

    public static boolean isAggregateFunction(BExpression bExpression) {
        return bExpression instanceof BAggregateFunction;
    }

    public static boolean isField(BExpression bExpression) {
        return bExpression instanceof BFieldExpression;
    }

    public static BExpression tag(BExpression bExpression) {
        int n = 0;
        int n2 = -1;
        if (bExpression instanceof BPath || bExpression instanceof BBqlFunction) {
            n |= 3;
            if (bExpression instanceof BAggregateFunction) {
                n |= 8;
            }
        } else if (ExprUtil.isSimple(bExpression)) {
            BSimple bSimple = ((BSimpleExpression)bExpression).getSimpleValue();
            n |= 4;
            if (bSimple instanceof BString) {
                n |= 3;
            } else if (bSimple instanceof BNumber) {
                n |= 2;
            } else if (bSimple instanceof BBoolean) {
                n |= 1;
            } else {
                if (bSimple instanceof Comparable) {
                    n |= 2;
                }
                if (bSimple.getType() == BBoolean.DEFAULT.getType()) {
                    n |= 1;
                }
            }
        } else if (ExprUtil.isBinary(bExpression)) {
            BBinaryExpression bBinaryExpression = (BBinaryExpression)bExpression;
            String string = bBinaryExpression.op();
            if (ExprUtil.isConstant(bBinaryExpression.lhs()) && ExprUtil.isConstant(bBinaryExpression.rhs())) {
                n |= 4;
            }
            if (ExprUtil.isAggregateExpr(bBinaryExpression.lhs()) || ExprUtil.isAggregateExpr(bBinaryExpression.rhs())) {
                n |= 8;
            }
            if (Constants.boolOps.contains((Object)string)) {
                n |= 1;
                n2 = ExprUtil.toOpId(string);
            } else if (Constants.numericOps.contains((Object)string)) {
                n |= 2;
                n2 = ExprUtil.toOpId(string);
            }
        } else if (ExprUtil.isUnary(bExpression)) {
            BUnaryExpression bUnaryExpression = (BUnaryExpression)bExpression;
            String string = bUnaryExpression.op();
            if (ExprUtil.isConstant(bUnaryExpression.operand())) {
                n |= 4;
            }
            if (ExprUtil.isAggregateExpr(bUnaryExpression.operand())) {
                n |= 8;
            }
            if (Constants.boolOps.contains((Object)string)) {
                n |= 1;
                n2 = ExprUtil.toOpId(string);
            } else if (Constants.numericOps.contains((Object)string)) {
                n |= 2;
                n2 = ExprUtil.toOpId(string);
            }
        }
        bExpression.add(EXPR_FLAGS, (BValue)BInteger.make((int)n));
        if (n2 != -1) {
            bExpression.add(OP_ID, (BValue)BInteger.make((int)n2));
        }
        return bExpression;
    }

    public static final boolean isBoolean(BExpression bExpression) {
        Property property = bExpression.getProperty(EXPR_FLAGS);
        boolean bl = false;
        if (property != null && (bExpression.getInt(property) & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isComparable(BExpression bExpression) {
        Property property = bExpression.getProperty(EXPR_FLAGS);
        boolean bl = false;
        if (property != null && (bExpression.getInt(property) & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isConstant(BExpression bExpression) {
        Property property = bExpression.getProperty(EXPR_FLAGS);
        boolean bl = false;
        if (property != null && (bExpression.getInt(property) & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isAggregateExpr(BExpression bExpression) {
        Property property = bExpression.getProperty(EXPR_FLAGS);
        boolean bl = false;
        if (property != null && (bExpression.getInt(property) & 8) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final int getOpId(BExpression bExpression) {
        Property property = bExpression.getProperty(OP_ID);
        if (property == null) {
            int n = -1;
            if (bExpression instanceof BUnaryExpression) {
                n = ExprUtil.toOpId(((BUnaryExpression)bExpression).op());
            } else if (bExpression instanceof BBinaryExpression) {
                n = ExprUtil.toOpId(((BBinaryExpression)bExpression).op());
            }
            if (bExpression.get(OP_ID) != null) {
                bExpression.set(OP_ID, (BValue)BInteger.make((int)n));
            } else {
                bExpression.add(OP_ID, (BValue)BInteger.make((int)n));
            }
            property = bExpression.getProperty(OP_ID);
        }
        return bExpression.getInt(property);
    }

    private static final int toOpId(String string) {
        int n = 0;
        while (n < Constants.OPTYPE_STRINGS.length) {
            if (Constants.OPTYPE_STRINGS[n].equalsIgnoreCase(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

