/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.BBqlInterval;
import com.tridium.bql.compiler.LiteralParseException;
import com.tridium.bql.compiler.SimpleTypeRequiredException;
import com.tridium.bql.compiler.TimeUtil;
import java.io.IOException;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BqlTypeSpec {
    private static final int DATE = 0;
    private static final int TIME = 1;
    private static final int TIMESTAMP = 2;
    private static final int INTERVAL = 3;
    private String moduleName;
    private String typeName;
    private String bajaTypeName;
    private BTypeSpec bts;
    private int specialType;

    public BTypeSpec getTypeSpec() {
        if (this.bts == null) {
            this.bts = BTypeSpec.make((String)this.moduleName, (String)this.typeName);
        }
        return this.bts;
    }

    public BObject parse(String string) throws ModuleException, TypeException, IOException, LiteralParseException {
        if (this.specialType == -1) {
            BTypeSpec bTypeSpec = this.getTypeSpec();
            Type type = bTypeSpec.getResolvedType();
            BObject bObject = type.getInstance();
            if (!bObject.isSimple()) {
                throw new SimpleTypeRequiredException(0, type);
            }
            try {
                return ((BSimple)bObject).decodeFromString(string);
            }
            catch (IOException iOException) {
                throw new LiteralParseException(0, bTypeSpec.toString(), string);
            }
        }
        if (this.specialType == 0) {
            return TimeUtil.parseDate(string);
        }
        if (this.specialType == 1) {
            return TimeUtil.parseTime(string);
        }
        if (this.specialType == 2) {
            return TimeUtil.parseTimestamp(string);
        }
        if (this.specialType == 3) {
            return BBqlInterval.make(string);
        }
        throw new LiteralParseException(0, this.getTypeSpec().toString(), string);
    }

    private final void setBajaType(String string) {
        this.moduleName = "baja";
        string = string.toLowerCase();
        char c = string.charAt(0);
        switch (c) {
            case 'd': {
                if (string.equals("date")) {
                    this.specialType = 0;
                    this.moduleName = "baja";
                    this.bajaTypeName = "AbsTime";
                    break;
                }
                if (!string.equals("datetime")) break;
                this.specialType = 2;
                this.moduleName = "baja";
                this.bajaTypeName = "AbsTime";
                break;
            }
            case 't': {
                if (string.equals("time")) {
                    this.specialType = 1;
                    this.moduleName = "baja";
                    this.bajaTypeName = "Time";
                    break;
                }
                if (!string.equals("timestamp")) break;
                this.specialType = 2;
                this.moduleName = "baja";
                this.bajaTypeName = "AbsTime";
                break;
            }
            case 'i': {
                if (!string.equals("interval")) break;
                this.specialType = 3;
                this.moduleName = "bql";
                this.bajaTypeName = "BqlInterval";
                break;
            }
            default: {
                this.specialType = -1;
                this.bajaTypeName = string;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.specialType = -1;
    }

    public BqlTypeSpec(String string) {
        this.this();
        int n = string.indexOf(58);
        if (n == -1) {
            this.typeName = string;
            this.setBajaType(this.typeName);
        } else {
            this.moduleName = string.substring(0, n);
            this.typeName = string.substring(n + 1);
            this.specialType = -1;
            this.bajaTypeName = this.typeName;
        }
    }
}

