/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.compiler;

import com.tridium.bql.compiler.Constants;
import com.tridium.bql.compiler.RuntimeCompilerException;
import com.tridium.bql.compiler.Token;
import com.tridium.bql.compiler.UnrecognizedSymbolException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BqlTokenizer
implements Constants {
    private static final short WHITESPACE_CHAR = 1;
    private static final short WORD_START_CHAR = 2;
    private static final short WORD_CHAR = 4;
    private static final short ALPHA_CHAR = 8;
    private static final short NUMBER_CHAR = 16;
    private static final short OPERATOR_CHAR = 32;
    private static final short DELIMITER_CHAR = 64;
    private static short[] charTypes = new short[255];
    private char[] buf;
    private int bufLen;
    private int index;
    private int current;
    private int currentType;
    private Token peek;
    private Token poke;
    private Token eof;
    private boolean showWhite;

    public void setShowWhite(boolean bl) {
        if (bl == this.showWhite) {
            return;
        }
        this.showWhite = bl;
        if (!this.showWhite) {
            if (this.poke != null && this.poke.type == 0) {
                this.poke = null;
            }
            if (this.peek != null && this.peek.type == 0) {
                this.peek = null;
            }
        }
    }

    public void reset(String string) {
        this.buf = string.toCharArray();
        this.bufLen = this.buf.length;
        this.index = -1;
        this.advance();
    }

    public void reset() {
        this.index = -1;
        this.currentType = -1;
        this.current = -1;
        this.eof = null;
        this.poke = null;
        this.peek = null;
        this.advance();
    }

    public Token peek() {
        if (this.poke != null) {
            return this.poke;
        }
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    public void push(Token token) {
        if (this.poke != null) {
            throw new IllegalStateException("Only one token can be pushed back onto the tokenizer.");
        }
        if (!this.showWhite && token.type == 0) {
            return;
        }
        this.poke = token;
    }

    public Token next() {
        if (this.poke != null) {
            Token token = this.poke;
            this.poke = null;
            return token;
        }
        if (this.peek != null) {
            Token token = this.peek;
            this.peek = null;
            return token;
        }
        if (this.eof != null) {
            return this.eof;
        }
        int n = this.index;
        if (this.skipWhiteSpace() && this.showWhite) {
            return new Token(0, n, " ");
        }
        if (this.eof()) {
            this.eof = new Token(2, n, null);
            return this.eof;
        }
        if (BqlTokenizer.is(this.currentType, 2)) {
            return this.parseWord();
        }
        if (BqlTokenizer.is(this.currentType, 16)) {
            return this.parseNumber();
        }
        if (BqlTokenizer.is(this.currentType, 32)) {
            return this.parseOperator();
        }
        if (this.current == 34) {
            return this.parseDelimitedWord(1, 34);
        }
        if (this.current == 39) {
            return this.parseDelimitedWord(5, 39);
        }
        return this.parseChar();
    }

    private final Token parseChar() {
        int n = this.index;
        Token token = null;
        if (this.current == 40) {
            token = new Token(7, n, "(");
        } else if (this.current == 41) {
            token = new Token(8, n, ")");
        } else if (this.current == 123) {
            token = new Token(9, n, "{");
        } else if (this.current == 125) {
            token = new Token(10, n, "}");
        } else if (this.current == 91) {
            token = new Token(35, n, "[");
        } else if (this.current == 93) {
            token = new Token(36, n, "]");
        } else if (this.current == 44) {
            token = new Token(11, n, ",");
        } else if (this.current == 46) {
            token = new Token(12, n, ".");
        } else if (this.current == 59) {
            token = new Token(28, n, ";");
        } else if (this.current == 58) {
            this.advance();
            if (this.current == 58) {
                token = new Token(22, n, "::");
            } else {
                this.backup();
                token = new Token(21, n, ":");
            }
        } else {
            throw new UnrecognizedSymbolException(this.index, String.valueOf((char)this.current));
        }
        this.advance();
        return token;
    }

    private final Token parseWord() {
        int n = this.index;
        boolean bl = false;
        boolean bl2 = false;
        while (this.current != -1 && BqlTokenizer.is(this.currentType, 4)) {
            if (this.current == 58) {
                if (bl2) {
                    throw new RuntimeCompilerException(n, "invalid.typespec", new String(this.buf, n, this.index - n));
                }
                bl = true;
                bl2 = true;
            }
            this.advance();
        }
        if (bl && this.buf[this.index - 1] == ':') {
            bl = false;
            this.backup();
        }
        String string = new String(this.buf, n, this.index - n);
        Token token = null;
        token = bl ? new Token(23, n, string) : this.parseKeyword(string, n);
        if (token == null) {
            if (this.showWhite) {
                token = Token.identifier(n, string);
            } else {
                this.skipWhiteSpace();
                if (this.current == 39) {
                    return new Token(23, n, string);
                }
                token = Token.identifier(n, string);
            }
        }
        return token;
    }

    private final Token parseKeyword(String string, int n) {
        if (string.length() == 0) {
            return null;
        }
        string = string.toLowerCase();
        char c = string.charAt(0);
        switch (c) {
            case 'a': {
                if (string.equals("all")) {
                    return new Token(20, n, string);
                }
                if (string.equals("and")) {
                    return Token.operator(13, n, string);
                }
                if (string.equals("as")) {
                    return new Token(14, n, string);
                }
                if (!string.equals("asc")) break;
                return new Token(39, n, string);
            }
            case 'b': {
                if (string.startsWith("bqltime")) {
                    if (string.length() == 7) {
                        return new Token(33, n, string);
                    }
                    if (string.equals("bqltimerange")) {
                        return new Token(34, n, string);
                    }
                }
                if (!string.equals("by")) break;
                return new Token(38, n, string);
            }
            case 'c': {
                if (string.equals("current_date")) {
                    return new Token(29, n, string);
                }
                if (string.equals("currentdate")) {
                    return new Token(29, n, string);
                }
                if (string.equals("current_time")) {
                    return new Token(30, n, string);
                }
                if (string.equals("currenttime")) {
                    return new Token(30, n, string);
                }
                if (string.equals("current_timestamp")) {
                    return new Token(31, n, string);
                }
                if (!string.equals("currenttimestamp")) break;
                return new Token(31, n, string);
            }
            case 'd': {
                if (string.equals("depth")) {
                    return new Token(17, n, string);
                }
                if (string.equals("distinct")) {
                    return new Token(19, n, string);
                }
                if (!string.equals("desc")) break;
                return new Token(40, n, string);
            }
            case 'f': {
                if (string.equals("false")) {
                    return Token.bool(n, string, false);
                }
                if (!string.equals("from")) break;
                return new Token(16, n, string);
            }
            case 'h': {
                if (!string.equals("having")) break;
                return new Token(41, n, string);
            }
            case 'i': {
                if (!string.equals("in")) break;
                return Token.operator(15, n, string);
            }
            case 'l': {
                if (!string.equals("like")) break;
                return Token.operator(11, n, string);
            }
            case 'n': {
                if (string.equals("not")) {
                    return Token.operator(12, n, string);
                }
                if (!string.equals("null")) break;
                return new Token(26, n, string);
            }
            case 'o': {
                if (string.equals("or")) {
                    return Token.operator(14, n, string);
                }
                if (!string.equals("order")) break;
                return new Token(37, n, string);
            }
            case 's': {
                if (string.equals("select")) {
                    return new Token(13, n, string);
                }
                if (!string.equals("stop")) break;
                return new Token(18, n, string);
            }
            case 't': {
                if (string.equals("top")) {
                    return new Token(42, n, string);
                }
                if (!string.equals("true")) break;
                return Token.bool(n, string, true);
            }
            case 'w': {
                if (!string.equals("where")) break;
                return new Token(15, n, string);
            }
        }
        return null;
    }

    private final Token parseDelimitedWord(int n, int n2) {
        this.advance();
        int n3 = this.index;
        while (this.current != -1 && this.current != n2) {
            this.advance();
        }
        if (this.current != n2) {
            throw new RuntimeCompilerException(n3, "invalid.string.unterminated", "" + (char)n2);
        }
        int n4 = this.index;
        this.advance();
        return new Token(n, n3, new String(this.buf, n3, n4 - n3));
    }

    private final Token parseNumber() {
        int n = this.index;
        String string = null;
        while (this.current != -1 && BqlTokenizer.is(this.currentType, 16)) {
            this.advance();
        }
        String string2 = new String(this.buf, n, this.index - n);
        if (string != null) {
            this.error(n, string, string2);
        }
        return Token.number(n, string2);
    }

    private final Token parseOperator() {
        int n = this.index;
        int n2 = this.current;
        int n3 = this.nextChar();
        this.advance();
        int n4 = 2;
        if (n3 != 61) {
            if (n3 != -1) {
                this.backup();
            }
            n4 = 1;
        }
        while (true) {
            if (n4 == 1) {
                switch (n2) {
                    case 43: {
                        return Token.operator(0, n, "+");
                    }
                    case 45: {
                        return Token.operator(1, n, "-");
                    }
                    case 42: {
                        return Token.operator(2, n, "*");
                    }
                    case 47: {
                        return Token.operator(3, n, "/");
                    }
                    case 37: {
                        return Token.operator(4, n, "%");
                    }
                    case 61: {
                        return Token.operator(5, n, "=");
                    }
                    case 62: {
                        return Token.operator(7, n, ">");
                    }
                    case 60: {
                        return Token.operator(9, n, "<");
                    }
                    case 33: {
                        return Token.operator(12, n, "not");
                    }
                }
                this.error(n, "operator.format", new String(this.buf, n, n4));
                continue;
            }
            switch (n2) {
                case 33: {
                    return Token.operator(6, n, "!=");
                }
                case 62: {
                    return Token.operator(8, n, ">=");
                }
                case 60: {
                    return Token.operator(10, n, "<=");
                }
            }
            this.backup();
            n4 = 1;
        }
    }

    private final void advance() {
        ++this.index;
        if (this.index >= this.bufLen) {
            this.index = this.bufLen;
            this.currentType = -1;
            this.current = -1;
        } else {
            this.current = this.buf[this.index];
            this.currentType = this.current < 255 ? charTypes[this.current] : 8;
        }
    }

    private final void backup() {
        this.backup(1);
    }

    private final void backup(int n) {
        this.index -= n;
        if (this.index <= -1) {
            this.index = -1;
            this.currentType = -1;
            this.current = -1;
        }
        this.current = this.buf[this.index];
        this.currentType = this.current < 255 ? charTypes[this.current] : 8;
    }

    private final int nextChar() {
        this.advance();
        return this.current;
    }

    private final int nextType() {
        this.advance();
        return this.currentType;
    }

    private final boolean eof() {
        boolean bl = false;
        if (this.index == this.bufLen) {
            bl = true;
        }
        return bl;
    }

    private final boolean skipWhiteSpace() {
        boolean bl = false;
        while (BqlTokenizer.isWhiteSpace(this.current)) {
            bl = true;
            this.advance();
        }
        return bl;
    }

    private static final boolean isWhiteSpace(int n) {
        int n2 = n != -1 && n < 255 ? charTypes[n] : 8;
        boolean bl = false;
        if ((n2 & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    private static final boolean is(int n, int n2) {
        boolean bl = false;
        if ((n & n2) != 0) {
            bl = true;
        }
        return bl;
    }

    private static final boolean isNot(int n, int n2) {
        boolean bl = false;
        if ((n & n2) == 0) {
            bl = true;
        }
        return bl;
    }

    private static final boolean isAndNot(int n, int n2, int n3) {
        boolean bl = false;
        if ((n & n2) != 0 && (n & n3) == 0) {
            bl = true;
        }
        return bl;
    }

    private final void error(int n, String string) {
        throw new RuntimeCompilerException(n, string);
    }

    private final void error(int n, String string, String string2) {
        throw new RuntimeCompilerException(n, string, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        try {
            BqlTokenizer bqlTokenizer = new BqlTokenizer(stringArray[0]);
            bqlTokenizer.setShowWhite(true);
            while (true) {
                Token token = bqlTokenizer.next();
                if (token.type == 2) {
                    return;
                }
                System.out.println(token);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.current = -1;
        this.currentType = -1;
        this.showWhite = false;
    }

    public BqlTokenizer(String string) {
        this.this();
        this.reset(string);
    }

    static {
        charTypes[32] = (short)(charTypes[32] | 0x41);
        charTypes[10] = (short)(charTypes[10] | 0x41);
        charTypes[13] = (short)(charTypes[13] | 0x41);
        charTypes[9] = (short)(charTypes[9] | 0x41);
        charTypes[44] = (short)(charTypes[44] | 0x40);
        charTypes[40] = (short)(charTypes[40] | 0x40);
        charTypes[41] = (short)(charTypes[41] | 0x40);
        charTypes[95] = (short)(charTypes[95] | 6);
        charTypes[36] = (short)(charTypes[36] | 6);
        charTypes[45] = (short)(charTypes[45] | 4);
        charTypes[58] = (short)(charTypes[58] | 4);
        charTypes[43] = (short)(charTypes[43] | 0x20);
        charTypes[45] = (short)(charTypes[45] | 0x20);
        charTypes[42] = (short)(charTypes[42] | 0x20);
        charTypes[47] = (short)(charTypes[47] | 0x20);
        charTypes[61] = (short)(charTypes[61] | 0x20);
        charTypes[60] = (short)(charTypes[60] | 0x20);
        charTypes[62] = (short)(charTypes[62] | 0x20);
        charTypes[37] = (short)(charTypes[37] | 0x20);
        charTypes[33] = (short)(charTypes[33] | 0x20);
        int n = 65;
        while (n <= 90) {
            int n2 = n++;
            charTypes[n2] = (short)(charTypes[n2] | 0xE);
        }
        n = 97;
        while (n <= 122) {
            int n3 = n++;
            charTypes[n3] = (short)(charTypes[n3] | 0xE);
        }
        n = 48;
        while (n <= 57) {
            int n4 = n++;
            charTypes[n4] = (short)(charTypes[n4] | 0x14);
        }
    }
}

