/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql.collection;

import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.util.BqlUtil;
import com.tridium.script.ScriptField;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class FieldColumn
extends BqlColumn {
    private Context cx;
    private ScriptField field;
    private Type columnType;

    public String getName() {
        return this.field.scriptName();
    }

    public String getDisplayName(Context context) {
        return this.field.scriptDisplayName(null, context);
    }

    public Type getType() {
        return this.columnType;
    }

    public BObject get(BObject bObject) {
        try {
            return BqlUtil.toBObject(this.field.scriptGet(bObject, this.cx));
        }
        catch (Exception exception) {
            System.out.println("field name = " + this.field.scriptName());
            exception.printStackTrace();
            return null;
        }
    }

    public float getFloat(BObject bObject) {
        try {
            Object object = this.field.scriptGet(bObject, this.cx);
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            return ((BFloat)object).getFloat();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    public double getDouble(BObject bObject) {
        try {
            Object object = this.field.scriptGet(bObject, this.cx);
            if (object instanceof Double) {
                return (Double)object;
            }
            return ((BDouble)object).getDouble();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String getString(BObject bObject) {
        try {
            Object object = this.field.scriptGet(bObject, this.cx);
            if (object == null) {
                return "null";
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof BString) {
                return ((BString)object).getString();
            }
            return object.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean getBoolean(BObject bObject) {
        try {
            Object object = this.field.scriptGet(bObject, this.cx);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return ((BBoolean)object).getBoolean();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getInt(BObject bObject) {
        try {
            Object object = this.field.scriptGet(bObject, this.cx);
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return ((BInteger)object).getInt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public long getLong(BObject bObject) {
        try {
            Object object = this.field.scriptGet(bObject, this.cx);
            if (object instanceof Long) {
                return (Long)object;
            }
            return ((BLong)object).getLong();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    public int getFlags(BObject bObject) {
        return 0;
    }

    public BFacets getFacets(BObject bObject) {
        return BFacets.NULL;
    }

    public FieldColumn(ScriptField scriptField, Context context) {
        this.field = scriptField;
        this.cx = context;
        this.columnType = BqlUtil.toType(scriptField.scriptType());
    }
}

