/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.BBqlExtent;
import com.tridium.bql.BSelect;
import com.tridium.bql.Ordering;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.RangeUtil;
import com.tridium.bql.collection.BAggregateTable;
import com.tridium.bql.collection.BDistinctTable;
import com.tridium.bql.collection.BTopTable;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.projection.AllProjection;
import com.tridium.bql.projection.SomeProjection;
import com.tridium.bql.query.BqlVisitor;
import javax.baja.bql.BqlQuery;
import javax.baja.bql.Queryable;
import javax.baja.collection.BICollection;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.InvalidRootSchemeException;
import javax.baja.naming.OrdTarget;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.util.IContextFilter;
import javax.baja.util.IFilter;

public class SelectQuery
extends BqlQuery {
    private BSelect query;
    private Context cx;

    public RangeSet getRange(String string, Type type, boolean bl) {
        return this.query.hasPredicate() ? new RangeUtil(this.query.getPredicate().getPredicateExpr(), this.query.getExprEngine(), string, type).solveRange(bl) : Range.ALL;
    }

    public BSelect getSelect() {
        return this.query;
    }

    public boolean hasPredicate() {
        return this.query.hasPredicate();
    }

    public OrdTarget resolve(OrdTarget ordTarget) {
        this.cx = ordTarget;
        this.query.updateTime();
        boolean bl = false;
        Object object = this.query.hasExtent() && !this.query.getExtent().isBaseExtent() ? ((BBqlExtent)this.query.getExtent()).getExtent(ordTarget, this) : this.getExtentFromBase(ordTarget);
        OrdTarget ordTarget2 = new OrdTarget(ordTarget, (BObject)object);
        if (this.query.hasPredicate()) {
            object = object.filter((IFilter)new BooleanFilter(this.query));
        }
        if (this.query.hasAggregates()) {
            object = new BAggregateTable((BICollection)object, this.query, this.cx);
            bl = true;
        }
        if (this.query.hasProjection() && this.query.getProjection().isDistinct() && !bl) {
            object = new BDistinctTable(object.toTable(), this.query, this.cx);
        }
        if (this.query.hasOrdering()) {
            object = new Ordering(this.query).order((BICollection)object, this.cx);
        }
        if (this.query.getTop() != null) {
            object = new BTopTable(object.toTable(), this.query.getTop().getLimit());
        }
        if (this.query.hasProjection()) {
            object = this.toProjection((BICollection)object);
        }
        return new OrdTarget(ordTarget2, (BObject)object);
    }

    protected BICollection getExtentFromBase(OrdTarget ordTarget) {
        if (ordTarget == null) {
            throw new InvalidRootSchemeException("bql");
        }
        BObject bObject = ordTarget.get();
        if (bObject instanceof Queryable) {
            return (BICollection)((Queryable)bObject).bqlQuery(ordTarget, this);
        }
        if (bObject instanceof BComplex) {
            return ((BBqlExtent)this.query.getExtent()).getExtent(ordTarget, this);
        }
        if (bObject instanceof BICollection) {
            return (BICollection)bObject;
        }
        throw new InvalidOrdBaseException();
    }

    protected BICollection toProjection(BICollection bICollection) {
        if (this.isSelectStar()) {
            return new AllProjection().getTable(bICollection, this.cx);
        }
        BProjectionColumn[] bProjectionColumnArray = this.query.getProjection().getProjectionColumns();
        return new SomeProjection(bProjectionColumnArray, this.query.getExprEngine()).getTable(bICollection, this.cx);
    }

    protected boolean isSelectStar() {
        if (!this.query.hasProjection()) {
            return false;
        }
        BProjectionColumn[] bProjectionColumnArray = this.query.getProjection().getProjectionColumns();
        boolean bl = false;
        if (bProjectionColumnArray.length == 1 && bProjectionColumnArray[0].getColumnExpression() instanceof BPath && ((BPath)bProjectionColumnArray[0].getColumnExpression()).getField().equals("*")) {
            bl = true;
        }
        return bl;
    }

    public SelectQuery(BSelect bSelect) {
        this.query = bSelect;
        BqlVisitor bqlVisitor = new BqlVisitor();
        bqlVisitor.visit(bSelect);
        this.setBody(bqlVisitor.getQueryString());
    }

    private static class BooleanFilter
    implements IContextFilter {
        private BExpression boolExpr;
        private ExprEngine engine;

        public boolean accept(Object object, Context context) {
            BObject bObject = this.engine.evaluate(this.boolExpr, (BObject)object, context);
            boolean bl = false;
            if (bObject == BBoolean.TRUE) {
                bl = true;
            }
            return bl;
        }

        public boolean accept(Object object) {
            return this.accept(object, null);
        }

        public BooleanFilter(BSelect bSelect) {
            this(bSelect.getPredicate().getPredicateExpr(), bSelect.getExprEngine());
        }

        public BooleanFilter(BExpression bExpression, ExprEngine exprEngine) {
            this.boolExpr = bExpression;
            this.engine = exprEngine;
        }
    }
}

