/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.RangeSet;
import com.tridium.bql.RangeSetImpl;
import javax.baja.query.BNull;
import javax.baja.sys.BSimple;

public class Range
implements RangeSet,
Comparable {
    public static final Range ALL = new Range(null, false, null, false);
    public static final Range NONE = new Range(null, true, null, true);
    public final BSimple min;
    public final boolean minInclusive;
    public final BSimple max;
    public final boolean maxInclusive;

    public boolean isSingletonRange() {
        boolean bl = false;
        if (this.minInclusive && this.maxInclusive && this.min != null && this.max != null && this.min.equals((Object)this.max)) {
            bl = true;
        }
        return bl;
    }

    public BSimple getSingleton() {
        if (!this.isSingletonRange()) {
            throw new IllegalStateException("Not singleton range.");
        }
        return this.min;
    }

    public int getCount() {
        return 1;
    }

    public Range getRange(int n) {
        if (n == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException(n + 62);
    }

    public RangeSet intersection() {
        return this;
    }

    public boolean isAll() {
        boolean bl = false;
        if (this.min == null && !this.minInclusive && this.max == null && !this.maxInclusive) {
            bl = true;
        }
        return bl;
    }

    public boolean isNone() {
        boolean bl = false;
        if (this.min == null && this.minInclusive && this.max == null && this.maxInclusive) {
            bl = true;
        }
        return bl;
    }

    public RangeSet not() {
        Range range = null;
        Range range2 = null;
        if (this.isAll()) {
            return NONE;
        }
        if (this.isNone()) {
            return ALL;
        }
        if (this.min != null) {
            range = new Range(null, false, this.min, this.minInclusive ^ true);
        }
        if (this.max != null) {
            range2 = new Range(this.max, this.maxInclusive ^ true, null, false);
        }
        if (range != null && range2 != null) {
            return new RangeSetImpl(new Range[]{range, range2});
        }
        if (range != null) {
            return range;
        }
        return range2;
    }

    public void sort() {
    }

    public RangeSet union() {
        return this;
    }

    public int compareTo(Object object) {
        int n;
        Range range = this;
        Range range2 = (Range)object;
        if (range.isAll() || range2.isAll()) {
            if (range.isAll() && range2.isAll()) {
                return 0;
            }
            if (range.isAll()) {
                return 1;
            }
            return -1;
        }
        if (range.isNone() || range2.isNone()) {
            if (range.isNone() && range2.isNone()) {
                return 0;
            }
            if (range.isNone()) {
                return -1;
            }
            return 1;
        }
        if (range.min == null && range2.min != null) {
            return -1;
        }
        if (range.min != null && range2.min == null) {
            return 1;
        }
        if (range.min != null && range2.min != null) {
            if (range.min instanceof Comparable) {
                n = ((Comparable)range.min).compareTo(range2.min);
                if (n != 0) {
                    return n;
                }
                if (range.minInclusive && !range2.minInclusive) {
                    return -1;
                }
                if (!range.minInclusive && range2.minInclusive) {
                    return 1;
                }
            } else {
                if (!range.isSingletonRange() || !range2.isSingletonRange()) {
                    throw new IllegalStateException("cannot compare non-Comparables that are not singleton ranges.");
                }
                if (range.min.equals((Object)range2.min)) {
                    return 0;
                }
                return range.min.toString().compareTo(range2.min.toString());
            }
        }
        if (range.max == null && range2.max != null) {
            return 1;
        }
        if (range.max != null && range2.max == null) {
            return -1;
        }
        if (range.max != null && range2.max != null) {
            n = ((Comparable)range.max).compareTo(range2.max);
            if (n != 0) {
                return n;
            }
            if (range.maxInclusive && !range2.maxInclusive) {
                return 1;
            }
            if (!range.maxInclusive && range2.maxInclusive) {
                return -1;
            }
        }
        return 0;
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        if (this.max != null) {
            n2 = this.max.hashCode();
        }
        n = 31 * n + n2;
        n = 31 * n + (this.maxInclusive ? 1231 : 1237);
        int n3 = 0;
        if (this.min != null) {
            n3 = this.min.hashCode();
        }
        n = 31 * n + n3;
        n = 31 * n + (this.minInclusive ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (this.max == null ? range.max != null : !this.max.equals((Object)range.max)) {
            return false;
        }
        if (this.maxInclusive != range.maxInclusive) {
            return false;
        }
        if (this.min == null ? range.min != null : !this.min.equals((Object)range.min)) {
            return false;
        }
        return this.minInclusive == range.minInclusive;
    }

    public String toString() {
        if (this.isAll()) {
            return "(-inf, inf)";
        }
        if (this.isNone()) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        if (this.min == null) {
            stringBuffer.append("(-inf");
        } else {
            if (this.minInclusive) {
                stringBuffer.append('[');
            } else {
                stringBuffer.append('(');
            }
            stringBuffer.append(this.min);
        }
        stringBuffer.append(", ");
        if (this.max == null) {
            stringBuffer.append("inf)");
        } else {
            stringBuffer.append(this.max);
            if (this.maxInclusive) {
                stringBuffer.append(']');
            } else {
                stringBuffer.append(')');
            }
        }
        return stringBuffer.toString();
    }

    public final BSimple getMin() {
        return this.min;
    }

    public final BSimple getMax() {
        return this.max;
    }

    public final boolean getMinInclusive() {
        return this.minInclusive;
    }

    public final boolean getMaxInclusive() {
        return this.maxInclusive;
    }

    public static RangeSet union(Range range, Range range2) {
        Range range3 = null;
        if (range.equals(range2)) {
            return range;
        }
        if (range.isSingletonRange() && range2.isSingletonRange()) {
            return new RangeSetImpl(new Range[]{range, range2});
        }
        if (range.compareTo(range2) > 0) {
            range3 = range;
            range = range2;
            range2 = range3;
        }
        if (range.isNone()) {
            return range2;
        }
        if (Range.intersection(range, range2).isNone()) {
            Range range4 = new Range(range.max, true, null, false);
            Range range5 = new Range(range2.min, true, null, false);
            if (range4.compareTo(range5) == 0 && (range.maxInclusive || range2.minInclusive)) {
                return new Range(range.min, range.minInclusive, range2.max, range2.maxInclusive);
            }
            return new RangeSetImpl(new Range[]{range, range2});
        }
        if (range.min == null && range2.max == null) {
            return ALL;
        }
        range3 = new Range(range.min, range.minInclusive, range2.max, range2.maxInclusive);
        if (range.compareTo(range3) < 0) {
            return range3;
        }
        return range;
    }

    public static Range intersection(Range range, Range range2) {
        Range range3;
        if (range.isAll()) {
            return range2;
        }
        if (range2.isAll()) {
            return range;
        }
        if (range.isNone() || range2.isNone()) {
            return NONE;
        }
        if (range.equals(range2)) {
            return range;
        }
        if (range.compareTo(range2) > 0) {
            range3 = range;
            range = range2;
            range2 = range3;
        }
        Range range4 = null;
        Range range5 = null;
        Range range6 = null;
        range4 = new Range(range.max, true, null, false);
        range5 = new Range(range2.min, true, null, false);
        if (range4.compareTo(range5) == 0) {
            if (!range.maxInclusive || !range2.minInclusive) {
                return NONE;
            }
            return new Range(range.max);
        }
        range6 = new Range(range2.min, range2.minInclusive, range.max, range.maxInclusive);
        if (range2.min != null && range6.compareTo(range3 = new Range(range2.min, range2.minInclusive, range2.min, range2.minInclusive)) < 0) {
            return NONE;
        }
        range3 = new Range(range6.min, range6.minInclusive, range2.max, range2.maxInclusive);
        if (range6.compareTo(range3) > 0) {
            range6 = range3;
        }
        return range6;
    }

    public Range(BSimple bSimple) {
        this(bSimple, true, bSimple, true);
    }

    public Range(BSimple bSimple, boolean bl, BSimple bSimple2, boolean bl2) {
        if (bSimple != null && bSimple.equals((Object)BNull.NULL)) {
            bSimple = null;
        }
        if (bSimple2 != null && bSimple2.equals((Object)BNull.NULL)) {
            bSimple2 = null;
        }
        this.min = bSimple;
        this.max = bSimple2;
        this.minInclusive = bl;
        this.maxInclusive = bl2;
        if (bSimple != null && bSimple2 != null) {
            if (!bSimple.getType().equals(bSimple2.getType())) {
                throw new IllegalStateException("min and max must have same type.");
            }
            if (!(bSimple instanceof Comparable) && !this.isSingletonRange()) {
                throw new IllegalStateException("must be a singleton range if items in range are not Comparable.");
            }
        }
    }
}

