/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.BDateTimeSource;
import com.tridium.bql.collection.BArrayCollection;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.bql.projection.SomeProjection;
import com.tridium.bql.query.BqlVisitor;
import com.tridium.collection.BEmptyTable;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.query.BExpression;
import javax.baja.query.BNull;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public abstract class ExpressionQuery
extends BqlQuery {
    public static SingleExpr make(BExpression bExpression) {
        return new SingleExpr(bExpression);
    }

    public static class SingleExpr
    extends ExpressionQuery {
        private BExpression expr;

        public OrdTarget resolve(OrdTarget ordTarget) {
            ExprEngine exprEngine = new ExprEngine(new BDateTimeSource());
            BObject bObject = exprEngine.evaluate(this.expr, ordTarget.get(), (Context)ordTarget);
            if (bObject.equals((Object)BNull.NULL)) {
                throw new UnresolvedException();
            }
            return new OrdTarget(ordTarget, bObject);
        }

        public String toString() {
            BqlVisitor bqlVisitor = new BqlVisitor();
            bqlVisitor.visit(this.expr);
            return bqlVisitor.getQueryString();
        }

        public SingleExpr(BExpression bExpression) {
            this.expr = bExpression;
        }
    }

    public static class ExprSet
    extends ExpressionQuery {
        private final BProjectionColumn[] exprCols;
        private BITable proj;

        public OrdTarget resolve(OrdTarget ordTarget) {
            if (this.exprCols.length == 0) {
                return new OrdTarget(ordTarget, (BObject)new BEmptyTable());
            }
            if (this.proj == null) {
                BArrayCollection bArrayCollection = new BArrayCollection(new BObject[]{ordTarget.get()}, (Context)ordTarget);
                SomeProjection someProjection = new SomeProjection(this.exprCols, new ExprEngine(null));
                this.proj = someProjection.getTable((BICollection)bArrayCollection, (Context)ordTarget);
            }
            return new OrdTarget(ordTarget, (BObject)this.proj);
        }

        private final String toQueryString() {
            StringBuffer stringBuffer = new StringBuffer().append('{');
            BqlVisitor bqlVisitor = new BqlVisitor();
            int n = 0;
            while (n < this.exprCols.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                bqlVisitor.visit(this.exprCols[n]);
                stringBuffer.append(bqlVisitor.getQueryString());
                ++n;
            }
            return stringBuffer.append('}').toString();
        }

        public ExprSet(BExpression[] bExpressionArray) {
            this.exprCols = new BProjectionColumn[bExpressionArray.length];
            int n = 0;
            while (n < bExpressionArray.length) {
                this.exprCols[n] = Columns.make((BExpression)bExpressionArray[n]);
                ++n;
            }
            this.setBody(this.toQueryString());
        }

        public ExprSet(BProjectionColumn[] bProjectionColumnArray) {
            this.exprCols = bProjectionColumnArray;
            this.setBody(this.toQueryString());
        }
    }
}

