/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bql;

import com.tridium.bql.compiler.RuntimeCompilerException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BBqlInterval
extends BSimple
implements BIComparable {
    public static final BBqlInterval DEFAULT = BBqlInterval.make("0ms");
    private static final int MILLIS = 1;
    private static final int SECONDS = 2;
    private static final int MINUTES = 4;
    private static final int HOURS = 8;
    private static final int DAYS = 16;
    private static final int WEEKS = 32;
    private static final int MONTHS = 64;
    private static final int YEARS = 128;
    public static final Type TYPE;
    private String format;
    private int fields;
    private long ms;
    private int seconds;
    private int minutes;
    private int hours;
    private int days;
    private int weeks;
    private int months;
    private int years;
    private long allMilliCache;
    private BRelTime milliCache;
    static /* synthetic */ Class class$com$tridium$bql$BBqlInterval;

    public static final BBqlInterval make(String string) {
        return new BBqlInterval(string);
    }

    public final BAbsTime addTo(BAbsTime bAbsTime) {
        if (this.useMilliMath()) {
            return bAbsTime.add(this.getRelTime());
        }
        int n = bAbsTime.getYear();
        BMonth bMonth = bAbsTime.getMonth();
        int n2 = bAbsTime.getDay();
        if ((this.fields & 0x80) != 0) {
            n += this.years;
        }
        if ((this.fields & 0x40) != 0) {
            int n3 = 0;
            while (n3 < this.months) {
                bMonth = bMonth.next();
                ++n3;
            }
        }
        if ((this.fields & 0xC0) != 0) {
            bAbsTime = BAbsTime.make((int)n, (BMonth)bMonth, (int)n2, (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)bAbsTime.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
        }
        if ((this.fields & 0x20) != 0) {
            bAbsTime = BBqlInterval.addDays(bAbsTime, this.weeks * 7);
        }
        if ((this.fields & 0x10) != 0) {
            bAbsTime = BBqlInterval.addDays(bAbsTime, this.days);
        }
        if ((this.fields & 0xF) != 0) {
            bAbsTime = bAbsTime.add(this.getRelTime());
        }
        return bAbsTime;
    }

    public static final BAbsTime addDays(BAbsTime bAbsTime, int n) {
        int n2 = bAbsTime.getYear();
        int n3 = bAbsTime.getDayOfYear();
        int n4 = BAbsTime.getDaysInYear((int)n2);
        n3 += n;
        while (n3 > n4) {
            n3 -= n4;
            n4 = BAbsTime.getDaysInYear((int)(++n2));
        }
        return BAbsTime.makeDayOfYear((int)n2, (int)n3, (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)bAbsTime.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
    }

    public final BAbsTime subtractFrom(BAbsTime bAbsTime) {
        if (this.useMilliMath()) {
            return bAbsTime.subtract(this.getRelTime());
        }
        int n = bAbsTime.getYear();
        BMonth bMonth = bAbsTime.getMonth();
        int n2 = bAbsTime.getDay();
        if ((this.fields & 0x80) != 0) {
            n -= this.years;
        }
        if ((this.fields & 0x40) != 0) {
            int n3 = 0;
            while (n3 < this.months) {
                bMonth = bMonth.previous();
                ++n3;
            }
        }
        if ((this.fields & 0xC0) != 0) {
            bAbsTime = BAbsTime.make((int)n, (BMonth)bMonth, (int)n2, (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)bAbsTime.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
        }
        if ((this.fields & 0x20) != 0) {
            bAbsTime = BBqlInterval.subtractDays(bAbsTime, this.weeks * 7);
        }
        if ((this.fields & 0x10) != 0) {
            bAbsTime = BBqlInterval.subtractDays(bAbsTime, this.days);
        }
        if ((this.fields & 0xF) != 0) {
            bAbsTime = bAbsTime.subtract(this.getRelTime());
        }
        return bAbsTime;
    }

    public static final BAbsTime subtractDays(BAbsTime bAbsTime, int n) {
        int n2 = bAbsTime.getYear();
        int n3 = bAbsTime.getDayOfYear();
        int n4 = BAbsTime.getDaysInYear((int)n2);
        n3 -= n;
        while (n3 < 1) {
            n4 = BAbsTime.getDaysInYear((int)(--n2));
            n3 += n4;
        }
        return BAbsTime.makeDayOfYear((int)n2, (int)n3, (int)bAbsTime.getHour(), (int)bAbsTime.getMinute(), (int)bAbsTime.getSecond(), (int)bAbsTime.getMillisecond(), (BTimeZone)bAbsTime.getTimeZone());
    }

    private final boolean useMilliMath() {
        boolean bl = false;
        if ((this.fields & 0xF0) == 0) {
            bl = true;
        }
        return bl;
    }

    private final BRelTime getRelTime() {
        if (this.milliCache != null) {
            return this.milliCache;
        }
        long l = 0L;
        if ((this.fields & 1) != 0) {
            l = this.ms;
        }
        if ((this.fields & 2) != 0) {
            l += (long)this.seconds * 1000L;
        }
        if ((this.fields & 4) != 0) {
            l += (long)this.minutes * 60000L;
        }
        if ((this.fields & 8) != 0) {
            l += (long)this.hours * 3600000L;
        }
        this.milliCache = BRelTime.make((long)l);
        return this.milliCache;
    }

    private final long getAllMillis() {
        if (this.allMilliCache == (long)-1) {
            this.allMilliCache = 0L;
            if ((this.fields & 1) != 0) {
                this.allMilliCache = this.ms;
            }
            if ((this.fields & 2) != 0) {
                this.allMilliCache += (long)this.seconds * 1000L;
            }
            if ((this.fields & 4) != 0) {
                this.allMilliCache += (long)this.minutes * 60000L;
            }
            if ((this.fields & 8) != 0) {
                this.allMilliCache += (long)this.hours * 3600000L;
            }
            if ((this.fields & 0x10) != 0) {
                this.allMilliCache += (long)this.days * 86400000L;
            }
            if ((this.fields & 0x20) != 0) {
                this.allMilliCache += (long)this.weeks * 604800000L;
            }
            if ((this.fields & 0x40) != 0) {
                this.allMilliCache += (long)this.months * 2592000000L;
            }
            if ((this.fields & 0x80) != 0) {
                this.allMilliCache += (long)this.years * 31536000000L;
            }
        }
        return this.allMilliCache;
    }

    public final int compareTo(Object object) {
        long l;
        BBqlInterval bBqlInterval = (BBqlInterval)((Object)object);
        long l2 = this.getAllMillis();
        if (l2 < (l = bBqlInterval.getAllMillis())) {
            return -1;
        }
        if (l2 == l) {
            return 0;
        }
        return 1;
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public final BObject decodeFromString(String string) throws IOException {
        try {
            return BBqlInterval.make(string);
        }
        catch (Exception exception) {
            throw new IOException("Invalid BqlInterval: " + string);
        }
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.format);
    }

    public final String encodeToString() throws IOException {
        return this.format;
    }

    public final int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.days;
        n = 31 * n + this.fields;
        n = 31 * n + this.hours;
        n = 31 * n + this.minutes;
        n = 31 * n + this.months;
        n = 31 * n + (int)(this.ms ^ this.ms >>> 32);
        n = 31 * n + this.seconds;
        n = 31 * n + this.weeks;
        n = 31 * n + this.years;
        return n;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        BBqlInterval bBqlInterval = (BBqlInterval)((Object)object);
        if (this.days != bBqlInterval.days) {
            return false;
        }
        if (this.fields != bBqlInterval.fields) {
            return false;
        }
        if (this.hours != bBqlInterval.hours) {
            return false;
        }
        if (this.minutes != bBqlInterval.minutes) {
            return false;
        }
        if (this.months != bBqlInterval.months) {
            return false;
        }
        if (this.ms != bBqlInterval.ms) {
            return false;
        }
        if (this.seconds != bBqlInterval.seconds) {
            return false;
        }
        if (this.weeks != bBqlInterval.weeks) {
            return false;
        }
        return this.years == bBqlInterval.years;
    }

    public final BBqlInterval setMillis(long l) {
        this.ms = l;
        this.milliCache = null;
        this.fields |= 1;
        return this;
    }

    public final BBqlInterval setSeconds(int n) {
        this.seconds = n;
        this.milliCache = null;
        this.fields |= 2;
        return this;
    }

    public final BBqlInterval setMinutes(int n) {
        this.minutes = n;
        this.milliCache = null;
        this.fields |= 4;
        return this;
    }

    public final BBqlInterval setHours(int n) {
        this.hours = n;
        this.milliCache = null;
        this.fields |= 8;
        return this;
    }

    public final BBqlInterval setDays(int n) {
        this.days = n;
        this.fields |= 0x10;
        return this;
    }

    public final BBqlInterval setWeeks(int n) {
        this.weeks = n;
        this.fields |= 0x20;
        return this;
    }

    public final BBqlInterval setMonths(int n) {
        this.months = n;
        this.fields |= 0x40;
        return this;
    }

    public final BBqlInterval setYears(int n) {
        this.years = n;
        this.fields |= 0x80;
        return this;
    }

    private final void parse() {
        char[] cArray = new char[]{',', ' '};
        CharBuf charBuf = new CharBuf(this.format.toCharArray(), 0, this.format.length());
        charBuf.checkNotDone("invalid.format.interval");
        int n = 0;
        while (!charBuf.done()) {
            int n2 = charBuf.readNumber();
            if (n == 0) {
                charBuf.checkNotDone("invalid.format.interval");
                if (charBuf.buf[charBuf.index] == ':') {
                    charBuf.advance();
                    this.parseAbsoluteInterval(n2, charBuf);
                    return;
                }
            }
            charBuf.skip(' ');
            charBuf.checkNotDone("invalid.format.interval");
            String string = charBuf.readString(cArray);
            switch (string.charAt(0)) {
                case 'd': {
                    if (string.equals("day") || string.length() == 1) {
                        this.setDays(n2);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
                case 'h': {
                    if (string.equals("hour") || string.length() == 1) {
                        this.setHours(n2);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
                case 'm': {
                    if (string.startsWith("min") || string.length() == 1) {
                        this.setMinutes(n2);
                        break;
                    }
                    if (string.equals("month")) {
                        this.setMonths(n2);
                        break;
                    }
                    if (string.equals("ms") || string.startsWith("milli")) {
                        this.setMillis(n2);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
                case 's': {
                    if (string.startsWith("sec") || string.length() == 1) {
                        this.setSeconds(n2);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
                case 'w': {
                    if (string.equals("week") || string.length() == 1) {
                        this.setWeeks(n2);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
                case 'y': {
                    if (string.equals("year") || string.length() == 1) {
                        this.setYears(n2);
                        break;
                    }
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
                default: {
                    throw new RuntimeCompilerException(0, "invalid.unit", string);
                }
            }
            charBuf.skip(cArray);
            ++n;
        }
    }

    private final void parseAbsoluteInterval(int n, CharBuf charBuf) {
        this.setHours(this.hours);
        this.setMinutes(charBuf.readNumber());
        if (charBuf.done()) {
            return;
        }
        charBuf.checkCurrent(':', "invalid.format.interval");
        charBuf.advance();
        this.setSeconds(charBuf.readNumber());
        if (charBuf.done()) {
            return;
        }
        charBuf.checkCurrent('.', "invalid.format.interval");
        charBuf.advance();
        this.setMillis(charBuf.readNumber());
        if (charBuf.done()) {
            return;
        }
        throw new RuntimeCompilerException(0, "invalid.format.interval", charBuf.toString());
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.fields = 0;
        this.allMilliCache = -1;
    }

    private BBqlInterval(String string) {
        this.this();
        this.format = string;
        this.parse();
    }

    static {
        Class clazz = class$com$tridium$bql$BBqlInterval;
        if (clazz == null) {
            clazz = class$com$tridium$bql$BBqlInterval = BBqlInterval.class("[Lcom.tridium.bql.BBqlInterval;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    private static class CharBuf {
        public char[] buf;
        public int offset;
        public int len;
        public int end;
        public int index;

        public final boolean done() {
            boolean bl = false;
            if (this.index == this.end) {
                bl = true;
            }
            return bl;
        }

        public final void advance() {
            if (this.index != this.end) {
                ++this.index;
            }
        }

        public final void skip(char c) {
            while (this.index != this.end && this.buf[this.index] == c) {
                ++this.index;
            }
        }

        public final void skip(char[] cArray) {
            while (this.index != this.end && this.in(this.buf[this.index], cArray)) {
                ++this.index;
            }
        }

        public final void checkDone(String string) {
            if (this.index != this.end) {
                throw new RuntimeCompilerException(0, string, this.toString());
            }
        }

        public final void checkNotDone(String string) {
            if (this.index == this.end) {
                throw new RuntimeCompilerException(0, string, this.toString());
            }
        }

        public final void checkCurrent(char c, String string) {
            if (this.index == this.end || this.buf[this.index] != c) {
                throw new RuntimeCompilerException(0, string, this.toString());
            }
        }

        /*
         * Unable to fully structure code
         */
        public final int readNumber() {
            var1_1 = this.index;
            if (Character.isDigit(this.buf[var1_1])) ** GOTO lbl6
            System.out.println("not digit: '" + this.buf[var1_1] + '\'');
            throw new RuntimeCompilerException(0, "invalid.format.interval", new String(this.buf, this.offset, this.len));
lbl-1000:
            // 1 sources

            {
                ++this.index;
lbl6:
                // 2 sources

                ** while (this.index < this.end && Character.isDigit((char)this.buf[this.index]))
            }
lbl7:
            // 1 sources

            return this.stringToInt(this.buf, var1_1, this.index - var1_1);
        }

        public final String readString(char[] cArray) {
            int n = this.index;
            while (this.index < this.end && !this.in(this.buf[this.index], cArray)) {
                ++this.index;
            }
            int n2 = this.index;
            int n3 = n2 - 1;
            if (this.buf[n3] == 's' && n3 != n) {
                --n2;
            }
            return new String(this.buf, n, n2 - n);
        }

        public final String toString() {
            return new String(this.buf, this.offset, this.len);
        }

        private final boolean in(char c, char[] cArray) {
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (cArray[n2] == c) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private final int stringToInt(char[] cArray, int n, int n2) {
            int n3 = 0;
            int n4 = 1;
            if (n2 == 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            int n5 = n + n2 - 1;
            while (n5 >= n) {
                if (cArray[n5] >= '0' && cArray[n5] <= '9') {
                    n3 += (cArray[n5] - 48) * n4;
                } else {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                n4 *= 10;
                --n5;
            }
            return n3;
        }

        public CharBuf(char[] cArray, int n, int n2) {
            this.buf = cArray;
            this.offset = n;
            this.len = n2;
            this.end = n + n2;
            this.index = n;
        }
    }
}

