/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.sys.BValue;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public abstract class TaskDetailDialog
extends TaskDetailPane {
    protected DialogCancel cancelCommand;
    private BDialog dialog;
    private BButton closeButton;

    public boolean open() {
        this.dialog.setBoundsCenteredOnOwner();
        new Thread(this).start();
        this.dialog.open();
        return this.update() == BJobState.success;
    }

    public BDialog getDialog() {
        return this.dialog;
    }

    public abstract String getDialogTitle();

    public abstract String getHeadingTitle();

    public String getHeadingDescription() {
        return null;
    }

    public BImage getHeadingIcon() {
        return null;
    }

    protected void init(BWidget bWidget) {
        super.init();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setValign(BValign.top);
        bGridPane.setStretchColumn(1);
        if (this.getHeadingIcon() == null) {
            bGridPane.add(null, (BValue)new BNullWidget());
        } else {
            bGridPane.add(null, (BValue)new BLabel(this.getHeadingIcon()));
        }
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.setValign(BValign.top);
        bGridPane2.setStretchColumn(0);
        BLabel bLabel = new BLabel(this.getHeadingTitle(), BHalign.left);
        bGridPane2.add(null, (BValue)bLabel);
        bLabel.setFont(Theme.widget().getLargeBoldFont());
        if (this.getHeadingDescription() != null) {
            bLabel = new BLabel(this.getHeadingDescription(), BHalign.left);
            bGridPane2.add(null, (BValue)bLabel);
        }
        bGridPane.add(null, (BValue)bGridPane2);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, BBorder.make((String)"bottom(solid)"));
        bBorderPane.setFill(BColor.make((int)170, (int)170, (int)170).toBrush());
        BButtonPane bButtonPane = new BButtonPane();
        this.closeButton = new BButton();
        bButtonPane.add((BWidget)this.closeButton);
        this.dialog = new BDialog(bWidget, this.getDialogTitle(), true, (BWidget)new BEdgePane((BWidget)bBorderPane, (BWidget)new BEdgePane((BWidget)new BBox(660.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)bButtonPane, 0.0, 10.0, 10.0, 10.0)), (BWidget)new BBox(0.0, 480.0), null, (BWidget)new BBorderPane(this.getPane(), 10.0, 10.0, 10.0, 10.0)));
        this.cancelCommand = new DialogCancel();
        this.closeButton.setCommand((Command)this.cancelCommand, true, false);
    }

    public void setCancelEnabled(boolean bl) {
        super.setCancelEnabled(bl);
        this.cancelCommand.setEnabled(bl);
    }

    protected BJobState update() {
        BJobState bJobState = super.update();
        if (bJobState == BJobState.failed || bJobState == BJobState.canceled || bJobState == BJobState.success) {
            this.closeButton.setCommand((Command)new DialogClose(), true, false);
        }
        return bJobState;
    }

    private class DialogCancel
    extends Command {
        private Lexicon lex = Lexicon.make((String)"platDaemon");

        public DialogCancel() {
            super((BWidget)TaskDetailDialog.this.dialog, UiLexicon.bajaui.getText("action.cancel"));
        }

        public CommandArtifact doInvoke() {
            TaskDetailDialog.this.getLog().append("\n");
            TaskDetailDialog.this.getLog().append(this.lex.getText("TaskDetailPane.output.cancelPending"));
            TaskDetailDialog.this.getLog().append("\n");
            TaskDetailDialog.this.cancel();
            return null;
        }
    }

    private class DialogClose
    extends Command {
        public DialogClose() {
            super((BWidget)TaskDetailDialog.this.dialog, UiLexicon.bajaui.getText("commands.close.label"));
        }

        public CommandArtifact doInvoke() {
            TaskDetailDialog.this.dialog.close();
            return null;
        }
    }
}

