/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.widget;

import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.file.BListView;
import com.tridium.ui.file.BTreeView;
import com.tridium.ui.file.FileChooserModel;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;

public class BCreateFileDialog
extends BEdgePane {
    public static final Action handleTextModified = BCreateFileDialog.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$widget$BCreateFileDialog == null ? (class$com$tridium$platDaemon$ui$widget$BCreateFileDialog = BCreateFileDialog.class$("com.tridium.platDaemon.ui.widget.BCreateFileDialog")) : class$com$tridium$platDaemon$ui$widget$BCreateFileDialog));
    private FileChooserModel model;
    private BListView listView;
    private BTreeView treeView;
    private BLabel currentDirectoryLabel;
    private BTextField fileNameTextField;
    private Ok okCommand;
    private NewDirCommand newDirCommand;
    private UpLevelCommand upLevelCommand;
    private String defaultExtension;
    private static Lexicon lex = null;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$BCreateFileDialog;

    public void handleTextModified() {
        this.invoke(handleTextModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BCreateFileDialog(BImage bImage, String string, String string2, BIFile bIFile, String string3) {
        this.defaultExtension = string3;
        this.model = new FileChooserModel((BSpace)BFileSystem.INSTANCE);
        this.model.setSupport((FileChooserModel.Support)new FileBrowserSupport());
        this.listView = new BListView(this.model);
        this.listView.setDetailsView();
        this.listView.setMultipleSelection(false);
        this.treeView = new BTreeView(this.model);
        this.treeView.setController((TreeController)new Controller());
        BSplitPane bSplitPane = new BSplitPane();
        bSplitPane.setDividerPosition(33.0);
        bSplitPane.setWidget1((BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.treeView), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        this.currentDirectoryLabel = new BLabel();
        bFlowPane.add(null, (BValue)this.currentDirectoryLabel);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add(null, (Command)new HomeCommand());
        this.upLevelCommand = new UpLevelCommand();
        bToolBar.add(null, (Command)this.upLevelCommand);
        this.newDirCommand = new NewDirCommand();
        bToolBar.add(null, (Command)this.newDirCommand);
        bFlowPane.add(null, (BValue)bToolBar);
        bSplitPane.setWidget2((BWidget)new BEdgePane((BWidget)bFlowPane, null, null, null, (BWidget)new BBorderPane((BWidget)this.listView, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0))));
        this.setTop((BWidget)new BWizardHeader(bImage, string, string2 == null ? "" : string2));
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)bSplitPane, 6.0, 4.0, 4.0, 4.0));
        bConstrainedPane.setFixedSize(550.0, 330.0);
        this.setCenter((BWidget)bConstrainedPane);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.center);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setColumnAlign(BHalign.left);
        bGridPane2.add(null, (BValue)new BLabel(BCreateFileDialog.lex().getText("CreateFileDialog.fileNameLabel")));
        this.fileNameTextField = new BTextField("", 40, true);
        bGridPane2.add(null, (BValue)this.fileNameTextField);
        this.linkTo((BComponent)this.fileNameTextField, (Slot)BTextEditor.textModified, (Slot)handleTextModified);
        bGridPane.add(null, (BValue)bGridPane2);
        this.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 4.0, 6.0, 4.0));
        if (bIFile != null && bIFile.isDirectory()) {
            this.model.setDirectory((BINavNode)bIFile);
            this.treeView.scrollToVisible((BINavNode)bIFile);
            this.currentDirectoryLabel.setImage(BImage.make((BIcon)bIFile.getNavIcon()));
            this.currentDirectoryLabel.setText(bIFile.getFileName());
        }
        this.okCommand = new Ok();
    }

    public static FilePath getPath(BWidget bWidget, BIFile bIFile, String string) {
        return BCreateFileDialog.getPath(bWidget, BImage.make((String)BCreateFileDialog.lex().getText("CreateFileDialog.defaultIcon")), BCreateFileDialog.lex().getText("CreateFileDialog.defaultTitle"), "", bIFile, string);
    }

    public static FilePath getPath(BWidget bWidget, BImage bImage, String string, String string2, BIFile bIFile, String string3) {
        BCreateFileDialog bCreateFileDialog = new BCreateFileDialog(bImage, string, string2, bIFile, string3);
        if (1 == BCommandDialog.open((BWidget)bWidget, (String)string, (Object)((Object)bCreateFileDialog), (DialogCommand[])new DialogCommand[]{bCreateFileDialog.getOkCommand(), DialogCommand.makeCancel((BWidget)bWidget)})) {
            return bCreateFileDialog.getFilePath();
        }
        return null;
    }

    public FilePath getFilePath() {
        String string = this.fileNameTextField.getText();
        if (FileUtil.getExtension((String)string) == null && this.defaultExtension != null) {
            string = string + '.' + this.defaultExtension;
        }
        return ((BIFile)this.model.getDirectory()).getFilePath().merge(string);
    }

    private DialogCommand getOkCommand() {
        return this.okCommand;
    }

    private static Lexicon lex() {
        if (lex == null) {
            lex = TYPE.getModule().getLexicon();
        }
        return lex;
    }

    public void doHandleTextModified() {
        this.okCommand.checkEnabled();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Controller
    extends TreeController {
        Controller() {
        }

        protected void mouseSelection(TreeNode treeNode, BMouseEvent bMouseEvent) {
            super.mouseSelection(treeNode, bMouseEvent);
            BCreateFileDialog.this.listView.getSelection().deselectAll();
        }

        protected void doSelectAction(TreeNode treeNode, double d, double d2) {
            BINavNode bINavNode = BCreateFileDialog.this.treeView.getFileForNode(treeNode);
            if (bINavNode != null) {
                BCreateFileDialog.this.model.setDirectory(bINavNode);
            }
        }
    }

    class HomeCommand
    extends Command {
        public HomeCommand() {
            super((BWidget)BCreateFileDialog.this, TYPE.getModule(), "CreateFileDialog.home");
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory bDirectory = BFileSystem.INSTANCE.getSysHome();
                BCreateFileDialog.this.model.setDirectory((BINavNode)bDirectory);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    class NewDirCommand
    extends Command {
        public NewDirCommand() {
            super((BWidget)BCreateFileDialog.this, TYPE.getModule(), "CreateFileDialog.newDir");
            this.checkEnabled();
        }

        public void checkEnabled() {
            this.setEnabled(BCreateFileDialog.this.model != null && BCreateFileDialog.this.model.getDirectory() != null);
        }

        public CommandArtifact doInvoke() {
            try {
                String string = BStringPromptDialog.getString((BWidget)BCreateFileDialog.this, null, (String)BCreateFileDialog.lex().getText("CreateFileDialog.newDir.nameTitle"), (String)BCreateFileDialog.lex().getText("CreateFileDialog.newDir.nameMessage"));
                if (string != null && BCreateFileDialog.this.model.getDirectory() != null) {
                    FilePath filePath = ((BIFile)BCreateFileDialog.this.model.getDirectory()).getFilePath().merge(string);
                    BFileSystem.INSTANCE.makeDir(filePath, null);
                    BCreateFileDialog.this.model.setDirectory(BCreateFileDialog.this.model.getDirectory());
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    class UpLevelCommand
    extends Command {
        public UpLevelCommand() {
            super((BWidget)BCreateFileDialog.this, TYPE.getModule(), "CreateFileDialog.upLevel");
            this.checkEnabled();
        }

        public void checkEnabled() {
            this.setEnabled(BCreateFileDialog.this.model != null && BCreateFileDialog.this.model.getDirectory() != null);
        }

        public CommandArtifact doInvoke() {
            try {
                BCreateFileDialog.this.model.moveUpDirectory();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    class Ok
    extends DialogCommand {
        public Ok() {
            super((BWidget)BCreateFileDialog.this, 1, UiLexicon.bajaui.getText("dialog.ok"));
            this.checkEnabled();
        }

        public void checkEnabled() {
            this.setEnabled(BCreateFileDialog.this.model.getDirectory() != null && BCreateFileDialog.this.fileNameTextField.getText().trim().length() > 0);
        }
    }

    class FileBrowserSupport
    extends FileChooserModel.Support {
        FileBrowserSupport() {
        }

        public void pathModified() {
            BCreateFileDialog.this.listView.populateChildren();
            BCreateFileDialog.this.listView.relayout();
            BIFile bIFile = (BIFile)BCreateFileDialog.this.model.getDirectory();
            BCreateFileDialog.this.newDirCommand.checkEnabled();
            BCreateFileDialog.this.upLevelCommand.checkEnabled();
            if (bIFile != null) {
                BCreateFileDialog.this.treeView.scrollToVisible((BINavNode)bIFile);
                BCreateFileDialog.this.currentDirectoryLabel.setImage(BImage.make((BIcon)bIFile.getNavIcon()));
                BCreateFileDialog.this.currentDirectoryLabel.setText(bIFile.getFileName());
                BCreateFileDialog.this.currentDirectoryLabel.relayout();
            }
        }

        public void selectionModified() {
            BIFile[] bIFileArray = BCreateFileDialog.this.model.getSelectedFiles();
            if (bIFileArray.length == 0) {
                return;
            }
            BCreateFileDialog.this.treeView.getSelection().deselectAll();
            if (!(bIFileArray[0] instanceof BIDirectory)) {
                BCreateFileDialog.this.fileNameTextField.setText(bIFileArray[0].getFileName());
            }
        }

        public void chooseSelectedFiles() {
        }
    }
}

