/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.stationtransfer;

import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDeleteFileInstallable;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platDaemon.ui.stationtransfer.StationWizardModel;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.message.DeleteStationMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import java.util.ListIterator;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class FinalStep
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private StationWizardModel wizardModel;
    private String lastText = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private Array items;
    private DaemonSessionTaskListener taskListener;
    private TaskDetailPane.TaskItem stopStationItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.stopStation"));
    private TaskDetailPane.TaskItem saveStationItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.saveStation"));
    private TaskDetailPane.TaskItem stopAllStationsItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.stopAllStations"));
    private TaskDetailPane.TaskItem deleteItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.delete"));
    private TaskDetailPane.TaskItem transferItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.transfer"));
    private TaskDetailPane.TaskItem startStationsItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.startStations"));
    private TaskDetailPane.TaskItem rebootItem = new TaskDetailPane.TaskItem(lex.getText("StationCopier.FinalStep.item.reboot"));
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tridium$install$installable$BInstallable;
    static /* synthetic */ Class class$com$tridium$platform$daemon$message$XmlResponseMessage;

    public FinalStep(StationWizardModel stationWizardModel) {
        try {
            BDirectory bDirectory;
            this.wizardModel = stationWizardModel;
            this.items = new Array(class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem == null ? (class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem = FinalStep.class$("com.tridium.platDaemon.ui.widget.TaskDetailPane$TaskItem")) : class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem);
            if (stationWizardModel.isLocalToRemote() && stationWizardModel.getDependencyAnalysis().getSolution().getToInstall().length > 0 && BStationSurrogate.isAnyStationRunning((BDaemonSession)stationWizardModel.getDaemonSession())) {
                this.items.add((Object)this.stopAllStationsItem);
            } else if (stationWizardModel.getStationSurrogate() != null && stationWizardModel.getStationSurrogate().isStationRunning()) {
                if (stationWizardModel.isLocalToRemote()) {
                    this.items.add((Object)this.stopStationItem);
                } else if (stationWizardModel.getDaemonSession().getHostProperties().supportsServlet("requeststate")) {
                    this.items.add((Object)this.saveStationItem);
                } else {
                    this.items.add((Object)this.stopStationItem);
                }
            }
            if (stationWizardModel.getStationDisposition() == BStationDispositionEnum.clean && (bDirectory = (BDirectory)stationWizardModel.getTargetStationsRoot().getNavChild(stationWizardModel.getTargetStationName())) != null) {
                this.items.add((Object)this.deleteItem);
            }
            this.items.add((Object)this.transferItem);
            if (stationWizardModel.shouldReboot()) {
                this.items.add((Object)this.rebootItem);
            } else if ((this.items.contains((Object)this.stopStationItem) || this.items.contains((Object)this.stopAllStationsItem) || stationWizardModel.startStation()) && stationWizardModel.allowStationRestart()) {
                this.items.add((Object)this.startStationsItem);
            }
            this.init((BWidget)stationWizardModel.getWizard());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public StationWizardModel getWizardModel() {
        return this.wizardModel;
    }

    public String getHeadingTitle() {
        return lex.getText("StationCopier.FinalStep.dialogHeading");
    }

    public String getDialogTitle() {
        return lex.getText("StationCopier.FinalStep.dialogTitle");
    }

    public BImage getHeadingIcon() {
        return StationWizardModel.wizImage;
    }

    public String getItemListHeading() {
        return lex.getText("StationCopier.FinalStep.itemHeading");
    }

    public TaskDetailPane.TaskItem[] makeTaskItems() {
        return (TaskDetailPane.TaskItem[])this.items.trim();
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
        if (daemonSessionTask instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)daemonSessionTask).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
        this.taskListener.taskFinished(daemonSessionTask);
    }

    public void run() {
        block26: {
            try {
                Array array;
                BDirectory bDirectory;
                BDirectory bDirectory2 = this.getWizardModel().getTargetStationsRoot();
                this.taskListener = new DaemonSessionTaskHandler((BWidget)this.getDialog());
                Array array2 = new Array(class$java$lang$String == null ? (class$java$lang$String = FinalStep.class$("java.lang.String")) : class$java$lang$String);
                if (this.items.contains((Object)this.stopAllStationsItem)) {
                    this.getLog().append(lex.getText("StationCopier.FinalStep.stopAll"));
                    this.setCurrentItem(this.stopAllStationsItem, BJobState.running);
                    bDirectory = BStationSurrogate.stopAllStations((BDaemonSession)this.getWizardModel().getDaemonSession(), (ICancelHint)this, (DaemonSessionTaskListener)this.taskListener);
                    for (int i = 0; i < ((BStationSurrogate[])bDirectory).length; ++i) {
                        array2.add((Object)bDirectory[i].getStationName());
                    }
                    if (this.wizardModel.startStation() && !array2.contains((Object)this.getWizardModel().getTargetStationName())) {
                        array2.add((Object)this.getWizardModel().getTargetStationName());
                    }
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.done.label"));
                    this.getLog().append("\n");
                } else if (this.items.contains((Object)this.stopStationItem)) {
                    this.getLog().append(lex.getText("StationCopier.FinalStep.stopOne", new Object[]{this.getWizardModel().getTargetStationName()}));
                    this.setCurrentItem(this.stopStationItem, BJobState.running);
                    this.getWizardModel().getStationSurrogate().stopStation((ICancelHint)this, this.taskListener);
                    array2.add((Object)this.getWizardModel().getTargetStationName());
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.done.label"));
                    this.getLog().append("\n");
                } else if (this.items.contains((Object)this.saveStationItem)) {
                    this.getLog().append(lex.getText("StationCopier.FinalStep.saving", new Object[]{this.getWizardModel().getSourceStationName()}));
                    this.setCurrentItem(this.saveStationItem, BJobState.running);
                    this.getWizardModel().getStationSurrogate().saveStation((ICancelHint)this, this.taskListener);
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.done.label"));
                    this.getLog().append("\n");
                } else if (this.wizardModel.startStation()) {
                    array2.add((Object)this.getWizardModel().getTargetStationName());
                }
                if (this.getWizardModel().getStationDisposition() == BStationDispositionEnum.clean && (bDirectory = (BDirectory)bDirectory2.getNavChild(this.getWizardModel().getTargetStationName())) != null) {
                    this.setCurrentItem(this.deleteItem, BJobState.running);
                    DaemonFileUtil.deleteFile((BIFile)bDirectory);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.deleted"));
                    this.getLog().append("\n");
                    this.updateCurrentItemState(BJobState.success);
                }
                bDirectory = null;
                Array array3 = this.getWizardModel().getTransferContents();
                if (this.getWizardModel().isLocalToRemote()) {
                    bDirectory = new Array(class$com$tridium$install$installable$BInstallable == null ? (class$com$tridium$install$installable$BInstallable = FinalStep.class$("com.tridium.install.installable.BInstallable")) : class$com$tridium$install$installable$BInstallable);
                    for (int i = 0; i < this.getWizardModel().getStationsToDelete().size(); ++i) {
                        array = (UnmeetableDependency[])this.getWizardModel().getStationsToDelete().get(i);
                        BStationSurrogate.stopStation((BDaemonSession)this.getWizardModel().getDaemonSession(), (String)array, (ICancelHint)this, (DaemonSessionTaskListener)this.taskListener);
                        bDirectory.add((Object)new BDeleteFileInstallable(new FilePath("!stations").merge((String)array)));
                    }
                }
                this.setCurrentItem(this.transferItem, BJobState.running);
                ListIterator listIterator = array3.iterator();
                while (listIterator.hasNext()) {
                    this.checkCanceled();
                    this.transfer((BIFile)listIterator.next(), (Array)bDirectory);
                }
                if (bDirectory != null) {
                    this.checkCanceled();
                    listIterator = this.getWizardModel().getDependencyAnalysis().getSolution().solve((DaemonSessionTaskListener)this, null, null, (BInstallable[])bDirectory.trim(), (InstallableRegistry)LocalInstallableRegistry.getInstance());
                    if (!listIterator.canCommit()) {
                        array = listIterator.getUnmeetableDependencies();
                        for (int i = 0; i < ((UnmeetableDependency[])array).length; ++i) {
                            this.getLog().append(lex.getText("StationCopier.FinalStep.unmetDependenciesMain", new Object[]{array[i]}));
                            this.getLog().append("\n");
                        }
                        this.getLog().append(lex.getText("StationCopier.FinalStep.failure"));
                        this.getLog().append("\n");
                        this.updateCurrentItemState(BJobState.failed);
                        this.setBottomLabelText(lex.getText("StationCopier.FinalStep.failure"));
                        return;
                    }
                    listIterator.commit(this, this);
                    this.checkCanceled();
                    this.setCancelEnabled(true);
                    array = new Array(class$com$tridium$platform$daemon$message$XmlResponseMessage == null ? (class$com$tridium$platform$daemon$message$XmlResponseMessage = FinalStep.class$("com.tridium.platform.daemon.message.XmlResponseMessage")) : class$com$tridium$platform$daemon$message$XmlResponseMessage);
                    for (int i = 0; i < this.getWizardModel().getStationsToDelete().size(); ++i) {
                        String string = (String)this.getWizardModel().getStationsToDelete().get(i);
                        array.add((Object)new DeleteStationMessage(string));
                    }
                    array.add((Object)new UpdateStationMessage());
                    array.add((Object)new UpdateStationMessage(this.getWizardModel().getTargetStationName(), false, this.getWizardModel().isAutoStart(), this.getWizardModel().isAutoRestart(), true));
                    this.getWizardModel().getDaemonSession().sendMessages((XmlResponseMessage[])array.trim(), BDaemonSession.DEFAULT_TIMEOUT);
                }
                this.updateCurrentItemState(BJobState.success);
                if (this.items.contains((Object)this.startStationsItem)) {
                    this.setCurrentItem(this.startStationsItem, BJobState.running);
                    for (int i = 0; i < array2.size(); ++i) {
                        BStationSurrogate bStationSurrogate;
                        array = (String)array2.get(i);
                        if (this.getWizardModel().getStationsToDelete().contains((Object)array) || (bStationSurrogate = BStationSurrogate.make((BDaemonSession)this.getWizardModel().getDaemonSession(), (String)array)) == null) continue;
                        bStationSurrogate.startStationAsync();
                        this.getLog().append(lex.getText("StationCopier.FinalStep.started", new Object[]{bStationSurrogate.getStationName()}));
                        this.getLog().append("\n");
                    }
                    this.updateCurrentItemState(BJobState.success);
                }
                if (this.items.contains((Object)this.rebootItem)) {
                    this.setCurrentItem(this.rebootItem, BJobState.running);
                    this.getWizardModel().getDaemonSession().sendRebootRequest();
                    this.getLog().append(lex.getText("StationCopier.FinalStep.reboot"));
                    this.getLog().append("\n");
                    this.updateCurrentItemState(BJobState.success);
                    this.getLog().append(lex.getText("StationCopier.FinalStep.success"));
                    this.getLog().append("\n");
                    break block26;
                }
                this.getLog().append(lex.getText("StationCopier.FinalStep.success"));
                this.getLog().append("\n");
                if (!this.getWizardModel().isLocalToRemote()) break block26;
                if (this.getWizardModel().getDependencyAnalysis().getSolution().getToInstall().length > 0) {
                    try {
                        this.getWizardModel().getRemoteModuleList().reset();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Array array4 = new Array(class$com$tridium$platform$daemon$message$XmlResponseMessage == null ? (class$com$tridium$platform$daemon$message$XmlResponseMessage = FinalStep.class$("com.tridium.platform.daemon.message.XmlResponseMessage")) : class$com$tridium$platform$daemon$message$XmlResponseMessage);
                array4.add((Object)new UpdateStationMessage());
                array4.add((Object)new UpdateStationMessage(this.getWizardModel().getTargetStationName(), false, this.getWizardModel().isAutoStart(), this.getWizardModel().isAutoRestart(), true));
                this.getWizardModel().getDaemonSession().sendMessages((XmlResponseMessage[])array4.trim(), BDaemonSession.DEFAULT_TIMEOUT);
                this.setBottomLabelText(lex.getText("StationCopier.FinalStep.success"));
            }
            catch (ICancelHint.CanceledException canceledException) {
                this.getLog().append("\n");
                this.getLog().append(lex.getText("StationCopier.FinalStep.canceled"));
                this.getLog().append("\n");
                this.cancel(false);
                this.setBottomLabelText(lex.getText("StationCopier.FinalStep.canceled"));
                return;
            }
            catch (Exception exception) {
                this.setCancelEnabled(true);
                this.setBottomLabelText(lex.getText("StationCopier.FinalStep.failure"));
                this.getLog().append("\n");
                this.getLog().append(lex.getText("StationCopier.FinalStep.failure"));
                this.getLog().append("\n");
                this.getLog().append((Throwable)exception);
                this.getLog().append("\n");
                this.updateCurrentItemState(BJobState.failed);
                exception.printStackTrace();
            }
        }
    }

    private void transfer(BIFile bIFile, Array array) throws AuthenticationException, ConnectException {
        if (array == null) {
            this.getLog().append(bIFile.getFilePath().getBody());
            this.getLog().append("\n");
            ((BDaemonFileStore)bIFile.getStore()).copyToLocalHost(this.getDestDir(bIFile.getFilePath()).merge(bIFile.getFileName()));
        } else {
            array.add((Object)new BFileInstallable(bIFile, this.getDestDir(bIFile.getFilePath())));
        }
    }

    private FilePath getDestDir(FilePath filePath) {
        FilePath filePath2 = this.getWizardModel().getTargetStationsRoot().getFilePath().merge(this.getWizardModel().getTargetStationName());
        for (int i = this.getWizardModel().getStationDirectory().getFilePath().depth(); i < filePath.depth() - 1; ++i) {
            filePath2 = filePath2.merge(filePath.nameAt(i));
        }
        return filePath2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

