/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BModuleStatus;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.gx.BImage;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.Type;
import javax.baja.util.Array;

public class InstallerTableRow {
    private Array forwardDeps = new Array(class$com$tridium$install$BDependency == null ? (class$com$tridium$install$BDependency = InstallerTableRow.class$("com.tridium.install.BDependency")) : class$com$tridium$install$BDependency);
    private HashMap reverseDepsByName = new HashMap();
    private BPart currentPart = null;
    private boolean outOfDate = false;
    private boolean needsCommission = false;
    private long installablePartSize = Long.MIN_VALUE;
    private BInstallable installable;
    private InstallerTableModel model;
    private BInstallable highestVersionInstallable = null;
    private BPartInstallStatus installStatus = BPartInstallStatus.noChange;
    static /* synthetic */ Class class$com$tridium$install$part$BPart;
    static /* synthetic */ Class class$com$tridium$install$BDependency;

    public InstallerTableRow(InstallerTableModel installerTableModel) {
        this.model = installerTableModel;
    }

    public int compareComment(InstallerTableRow installerTableRow) {
        int n;
        int n2 = this.getStatusRank(this.getStatus());
        if (n2 < (n = this.getStatusRank(installerTableRow.getStatus()))) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return TextUtil.toLowerCase((String)this.getComment()).compareTo(TextUtil.toLowerCase((String)installerTableRow.getComment()));
    }

    public String getComment() {
        switch (this.getInstallStatus().getOrdinal()) {
            case 2: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.install", new Object[]{this.installable.getVersion()});
            }
            case 3: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.upgrade", new Object[]{this.installable.getVersion()});
            }
            case 4: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.reinstall", new Object[]{this.installable.getVersion()});
            }
            case 5: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.downgrade", new Object[]{this.installable.getVersion()});
            }
            case 6: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.uninstall", new Object[]{this.currentPart.getVersion()});
            }
        }
        switch (this.getStatus()) {
            case 6: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.notInstalled");
            }
            case 3: 
            case 4: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.outOfDate");
            }
            case 1: 
            case 2: 
            case 5: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.upToDate");
            }
            case 7: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.badInstallable");
            }
            case 8: 
            case 9: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.badTarget");
            }
            case 10: 
            case 11: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.noLocal");
            }
            case 12: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.needCommissioningOod");
            }
            case 13: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.status.needCommissioningMissing");
            }
        }
        return "";
    }

    public BPart getCurrentPart() {
        return this.currentPart;
    }

    public BImage getPartIcon() {
        if (this.getCurrentPart() == null) {
            if (this.getInstallablePart() == null) {
                return BImage.make((BIcon)this.getInstallable().getIcon());
            }
            return BImage.make((BIcon)this.getInstallablePart().getIcon());
        }
        return BImage.make((BIcon)this.getCurrentPart().getIcon());
    }

    public BVersion getCurrentVersion() {
        return this.currentPart == null ? null : this.currentPart.getVersion();
    }

    public String getInstallableName() {
        return this.installable == null ? null : this.installable.getInstallableName();
    }

    public BPart getInstallablePart() {
        return this.installable == null ? null : this.installable.getPart();
    }

    public BPart getHighestVersionedPart() {
        return this.highestVersionInstallable == null ? null : this.highestVersionInstallable.getPart();
    }

    public long getInstallablePartSize() {
        if (this.installable == null) {
            return 0L;
        }
        if (this.installablePartSize == Long.MIN_VALUE) {
            this.installablePartSize = this.installable instanceof BModuleInstallable ? ((BModulePart)this.getInstallablePart()).getFilteredFileSize(this.model.getTargetModuleContent(), this.model.getTargetStripLineNumbers()) : this.installable.getInstallableFileSize();
        }
        return this.installablePartSize;
    }

    public BVersion getHighestInstallableVersion() {
        if (this.highestVersionInstallable == null) {
            return this.installable == null ? null : this.installable.getVersion();
        }
        return this.highestVersionInstallable.getVersion();
    }

    public void setLatestAvailableInstallable(BInstallable bInstallable) {
        this.highestVersionInstallable = bInstallable;
    }

    public String getPartName() {
        return this.installable == null ? this.currentPart.getPartName() : this.installable.getInstallableName();
    }

    public BPart getPart() {
        return this.installable == null ? this.currentPart : this.installable.getPart();
    }

    public long getSizeDeltaOnCommit() {
        if (this.installStatus == BPartInstallStatus.install) {
            return this.getInstallablePartSize();
        }
        if (this.installStatus == BPartInstallStatus.uninstall) {
            BInstallable bInstallable = this.currentPart.getInstallable();
            if (bInstallable != null) {
                return -1L * bInstallable.getInstallableFileSize();
            }
        } else if (this.installStatus == BPartInstallStatus.upgrade || this.installStatus == BPartInstallStatus.downgrade || this.installStatus == BPartInstallStatus.reinstall) {
            if (this.currentPart.getInstallable() == null) {
                return 0L;
            }
            return this.getInstallablePartSize() - this.currentPart.getInstallable().getInstallableFileSize();
        }
        return 0L;
    }

    public int getStatus() {
        if (this.currentPart == null) {
            if (this.installable != null) {
                if (!this.installable.getIsInstallable() || this.installable instanceof BModuleInstallable && ((BModulePart)this.getInstallablePart()).getStatus() != BModuleStatus.ok) {
                    return 7;
                }
                return this.needsCommission ? 13 : 6;
            }
        } else {
            if (this.installable == null) {
                if (this.currentPart instanceof BModulePart) {
                    BModuleStatus bModuleStatus = ((BModulePart)this.currentPart).getStatus();
                    if (bModuleStatus == BModuleStatus.nomanifest) {
                        return 10;
                    }
                    if (bModuleStatus != BModuleStatus.ok) {
                        return 8;
                    }
                }
                return 11;
            }
            BVersion bVersion = this.currentPart.getVersion();
            BVersion bVersion2 = this.getInstallablePart().getVersion();
            if (!(!(this.installable instanceof BModuleInstallable) || this.installable.getIsInstallable() && ((BModulePart)this.getInstallablePart()).getStatus().equals((Object)BModuleStatus.ok))) {
                if (!(!(this.currentPart instanceof BModulePart) || ((BModulePart)this.currentPart).getIsInstallable() && ((BModulePart)this.currentPart).getStatus().equals((Object)BModuleStatus.ok))) {
                    return 9;
                }
                return 7;
            }
            if (!(!(this.currentPart instanceof BModulePart) || ((BModulePart)this.currentPart).getIsInstallable() && ((BModulePart)this.currentPart).getStatus().equals((Object)BModuleStatus.ok))) {
                return 8;
            }
            switch (bVersion.checkVersionRequirement(bVersion2)) {
                case 2: {
                    if (this.currentPart instanceof BModulePart) {
                        BModulePart bModulePart = (BModulePart)this.currentPart;
                        BModulePart bModulePart2 = (BModulePart)this.getInstallablePart();
                        if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                            int n = bModulePart2.getBuildAbsTime().compareTo((Object)bModulePart.getBuildAbsTime());
                            if (n > 0) {
                                return this.outOfDate ? 3 : 12;
                            }
                            if (n < 0) {
                                return 1;
                            }
                        }
                    }
                    return 2;
                }
                case 16: {
                    return 5;
                }
                case 8: {
                    return this.outOfDate ? 4 : 12;
                }
                case 4: {
                    return this.outOfDate ? 3 : 12;
                }
            }
            return 1;
        }
        return 0;
    }

    public String getType() {
        if (this.currentPart == null) {
            if (this.installable.getPart() == null) {
                return this.installable.getDisplayName(null);
            }
            return BPart.getPartTypeShortName((Type)this.installable.getPart().getType());
        }
        return BPart.getPartTypeShortName((Type)this.currentPart.getType());
    }

    public int hashCode() {
        return this.getPartName().hashCode();
    }

    public boolean isModule() {
        BPart bPart = this.currentPart == null ? this.getInstallablePart() : this.currentPart;
        return bPart instanceof BModulePart;
    }

    public void setCurrentPart(BPart bPart) {
        this.currentPart = bPart;
        this.outOfDate = this.model.oodScenario.getPartStatus(bPart) == BPartInstallStatus.upgrade;
    }

    public void setInstallable(BInstallable bInstallable) {
        if (this.installable != bInstallable) {
            this.installable = bInstallable;
            this.installablePartSize = Long.MIN_VALUE;
        }
    }

    public BInstallable getInstallable() {
        return this.installable;
    }

    public String toString() {
        return this.getPartName();
    }

    public void setForwardDeps(Array array) {
        this.forwardDeps = array;
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                BDependency bDependency = (BDependency)array.get(i);
                if (bDependency.canSolveWith(this.model.scenario.getSolutionParameters().solvers)) continue;
                this.needsCommission = !this.model.scenario.getTargetPlatform().meets(bDependency);
                break;
            }
        }
    }

    public Array getForwardDeps() {
        return this.forwardDeps;
    }

    public Array getDependentParts() {
        Array array = new Array(class$com$tridium$install$part$BPart == null ? (class$com$tridium$install$part$BPart = InstallerTableRow.class$("com.tridium.install.part.BPart")) : class$com$tridium$install$part$BPart);
        Iterator iterator = this.reverseDepsByName.keySet().iterator();
        while (iterator.hasNext()) {
            InstallerTableRow installerTableRow = (InstallerTableRow)iterator.next();
            if (installerTableRow.getInstallablePart() == null) {
                array.add((Object)installerTableRow.getCurrentPart());
                continue;
            }
            array.add((Object)installerTableRow.getInstallablePart());
        }
        return array;
    }

    public Map getReverseDeps() {
        return this.reverseDepsByName;
    }

    public void addReverseDep(InstallerTableRow installerTableRow, BDependency bDependency) {
        this.reverseDepsByName.put(installerTableRow, bDependency);
    }

    public void clearDeps() {
        this.forwardDeps.clear();
        this.reverseDepsByName.clear();
    }

    public void updateRow() {
        this.installStatus = this.model.getScenario().getPartStatus(this.getPart());
    }

    public BPartInstallStatus getInstallStatus() {
        return this.installStatus;
    }

    private int getStatusRank(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 9: {
                return 0;
            }
            case 3: 
            case 4: {
                return 1;
            }
            case 12: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 1: 
            case 2: 
            case 5: {
                return 6;
            }
            case 0: 
            case 10: 
            case 11: {
                return 7;
            }
        }
        return 5;
    }

    protected boolean needsCommission() {
        return this.needsCommission;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

