/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BPartInstallStatus;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.softwaremanager.BInstallerTableRowFilter;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.baja.gx.BImage;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.IFilter;

public class InstallerTableModel
extends TableModel {
    public static final int NAME_COL = 0;
    public static final int CURRENT_VER_COL = 1;
    public static final int AVAIL_VER_COL = 2;
    public static final int COMMENT_COL = 3;
    public static final int STATUS_NONE = 0;
    public static final int STATUS_LATER = 1;
    public static final int STATUS_SAME = 2;
    public static final int STATUS_EARLIER = 3;
    public static final int STATUS_DIFFERENT = 4;
    public static final int STATUS_EQUIVALENT = 5;
    public static final int STATUS_NOT_INSTALLED = 6;
    public static final int STATUS_BAD_INSTALLABLE = 7;
    public static final int STATUS_BAD_TARGET = 8;
    public static final int STATUS_BOTH_BAD = 9;
    public static final int STATUS_NO_DETAILS = 10;
    public static final int STATUS_NO_LOCAL = 11;
    public static final int STATUS_EARLIER_COMMISSION = 12;
    public static final int STATUS_NOT_INSTALLED_COMMISSION = 13;
    private int sortColumn = 3;
    private boolean sortAscending = true;
    private boolean needsSort = true;
    protected InstallScenario scenario;
    protected InstallScenario oodScenario;
    private TreeMap rowsByPartSpec = new TreeMap();
    protected Array rows = new Array(class$com$tridium$platDaemon$ui$softwaremanager$InstallerTableRow == null ? (class$com$tridium$platDaemon$ui$softwaremanager$InstallerTableRow = InstallerTableModel.class$("com.tridium.platDaemon.ui.softwaremanager.InstallerTableRow")) : class$com$tridium$platDaemon$ui$softwaremanager$InstallerTableRow);
    private BInstallerTableRowFilter filter = null;
    protected DaemonSessionTaskListener taskListener;
    private long elapsed = 0L;
    private static final Comparator COMMENT_COLUMN_COMPARATOR = new CommentColumnComparator();
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$softwaremanager$InstallerTableRow;

    public BPartInstallStatus getInstallStatusAt(int n) {
        return this.getRow(n).getInstallStatus();
    }

    public BImage getCellIcon(int n, int n2) {
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 1: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.column.currentVersion");
            }
            case 0: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.column.installableFile");
            }
            case 2: {
                return BDaemonSessionView.lexicon.getText("SoftwareManager.column.availableVersion");
            }
            case 3: {
                return "";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int indexOf(PartSpec partSpec) {
        InstallerTableRow installerTableRow = this.getRow(partSpec);
        if (installerTableRow == null) {
            return -1;
        }
        return this.rows.indexOf((Object)installerTableRow);
    }

    public BPart getCurrentPartAt(int n) {
        return this.getRow(n).getCurrentPart();
    }

    public BVersion getCurrentVersionAt(int n) {
        return this.getRow(n).getCurrentVersion();
    }

    public Array getForwardDependenciesAt(int n) {
        return this.getRow(n).getForwardDeps();
    }

    public BInstallable getInstallableAt(int n) {
        return this.getRow(n).getInstallable();
    }

    public BPart getInstallablePartAt(int n) {
        return this.getRow(n).getInstallablePart();
    }

    public BVersion getInstallableVersionAt(int n) {
        return this.getRow(n).getHighestInstallableVersion();
    }

    public InstallScenario getScenario() {
        return this.scenario;
    }

    public void setScenario(InstallScenario installScenario) {
        if (!installScenario.canCommit()) {
            throw new IllegalArgumentException("Install scenario has unmet dependencies");
        }
        this.scenario = installScenario;
        this.rebuild(false);
    }

    public String getNameAt(int n) {
        return this.getRow(n).getPartName();
    }

    public Array getReverseDependenciesAt(int n) {
        Map map = this.getRow(n).getReverseDeps();
        return new Array(map.keySet());
    }

    public Array getDependentPartsAt(int n) {
        return this.getRow(n).getDependentParts();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public BImage getRowIcon(int n) {
        return this.getCellIcon(n, 0);
    }

    public int getStatusAt(int n) {
        return this.getRow(n).getStatus();
    }

    public String getTypeAt(int n) {
        return this.getRow(n).getType();
    }

    public DaemonSessionTaskListener getTaskListener() {
        return this.taskListener;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 1: {
                return InstallerTableModel.nvl(this.getRow(n).getCurrentVersion(), "-");
            }
            case 0: {
                return InstallerTableModel.nvl(this.getRow(n).getPartName(), "-");
            }
            case 2: {
                return InstallerTableModel.nvl(this.getRow(n).getHighestInstallableVersion(), "-");
            }
            case 3: {
                return this.getRow(n).getComment();
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void init(BDaemonSession bDaemonSession, DaemonSessionTaskListener daemonSessionTaskListener) throws AuthenticationException {
        this.init(bDaemonSession, daemonSessionTaskListener, true);
    }

    public void init(BDaemonSession bDaemonSession, DaemonSessionTaskListener daemonSessionTaskListener, boolean bl) throws AuthenticationException {
        try {
            this.scenario = new InstallScenario((BDaemonPlatform)BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, (DaemonSessionTaskListener)daemonSessionTaskListener), null, null, null, null, null, null, new SolutionParameters(daemonSessionTaskListener, true, "default"), (InstallableRegistry)LocalInstallableRegistry.getInstance());
            this.oodScenario = InstallScenario.upgradeOutOfDate((InstallScenario)this.scenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
            this.taskListener = daemonSessionTaskListener;
            this.rebuild(bl);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public boolean isModule(int n) {
        return this.getRow(n).isModule();
    }

    public void rebuild() throws AuthenticationException {
        this.rebuild(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(boolean bl) throws AuthenticationException {
        this.rowsByPartSpec = new TreeMap();
        BDaemonPlatform bDaemonPlatform = null;
        DaemonSessionTask daemonSessionTask = new DaemonSessionTask(BDaemonSessionView.lexicon, "SoftwareManager.rebuilding", "SoftwareManager.rebuilding");
        try {
            Object object;
            Object object2;
            PartSpec partSpec;
            Object object3;
            if (this.taskListener != null) {
                this.taskListener.taskStarted(daemonSessionTask);
            }
            if (this.scenario != null) {
                bDaemonPlatform = this.scenario.getTargetPlatform();
                BDaemonSessionView.log.trace("model rebuild: fetched platform " + this.getElapsed());
                bDaemonPlatform.getModuleList().init(this.taskListener);
                object3 = bDaemonPlatform.getModuleList().getModules().getProperties();
                while (object3.next()) {
                    this.addCurrentPart((BPart)((BModuleInstallable)object3.get()).getModulePart());
                }
                BDaemonSessionView.log.trace("model rebuild: added remote modules " + this.getElapsed());
            }
            try {
                object3 = this.scenario.getToInstall();
                partSpec = new HashSet();
                for (int i = 0; i < ((BInstallable[])object3).length; ++i) {
                    if (!(object3[i] instanceof BModuleInstallable)) continue;
                    this.addInstallable(object3[i]);
                    partSpec.add(object3[i].getInstallableName());
                }
                object2 = LocalInstallableRegistry.getInstance().getInstallables(true, this.taskListener, null, "*.dist");
                while (object2.next()) {
                    object = (BInstallable)object2.get();
                    if (!(object instanceof BModuleInstallable) || object.getUnmetPlatformDependencies(bDaemonPlatform).size() != 0) continue;
                    if (partSpec.contains(object.getInstallableName())) {
                        this.getRow(object.getPartSpec()).setLatestAvailableInstallable((BInstallable)object);
                        continue;
                    }
                    this.addInstallable((BInstallable)object);
                }
            }
            catch (AuthenticationException authenticationException) {
                throw authenticationException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            BDaemonSessionView.log.trace("model rebuild: added local modules " + this.getElapsed());
            object3 = this.rowsByPartSpec.keySet().iterator();
            while (object3.hasNext()) {
                partSpec = (PartSpec)object3.next();
                object2 = (InstallerTableRow)this.rowsByPartSpec.get(partSpec);
                object = new TreeMap();
                Array array = new Array();
                this.checkDependencies(partSpec, (Map)object, array, null);
                ((InstallerTableRow)object2).setForwardDeps(new Array(((TreeMap)object).values()));
            }
            this.updateValues(bl);
        }
        finally {
            if (this.taskListener != null) {
                this.taskListener.taskFinished(daemonSessionTask);
            }
        }
    }

    public void reload() throws AuthenticationException {
        try {
            this.getTable().getSelection().deselectAll();
            if (this.scenario != null) {
                this.scenario.getTargetPlatform().getModuleList().reload(this.taskListener);
                this.scenario.getTargetPlatform().getDaemonSession().reloadHostProperties();
            }
            this.rebuild();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public long getSizeDeltaOnCommit() {
        long l = 0L;
        for (int i = 0; i < this.getRowCount(); ++i) {
            l += this.getRow(i).getSizeDeltaOnCommit();
        }
        return l;
    }

    public void resetScenario() {
        try {
            this.scenario = new InstallScenario(this.scenario.getTargetPlatform(), this.taskListener, null, null, null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            this.updateValues(true);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void sortByColumn(int n, boolean bl) {
        if (!this.needsSort && n == this.sortColumn && bl == this.sortAscending) {
            return;
        }
        this.sortColumn = n;
        this.sortAscending = bl;
        this.updateValues(true);
    }

    public void setFilter(BInstallerTableRowFilter bInstallerTableRowFilter) {
        this.filter = bInstallerTableRowFilter;
        if (this.filter != null && this.filter.getIsEnabled()) {
            this.updateValues(true);
        }
    }

    public BInstallerTableRowFilter getFilter() {
        return this.filter;
    }

    public void updateTable(boolean bl) {
        this.needsSort = true;
        for (int i = 0; i < this.rows.size(); ++i) {
            ((InstallerTableRow)this.rows.get(i)).updateRow();
        }
        super.updateTable(bl);
    }

    private void addCurrentPart(BPart bPart) {
        if (bPart == null || bPart.isNull()) {
            return;
        }
        InstallerTableRow installerTableRow = (InstallerTableRow)this.rowsByPartSpec.get(bPart.getPartSpec());
        if (installerTableRow == null) {
            installerTableRow = this.makeRow();
            this.rowsByPartSpec.put(bPart.getPartSpec(), installerTableRow);
        }
        installerTableRow.setCurrentPart(bPart);
        installerTableRow.updateRow();
    }

    protected InstallerTableRow makeRow() {
        return new InstallerTableRow(this);
    }

    private void checkDependencies(PartSpec partSpec, Map map, Array array, BDependency bDependency) {
        if (array.contains((Object)partSpec)) {
            return;
        }
        array.add((Object)partSpec);
        InstallerTableRow installerTableRow = (InstallerTableRow)this.rowsByPartSpec.get(partSpec);
        if (installerTableRow == null) {
            return;
        }
        BPart bPart = null;
        if (bDependency == null) {
            bPart = installerTableRow.getInstallablePart() == null ? installerTableRow.getCurrentPart() : installerTableRow.getInstallablePart();
        } else {
            bPart = installerTableRow.getCurrentPart();
            if (bPart == null || !bPart.meets(bDependency)) {
                bPart = installerTableRow.getHighestVersionedPart();
            }
            if (bPart == null) {
                bPart = installerTableRow.getInstallablePart();
            }
        }
        if (bPart != null) {
            BDependency[] bDependencyArray = bPart.getDependencyArray();
            for (int i = 0; i < bDependencyArray.length; ++i) {
                BDependency bDependency2 = (BDependency)map.get(bDependencyArray[i].getPartSpec());
                if (bDependency2 == null) {
                    map.put(bDependencyArray[i].getPartSpec(), bDependencyArray[i]);
                    this.checkDependencies(bDependencyArray[i].getPartSpec(), map, array, bDependencyArray[i]);
                } else if (bDependencyArray[i].supersedes(bDependency2)) {
                    map.put(bDependencyArray[i].getPartSpec(), bDependencyArray[i]);
                }
                InstallerTableRow installerTableRow2 = (InstallerTableRow)this.rowsByPartSpec.get(bDependencyArray[i].getPartSpec());
                if (installerTableRow2 == null) continue;
                installerTableRow2.addReverseDep(installerTableRow, bDependencyArray[i]);
            }
        }
    }

    private void addInstallable(BInstallable bInstallable) {
        BInstallable bInstallable2;
        if (bInstallable == null || bInstallable.getPart() == null) {
            return;
        }
        InstallerTableRow installerTableRow = (InstallerTableRow)this.rowsByPartSpec.get(bInstallable.getPart().getPartSpec());
        if (installerTableRow == null) {
            installerTableRow = this.makeRow();
            this.rowsByPartSpec.put(bInstallable.getPart().getPartSpec(), installerTableRow);
        }
        if (this.isUpgrade(bInstallable, bInstallable2 = installerTableRow.getInstallable())) {
            installerTableRow.setInstallable(bInstallable);
            installerTableRow.updateRow();
        }
    }

    private boolean isUpgrade(BInstallable bInstallable, BInstallable bInstallable2) {
        if (bInstallable == null) {
            return false;
        }
        if (bInstallable2 == null) {
            return true;
        }
        switch (bInstallable2.getVersion().checkVersionRequirement(bInstallable.getVersion())) {
            case 2: {
                if (bInstallable2 instanceof BModuleInstallable) {
                    BModulePart bModulePart = (BModulePart)bInstallable.getPart();
                    BModulePart bModulePart2 = (BModulePart)bInstallable2.getPart();
                    if (bModulePart.getBuildAbsTime() != null && bModulePart2.getBuildAbsTime() != null) {
                        int n = bModulePart.getBuildAbsTime().compareTo((Object)bModulePart2.getBuildAbsTime());
                        if (n > 0) {
                            return true;
                        }
                        if (n < 0) {
                            return false;
                        }
                    }
                }
                return false;
            }
            case 8: 
            case 16: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    public BModuleContent getTargetModuleContent() {
        return this.getScenario().getTargetPlatform().getModuleContent();
    }

    public boolean getTargetStripLineNumbers() {
        return this.getScenario().getTargetPlatform().getStripLineNumbers();
    }

    protected InstallerTableRow getRow(int n) {
        return (InstallerTableRow)this.rows.get(n);
    }

    protected InstallerTableRow getRow(PartSpec partSpec) {
        return (InstallerTableRow)this.rowsByPartSpec.get(partSpec);
    }

    private static String nvl(Object object, String string) {
        return object == null ? string : object.toString();
    }

    protected void updateValues(boolean bl) {
        OriginalOrderComparator originalOrderComparator = new OriginalOrderComparator(this.rows);
        this.needsSort = false;
        this.rows = new Array(this.rowsByPartSpec.values());
        this.rows = bl ? this.rows.sort((Comparator)new InstallerTableRowComparator()) : this.rows.sort((Comparator)originalOrderComparator);
        if (this.filter != null && this.filter.getIsEnabled()) {
            this.rows = this.rows.filter((IFilter)this.filter);
        }
        this.getTable().getSelection().deselectAll();
        this.updateTable(true);
    }

    private String getElapsed() {
        long l = this.elapsed;
        this.elapsed = Clock.ticks();
        return l == 0L ? "" : this.elapsed - l + " ms";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InstallerTableRowComparator
    implements Comparator {
        private Comparator[] comparators;

        public InstallerTableRowComparator() {
            int n;
            int[] nArray = new int[4];
            nArray[0] = InstallerTableModel.this.sortColumn;
            int n2 = 1;
            for (n = 0; n < nArray.length; ++n) {
                if (n == InstallerTableModel.this.sortColumn) continue;
                nArray[n2++] = n;
            }
            this.comparators = new Comparator[4];
            for (n = 0; n < 4; ++n) {
                this.comparators[n] = new InstallerColumnComparator(nArray[n], InstallerTableModel.this.sortAscending);
            }
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            for (int i = 0; i < this.comparators.length && n == 0; ++i) {
                n = this.comparators[i].compare(object, object2);
            }
            return n;
        }
    }

    protected class OriginalOrderComparator
    implements Comparator {
        HashMap sequenceMapByPartName = new HashMap();

        public OriginalOrderComparator(Array array) {
            if (array != null) {
                for (int i = 0; i < array.size(); ++i) {
                    this.sequenceMapByPartName.put(((InstallerTableRow)array.get(i)).getInstallableName(), new Integer(i));
                }
            }
        }

        public int compare(Object object, Object object2) {
            InstallerTableRow installerTableRow = (InstallerTableRow)object;
            InstallerTableRow installerTableRow2 = (InstallerTableRow)object2;
            Integer n = (Integer)this.sequenceMapByPartName.get(installerTableRow.getInstallableName());
            Integer n2 = (Integer)this.sequenceMapByPartName.get(installerTableRow2.getInstallableName());
            if (n == null) {
                if (n2 == null) {
                    return 0;
                }
                return -1;
            }
            if (n2 == null) {
                return 1;
            }
            return n.compareTo(n2);
        }
    }

    private static class InstallerColumnComparator
    implements Comparator {
        private int comparatorSortColumn;
        private boolean comparatorAscending;

        public InstallerColumnComparator(int n, boolean bl) {
            this.comparatorSortColumn = n;
            this.comparatorAscending = bl;
        }

        public int compare(Object object, Object object2) {
            InstallerTableRow installerTableRow = (InstallerTableRow)object;
            InstallerTableRow installerTableRow2 = (InstallerTableRow)object2;
            int n = this.comparatorAscending ? 1 : -1;
            switch (this.comparatorSortColumn) {
                case 3: {
                    return n * COMMENT_COLUMN_COMPARATOR.compare(installerTableRow, installerTableRow2);
                }
                case 0: {
                    if (installerTableRow.getInstallableName() == null) {
                        if (installerTableRow2.getInstallableName() == null) {
                            return 0;
                        }
                        return n;
                    }
                    if (installerTableRow2.getInstallableName() == null) {
                        return n * -1;
                    }
                    return n * TextUtil.toLowerCase((String)installerTableRow.getInstallableName()).compareTo(TextUtil.toLowerCase((String)installerTableRow2.getInstallableName()));
                }
                case 1: {
                    if (installerTableRow.getCurrentPart() == null) {
                        if (installerTableRow2.getCurrentPart() == null) {
                            return 0;
                        }
                        return -1 * n;
                    }
                    if (installerTableRow2.getCurrentPart() == null) {
                        return n;
                    }
                    return n * installerTableRow.getCurrentPart().getVersion().compareTo((Object)installerTableRow2.getCurrentPart().getVersion());
                }
                case 2: {
                    if (installerTableRow.getInstallable() == null) {
                        if (installerTableRow2.getInstallable() == null) {
                            return 0;
                        }
                        return -1 * n;
                    }
                    if (installerTableRow2.getInstallable() == null) {
                        return n;
                    }
                    return n * installerTableRow.getInstallable().getVersion().compareTo((Object)installerTableRow2.getInstallable().getVersion());
                }
            }
            throw new IllegalArgumentException();
        }
    }

    private static class CommentColumnComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            InstallerTableRow installerTableRow = (InstallerTableRow)object;
            InstallerTableRow installerTableRow2 = (InstallerTableRow)object2;
            return installerTableRow.compareComment(installerTableRow2);
        }
    }
}

